/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import java.time.Duration;
import org.apache.beam.sdk.io.gcp.bigquery.BeamRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.Cache;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.cache.CacheBuilder;

class StorageApiDynamicDestinationsBeamRow<T, DestinationT>
extends StorageApiDynamicDestinations<T, DestinationT> {
    private final Schema schema;
    private final SerializableFunction<T, Row> toRow;
    private final Cache<DestinationT, Descriptors.Descriptor> destinationDescriptorCache = CacheBuilder.newBuilder().expireAfterAccess(Duration.ofMinutes(15L)).build();

    StorageApiDynamicDestinationsBeamRow(DynamicDestinations<T, DestinationT> inner, Schema schema, SerializableFunction<T, Row> toRow) {
        super(inner);
        this.schema = schema;
        this.toRow = toRow;
    }

    @Override
    public StorageApiDynamicDestinations.MessageConverter<T> getMessageConverter(final DestinationT destination) throws Exception {
        return new StorageApiDynamicDestinations.MessageConverter<T>(){
            Descriptors.Descriptor descriptor;
            {
                this.descriptor = (Descriptors.Descriptor)StorageApiDynamicDestinationsBeamRow.this.destinationDescriptorCache.get(destination, () -> BeamRowToStorageApiProto.getDescriptorFromSchema(StorageApiDynamicDestinationsBeamRow.this.schema));
            }

            @Override
            public Descriptors.Descriptor getSchemaDescriptor() {
                return this.descriptor;
            }

            @Override
            public Message toMessage(T element) {
                return BeamRowToStorageApiProto.messageFromBeamRow(this.descriptor, (Row)StorageApiDynamicDestinationsBeamRow.this.toRow.apply(element));
            }
        };
    }
}

