/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.math.BigDecimal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.CivilTimeEncoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Functions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Bytes;
import org.joda.time.ReadableInstant;

public class BeamRowToStorageApiProto {
    private static final int NUMERIC_SCALE = 9;
    private static final BigDecimal MAX_NUMERIC_VALUE = new BigDecimal("99999999999999999999999999999.999999999");
    private static final BigDecimal MIN_NUMERIC_VALUE = new BigDecimal("-99999999999999999999999999999.999999999");
    static final Map<Schema.TypeName, DescriptorProtos.FieldDescriptorProto.Type> PRIMITIVE_TYPES = ImmutableMap.builder().put((Object)Schema.TypeName.INT16, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put((Object)Schema.TypeName.BYTE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put((Object)Schema.TypeName.INT32, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put((Object)Schema.TypeName.INT64, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)Schema.TypeName.FLOAT, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT).put((Object)Schema.TypeName.DOUBLE, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE).put((Object)Schema.TypeName.STRING, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).put((Object)Schema.TypeName.BOOLEAN, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BOOL).put((Object)Schema.TypeName.DATETIME, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)Schema.TypeName.BYTES, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).put((Object)Schema.TypeName.DECIMAL, (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_BYTES).build();
    static final Map<String, DescriptorProtos.FieldDescriptorProto.Type> LOGICAL_TYPES = ImmutableMap.builder().put((Object)SqlTypes.DATE.getIdentifier(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32).put((Object)SqlTypes.TIME.getIdentifier(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)SqlTypes.DATETIME.getIdentifier(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)SqlTypes.TIMESTAMP.getIdentifier(), (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64).put((Object)"Enum", (Object)DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING).build();
    static final Map<Schema.TypeName, Function<Object, Object>> PRIMITIVE_ENCODERS = ImmutableMap.builder().put((Object)Schema.TypeName.INT16, o -> (int)((Short)o).shortValue()).put((Object)Schema.TypeName.BYTE, o -> (int)((Byte)o).byteValue()).put((Object)Schema.TypeName.INT32, (Object)Functions.identity()).put((Object)Schema.TypeName.INT64, (Object)Functions.identity()).put((Object)Schema.TypeName.FLOAT, Function.identity()).put((Object)Schema.TypeName.DOUBLE, Function.identity()).put((Object)Schema.TypeName.STRING, Function.identity()).put((Object)Schema.TypeName.BOOLEAN, Function.identity()).put((Object)Schema.TypeName.DATETIME, o -> ((ReadableInstant)o).getMillis() * 1000L).put((Object)Schema.TypeName.BYTES, o -> ByteString.copyFrom((byte[])((byte[])o))).put((Object)Schema.TypeName.DECIMAL, o -> BeamRowToStorageApiProto.serializeBigDecimalToNumeric((BigDecimal)o)).build();
    static final Map<String, BiFunction<Schema.LogicalType<?, ?>, Object, Object>> LOGICAL_TYPE_ENCODERS = ImmutableMap.builder().put((Object)SqlTypes.DATE.getIdentifier(), (logicalType, value) -> (int)((LocalDate)value).toEpochDay()).put((Object)SqlTypes.TIME.getIdentifier(), (logicalType, value) -> CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)value)).put((Object)SqlTypes.DATETIME.getIdentifier(), (logicalType, value) -> CivilTimeEncoder.encodePacked64DatetimeSeconds((LocalDateTime)value)).put((Object)SqlTypes.TIMESTAMP.getIdentifier(), (logicalType, value) -> ((Instant)value).toEpochMilli() * 1000L).put((Object)"Enum", (logicalType, value) -> ((EnumerationType)logicalType).toString((EnumerationType.Value)value)).build();

    public static Descriptors.Descriptor getDescriptorFromSchema(Schema schema) throws Descriptors.DescriptorValidationException {
        DescriptorProtos.DescriptorProto descriptorProto = BeamRowToStorageApiProto.descriptorSchemaFromBeamSchema(schema);
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(descriptorProto).build();
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        return (Descriptors.Descriptor)Iterables.getOnlyElement((Iterable)fileDescriptor.getMessageTypes());
    }

    public static DynamicMessage messageFromBeamRow(Descriptors.Descriptor descriptor, Row row) {
        Schema beamSchema = row.getSchema();
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (int i = 0; i < row.getFieldCount(); ++i) {
            Schema.Field beamField = beamSchema.getField(i);
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)Preconditions.checkNotNull((Object)descriptor.findFieldByName(beamField.getName().toLowerCase()));
            Object value = BeamRowToStorageApiProto.messageValueFromRowValue(fieldDescriptor, beamField, i, row);
            if (value == null) continue;
            builder.setField(fieldDescriptor, value);
        }
        return builder.build();
    }

    @VisibleForTesting
    static DescriptorProtos.DescriptorProto descriptorSchemaFromBeamSchema(Schema schema) {
        Preconditions.checkState((schema.getFieldCount() > 0 ? 1 : 0) != 0);
        DescriptorProtos.DescriptorProto.Builder descriptorBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        descriptorBuilder.setName("D" + UUID.randomUUID().toString().replace("-", "_"));
        int i = 1;
        ArrayList nestedTypes = Lists.newArrayList();
        for (Schema.Field field : schema.getFields()) {
            DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorProtoBuilder = BeamRowToStorageApiProto.fieldDescriptorFromBeamField(field, i++, nestedTypes);
            descriptorBuilder.addField(fieldDescriptorProtoBuilder);
        }
        nestedTypes.forEach(arg_0 -> ((DescriptorProtos.DescriptorProto.Builder)descriptorBuilder).addNestedType(arg_0));
        return descriptorBuilder.build();
    }

    private static DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorFromBeamField(Schema.Field field, int fieldNumber, List<DescriptorProtos.DescriptorProto> nestedTypes) {
        DescriptorProtos.FieldDescriptorProto.Builder fieldDescriptorBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
        fieldDescriptorBuilder = fieldDescriptorBuilder.setName(field.getName().toLowerCase());
        fieldDescriptorBuilder = fieldDescriptorBuilder.setNumber(fieldNumber);
        switch (field.getType().getTypeName()) {
            case ROW: {
                Schema rowSchema = field.getType().getRowSchema();
                if (rowSchema == null) {
                    throw new RuntimeException("Unexpected null schema!");
                }
                DescriptorProtos.DescriptorProto nested = BeamRowToStorageApiProto.descriptorSchemaFromBeamSchema(rowSchema);
                nestedTypes.add(nested);
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(DescriptorProtos.FieldDescriptorProto.Type.TYPE_MESSAGE).setTypeName(nested.getName());
                break;
            }
            case ARRAY: 
            case ITERABLE: {
                Schema.FieldType elementType = field.getType().getCollectionElementType();
                if (elementType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                Preconditions.checkState((!((Schema.TypeName)Preconditions.checkNotNull((Object)elementType.getTypeName())).isCollectionType() ? 1 : 0) != 0, (Object)"Nested arrays not supported by BigQuery.");
                return BeamRowToStorageApiProto.fieldDescriptorFromBeamField(Schema.Field.of((String)field.getName(), (Schema.FieldType)elementType), fieldNumber, nestedTypes).setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REPEATED);
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = field.getType().getLogicalType();
                if (logicalType == null) {
                    throw new RuntimeException("Unexpected null logical type " + field.getType());
                }
                DescriptorProtos.FieldDescriptorProto.Type type = LOGICAL_TYPES.get(logicalType.getIdentifier());
                if (type == null) {
                    throw new RuntimeException("Unsupported logical type " + field.getType());
                }
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(type);
                break;
            }
            case MAP: {
                throw new RuntimeException("Map types not supported by BigQuery.");
            }
            default: {
                DescriptorProtos.FieldDescriptorProto.Type primitiveType = PRIMITIVE_TYPES.get(field.getType().getTypeName());
                if (primitiveType == null) {
                    throw new RuntimeException("Unsupported type " + field.getType());
                }
                fieldDescriptorBuilder = fieldDescriptorBuilder.setType(primitiveType);
            }
        }
        fieldDescriptorBuilder = field.getType().getNullable() != false ? fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL) : fieldDescriptorBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
        return fieldDescriptorBuilder;
    }

    @Nullable
    private static Object messageValueFromRowValue(Descriptors.FieldDescriptor fieldDescriptor, Schema.Field beamField, int index, Row row) {
        Object value = row.getValue(index);
        if (value == null) {
            if (fieldDescriptor.isOptional()) {
                return null;
            }
            throw new IllegalArgumentException("Received null value for non-nullable field " + fieldDescriptor.getName());
        }
        return BeamRowToStorageApiProto.toProtoValue(fieldDescriptor, beamField.getType(), value);
    }

    private static Object toProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Schema.FieldType beamFieldType, Object value) {
        switch (beamFieldType.getTypeName()) {
            case ROW: {
                return BeamRowToStorageApiProto.messageFromBeamRow(fieldDescriptor.getMessageType(), (Row)value);
            }
            case ARRAY: {
                List list = (List)value;
                Schema.FieldType arrayElementType = beamFieldType.getCollectionElementType();
                if (arrayElementType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                return list.stream().map(v -> BeamRowToStorageApiProto.toProtoValue(fieldDescriptor, arrayElementType, v)).collect(Collectors.toList());
            }
            case ITERABLE: {
                Iterable iterable = (Iterable)value;
                Schema.FieldType iterableElementType = beamFieldType.getCollectionElementType();
                if (iterableElementType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                return StreamSupport.stream(iterable.spliterator(), false).map(v -> BeamRowToStorageApiProto.toProtoValue(fieldDescriptor, iterableElementType, v)).collect(Collectors.toList());
            }
            case MAP: {
                throw new RuntimeException("Map types not supported by BigQuery.");
            }
        }
        return BeamRowToStorageApiProto.scalarToProtoValue(beamFieldType, value);
    }

    @VisibleForTesting
    static Object scalarToProtoValue(Schema.FieldType beamFieldType, Object value) {
        if (beamFieldType.getTypeName() == Schema.TypeName.LOGICAL_TYPE) {
            Schema.LogicalType logicalType = beamFieldType.getLogicalType();
            if (logicalType == null) {
                throw new RuntimeException("Unexpectedly null logical type " + beamFieldType);
            }
            BiFunction<Schema.LogicalType<?, ?>, Object, Object> logicalTypeEncoder = LOGICAL_TYPE_ENCODERS.get(logicalType.getIdentifier());
            if (logicalTypeEncoder == null) {
                throw new RuntimeException("Unsupported logical type " + logicalType.getIdentifier());
            }
            return logicalTypeEncoder.apply(logicalType, value);
        }
        Function<Object, Object> encoder = PRIMITIVE_ENCODERS.get(beamFieldType.getTypeName());
        if (encoder == null) {
            throw new RuntimeException("Unexpected beam type " + beamFieldType);
        }
        return encoder.apply(value);
    }

    static ByteString serializeBigDecimalToNumeric(BigDecimal o) {
        return BeamRowToStorageApiProto.serializeBigDecimal(o, 9, MAX_NUMERIC_VALUE, MIN_NUMERIC_VALUE, "Numeric");
    }

    private static ByteString serializeBigDecimal(BigDecimal v, int scale, BigDecimal maxValue, BigDecimal minValue, String typeName) {
        if (v.scale() > scale) {
            throw new IllegalArgumentException(typeName + " scale cannot exceed " + scale + ": " + v.toPlainString());
        }
        if (v.compareTo(maxValue) > 0 || v.compareTo(minValue) < 0) {
            throw new IllegalArgumentException(typeName + " overflow: " + v.toPlainString());
        }
        byte[] bytes = v.setScale(scale).unscaledValue().toByteArray();
        Bytes.reverse((byte[])bytes);
        return ByteString.copyFrom((byte[])bytes);
    }
}

