/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fuzzymatch;

import com.wcohen.ss.Jaro;
import com.wcohen.ss.JaroWinkler;
import com.wcohen.ss.NeedlemanWunsch;
import java.util.Iterator;
import org.apache.commons.codec.language.DoubleMetaphone;
import org.apache.commons.codec.language.Metaphone;
import org.apache.commons.codec.language.RefinedSoundex;
import org.apache.commons.codec.language.Soundex;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.IRowSet;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transform.errorhandling.IStream;
import org.apache.hop.pipeline.transforms.fuzzymatch.FuzzyMatchData;
import org.apache.hop.pipeline.transforms.fuzzymatch.FuzzyMatchMeta;
import org.apache.hop.pipeline.transforms.fuzzymatch.LetterPairSimilarity;

public class FuzzyMatch
extends BaseTransform<FuzzyMatchMeta, FuzzyMatchData>
implements ITransform<FuzzyMatchMeta, FuzzyMatchData> {
    private static final Class<?> PKG = FuzzyMatchMeta.class;

    public FuzzyMatch(TransformMeta transformMeta, FuzzyMatchMeta meta, FuzzyMatchData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private boolean readLookupValues() throws HopException {
        ((FuzzyMatchData)this.data).infoStream = (IStream)((FuzzyMatchMeta)this.meta).getTransformIOMeta().getInfoStreams().get(0);
        if (((FuzzyMatchData)this.data).infoStream.getTransformMeta() == null) {
            this.logError(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.NoLookupTransformSpecified", (String[])new String[0]));
            return false;
        }
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.ReadingFromStream", (String[])new String[0]) + ((FuzzyMatchData)this.data).infoStream.getTransformName() + "]");
        }
        boolean firstRun = true;
        IRowSet rowSet = this.findInputRowSet(((FuzzyMatchData)this.data).infoStream.getTransformName());
        Object[] rowData = this.getRowFrom(rowSet);
        while (rowData != null) {
            IValueMeta fromStreamRowMeta;
            if (firstRun) {
                ((FuzzyMatchData)this.data).infoMeta = rowSet.getRowMeta().clone();
                int indexOfLookupField = ((FuzzyMatchData)this.data).infoMeta.indexOfValue(this.resolve(((FuzzyMatchMeta)this.meta).getLookupField()));
                if (indexOfLookupField < 0) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"FuzzyMatch.Exception.CouldnotFindLookField", (String[])new String[]{((FuzzyMatchMeta)this.meta).getLookupField()}));
                }
                ((FuzzyMatchData)this.data).infoCache = new RowMeta();
                IValueMeta keyValueMeta = ((FuzzyMatchData)this.data).infoMeta.getValueMeta(indexOfLookupField);
                keyValueMeta.setStorageType(0);
                ((FuzzyMatchData)this.data).infoCache.addValueMeta(keyValueMeta);
                ((FuzzyMatchData)this.data).indexOfCachedFields[0] = indexOfLookupField;
                if (((FuzzyMatchData)this.data).addAdditionalFields) {
                    for (int i = 0; i < ((FuzzyMatchMeta)this.meta).getValue().length; ++i) {
                        int fi = i + 1;
                        ((FuzzyMatchData)this.data).indexOfCachedFields[fi] = ((FuzzyMatchData)this.data).infoMeta.indexOfValue(((FuzzyMatchMeta)this.meta).getValue()[i]);
                        if (((FuzzyMatchData)this.data).indexOfCachedFields[fi] < 0) {
                            throw new HopException(BaseMessages.getString(PKG, (String)"FuzzyMatch.Exception.CouldnotFindLookField", (String[])new String[]{((FuzzyMatchMeta)this.meta).getValue()[i]}));
                        }
                        IValueMeta additionalFieldValueMeta = ((FuzzyMatchData)this.data).infoMeta.getValueMeta(((FuzzyMatchData)this.data).indexOfCachedFields[fi]);
                        additionalFieldValueMeta.setStorageType(0);
                        ((FuzzyMatchData)this.data).infoCache.addValueMeta(additionalFieldValueMeta);
                    }
                    ((FuzzyMatchData)this.data).nrCachedFields += ((FuzzyMatchMeta)this.meta).getValue().length;
                }
            }
            if (this.log.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.ReadLookupRow", (String[])new String[0]) + rowSet.getRowMeta().getString(rowData));
            }
            Object[] storeData = new Object[((FuzzyMatchData)this.data).nrCachedFields];
            storeData[0] = rowData[((FuzzyMatchData)this.data).indexOfCachedFields[0]] == null ? "" : ((fromStreamRowMeta = rowSet.getRowMeta().getValueMeta(((FuzzyMatchData)this.data).indexOfCachedFields[0])).isStorageBinaryString() ? fromStreamRowMeta.convertToNormalStorageType(rowData[((FuzzyMatchData)this.data).indexOfCachedFields[0]]) : rowData[((FuzzyMatchData)this.data).indexOfCachedFields[0]]);
            for (int i = 1; i < ((FuzzyMatchData)this.data).nrCachedFields; ++i) {
                IValueMeta fromStreamRowMeta2 = rowSet.getRowMeta().getValueMeta(((FuzzyMatchData)this.data).indexOfCachedFields[i]);
                storeData[i] = fromStreamRowMeta2.isStorageBinaryString() ? fromStreamRowMeta2.convertToNormalStorageType(rowData[((FuzzyMatchData)this.data).indexOfCachedFields[i]]) : rowData[((FuzzyMatchData)this.data).indexOfCachedFields[i]];
            }
            if (this.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.AddingValueToCache", (String[])new String[]{((FuzzyMatchData)this.data).infoCache.getString(storeData)}));
            }
            this.addToCache(storeData);
            rowData = this.getRowFrom(rowSet);
            if (!firstRun) continue;
            firstRun = false;
        }
        return true;
    }

    private Object[] lookupValues(IRowMeta rowMeta, Object[] row) throws HopException {
        if (this.first) {
            this.first = false;
            ((FuzzyMatchData)this.data).outputRowMeta = this.getInputRowMeta().clone();
            ((FuzzyMatchMeta)this.meta).getFields(((FuzzyMatchData)this.data).outputRowMeta, this.getTransformName(), new IRowMeta[]{((FuzzyMatchData)this.data).infoMeta}, null, (IVariables)this, this.metadataProvider);
            ((FuzzyMatchData)this.data).indexOfMainField = this.getInputRowMeta().indexOfValue(this.resolve(((FuzzyMatchMeta)this.meta).getMainStreamField()));
            if (((FuzzyMatchData)this.data).indexOfMainField < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"FuzzyMatch.Exception.CouldnotFindMainField", (String[])new String[]{((FuzzyMatchMeta)this.meta).getMainStreamField()}));
            }
        }
        Object[] add = null;
        if (row[((FuzzyMatchData)this.data).indexOfMainField] == null) {
            add = this.buildEmptyRow();
        } else {
            try {
                add = this.getFromCache(row);
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
        return RowDataUtil.addRowData((Object[])row, (int)rowMeta.size(), (Object[])add);
    }

    private void addToCache(Object[] value) throws HopException {
        try {
            ((FuzzyMatchData)this.data).look.add(value);
        }
        catch (OutOfMemoryError o) {
            throw new HopException(BaseMessages.getString(PKG, (String)"FuzzyMatch.Error.JavaHeap", (String[])new String[]{o.toString()}));
        }
    }

    private Object[] getFromCache(Object[] keyRow) throws HopValueException {
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.ReadingMainStreamRow", (String[])new String[]{this.getInputRowMeta().getString(keyRow)}));
        }
        Object[] retval = null;
        switch (((FuzzyMatchMeta)this.meta).getAlgorithmType()) {
            case 0: 
            case 1: 
            case 2: {
                retval = this.doDistance(keyRow);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                retval = this.doPhonetic(keyRow);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                retval = this.doSimilarity(keyRow);
                break;
            }
        }
        return retval;
    }

    private Object[] doDistance(Object[] row) throws HopValueException {
        Object[] rowData = this.buildEmptyRow();
        Iterator<Object[]> it = ((FuzzyMatchData)this.data).look.iterator();
        long distance = -1L;
        String lookupvalue = this.getInputRowMeta().getString(row, ((FuzzyMatchData)this.data).indexOfMainField);
        while (it.hasNext()) {
            Object[] cachedData = it.next();
            String cacheValue = (String)cachedData[0];
            int cdistance = -1;
            String usecacheValue = cacheValue;
            String uselookupvalue = lookupvalue;
            if (!((FuzzyMatchMeta)this.meta).isCaseSensitive()) {
                usecacheValue = cacheValue.toLowerCase();
                uselookupvalue = lookupvalue.toLowerCase();
            }
            switch (((FuzzyMatchMeta)this.meta).getAlgorithmType()) {
                case 1: {
                    cdistance = Utils.getDamerauLevenshteinDistance((String)usecacheValue, (String)uselookupvalue);
                    break;
                }
                case 2: {
                    cdistance = Math.abs((int)new NeedlemanWunsch().score(usecacheValue, uselookupvalue));
                    break;
                }
                default: {
                    cdistance = StringUtils.getLevenshteinDistance((String)usecacheValue, (String)uselookupvalue);
                }
            }
            if (((FuzzyMatchData)this.data).minimalDistance > cdistance || cdistance > ((FuzzyMatchData)this.data).maximalDistance) continue;
            if (((FuzzyMatchMeta)this.meta).isGetCloserValue()) {
                if ((long)cdistance >= distance && distance != -1L) continue;
                distance = cdistance;
                int index = 0;
                rowData[index++] = cacheValue;
                if (((FuzzyMatchData)this.data).addValueFieldName) {
                    rowData[index++] = distance;
                }
                if (!((FuzzyMatchData)this.data).addAdditionalFields) continue;
                for (int i = 0; i < ((FuzzyMatchMeta)this.meta).getValue().length; ++i) {
                    int nr = i + 1;
                    int nf = i + index;
                    rowData[nf] = cachedData[nr];
                }
                continue;
            }
            if (rowData[0] == null) {
                rowData[0] = cacheValue;
                continue;
            }
            rowData[0] = (String)rowData[0] + ((FuzzyMatchData)this.data).valueSeparator + cacheValue;
        }
        return rowData;
    }

    private Object[] doPhonetic(Object[] row) {
        Object[] rowData = this.buildEmptyRow();
        Iterator<Object[]> it = ((FuzzyMatchData)this.data).look.iterator();
        Object o = row[((FuzzyMatchData)this.data).indexOfMainField];
        String lookupvalue = (String)o;
        String lookupValueMF = this.getEncodedMF(lookupvalue, ((FuzzyMatchMeta)this.meta).getAlgorithmType());
        while (it.hasNext()) {
            Object[] cachedData = it.next();
            String cacheValue = (String)cachedData[0];
            String cacheValueMF = this.getEncodedMF(cacheValue, ((FuzzyMatchMeta)this.meta).getAlgorithmType());
            if (!lookupValueMF.equals(cacheValueMF)) continue;
            int index = 0;
            rowData[index++] = cacheValue;
            if (((FuzzyMatchData)this.data).addValueFieldName) {
                rowData[index++] = cacheValueMF;
            }
            if (!((FuzzyMatchData)this.data).addAdditionalFields) continue;
            for (int i = 0; i < ((FuzzyMatchMeta)this.meta).getValue().length; ++i) {
                int nf = i + index;
                int nr = i + 1;
                rowData[nf] = cachedData[nr];
            }
        }
        return rowData;
    }

    private String getEncodedMF(String value, Integer algorithmType) {
        String encodedValueMF = "";
        switch (algorithmType) {
            case 6: {
                encodedValueMF = new Metaphone().metaphone(value);
                break;
            }
            case 7: {
                encodedValueMF = new DoubleMetaphone().doubleMetaphone(value);
                break;
            }
            case 8: {
                encodedValueMF = new Soundex().encode(value);
                break;
            }
            case 9: {
                encodedValueMF = new RefinedSoundex().encode(value);
                break;
            }
        }
        return encodedValueMF;
    }

    private Object[] doSimilarity(Object[] row) {
        String lookupvalue;
        Object[] rowData = this.buildEmptyRow();
        Iterator<Object[]> it = ((FuzzyMatchData)this.data).look.iterator();
        double similarity = 0.0;
        Object o = row[((FuzzyMatchData)this.data).indexOfMainField];
        String string = lookupvalue = o == null ? "" : (String)o;
        while (it.hasNext()) {
            Object[] cachedData = it.next();
            String cacheValue = (String)cachedData[0];
            double csimilarity = 0.0;
            switch (((FuzzyMatchMeta)this.meta).getAlgorithmType()) {
                case 3: {
                    csimilarity = new Jaro().score(cacheValue, lookupvalue);
                    break;
                }
                case 4: {
                    csimilarity = new JaroWinkler().score(cacheValue, lookupvalue);
                    break;
                }
                default: {
                    csimilarity = LetterPairSimilarity.getSimiliarity(cacheValue, lookupvalue);
                }
            }
            if (!(((FuzzyMatchData)this.data).minimalSimilarity <= csimilarity) || !(csimilarity <= ((FuzzyMatchData)this.data).maximalSimilarity)) continue;
            if (((FuzzyMatchMeta)this.meta).isGetCloserValue()) {
                if (!(csimilarity > similarity) && (csimilarity != 0.0 || !cacheValue.equals(lookupvalue))) continue;
                similarity = csimilarity;
                int index = 0;
                rowData[index++] = cacheValue;
                if (((FuzzyMatchData)this.data).addValueFieldName) {
                    rowData[index++] = similarity;
                }
                if (!((FuzzyMatchData)this.data).addAdditionalFields) continue;
                for (int i = 0; i < ((FuzzyMatchMeta)this.meta).getValue().length; ++i) {
                    int nf = i + index;
                    int nr = i + 1;
                    rowData[nf] = cachedData[nr];
                }
                continue;
            }
            if (rowData[0] == null) {
                rowData[0] = cacheValue;
                continue;
            }
            rowData[0] = (String)rowData[0] + ((FuzzyMatchData)this.data).valueSeparator + cacheValue;
        }
        return rowData;
    }

    private Object[] buildEmptyRow() {
        Object[] rowData = RowDataUtil.allocateRowData((int)((FuzzyMatchData)this.data).outputRowMeta.size());
        return rowData;
    }

    public boolean processRow() throws HopException {
        block10: {
            Object[] r;
            if (((FuzzyMatchData)this.data).readLookupValues) {
                ((FuzzyMatchData)this.data).readLookupValues = false;
                if (!this.readLookupValues()) {
                    this.logError(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.UnableToReadDataFromLookupStream", (String[])new String[0]));
                    this.setErrors(1L);
                    this.stopAll();
                    return false;
                }
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.ReadValuesInMemory", (Object[])new Object[]{((FuzzyMatchData)this.data).look.size()}));
                }
            }
            if ((r = this.getRow()) == null) {
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.StoppedProcessingWithEmpty", (Object[])new Object[]{this.getLinesRead()}));
                }
                this.setOutputDone();
                return false;
            }
            try {
                Object[] outputRow = this.lookupValues(this.getInputRowMeta(), r);
                if (outputRow == null) {
                    this.setOutputDone();
                    return false;
                }
                this.putRow(((FuzzyMatchData)this.data).outputRowMeta, outputRow);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block10;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((FuzzyMatchMeta)this.meta).getMainStreamField(), "FuzzyMatch001");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((FuzzyMatchMeta)this.meta).getMainStreamField())) {
                this.logError(BaseMessages.getString(PKG, (String)"FuzzyMatch.Error.MainStreamFieldMissing", (String[])new String[0]));
                return false;
            }
            if (Utils.isEmpty((CharSequence)((FuzzyMatchMeta)this.meta).getLookupField())) {
                this.logError(BaseMessages.getString(PKG, (String)"FuzzyMatch.Error.LookupStreamFieldMissing", (String[])new String[0]));
                return false;
            }
            String matchField = this.resolve(((FuzzyMatchMeta)this.meta).getOutputMatchField());
            if (Utils.isEmpty((CharSequence)matchField)) {
                this.logError(BaseMessages.getString(PKG, (String)"FuzzyMatch.Error.OutputMatchFieldMissing", (String[])new String[0]));
                return false;
            }
            ((FuzzyMatchData)this.data).addValueFieldName = !Utils.isEmpty((CharSequence)this.resolve(((FuzzyMatchMeta)this.meta).getOutputValueField())) && ((FuzzyMatchMeta)this.meta).isGetCloserValue();
            int nrFields = 1;
            if (((FuzzyMatchMeta)this.meta).getValue() != null && ((FuzzyMatchMeta)this.meta).getValue().length > 0 && (((FuzzyMatchMeta)this.meta).isGetCloserValue() || ((FuzzyMatchMeta)this.meta).getAlgorithmType() == 7 || ((FuzzyMatchMeta)this.meta).getAlgorithmType() == 8 || ((FuzzyMatchMeta)this.meta).getAlgorithmType() == 9 || ((FuzzyMatchMeta)this.meta).getAlgorithmType() == 6)) {
                ((FuzzyMatchData)this.data).addAdditionalFields = true;
                nrFields += ((FuzzyMatchMeta)this.meta).getValue().length;
            }
            ((FuzzyMatchData)this.data).indexOfCachedFields = new int[nrFields];
            switch (((FuzzyMatchMeta)this.meta).getAlgorithmType()) {
                case 0: 
                case 1: 
                case 2: {
                    ((FuzzyMatchData)this.data).minimalDistance = Const.toInt((String)this.resolve(((FuzzyMatchMeta)this.meta).getMinimalValue()), (int)0);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.MinimalDistance", (Object[])new Object[]{((FuzzyMatchData)this.data).minimalDistance}));
                    }
                    ((FuzzyMatchData)this.data).maximalDistance = Const.toInt((String)this.resolve(((FuzzyMatchMeta)this.meta).getMaximalValue()), (int)5);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.MaximalDistance", (Object[])new Object[]{((FuzzyMatchData)this.data).maximalDistance}));
                    }
                    if (((FuzzyMatchMeta)this.meta).isGetCloserValue()) break;
                    ((FuzzyMatchData)this.data).valueSeparator = this.resolve(((FuzzyMatchMeta)this.meta).getSeparator());
                    if (!this.isDetailed()) break;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.Separator", (String[])new String[]{((FuzzyMatchData)this.data).valueSeparator}));
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    ((FuzzyMatchData)this.data).minimalSimilarity = Const.toDouble((String)this.resolve(((FuzzyMatchMeta)this.meta).getMinimalValue()), (double)0.0);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.MinimalSimilarity", (Object[])new Object[]{((FuzzyMatchData)this.data).minimalSimilarity}));
                    }
                    ((FuzzyMatchData)this.data).maximalSimilarity = Const.toDouble((String)this.resolve(((FuzzyMatchMeta)this.meta).getMaximalValue()), (double)1.0);
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.MaximalSimilarity", (Object[])new Object[]{((FuzzyMatchData)this.data).maximalSimilarity}));
                    }
                    if (((FuzzyMatchMeta)this.meta).isGetCloserValue()) break;
                    ((FuzzyMatchData)this.data).valueSeparator = this.resolve(((FuzzyMatchMeta)this.meta).getSeparator());
                    if (!this.isDetailed()) break;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"FuzzyMatch.Log.Separator", (String[])new String[]{((FuzzyMatchData)this.data).valueSeparator}));
                    break;
                }
            }
            ((FuzzyMatchData)this.data).readLookupValues = true;
            return true;
        }
        return false;
    }

    public void dispose() {
        ((FuzzyMatchData)this.data).look.clear();
        super.dispose();
    }
}

