/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.writetofile;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.writetofile.ActionWriteToFile;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActionWriteToFileDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionWriteToFile.class;
    private static final String[] FILETYPES = new String[]{BaseMessages.getString(PKG, (String)"ActionWriteToFile.Filetype.All", (String[])new String[0])};
    private Text wName;
    private TextVar wFilename;
    private Button wCreateParentFolder;
    private Button wAppendFile;
    private ComboVar wEncoding;
    private Text wContent;
    private ActionWriteToFile action;
    private Shell shell;
    private boolean changed;
    private boolean gotEncodings = false;

    public ActionWriteToFileDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionWriteToFile)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Group wFileGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)wFileGroup);
        wFileGroup.setText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Group.File.Label", (String[])new String[0]));
        FormLayout FileGroupLayout = new FormLayout();
        FileGroupLayout.marginWidth = 10;
        FileGroupLayout.marginHeight = 10;
        wFileGroup.setLayout((Layout)FileGroupLayout);
        Label wlFilename = new Label((Composite)wFileGroup, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wName, margin);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        Button wbFilename = new Button((Composite)wFileGroup, 0x1000008);
        this.props.setLook((Control)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.wName, 0);
        wbFilename.setLayoutData((Object)fdbFilename);
        this.wFilename = new TextVar(this.variables, (Composite)wFileGroup, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.top = new FormAttachment((Control)this.wName, margin);
        fdFilename.right = new FormAttachment((Control)wbFilename, -margin);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wFilename.addModifyListener(e -> this.wFilename.setToolTipText(this.variables.resolve(this.wFilename.getText())));
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])new String[]{"*"}, (String[])FILETYPES, (boolean)true));
        Label wlCreateParentFolder = new Label((Composite)wFileGroup, 131072);
        wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.CreateParentFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateParentFolder);
        FormData fdlCreateParentFolder = new FormData();
        fdlCreateParentFolder.left = new FormAttachment(0, 0);
        fdlCreateParentFolder.top = new FormAttachment((Control)this.wFilename, margin);
        fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        wlCreateParentFolder.setLayoutData((Object)fdlCreateParentFolder);
        this.wCreateParentFolder = new Button((Composite)wFileGroup, 32);
        this.props.setLook((Control)this.wCreateParentFolder);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.CreateParentFolder.Tooltip", (String[])new String[0]));
        FormData fdCreateParentFolder = new FormData();
        fdCreateParentFolder.left = new FormAttachment(middle, 0);
        fdCreateParentFolder.top = new FormAttachment((Control)wlCreateParentFolder, 0, 0x1000000);
        fdCreateParentFolder.right = new FormAttachment(100, 0);
        this.wCreateParentFolder.setLayoutData((Object)fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWriteToFileDialog.this.action.setChanged();
            }
        });
        Label wlAppendFile = new Label((Composite)wFileGroup, 131072);
        wlAppendFile.setText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.AppendFile.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAppendFile);
        FormData fdlAppendFile = new FormData();
        fdlAppendFile.left = new FormAttachment(0, 0);
        fdlAppendFile.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        fdlAppendFile.right = new FormAttachment(middle, -margin);
        wlAppendFile.setLayoutData((Object)fdlAppendFile);
        this.wAppendFile = new Button((Composite)wFileGroup, 32);
        this.props.setLook((Control)this.wAppendFile);
        this.wAppendFile.setToolTipText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.AppendFile.Tooltip", (String[])new String[0]));
        FormData fdAppendFile = new FormData();
        fdAppendFile.left = new FormAttachment(middle, 0);
        fdAppendFile.top = new FormAttachment((Control)wlAppendFile, 0, 0x1000000);
        fdAppendFile.right = new FormAttachment(100, 0);
        this.wAppendFile.setLayoutData((Object)fdAppendFile);
        this.wAppendFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActionWriteToFileDialog.this.action.setChanged();
            }
        });
        FormData fdFileGroup = new FormData();
        fdFileGroup.left = new FormAttachment(0, margin);
        fdFileGroup.top = new FormAttachment((Control)this.wName, margin);
        fdFileGroup.right = new FormAttachment(100, -margin);
        wFileGroup.setLayoutData((Object)fdFileGroup);
        Group wContentGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)wContentGroup);
        wContentGroup.setText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Group.Content.Label", (String[])new String[0]));
        FormLayout ContentGroupLayout = new FormLayout();
        ContentGroupLayout.marginWidth = 10;
        ContentGroupLayout.marginHeight = 10;
        wContentGroup.setLayout((Layout)ContentGroupLayout);
        Label wlEncoding = new Label((Composite)wContentGroup, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, -margin);
        fdlEncoding.top = new FormAttachment((Control)this.wAppendFile, margin);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new ComboVar(this.variables, (Composite)wContentGroup, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.top = new FormAttachment((Control)this.wAppendFile, margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ActionWriteToFileDialog.this.setEncodings();
            }
        });
        Label wlContent = new Label((Composite)wContentGroup, 131072);
        wlContent.setText(BaseMessages.getString(PKG, (String)"ActionWriteToFile.Content.Label", (String[])new String[0]));
        this.props.setLook((Control)wlContent);
        FormData fdlContent = new FormData();
        fdlContent.left = new FormAttachment(0, 0);
        fdlContent.top = new FormAttachment((Control)this.wEncoding, margin);
        fdlContent.right = new FormAttachment(middle, -margin);
        wlContent.setLayoutData((Object)fdlContent);
        this.wContent = new Text((Composite)wContentGroup, 19202);
        this.props.setLook((Control)this.wContent, 1);
        this.wContent.addModifyListener(lsMod);
        FormData fdContent = new FormData();
        fdContent.left = new FormAttachment(middle, 0);
        fdContent.top = new FormAttachment((Control)this.wEncoding, margin);
        fdContent.right = new FormAttachment(100, 0);
        fdContent.bottom = new FormAttachment(100, -margin);
        this.wContent.setLayoutData((Object)fdContent);
        FormData fdContentGroup = new FormData();
        fdContentGroup.left = new FormAttachment(0, margin);
        fdContentGroup.top = new FormAttachment((Control)wFileGroup, margin);
        fdContentGroup.right = new FormAttachment(100, -margin);
        fdContentGroup.bottom = new FormAttachment((Control)wOk, -margin);
        wContentGroup.setLayoutData((Object)fdContentGroup);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (Charset charSet : values) {
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wFilename.setText(Const.nullToEmpty((String)this.action.getFilename()));
        this.wCreateParentFolder.setSelection(this.action.isCreateParentFolder());
        this.wAppendFile.setSelection(this.action.isAppendFile());
        this.wContent.setText(Const.nullToEmpty((String)this.action.getContent()));
        this.wEncoding.setText(Const.nullToEmpty((String)this.action.getEncoding()));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setFilename(this.wFilename.getText());
        this.action.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        this.action.setAppendFile(this.wAppendFile.getSelection());
        this.action.setContent(this.wContent.getText());
        this.action.setEncoding(this.wEncoding.getText());
        this.dispose();
    }
}

