/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.waitforfile;

import java.util.List;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.w3c.dom.Node;

@Action(id="WAIT_FOR_FILE", name="i18n::ActionWaitForFile.Name", description="i18n::ActionWaitForFile.Description", image="WaitForFile.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", documentationUrl="/workflow/actions/waitforfile.html")
public class ActionWaitForFile
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionWaitForFile.class;
    private String filename = null;
    private String maximumTimeout = DEFAULT_MAXIMUM_TIMEOUT;
    private String checkCycleTime = DEFAULT_CHECK_CYCLE_TIME;
    private boolean successOnTimeout = false;
    private boolean fileSizeCheck = false;
    private boolean addFilenameToResult = false;
    private static String DEFAULT_MAXIMUM_TIMEOUT = "0";
    private static String DEFAULT_CHECK_CYCLE_TIME = "60";

    public ActionWaitForFile(String n) {
        super(n, "");
    }

    public ActionWaitForFile() {
        this("");
    }

    public Object clone() {
        ActionWaitForFile je = (ActionWaitForFile)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(100);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"maximum_timeout", (String)this.maximumTimeout));
        retval.append("      ").append(XmlHandler.addTagValue((String)"check_cycle_time", (String)this.checkCycleTime));
        retval.append("      ").append(XmlHandler.addTagValue((String)"success_on_timeout", (boolean)this.successOnTimeout));
        retval.append("      ").append(XmlHandler.addTagValue((String)"file_size_check", (boolean)this.fileSizeCheck));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_filename_result", (boolean)this.addFilenameToResult));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.filename = XmlHandler.getTagValue((Node)entrynode, (String)"filename");
            this.maximumTimeout = XmlHandler.getTagValue((Node)entrynode, (String)"maximum_timeout");
            this.checkCycleTime = XmlHandler.getTagValue((Node)entrynode, (String)"check_cycle_time");
            this.successOnTimeout = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"success_on_timeout"));
            this.fileSizeCheck = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"file_size_check"));
            this.addFilenameToResult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"add_filename_result"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'wait for file' from XML node", (Throwable)xe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(false);
        long timeStart = System.currentTimeMillis() / 1000L;
        if (this.filename != null) {
            FileObject fileObject = null;
            String realFilename = this.getRealFilename();
            try {
                fileObject = HopVfs.getFileObject((String)realFilename);
                long iMaximumTimeout = Const.toInt((String)this.getRealMaximumTimeout(), (int)Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0));
                long iCycleTime = Const.toInt((String)this.getRealCheckCycleTime(), (int)Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)0));
                if (iMaximumTimeout < 0L) {
                    iMaximumTimeout = Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0);
                    if (this.log.isBasic()) {
                        this.logBasic("Maximum timeout invalid, reset to " + iMaximumTimeout);
                    }
                }
                if (iCycleTime < 1L) {
                    iCycleTime = Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)1);
                    if (this.log.isBasic()) {
                        this.logBasic("Check cycle time invalid, reset to " + iCycleTime);
                    }
                }
                if (iMaximumTimeout == 0L) {
                    if (this.log.isBasic()) {
                        this.logBasic("Waiting indefinitely for file [" + realFilename + "]");
                    }
                } else if (this.log.isBasic()) {
                    this.logBasic("Waiting " + iMaximumTimeout + " seconds for file [" + realFilename + "]");
                }
                boolean continueLoop = true;
                while (continueLoop && !this.parentWorkflow.isStopped()) {
                    fileObject = HopVfs.getFileObject((String)realFilename);
                    if (fileObject.exists()) {
                        if (this.log.isBasic()) {
                            this.logBasic("Detected file [" + realFilename + "] within timeout");
                        }
                        result.setResult(true);
                        continueLoop = false;
                        if (!this.addFilenameToResult || fileObject.getType() != FileType.FILE) continue;
                        ResultFile resultFile = new ResultFile(0, fileObject, this.parentWorkflow.getWorkflowName(), this.toString());
                        resultFile.setComment(BaseMessages.getString(PKG, (String)"ActionWaitForFile.FilenameAdded", (String[])new String[0]));
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        continue;
                    }
                    long now = System.currentTimeMillis() / 1000L;
                    if (iMaximumTimeout > 0L && now > timeStart + iMaximumTimeout) {
                        continueLoop = false;
                        if (this.isSuccessOnTimeout()) {
                            if (this.log.isBasic()) {
                                this.logBasic("Didn't detect file [" + realFilename + "] before timeout, success");
                            }
                            result.setResult(true);
                        } else {
                            if (this.log.isBasic()) {
                                this.logBasic("Didn't detect file [" + realFilename + "] before timeout, failure");
                            }
                            result.setResult(false);
                        }
                    }
                    long sleepTime = 0L;
                    sleepTime = iMaximumTimeout == 0L ? iCycleTime : (now + iCycleTime < timeStart + iMaximumTimeout ? iCycleTime : iCycleTime - (now + iCycleTime - (timeStart + iMaximumTimeout)));
                    try {
                        if (sleepTime <= 0L) continue;
                        if (this.log.isDetailed()) {
                            this.logDetailed("Sleeping " + sleepTime + " seconds before next check for file [" + realFilename + "]");
                        }
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException e) {
                        result.setResult(false);
                        continueLoop = false;
                    }
                }
                if (!this.parentWorkflow.isStopped() && fileObject.exists() && this.isFileSizeCheck()) {
                    long oldSize = -1L;
                    long newSize = fileObject.getContent().getSize();
                    if (this.log.isDetailed()) {
                        this.logDetailed("File [" + realFilename + "] is " + newSize + " bytes long");
                    }
                    if (this.log.isBasic()) {
                        this.logBasic("Waiting until file [" + realFilename + "] stops growing for " + iCycleTime + " seconds");
                    }
                    while (oldSize != newSize && !this.parentWorkflow.isStopped()) {
                        try {
                            if (this.log.isDetailed()) {
                                this.logDetailed("Sleeping " + iCycleTime + " seconds, waiting for file [" + realFilename + "] to stop growing");
                            }
                            Thread.sleep(iCycleTime * 1000L);
                        }
                        catch (InterruptedException e) {
                            result.setResult(false);
                            continueLoop = false;
                        }
                        oldSize = newSize;
                        newSize = fileObject.getContent().getSize();
                        if (!this.log.isDetailed()) continue;
                        this.logDetailed("File [" + realFilename + "] is " + newSize + " bytes long");
                    }
                    if (this.log.isBasic()) {
                        this.logBasic("Stopped waiting for file [" + realFilename + "] to stop growing");
                    }
                }
                if (!this.parentWorkflow.isStopped()) return result;
                result.setResult(false);
                return result;
            }
            catch (Exception e) {
                this.logBasic("Exception while waiting for file [" + realFilename + "] to stop growing", new Object[]{e});
                return result;
            }
            finally {
                if (fileObject != null) {
                    try {
                        fileObject.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        this.logError("No filename is defined.");
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public boolean isSuccessOnTimeout() {
        return this.successOnTimeout;
    }

    public void setSuccessOnTimeout(boolean successOnTimeout) {
        this.successOnTimeout = successOnTimeout;
    }

    public String getCheckCycleTime() {
        return this.checkCycleTime;
    }

    public String getRealCheckCycleTime() {
        return this.resolve(this.getCheckCycleTime());
    }

    public void setCheckCycleTime(String checkCycleTime) {
        this.checkCycleTime = checkCycleTime;
    }

    public String getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public String getRealMaximumTimeout() {
        return this.resolve(this.getMaximumTimeout());
    }

    public void setMaximumTimeout(String maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    public boolean isFileSizeCheck() {
        return this.fileSizeCheck;
    }

    public void setFileSizeCheck(boolean fileSizeCheck) {
        this.fileSizeCheck = fileSizeCheck;
    }

    public boolean isAddFilenameToResult() {
        return this.addFilenameToResult;
    }

    public void setAddFilenameToResult(boolean addFilenameToResult) {
        this.addFilenameToResult = addFilenameToResult;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.filename)) {
            String realFileName = this.resolve(this.filename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "filename", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "maximumTimeout", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "checkCycleTime", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.integerValidator()}));
    }
}

