/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.apache.flink.runtime.checkpoint.OperatorSubtaskState;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.concurrent.FutureUtils;
import org.apache.flink.runtime.state.InputChannelStateHandle;
import org.apache.flink.runtime.state.KeyedStateHandle;
import org.apache.flink.runtime.state.OperatorStateHandle;
import org.apache.flink.runtime.state.ResultSubpartitionStateHandle;
import org.apache.flink.runtime.state.SnapshotResult;
import org.apache.flink.streaming.api.operators.OperatorSnapshotFutures;

public class OperatorSnapshotFinalizer {
    private final OperatorSubtaskState jobManagerOwnedState;
    private final OperatorSubtaskState taskLocalState;

    public OperatorSnapshotFinalizer(@Nonnull OperatorSnapshotFutures snapshotFutures) throws ExecutionException, InterruptedException {
        SnapshotResult keyedManaged = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getKeyedStateManagedFuture());
        SnapshotResult keyedRaw = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getKeyedStateRawFuture());
        SnapshotResult operatorManaged = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getOperatorStateManagedFuture());
        SnapshotResult operatorRaw = (SnapshotResult)FutureUtils.runIfNotDoneAndGet(snapshotFutures.getOperatorStateRawFuture());
        SnapshotResult<StateObjectCollection<InputChannelStateHandle>> inputChannel = snapshotFutures.getInputChannelStateFuture().get();
        SnapshotResult<StateObjectCollection<ResultSubpartitionStateHandle>> resultSubpartition = snapshotFutures.getResultSubpartitionStateFuture().get();
        this.jobManagerOwnedState = new OperatorSubtaskState((OperatorStateHandle)operatorManaged.getJobManagerOwnedSnapshot(), (OperatorStateHandle)operatorRaw.getJobManagerOwnedSnapshot(), (KeyedStateHandle)keyedManaged.getJobManagerOwnedSnapshot(), (KeyedStateHandle)keyedRaw.getJobManagerOwnedSnapshot(), (StateObjectCollection)inputChannel.getJobManagerOwnedSnapshot(), (StateObjectCollection)resultSubpartition.getJobManagerOwnedSnapshot());
        this.taskLocalState = new OperatorSubtaskState((OperatorStateHandle)operatorManaged.getTaskLocalSnapshot(), (OperatorStateHandle)operatorRaw.getTaskLocalSnapshot(), (KeyedStateHandle)keyedManaged.getTaskLocalSnapshot(), (KeyedStateHandle)keyedRaw.getTaskLocalSnapshot(), (StateObjectCollection)inputChannel.getTaskLocalSnapshot(), (StateObjectCollection)resultSubpartition.getTaskLocalSnapshot());
    }

    public OperatorSubtaskState getTaskLocalState() {
        return this.taskLocalState;
    }

    public OperatorSubtaskState getJobManagerOwnedState() {
        return this.jobManagerOwnedState;
    }
}

