/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.type;

import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonDecoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.hop.core.WriterOutputStream;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.ValueDataUtil;
import org.apache.hop.core.row.value.ValueMetaBase;
import org.apache.hop.core.row.value.ValueMetaPlugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

@ValueMetaPlugin(id="20", name="Avro Record", description="This type wraps around an Avro Record", image="Apache_Avro_Logo.svg")
public class ValueMetaAvroRecord
extends ValueMetaBase
implements IValueMeta {
    public static final int TYPE_AVRO_RECORD = 20;

    public ValueMetaAvroRecord() {
        super(null, 20);
    }

    public ValueMetaAvroRecord(String name) {
        super(name, 20);
    }

    public Object getNativeDataType(Object object) throws HopValueException {
        return this.getGenericRecord(object);
    }

    public String toStringMeta() {
        return "Avro Generic Record";
    }

    public GenericRecord getGenericRecord(Object object) throws HopValueException {
        switch (this.type) {
            case 20: {
                switch (this.storageType) {
                    case 0: {
                        return (GenericRecord)object;
                    }
                }
                throw new HopValueException("Only normal storage type is supported for the Avro GenericRecord value : " + this.toString());
            }
            case 2: {
                switch (this.storageType) {
                    case 0: {
                        try {
                            String jsonString = (String)object;
                            return this.convertStringToGenericRecord(jsonString);
                        }
                        catch (Exception e) {
                            throw new HopValueException("Error converting a JSON representation of an Avro GenericRecord to a native representation", (Throwable)e);
                        }
                    }
                }
                throw new HopValueException("Only normal storage type is supported for Avro GenericRecord value : " + this.toString());
            }
        }
        throw new HopValueException("Unable to convert data type " + this.toString() + " to an Avro GenericRecord value");
    }

    public String convertGenericRecordToString(GenericRecord genericRecord) throws HopValueException {
        try {
            Schema schema = genericRecord.getSchema();
            String schemaJson = schema.toString();
            StringWriter stringWriter = new StringWriter();
            WriterOutputStream outputStream = new WriterOutputStream((Writer)stringWriter);
            JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(genericRecord.getSchema(), (OutputStream)outputStream);
            GenericDatumWriter datumWriter = new GenericDatumWriter(genericRecord.getSchema());
            datumWriter.write((Object)genericRecord, (Encoder)jsonEncoder);
            String dataJson = stringWriter.toString();
            String json = "{ \"schema\" : " + schemaJson + ", \"data\" : " + dataJson + " }";
            return json;
        }
        catch (IOException e) {
            throw new HopValueException("Unable to convert an Avro record to a JSON String using the provided schema", (Throwable)e);
        }
    }

    public GenericRecord convertStringToGenericRecord(String jsonString) throws HopValueException {
        try {
            JSONObject json = (JSONObject)new JSONParser().parse(jsonString);
            JSONObject schemaObject = (JSONObject)json.get((Object)"schema");
            JSONObject dataObject = (JSONObject)json.get((Object)"data");
            Schema schema = new Schema.Parser().parse(schemaObject.toJSONString());
            JsonDecoder jsonDecoder = DecoderFactory.get().jsonDecoder(schema, dataObject.toJSONString());
            GenericDatumReader genericDatumReader = new GenericDatumReader(schema);
            return (GenericRecord)genericDatumReader.read(null, (Decoder)jsonDecoder);
        }
        catch (Exception e) {
            throw new HopValueException("Unable to convert a String to an Avro record", (Throwable)e);
        }
    }

    public String getString(Object object) throws HopValueException {
        try {
            String string;
            block1 : switch (this.type) {
                case 2: {
                    switch (this.storageType) {
                        case 0: {
                            string = object == null ? null : this.convertGenericRecordToString((GenericRecord)object);
                            break;
                        }
                        case 1: {
                            string = (String)this.convertBinaryStringToNativeType((byte[])object);
                            break;
                        }
                        case 2: {
                            string = object == null ? null : (String)this.index[(Integer)object];
                            break;
                        }
                        default: {
                            throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                        }
                    }
                    if (string == null) break;
                    string = this.trim(string);
                    break;
                }
                case 3: {
                    throw new HopValueException("You can't convert a Date to an Avro GenericRecord data type for : " + this.toString());
                }
                case 1: {
                    throw new HopValueException("You can't convert a Number to an Avro GenericRecord data type for : " + this.toString());
                }
                case 5: {
                    throw new HopValueException("You can't convert an Integer to an Avro GenericRecord data type for : " + this.toString());
                }
                case 6: {
                    throw new HopValueException("You can't convert a BigNumber to an Avro GenericRecord data type for : " + this.toString());
                }
                case 4: {
                    throw new HopValueException("You can't convert a Boolean to an Avro GenericRecord data type for : " + this.toString());
                }
                case 8: {
                    switch (this.storageType) {
                        case 0: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 1: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.convertBinaryStringToString((byte[])this.index[(Integer)object]);
                            break block1;
                        }
                    }
                    throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 7: {
                    switch (this.storageType) {
                        case 0: {
                            string = object == null ? null : object.toString();
                            break block1;
                        }
                        case 1: {
                            string = this.convertBinaryStringToString((byte[])object);
                            break block1;
                        }
                        case 2: {
                            string = object == null ? null : this.index[(Integer)object].toString();
                            break block1;
                        }
                    }
                    throw new HopValueException(this.toString() + " : Unknown storage type " + this.storageType + " specified.");
                }
                case 20: {
                    switch (this.storageType) {
                        case 0: {
                            string = object == null ? null : object.toString();
                            break block1;
                        }
                    }
                    throw new HopValueException(this.toString() + " : Unsupported storage type " + this.getStorageTypeDesc() + " for " + this.toString());
                }
                default: {
                    throw new HopValueException(this.toString() + " : Unknown type " + this.type + " specified.");
                }
            }
            if (this.isOutputPaddingEnabled() && this.getLength() > 0) {
                string = ValueDataUtil.rightPad((String)string, (int)this.getLength());
            }
            return string;
        }
        catch (ClassCastException e) {
            throw new HopValueException(this.toString() + " : There was a data type error: the data type of " + object.getClass().getName() + " object [" + object + "] does not correspond to value meta [" + this.toStringMeta() + "]");
        }
    }

    public Object cloneValueData(Object object) throws HopValueException {
        if (object == null) {
            return null;
        }
        GenericRecord genericRecord = this.getGenericRecord(object);
        String jsonString = this.convertGenericRecordToString(genericRecord);
        return this.convertStringToGenericRecord(jsonString);
    }

    public Class<?> getNativeDataTypeClass() throws HopValueException {
        return GenericRecord.class;
    }
}

