/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avrodecode;

import java.util.Objects;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;

public class TargetField {
    @HopMetadataProperty(key="source_field")
    private String sourceField;
    @HopMetadataProperty(key="source_avro_type")
    private String sourceAvroType;
    @HopMetadataProperty(key="target_field_name")
    private String targetFieldName;
    @HopMetadataProperty(key="target_type")
    private String targetType;
    @HopMetadataProperty(key="target_format")
    private String targetFormat;
    @HopMetadataProperty(key="target_length")
    private String targetLength;
    @HopMetadataProperty(key="target_precision")
    private String targetPrecision;

    public TargetField() {
    }

    public TargetField(String sourceField, String sourceAvroType, String targetFieldName, String targetType, String targetFormat, String targetLength, String targetPrecision) {
        this.sourceField = sourceField;
        this.sourceAvroType = sourceAvroType;
        this.targetFieldName = targetFieldName;
        this.targetType = targetType;
        this.targetFormat = targetFormat;
        this.targetLength = targetLength;
        this.targetPrecision = targetPrecision;
    }

    public TargetField(TargetField f) {
        this.sourceField = f.sourceField;
        this.sourceAvroType = f.sourceAvroType;
        this.targetFieldName = f.targetFieldName;
        this.targetType = f.targetType;
        this.targetFormat = f.targetFormat;
        this.targetLength = f.targetLength;
        this.targetPrecision = f.targetPrecision;
    }

    public TargetField clone() {
        return new TargetField(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetField that = (TargetField)o;
        return Objects.equals(this.sourceField, that.sourceField);
    }

    public int hashCode() {
        return Objects.hash(this.sourceField);
    }

    public IValueMeta createTargetValueMeta(IVariables variables) throws HopException {
        String name = variables.resolve(this.targetFieldName);
        int type = ValueMetaFactory.getIdForValueMeta((String)variables.resolve(this.targetType));
        int length = Const.toInt((String)variables.resolve(this.targetLength), (int)-1);
        int precision = Const.toInt((String)variables.resolve(this.targetPrecision), (int)-1);
        IValueMeta valueMeta = ValueMetaFactory.createValueMeta((String)name, (int)type, (int)length, (int)precision);
        valueMeta.setConversionMask(variables.resolve(this.targetFormat));
        return valueMeta;
    }

    public String getSourceField() {
        return this.sourceField;
    }

    public void setSourceField(String sourceField) {
        this.sourceField = sourceField;
    }

    public String getSourceAvroType() {
        return this.sourceAvroType;
    }

    public void setSourceAvroType(String sourceAvroType) {
        this.sourceAvroType = sourceAvroType;
    }

    public String getTargetFieldName() {
        return this.targetFieldName;
    }

    public void setTargetFieldName(String targetFieldName) {
        this.targetFieldName = targetFieldName;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public void setTargetType(String targetType) {
        this.targetType = targetType;
    }

    public String getTargetFormat() {
        return this.targetFormat;
    }

    public void setTargetFormat(String targetFormat) {
        this.targetFormat = targetFormat;
    }

    public String getTargetLength() {
        return this.targetLength;
    }

    public void setTargetLength(String targetLength) {
        this.targetLength = targetLength;
    }

    public String getTargetPrecision() {
        return this.targetPrecision;
    }

    public void setTargetPrecision(String targetPrecision) {
        this.targetPrecision = targetPrecision;
    }
}

