/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.avro.transforms.avrodecode;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.avro.transforms.avrodecode.AvroDecode;
import org.apache.hop.avro.transforms.avrodecode.AvroDecodeData;
import org.apache.hop.avro.transforms.avrodecode.TargetField;
import org.apache.hop.avro.transforms.avroinput.AvroFileInput;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="AvroDecode", name="Avro Decode", description="Decodes Avro data types into Hop fields", image="avro_decode.svg", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Input", documentationUrl="/pipeline/transforms/avro-decode.html", keywords={"Avro", "Decode"})
@InjectionSupported(localizationPrefix="AvroInputMeta.Injection.")
public class AvroDecodeMeta
extends BaseTransformMeta
implements ITransformMeta<AvroFileInput, AvroDecodeData> {
    private static final Class<?> PKG = AvroDecodeMeta.class;
    @HopMetadataProperty(key="source_field")
    private String sourceFieldName = "avro";
    @HopMetadataProperty(key="ignore_missing")
    private boolean ignoringMissingPaths = true;
    @HopMetadataProperty(groupKey="fields", key="field")
    private List<TargetField> targetFields = new ArrayList<TargetField>();

    public void getFields(IRowMeta rowMeta, String transformName, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        for (TargetField targetField : this.targetFields) {
            try {
                IValueMeta valueMeta = targetField.createTargetValueMeta(variables);
                rowMeta.addValueMeta(valueMeta);
            }
            catch (HopException e) {
                throw new HopTransformException("Error creating target field with name " + targetField.getTargetFieldName(), (Throwable)e);
            }
        }
    }

    public AvroDecode createTransform(TransformMeta transformMeta, AvroDecodeData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new AvroDecode(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public AvroDecodeData getTransformData() {
        return new AvroDecodeData();
    }

    public String getSourceFieldName() {
        return this.sourceFieldName;
    }

    public void setSourceFieldName(String sourceFieldName) {
        this.sourceFieldName = sourceFieldName;
    }

    public boolean isIgnoringMissingPaths() {
        return this.ignoringMissingPaths;
    }

    public void setIgnoringMissingPaths(boolean ignoringMissingPaths) {
        this.ignoringMissingPaths = ignoringMissingPaths;
    }

    public List<TargetField> getTargetFields() {
        return this.targetFields;
    }

    public void setTargetFields(List<TargetField> targetFields) {
        this.targetFields = targetFields;
    }
}

