/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.unzip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.AllFileSelector;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSelectInfo;
import org.apache.commons.vfs2.FileSelector;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.impl.DefaultFileSystemManager;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.w3c.dom.Node;

@Action(id="UNZIP", name="i18n::ActionUnZip.Name", description="i18n::ActionUnZip.Description", image="UnZip.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", documentationUrl="/workflow/actions/unzip.html")
public class ActionUnZip
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionUnZip.class;
    private String zipFilename = null;
    public int afterunzip = 0;
    private String wildcard = null;
    private String wildcardExclude = null;
    private String sourcedirectory = null;
    private String movetodirectory = null;
    private boolean addfiletoresult = false;
    private boolean isfromprevious = false;
    private boolean adddate = false;
    private boolean addtime = false;
    private boolean specifyFormat = false;
    private String dateTimeFormat;
    private boolean rootzip = false;
    private boolean createfolder = false;
    private String nrLimit = "10";
    private String wildcardSource = null;
    private int iffileexist = 0;
    private boolean createMoveToDirectory = false;
    private boolean addOriginalTimestamp = false;
    private boolean setOriginalModificationDate = false;
    public String SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String successCondition = this.SUCCESS_IF_NO_ERRORS;
    public static final int IF_FILE_EXISTS_SKIP = 0;
    public static final int IF_FILE_EXISTS_OVERWRITE = 1;
    public static final int IF_FILE_EXISTS_UNIQ = 2;
    public static final int IF_FILE_EXISTS_FAIL = 3;
    public static final int IF_FILE_EXISTS_OVERWRITE_DIFF_SIZE = 4;
    public static final int IF_FILE_EXISTS_OVERWRITE_EQUAL_SIZE = 5;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_BIG = 6;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_BIG_EQUAL = 7;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_SMALL = 8;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_SMALL_EQUAL = 9;
    public static final String[] typeIfFileExistsCode = new String[]{"SKIP", "OVERWRITE", "UNIQ", "FAIL", "OVERWRITE_DIFF_SIZE", "OVERWRITE_EQUAL_SIZE", "OVERWRITE_ZIP_BIG", "OVERWRITE_ZIP_BIG_EQUAL", "OVERWRITE_ZIP_BIG_SMALL", "OVERWRITE_ZIP_BIG_SMALL_EQUAL"};
    public static final String[] typeIfFileExistsDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionUnZip.Skip.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.Overwrite.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.Give_Unique_Name.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.Fail.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfSizeDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfSizeEquals.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfZipBigger.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfZipBiggerOrEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfZipSmaller.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionUnZip.OverwriteIfZipSmallerOrEqual.Label", (String[])new String[0])};
    private int nrErrors = 0;
    private int nrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFiles = 0;
    private static SimpleDateFormat daf;
    private boolean dateFormatSet = false;

    public ActionUnZip(String n) {
        super(n, "");
    }

    public ActionUnZip() {
        this("");
    }

    public Object clone() {
        ActionUnZip je = (ActionUnZip)super.clone();
        return je;
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(550);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"zipfilename", (String)this.zipFilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XmlHandler.addTagValue((String)"wildcardexclude", (String)this.wildcardExclude));
        retval.append("      ").append(XmlHandler.addTagValue((String)"targetdirectory", (String)this.sourcedirectory));
        retval.append("      ").append(XmlHandler.addTagValue((String)"movetodirectory", (String)this.movetodirectory));
        retval.append("      ").append(XmlHandler.addTagValue((String)"afterunzip", (int)this.afterunzip));
        retval.append("      ").append(XmlHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XmlHandler.addTagValue((String)"isfromprevious", (boolean)this.isfromprevious));
        retval.append("      ").append(XmlHandler.addTagValue((String)"adddate", (boolean)this.adddate));
        retval.append("      ").append(XmlHandler.addTagValue((String)"addtime", (boolean)this.addtime));
        retval.append("      ").append(XmlHandler.addTagValue((String)"addOriginalTimestamp", (boolean)this.addOriginalTimestamp));
        retval.append("      ").append(XmlHandler.addTagValue((String)"SpecifyFormat", (boolean)this.specifyFormat));
        retval.append("      ").append(XmlHandler.addTagValue((String)"date_time_format", (String)this.dateTimeFormat));
        retval.append("      ").append(XmlHandler.addTagValue((String)"rootzip", (boolean)this.rootzip));
        retval.append("      ").append(XmlHandler.addTagValue((String)"createfolder", (boolean)this.createfolder));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nr_limit", (String)this.nrLimit));
        retval.append("      ").append(XmlHandler.addTagValue((String)"wildcardSource", (String)this.wildcardSource));
        retval.append("      ").append(XmlHandler.addTagValue((String)"success_condition", (String)this.successCondition));
        retval.append("      ").append(XmlHandler.addTagValue((String)"iffileexists", (String)ActionUnZip.getIfFileExistsCode(this.iffileexist)));
        retval.append("      ").append(XmlHandler.addTagValue((String)"create_move_to_directory", (boolean)this.createMoveToDirectory));
        retval.append("      ").append(XmlHandler.addTagValue((String)"setOriginalModificationDate", (boolean)this.setOriginalModificationDate));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.zipFilename = XmlHandler.getTagValue((Node)entrynode, (String)"zipfilename");
            this.afterunzip = Const.toInt((String)XmlHandler.getTagValue((Node)entrynode, (String)"afterunzip"), (int)-1);
            this.wildcard = XmlHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.wildcardExclude = XmlHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
            this.sourcedirectory = XmlHandler.getTagValue((Node)entrynode, (String)"targetdirectory");
            this.movetodirectory = XmlHandler.getTagValue((Node)entrynode, (String)"movetodirectory");
            this.addfiletoresult = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.isfromprevious = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"isfromprevious"));
            this.adddate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"adddate"));
            this.addtime = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"addtime"));
            this.addOriginalTimestamp = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"addOriginalTimestamp"));
            this.specifyFormat = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.dateTimeFormat = XmlHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.rootzip = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"rootzip"));
            this.createfolder = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"createfolder"));
            this.nrLimit = XmlHandler.getTagValue((Node)entrynode, (String)"nr_limit");
            this.wildcardSource = XmlHandler.getTagValue((Node)entrynode, (String)"wildcardSource");
            this.successCondition = XmlHandler.getTagValue((Node)entrynode, (String)"success_condition");
            if (Utils.isEmpty((CharSequence)this.successCondition)) {
                this.successCondition = this.SUCCESS_IF_NO_ERRORS;
            }
            this.iffileexist = ActionUnZip.getIfFileExistsInt(XmlHandler.getTagValue((Node)entrynode, (String)"iffileexists"));
            this.createMoveToDirectory = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"create_move_to_directory"));
            this.setOriginalModificationDate = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"setOriginalModificationDate"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load action of type 'unzip' from XML node", (Throwable)xe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result execute(Result previousResult, int nr) {
        Result result;
        block90: {
            FileObject movetodir;
            FileObject fileObject;
            String realMovetodirectory;
            String realTargetdirectory;
            String realWildcardExclude;
            String realWildcard;
            String realWildcardSource;
            String realFilenameSource;
            RowMetaAndData resultRow;
            List rows;
            block91: {
                result = previousResult;
                result.setResult(false);
                result.setNrErrors(1L);
                rows = result.getRows();
                resultRow = null;
                realFilenameSource = this.resolve(this.zipFilename);
                realWildcardSource = this.resolve(this.wildcardSource);
                realWildcard = this.resolve(this.wildcard);
                realWildcardExclude = this.resolve(this.wildcardExclude);
                realTargetdirectory = this.resolve(this.sourcedirectory);
                realMovetodirectory = this.resolve(this.movetodirectory);
                this.limitFiles = Const.toInt((String)this.resolve(this.getLimit()), (int)10);
                this.nrErrors = 0;
                this.nrSuccess = 0;
                this.successConditionBroken = false;
                this.successConditionBrokenExit = false;
                if (this.isfromprevious) {
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
                    }
                    if (rows.size() == 0) {
                        return result;
                    }
                } else if (Utils.isEmpty((CharSequence)this.zipFilename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.No_ZipFile_Defined.Label", (String[])new String[0]));
                    return result;
                }
                fileObject = null;
                FileObject targetdir = null;
                movetodir = null;
                try {
                    boolean exitaction;
                    block93: {
                        block92: {
                            if (Utils.isEmpty((CharSequence)realTargetdirectory)) {
                                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.TargetFolderMissing", (String[])new String[0]));
                                Result result2 = result;
                                return result2;
                            }
                            exitaction = false;
                            targetdir = HopVfs.getFileObject((String)realTargetdirectory);
                            if (targetdir.exists()) break block92;
                            if (this.createfolder) {
                                targetdir.createFolder();
                                if (this.log.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.TargetFolderCreated", (String[])new String[]{realTargetdirectory}));
                                }
                                break block93;
                            } else {
                                this.log.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.TargetFolderNotFound.Label", (String[])new String[0]));
                                exitaction = true;
                            }
                            break block93;
                        }
                        if (targetdir.getType() != FileType.FOLDER) {
                            this.log.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.TargetFolderNotFolder.Label", (String[])new String[]{realTargetdirectory}));
                            exitaction = true;
                        } else if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.TargetFolderExists.Label", (String[])new String[]{realTargetdirectory}));
                        }
                    }
                    if (this.afterunzip == 2) {
                        if (Utils.isEmpty((CharSequence)this.movetodirectory)) {
                            this.log.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.MoveToDirectoryEmpty.Label", (String[])new String[0]));
                            exitaction = true;
                        } else {
                            movetodir = HopVfs.getFileObject((String)realMovetodirectory);
                            if (!movetodir.exists() || movetodir.getType() != FileType.FOLDER) {
                                if (this.createMoveToDirectory) {
                                    movetodir.createFolder();
                                    if (this.log.isDetailed()) {
                                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.MoveToFolderCreated", (String[])new String[]{realMovetodirectory}));
                                    }
                                } else {
                                    this.log.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.MoveToDirectoryNotExists.Label", (String[])new String[0]));
                                    exitaction = true;
                                }
                            }
                        }
                    }
                    if (exitaction) {
                        Result result3 = result;
                        return result3;
                    }
                    if (this.isfromprevious) {
                        if (rows == null) break block90;
                        break block91;
                    }
                    fileObject = HopVfs.getFileObject((String)realFilenameSource);
                    if (!fileObject.exists()) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.ZipFile.NotExists.Label", (String[])new String[]{realFilenameSource}));
                        Result result4 = result;
                        return result4;
                    }
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Zip_FileExists.Label", (String[])new String[]{realFilenameSource}));
                    }
                    if (Utils.isEmpty((CharSequence)this.sourcedirectory)) {
                        this.log.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.SourceFolderNotFound.Label", (String[])new String[0]));
                        Result result5 = result;
                        return result5;
                    }
                    this.processOneFile(result, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, fileObject, realTargetdirectory, realWildcard, realWildcardExclude, movetodir, realMovetodirectory, realWildcardSource);
                    break block90;
                }
                catch (Exception e) {
                    this.log.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.ErrorUnzip.Label", (String[])new String[]{realFilenameSource, e.getMessage()}));
                    this.updateErrors();
                    break block90;
                }
                finally {
                    if (fileObject != null) {
                        try {
                            fileObject.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (targetdir != null) {
                        try {
                            targetdir.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (movetodir != null) {
                        try {
                            movetodir.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            for (int iteration = 0; iteration < rows.size() && !this.parentWorkflow.isStopped(); ++iteration) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.SuccessConditionbroken", (String[])new String[]{"" + this.nrErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    result.setNrErrors((long)this.nrErrors);
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(iteration);
                realFilenameSource = resultRow.getString(0, null);
                realWildcardSource = resultRow.getString(1, null);
                fileObject = HopVfs.getFileObject((String)realFilenameSource);
                if (fileObject.exists()) {
                    this.processOneFile(result, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow, fileObject, realTargetdirectory, realWildcard, realWildcardExclude, movetodir, realMovetodirectory, realWildcardSource);
                    continue;
                }
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.CanNotFindFile", (String[])new String[]{realFilenameSource}));
            }
        }
        result.setNrErrors((long)this.nrErrors);
        result.setNrLinesWritten((long)this.nrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        this.displayResults();
        return result;
    }

    private void displayResults() {
        if (this.log.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.Info.FilesInError", (String[])new String[]{"" + this.nrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.Info.FilesInSuccess", (String[])new String[]{"" + this.nrSuccess}));
            this.logDetailed("=======================================");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processOneFile(Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow, FileObject fileObject, String realTargetdirectory, String realWildcard, String realWildcardExclude, FileObject movetodir, String realMovetodirectory, String realWildcardSource) {
        boolean retval;
        block28: {
            retval = false;
            try {
                if (fileObject.getType().equals((Object)FileType.FILE)) {
                    if (!this.unzipFile(fileObject, realTargetdirectory, realWildcard, realWildcardExclude, result, parentWorkflow, movetodir, realMovetodirectory)) {
                        this.updateErrors();
                    } else {
                        this.updateSuccess();
                    }
                    break block28;
                }
                FileObject[] children = fileObject.getChildren();
                int i = 0;
                while (true) {
                    if (i < children.length && !parentWorkflow.isStopped()) {
                        if (this.successConditionBroken) {
                            if (!this.successConditionBrokenExit) {
                                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.SuccessConditionbroken", (String[])new String[]{"" + this.nrErrors}));
                                this.successConditionBrokenExit = true;
                            }
                            boolean bl = false;
                            return bl;
                        }
                        if (!children[i].getType().equals((Object)FileType.FOLDER)) {
                            boolean unzip = true;
                            String filename = children[i].getName().getPath();
                            Pattern patternSource = null;
                            if (!Utils.isEmpty((CharSequence)realWildcardSource)) {
                                patternSource = Pattern.compile(realWildcardSource);
                            }
                            if (patternSource != null) {
                                Matcher matcher = patternSource.matcher(filename);
                                unzip = matcher.matches();
                            }
                            if (unzip) {
                                if (!this.unzipFile(children[i], realTargetdirectory, realWildcard, realWildcardExclude, result, parentWorkflow, movetodir, realMovetodirectory)) {
                                    this.updateErrors();
                                } else {
                                    this.updateSuccess();
                                }
                            }
                        }
                        ++i;
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.Label", (String[])new String[]{e.getMessage()}));
            }
            finally {
                if (fileObject != null) {
                    try {
                        fileObject.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean unzipFile(FileObject sourceFileObject, String realTargetdirectory, String realWildcard, String realWildcardExclude, Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow, FileObject movetodir, String realMovetodirectory) {
        boolean retval = false;
        String unzipToFolder = realTargetdirectory;
        try {
            if (this.log.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.ProcessingFile", (String[])new String[]{sourceFileObject.toString()}));
            }
            if (this.rootzip) {
                String folderName;
                FileObject rootfolder;
                String shortSourceFilename = sourceFileObject.getName().getBaseName();
                int lenstring = shortSourceFilename.length();
                int lastindexOfDot = shortSourceFilename.lastIndexOf(46);
                if (lastindexOfDot == -1) {
                    lastindexOfDot = lenstring;
                }
                if (!(rootfolder = HopVfs.getFileObject((String)(folderName = realTargetdirectory + "/" + shortSourceFilename.substring(0, lastindexOfDot)))).exists()) {
                    try {
                        rootfolder.createFolder();
                        if (this.log.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.RootFolderCreated", (String[])new String[]{folderName}));
                        }
                    }
                    catch (Exception e) {
                        throw new Exception(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.CanNotCreateRootFolder", (String[])new String[]{folderName}), e);
                    }
                }
                unzipToFolder = folderName;
            }
            String zipFilename = "zip:" + sourceFileObject.getName().getFriendlyURI();
            FileObject zipFile = HopVfs.getFileObject((String)zipFilename);
            FileObject[] items = zipFile.findFiles((FileSelector)new AllFileSelector(){

                public boolean traverseDescendents(FileSelectInfo info) {
                    return true;
                }

                public boolean includeFile(FileSelectInfo info) {
                    if (info.getDepth() == 0) {
                        return false;
                    }
                    FileObject fileObject = info.getFile();
                    return fileObject != null;
                }
            });
            Pattern pattern = null;
            if (!Utils.isEmpty((CharSequence)realWildcard)) {
                pattern = Pattern.compile(realWildcard);
            }
            Pattern patternexclude = null;
            if (!Utils.isEmpty((CharSequence)realWildcardExclude)) {
                patternexclude = Pattern.compile(realWildcardExclude);
            }
            for (FileObject item : items) {
                if (this.successConditionBroken) {
                    if (!this.successConditionBrokenExit) {
                        this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.SuccessConditionbroken", (String[])new String[]{"" + this.nrErrors}));
                        this.successConditionBrokenExit = true;
                    }
                    return false;
                }
                DefaultFileSystemManager defaultFileSystemManager = HopVfs.getFileSystemManager();
                synchronized (defaultFileSystemManager) {
                    block50: {
                        FileObject newFileObject = null;
                        try {
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.ProcessingZipEntry", (String[])new String[]{item.getName().getURI(), sourceFileObject.toString()}));
                            }
                            String newFileName = unzipToFolder + Const.FILE_SEPARATOR + this.getTargetFilename(item);
                            newFileObject = HopVfs.getFileObject((String)newFileName);
                            if (item.getType().equals((Object)FileType.FOLDER)) {
                                if (this.log.isDetailed()) {
                                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.CreatingDirectory.Label", (String[])new String[]{newFileName}));
                                }
                                if (!newFileObject.exists()) {
                                    newFileObject.createFolder();
                                }
                                break block50;
                            }
                            boolean getIt = true;
                            boolean getItexclude = false;
                            if (pattern != null) {
                                Matcher matcher = pattern.matcher(item.getName().getURI());
                                getIt = matcher.matches();
                            }
                            if (patternexclude != null) {
                                Matcher matcherexclude = patternexclude.matcher(item.getName().getURI());
                                getItexclude = matcherexclude.matches();
                            }
                            boolean take = this.takeThisFile(item, newFileName);
                            if (!getIt || getItexclude || !take) break block50;
                            if (this.log.isDetailed()) {
                                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.ExtractingEntry.Label", (String[])new String[]{item.getName().getURI(), newFileName}));
                            }
                            if (this.iffileexist == 2) {
                                int lenstring = newFileName.length();
                                int lastindexOfDot = newFileName.lastIndexOf(46);
                                if (lastindexOfDot == -1) {
                                    lastindexOfDot = lenstring;
                                }
                                newFileName = newFileName.substring(0, lastindexOfDot) + StringUtil.getFormattedDateTimeNow((boolean)true) + newFileName.substring(lastindexOfDot, lenstring);
                                if (this.log.isDebug()) {
                                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.CreatingUniqFile", (String[])new String[]{newFileName}));
                                }
                            }
                            if (!newFileObject.getParent().exists()) {
                                newFileObject.getParent().createFolder();
                            }
                            InputStream is = null;
                            OutputStream os = null;
                            try {
                                is = HopVfs.getInputStream((FileObject)item);
                                os = HopVfs.getOutputStream((FileObject)newFileObject, (boolean)false);
                                if (is != null) {
                                    int len;
                                    byte[] buff = new byte[2048];
                                    while ((len = is.read(buff)) > 0) {
                                        os.write(buff, 0, len);
                                    }
                                    this.addFilenameToResultFilenames(result, parentWorkflow, newFileName);
                                }
                            }
                            finally {
                                if (is != null) {
                                    is.close();
                                }
                                if (os != null) {
                                    os.close();
                                }
                            }
                        }
                        catch (Exception e) {
                            this.updateErrors();
                            this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Error.CanNotProcessZipEntry", (String[])new String[]{item.getName().getURI(), sourceFileObject.toString()}), e);
                        }
                        finally {
                            if (newFileObject != null) {
                                try {
                                    newFileObject.close();
                                    if (this.setOriginalModificationDate) {
                                        newFileObject.getContent().setLastModifiedTime(item.getContent().getLastModifiedTime());
                                    }
                                }
                                catch (Exception exception) {}
                            }
                            HopVfs.getFileSystemManager().closeFileSystem(item.getFileSystem());
                            if (items != null) {
                                items = null;
                            }
                        }
                    }
                }
            }
            if (this.afterunzip > 0) {
                this.doUnzipPostProcessing(sourceFileObject, movetodir, realMovetodirectory);
            }
            retval = true;
        }
        catch (Exception e) {
            this.updateErrors();
            this.log.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.ErrorUnzip.Label", (String[])new String[]{sourceFileObject.toString(), e.getMessage()}), (Throwable)e);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUnzipPostProcessing(FileObject sourceFileObject, FileObject movetodir, String realMovetodirectory) throws FileSystemException {
        if (this.afterunzip == 1) {
            boolean deleted = sourceFileObject.delete();
            if (!deleted) {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Cant_Delete_File.Label", (String[])new String[]{sourceFileObject.toString()}));
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.File_Deleted.Label", (String[])new String[]{sourceFileObject.toString()}));
            }
        } else if (this.afterunzip == 2) {
            FileObject destFile = null;
            try {
                String destinationFilename = movetodir + Const.FILE_SEPARATOR + sourceFileObject.getName().getBaseName();
                destFile = HopVfs.getFileObject((String)destinationFilename);
                sourceFileObject.moveTo(destFile);
                if (this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileMovedTo", (String[])new String[]{sourceFileObject.toString(), realMovetodirectory}));
                }
            }
            catch (Exception e) {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Cant_Move_File.Label", (String[])new String[]{sourceFileObject.toString(), realMovetodirectory, e.getMessage()}));
            }
            finally {
                if (destFile != null) {
                    try {
                        destFile.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    private void addFilenameToResultFilenames(Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow, String newfile) throws Exception {
        if (this.addfiletoresult) {
            ResultFile resultFile = new ResultFile(0, HopVfs.getFileObject((String)newfile), parentWorkflow.getWorkflowName(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
    }

    private void updateErrors() {
        ++this.nrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private void updateSuccess() {
        ++this.nrSuccess;
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.nrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.nrErrors >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.nrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.nrSuccess >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED) || this.nrErrors <= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean takeThisFile(FileObject sourceFile, String destinationFile) throws FileSystemException {
        boolean retval = false;
        File destination = new File(destinationFile);
        if (!destination.exists()) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.CanNotFindFile", (String[])new String[]{destinationFile}));
            }
            return true;
        }
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileExists", (String[])new String[]{destinationFile}));
        }
        if (this.iffileexist == 0) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileSkip", (String[])new String[]{destinationFile}));
            }
            return false;
        }
        if (this.iffileexist == 3) {
            this.updateErrors();
            this.logError(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileError", (String[])new String[]{destinationFile, "" + this.nrErrors}));
            return false;
        }
        if (this.iffileexist == 1) {
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileOverwrite", (String[])new String[]{destinationFile}));
            }
            return true;
        }
        Long entrySize = sourceFile.getContent().getSize();
        Long destinationSize = destination.length();
        if (this.iffileexist == 4) {
            if (entrySize != destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileDiffSize.Diff", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileDiffSize.Same", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 5) {
            if (entrySize == destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileEqualSize.Same", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileEqualSize.Diff", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 6) {
            if (entrySize > destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileBigSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileBigSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 7) {
            if (entrySize >= destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileBigEqualSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileBigEqualSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 8) {
            if (entrySize < destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileSmallSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileSmallSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 9) {
            if (entrySize <= destinationSize) {
                if (this.log.isDebug()) {
                    this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileSmallEqualSize.Small", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
                }
                return true;
            }
            if (this.log.isDebug()) {
                this.logDebug(BaseMessages.getString(PKG, (String)"ActionUnZip.Log.FileSmallEqualSize.Big", (String[])new String[]{sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize}));
            }
            return false;
        }
        if (this.iffileexist == 2) {
            return true;
        }
        return retval;
    }

    public boolean isEvaluation() {
        return true;
    }

    public static final int getIfFileExistsInt(String desc) {
        for (int i = 0; i < typeIfFileExistsCode.length; ++i) {
            if (!typeIfFileExistsCode[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getIfFileExistsCode(int i) {
        if (i < 0 || i >= typeIfFileExistsCode.length) {
            return null;
        }
        return typeIfFileExistsCode[i];
    }

    public int getIfFileExist() {
        return this.iffileexist;
    }

    public void setIfFileExists(int iffileexist) {
        this.iffileexist = iffileexist;
    }

    public boolean isCreateMoveToDirectory() {
        return this.createMoveToDirectory;
    }

    public void setCreateMoveToDirectory(boolean createMoveToDirectory) {
        this.createMoveToDirectory = createMoveToDirectory;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setWildcardExclude(String wildcardExclude) {
        this.wildcardExclude = wildcardExclude;
    }

    public void setSourceDirectory(String targetdirectoryin) {
        this.sourcedirectory = targetdirectoryin;
    }

    public void setMoveToDirectory(String movetodirectory) {
        this.movetodirectory = movetodirectory;
    }

    public String getSourceDirectory() {
        return this.sourcedirectory;
    }

    public String getMoveToDirectory() {
        return this.movetodirectory;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public String getWildcardSource() {
        return this.wildcardSource;
    }

    public void setWildcardSource(String wildcardSource) {
        this.wildcardSource = wildcardSource;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getWildcardExclude() {
        return this.wildcardExclude;
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    public void setDateInFilename(boolean adddate) {
        this.adddate = adddate;
    }

    public void setAddOriginalTimestamp(boolean addOriginalTimestamp) {
        this.addOriginalTimestamp = addOriginalTimestamp;
    }

    public boolean isOriginalTimestamp() {
        return this.addOriginalTimestamp;
    }

    public void setOriginalModificationDate(boolean setOriginalModificationDate) {
        this.setOriginalModificationDate = setOriginalModificationDate;
    }

    public boolean isOriginalModificationDate() {
        return this.setOriginalModificationDate;
    }

    public boolean isDateInFilename() {
        return this.adddate;
    }

    public void setTimeInFilename(boolean addtime) {
        this.addtime = addtime;
    }

    public boolean isTimeInFilename() {
        return this.addtime;
    }

    public boolean isSpecifyFormat() {
        return this.specifyFormat;
    }

    public void setSpecifyFormat(boolean specifyFormat) {
        this.specifyFormat = specifyFormat;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat;
    }

    public void setDateTimeFormat(String dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
    }

    public void setDatafromprevious(boolean isfromprevious) {
        this.isfromprevious = isfromprevious;
    }

    public boolean getDatafromprevious() {
        return this.isfromprevious;
    }

    public void setCreateRootFolder(boolean rootzip) {
        this.rootzip = rootzip;
    }

    public boolean isCreateRootFolder() {
        return this.rootzip;
    }

    public void setCreateFolder(boolean createfolder) {
        this.createfolder = createfolder;
    }

    public boolean isCreateFolder() {
        return this.createfolder;
    }

    public void setLimit(String nrLimitin) {
        this.nrLimit = nrLimitin;
    }

    public String getLimit() {
        return this.nrLimit;
    }

    public void setSuccessCondition(String successCondition) {
        this.successCondition = successCondition;
    }

    public String getSuccessCondition() {
        return this.successCondition;
    }

    protected String getTargetFilename(FileObject file) throws FileSystemException {
        String retval = "";
        String filename = file.getName().getPath();
        if (filename != null) {
            retval = filename;
        }
        if (file.getType() != FileType.FILE) {
            return retval;
        }
        if (!(this.specifyFormat || this.adddate || this.addtime)) {
            return retval;
        }
        int lenstring = retval.length();
        int lastindexOfDot = retval.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = retval.substring(0, lastindexOfDot);
        if (daf == null) {
            daf = new SimpleDateFormat();
        }
        Date timestamp = new Date();
        if (this.addOriginalTimestamp) {
            timestamp = new Date(file.getContent().getLastModifiedTime());
        }
        if (this.specifyFormat && !Utils.isEmpty((CharSequence)this.dateTimeFormat)) {
            if (!this.dateFormatSet) {
                daf.applyPattern(this.dateTimeFormat);
            }
            String dt = daf.format(timestamp);
            retval = retval + dt;
        } else {
            if (this.adddate) {
                if (!this.dateFormatSet) {
                    daf.applyPattern("yyyyMMdd");
                }
                String d = daf.format(timestamp);
                retval = retval + "_" + d;
            }
            if (this.addtime) {
                if (!this.dateFormatSet) {
                    daf.applyPattern("HHmmssSSS");
                }
                String t = daf.format(timestamp);
                retval = retval + "_" + t;
            }
        }
        if (daf != null) {
            this.dateFormatSet = true;
        }
        retval = retval + filename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx1 = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx1, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx1, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileDoesNotExistValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "zipFilename", remarks, ctx1);
        if (2 == this.afterunzip) {
            ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "moveToDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
        }
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "sourceDirectory", remarks, AndValidator.putValidators((IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator()}));
    }
}

