/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.zipfile;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.zipfile.ZipFile;
import org.apache.hop.pipeline.transforms.zipfile.ZipFileData;

@Transform(id="ZipFile", image="zipfile.svg", name="i18n::ZipFile.Name", description="i18n::ZipFile.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", documentationUrl="/pipeline/transforms/zipfile.html")
public class ZipFileMeta
extends BaseTransformMeta
implements ITransformMeta<ZipFile, ZipFileData> {
    private static final Class<?> PKG = ZipFileMeta.class;
    @HopMetadataProperty(key="sourcefilenamefield", injectionKeyDescription="")
    private String sourceFilenameField;
    @HopMetadataProperty(key="targetfilenamefield", injectionKeyDescription="")
    private String targetFilenameField;
    @HopMetadataProperty(key="baseFolderField", injectionKeyDescription="")
    private String baseFolderField;
    @HopMetadataProperty(key="movetofolderfield", injectionKeyDescription="")
    private String moveToFolderField;
    @HopMetadataProperty(key="addresultfilenames", injectionKeyDescription="")
    private boolean addResultFilenames;
    @HopMetadataProperty(key="overwritezipentry", injectionKeyDescription="")
    private boolean overwriteZipEntry;
    @HopMetadataProperty(key="createparentfolder", injectionKeyDescription="")
    private boolean createParentFolder;
    @HopMetadataProperty(key="keepsourcefolder", injectionKeyDescription="")
    private boolean keepSourceFolder;
    @HopMetadataProperty(key="operation_type", injectionKeyDescription="")
    private String operationTypeMeta;
    private int operationType;
    public static final String[] operationTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ZipFileMeta.operationType.DoNothing", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ZipFileMeta.operationType.Move", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ZipFileMeta.operationType.Delete", (String[])new String[0])};
    public static final String[] operationTypeCode = new String[]{"", "move", "delete"};
    public static final int OPERATION_TYPE_NOTHING = 0;
    public static final int OPERATION_TYPE_MOVE = 1;
    public static final int OPERATION_TYPE_DELETE = 2;

    public ITransform createTransform(TransformMeta transformMeta, ZipFileData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new ZipFile(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public String getSourceFilenameField() {
        return this.sourceFilenameField;
    }

    public void setSourceFilenameField(String sourceFilenameField) {
        this.sourceFilenameField = sourceFilenameField;
    }

    public String getBaseFolderField() {
        return this.baseFolderField;
    }

    public void setBaseFolderField(String baseFolderField) {
        this.baseFolderField = baseFolderField;
    }

    public String getMoveToFolderField() {
        return this.moveToFolderField;
    }

    public void setMoveToFolderField(String movetofolderfield) {
        this.moveToFolderField = movetofolderfield;
    }

    public String getTargetFilenameField() {
        return this.targetFilenameField;
    }

    public void setTargetFilenameField(String targetFilenameField) {
        this.targetFilenameField = targetFilenameField;
    }

    public boolean isAddResultFilenames() {
        return this.addResultFilenames;
    }

    public boolean isOverwriteZipEntry() {
        return this.overwriteZipEntry;
    }

    public boolean isCreateParentFolder() {
        return this.createParentFolder;
    }

    public boolean isKeepSourceFolder() {
        return this.keepSourceFolder;
    }

    public void setKeepSourceFolder(boolean value) {
        this.keepSourceFolder = value;
    }

    public void setAddResultFilenames(boolean addResultFilenames) {
        this.addResultFilenames = addResultFilenames;
    }

    public void setOverwriteZipEntry(boolean overwriteZipEntry) {
        this.overwriteZipEntry = overwriteZipEntry;
    }

    public void setCreateParentFolder(boolean createParentFolder) {
        this.createParentFolder = createParentFolder;
    }

    public String getOperationTypeMeta() {
        return ZipFileMeta.getOperationTypeCode(this.operationType);
    }

    public void setOperationTypeMeta(String operationTypeMeta) {
        this.operationTypeMeta = operationTypeMeta;
        this.operationType = ZipFileMeta.getOperationTypeByCode(operationTypeMeta);
    }

    public int getOperationType() {
        return this.operationType;
    }

    public void setOperationType(int operationType) {
        this.operationType = operationType;
    }

    public Object clone() {
        ZipFileMeta retval = (ZipFileMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.addResultFilenames = false;
        this.overwriteZipEntry = false;
        this.createParentFolder = false;
        this.keepSourceFolder = false;
        this.operationType = 0;
    }

    private static String getOperationTypeCode(int i) {
        if (i < 0 || i >= operationTypeCode.length) {
            return operationTypeCode[0];
        }
        return operationTypeCode[i];
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (Utils.isEmpty((CharSequence)this.sourceFilenameField)) {
            errorMessage = BaseMessages.getString(PKG, (String)"ZipFileMeta.CheckResult.SourceFileFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"ZipFileMeta.CheckResult.TargetFileFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"ZipFileMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"ZipFileMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public ZipFileData getTransformData() {
        return new ZipFileData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }

    public static int getOperationTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeDesc.length; ++i) {
            if (!operationTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ZipFileMeta.getOperationTypeByCode(tt);
    }

    public static String getOperationTypeDesc(int i) {
        if (i < 0 || i >= operationTypeDesc.length) {
            return operationTypeDesc[0];
        }
        return operationTypeDesc[i];
    }

    private static int getOperationTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < operationTypeCode.length; ++i) {
            if (!operationTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }
}

