/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.zipfile;

import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.zipfile.ZipFileMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ZipFileDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = ZipFileMeta.class;
    private CCombo wSourceFileNameField;
    private CCombo wTargetFileNameField;
    private Button wAddResult;
    private Button wOverwriteZipEntry;
    private Button wCreateParentFolder;
    private Button wKeepFolders;
    private final ZipFileMeta input;
    private Label wlBaseFolderField;
    private CCombo wBaseFolderField;
    private CCombo wOperation;
    private Label wlMoveToFolderField;
    private CCombo wMoveToFolderField;
    private boolean gotPreviousFields = false;

    public ZipFileDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (ZipFileMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        SelectionAdapter lsSel = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ZipFileDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Group wSettingsGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)wSettingsGroup);
        wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.wSettingsGroup.Label", (String[])new String[0]));
        FormLayout settingGroupLayout = new FormLayout();
        settingGroupLayout.marginWidth = 10;
        settingGroupLayout.marginHeight = 10;
        wSettingsGroup.setLayout((Layout)settingGroupLayout);
        Label wlCreateParentFolder = new Label((Composite)wSettingsGroup, 131072);
        wlCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.CreateParentFolder.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCreateParentFolder);
        FormData fdlCreateParentFolder = new FormData();
        fdlCreateParentFolder.left = new FormAttachment(0, 0);
        fdlCreateParentFolder.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlCreateParentFolder.right = new FormAttachment(middle, -margin);
        wlCreateParentFolder.setLayoutData((Object)fdlCreateParentFolder);
        this.wCreateParentFolder = new Button((Composite)wSettingsGroup, 32);
        this.props.setLook((Control)this.wCreateParentFolder);
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"ZipFileDialog.CreateParentFolder.Tooltip", (String[])new String[0]));
        FormData fdCreateParentFolder = new FormData();
        fdCreateParentFolder.left = new FormAttachment(middle, 0);
        fdCreateParentFolder.top = new FormAttachment((Control)wlCreateParentFolder, 0, 0x1000000);
        this.wCreateParentFolder.setLayoutData((Object)fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)lsSel);
        Label wlOverwriteTarget = new Label((Composite)wSettingsGroup, 131072);
        wlOverwriteTarget.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.OverwriteTarget.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOverwriteTarget);
        FormData fdlOverwriteTarget = new FormData();
        fdlOverwriteTarget.left = new FormAttachment(0, 0);
        fdlOverwriteTarget.top = new FormAttachment((Control)this.wCreateParentFolder, margin);
        fdlOverwriteTarget.right = new FormAttachment(middle, -margin);
        wlOverwriteTarget.setLayoutData((Object)fdlOverwriteTarget);
        this.wOverwriteZipEntry = new Button((Composite)wSettingsGroup, 32);
        this.props.setLook((Control)this.wOverwriteZipEntry);
        this.wOverwriteZipEntry.setToolTipText(BaseMessages.getString(PKG, (String)"ZipFileDialog.OverwriteTarget.Tooltip", (String[])new String[0]));
        FormData fdOverwriteTarget = new FormData();
        fdOverwriteTarget.left = new FormAttachment(middle, 0);
        fdOverwriteTarget.top = new FormAttachment((Control)wlOverwriteTarget, 0, 0x1000000);
        this.wOverwriteZipEntry.setLayoutData((Object)fdOverwriteTarget);
        this.wOverwriteZipEntry.addSelectionListener((SelectionListener)lsSel);
        Label wlAddResult = new Label((Composite)wSettingsGroup, 131072);
        wlAddResult.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.AddResult.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddResult);
        FormData fdlAddResult = new FormData();
        fdlAddResult.left = new FormAttachment(0, 0);
        fdlAddResult.top = new FormAttachment((Control)this.wOverwriteZipEntry, margin);
        fdlAddResult.right = new FormAttachment(middle, -margin);
        wlAddResult.setLayoutData((Object)fdlAddResult);
        this.wAddResult = new Button((Composite)wSettingsGroup, 32);
        this.props.setLook((Control)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"ZipFileDialog.AddResult.Tooltip", (String[])new String[0]));
        FormData fdAddResult = new FormData();
        fdAddResult.left = new FormAttachment(middle, 0);
        fdAddResult.top = new FormAttachment((Control)wlAddResult, 0, 0x1000000);
        this.wAddResult.setLayoutData((Object)fdAddResult);
        this.wAddResult.addSelectionListener((SelectionListener)lsSel);
        FormData fdSettingsGroup = new FormData();
        fdSettingsGroup.left = new FormAttachment(0, margin);
        fdSettingsGroup.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSettingsGroup.right = new FormAttachment(100, -margin);
        wSettingsGroup.setLayoutData((Object)fdSettingsGroup);
        Label wlSourceFileNameField = new Label((Composite)this.shell, 131072);
        wlSourceFileNameField.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.SourceFileNameField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSourceFileNameField);
        FormData fdlSourceFileNameField = new FormData();
        fdlSourceFileNameField.left = new FormAttachment(0, 0);
        fdlSourceFileNameField.right = new FormAttachment(middle, -margin);
        fdlSourceFileNameField.top = new FormAttachment((Control)wSettingsGroup, 2 * margin);
        wlSourceFileNameField.setLayoutData((Object)fdlSourceFileNameField);
        this.wSourceFileNameField = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wSourceFileNameField);
        this.wSourceFileNameField.setEditable(true);
        this.wSourceFileNameField.addModifyListener(lsMod);
        FormData fdSourceFileNameField = new FormData();
        fdSourceFileNameField.left = new FormAttachment(middle, 0);
        fdSourceFileNameField.top = new FormAttachment((Control)wSettingsGroup, 2 * margin);
        fdSourceFileNameField.right = new FormAttachment(100, -margin);
        this.wSourceFileNameField.setLayoutData((Object)fdSourceFileNameField);
        this.wSourceFileNameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ZipFileDialog.this.get();
            }
        });
        Label wlTargetFileNameField = new Label((Composite)this.shell, 131072);
        wlTargetFileNameField.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.TargetFileNameField.Label", (String[])new String[0]));
        this.props.setLook((Control)wlTargetFileNameField);
        FormData fdlTargetFileNameField = new FormData();
        fdlTargetFileNameField.left = new FormAttachment(0, 0);
        fdlTargetFileNameField.right = new FormAttachment(middle, -margin);
        fdlTargetFileNameField.top = new FormAttachment((Control)this.wSourceFileNameField, margin);
        wlTargetFileNameField.setLayoutData((Object)fdlTargetFileNameField);
        this.wTargetFileNameField = new CCombo((Composite)this.shell, 2056);
        this.wTargetFileNameField.setEditable(true);
        this.props.setLook((Control)this.wTargetFileNameField);
        this.wTargetFileNameField.addModifyListener(lsMod);
        FormData fdTargetFileNameField = new FormData();
        fdTargetFileNameField.left = new FormAttachment(middle, 0);
        fdTargetFileNameField.top = new FormAttachment((Control)this.wSourceFileNameField, margin);
        fdTargetFileNameField.right = new FormAttachment(100, -margin);
        this.wTargetFileNameField.setLayoutData((Object)fdTargetFileNameField);
        this.wTargetFileNameField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ZipFileDialog.this.get();
            }
        });
        Label wlKeepFolders = new Label((Composite)this.shell, 131072);
        wlKeepFolders.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.KeepFolders.Label", (String[])new String[0]));
        this.props.setLook((Control)wlKeepFolders);
        FormData fdlKeepFolders = new FormData();
        fdlKeepFolders.left = new FormAttachment(0, 0);
        fdlKeepFolders.top = new FormAttachment((Control)this.wTargetFileNameField, margin);
        fdlKeepFolders.right = new FormAttachment(middle, -margin);
        wlKeepFolders.setLayoutData((Object)fdlKeepFolders);
        this.wKeepFolders = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wKeepFolders);
        this.wKeepFolders.setToolTipText(BaseMessages.getString(PKG, (String)"ZipFileDialog.KeepFolders.Tooltip", (String[])new String[0]));
        FormData fdKeepFolders = new FormData();
        fdKeepFolders.left = new FormAttachment(middle, 0);
        fdKeepFolders.top = new FormAttachment((Control)this.wTargetFileNameField, margin);
        this.wKeepFolders.setLayoutData((Object)fdKeepFolders);
        this.wKeepFolders.addSelectionListener((SelectionListener)lsSel);
        this.wKeepFolders.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ZipFileDialog.this.keepFolder();
            }
        });
        this.wlBaseFolderField = new Label((Composite)this.shell, 131072);
        this.wlBaseFolderField.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.BaseFolderField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBaseFolderField);
        FormData fdlBaseFolderField = new FormData();
        fdlBaseFolderField.left = new FormAttachment(0, 0);
        fdlBaseFolderField.right = new FormAttachment(middle, -margin);
        fdlBaseFolderField.top = new FormAttachment((Control)this.wKeepFolders, margin);
        this.wlBaseFolderField.setLayoutData((Object)fdlBaseFolderField);
        this.wBaseFolderField = new CCombo((Composite)this.shell, 2056);
        this.wBaseFolderField.setEditable(true);
        this.props.setLook((Control)this.wBaseFolderField);
        this.wBaseFolderField.addModifyListener(lsMod);
        FormData fdBaseFolderField = new FormData();
        fdBaseFolderField.left = new FormAttachment(middle, 0);
        fdBaseFolderField.top = new FormAttachment((Control)this.wKeepFolders, margin);
        fdBaseFolderField.right = new FormAttachment(100, -margin);
        this.wBaseFolderField.setLayoutData((Object)fdBaseFolderField);
        this.wBaseFolderField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ZipFileDialog.this.get();
            }
        });
        Label wlOperation = new Label((Composite)this.shell, 131072);
        wlOperation.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.Operation.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOperation);
        FormData fdlOperation = new FormData();
        fdlOperation.left = new FormAttachment(0, 0);
        fdlOperation.right = new FormAttachment(middle, -margin);
        fdlOperation.top = new FormAttachment((Control)this.wBaseFolderField, margin);
        wlOperation.setLayoutData((Object)fdlOperation);
        this.wOperation = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wOperation);
        this.wOperation.addModifyListener(lsMod);
        FormData fdOperation = new FormData();
        fdOperation.left = new FormAttachment(middle, 0);
        fdOperation.top = new FormAttachment((Control)this.wBaseFolderField, margin);
        fdOperation.right = new FormAttachment(100, -margin);
        this.wOperation.setLayoutData((Object)fdOperation);
        this.wOperation.setItems(ZipFileMeta.operationTypeDesc);
        this.wOperation.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ZipFileDialog.this.updateOperation();
            }
        });
        this.wlMoveToFolderField = new Label((Composite)this.shell, 131072);
        this.wlMoveToFolderField.setText(BaseMessages.getString(PKG, (String)"ZipFileDialog.MoveToFolderField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMoveToFolderField);
        FormData fdlMoveToFolderField = new FormData();
        fdlMoveToFolderField.left = new FormAttachment(0, 0);
        fdlMoveToFolderField.right = new FormAttachment(middle, -margin);
        fdlMoveToFolderField.top = new FormAttachment((Control)this.wOperation, margin);
        this.wlMoveToFolderField.setLayoutData((Object)fdlMoveToFolderField);
        this.wMoveToFolderField = new CCombo((Composite)this.shell, 2056);
        this.wMoveToFolderField.setEditable(true);
        this.props.setLook((Control)this.wMoveToFolderField);
        this.wMoveToFolderField.addModifyListener(lsMod);
        FormData fdMoveToFolderField = new FormData();
        fdMoveToFolderField.left = new FormAttachment(middle, 0);
        fdMoveToFolderField.top = new FormAttachment((Control)this.wOperation, margin);
        fdMoveToFolderField.right = new FormAttachment(100, -margin);
        this.wMoveToFolderField.setLayoutData((Object)fdMoveToFolderField);
        this.wMoveToFolderField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                ZipFileDialog.this.get();
            }
        });
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)this.wMoveToFolderField);
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel.addListener(13, e -> this.cancel());
        this.getData();
        this.keepFolder();
        this.updateOperation();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.log.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ZipFileDialog.Log.GettingKeyInfo", (String[])new String[0])});
        }
        if (this.input.getBaseFolderField() != null) {
            this.wBaseFolderField.setText(this.input.getBaseFolderField());
        }
        if (this.input.getSourceFilenameField() != null) {
            this.wSourceFileNameField.setText(this.input.getSourceFilenameField());
        }
        if (this.input.getTargetFilenameField() != null) {
            this.wTargetFileNameField.setText(this.input.getTargetFilenameField());
        }
        this.wOperation.setText(ZipFileMeta.getOperationTypeDesc(this.input.getOperationType()));
        if (this.input.getMoveToFolderField() != null) {
            this.wMoveToFolderField.setText(this.input.getMoveToFolderField());
        }
        this.wAddResult.setSelection(this.input.isAddResultFilenames());
        this.wOverwriteZipEntry.setSelection(this.input.isOverwriteZipEntry());
        this.wCreateParentFolder.setSelection(this.input.isCreateParentFolder());
        this.wKeepFolders.setSelection(this.input.isKeepSourceFolder());
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.Error.TransformNameMissing.Message", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Error.TransformNameMissing.Title", (String[])new String[0]));
            mb.open();
            return;
        }
        this.input.setBaseFolderField(this.wBaseFolderField.getText());
        this.input.setSourceFilenameField(this.wSourceFileNameField.getText());
        this.input.setTargetFilenameField(this.wTargetFileNameField.getText());
        this.input.setAddResultFilenames(this.wAddResult.getSelection());
        this.input.setOverwriteZipEntry(this.wOverwriteZipEntry.getSelection());
        this.input.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        this.input.setKeepSourceFolder(this.wKeepFolders.getSelection());
        this.input.setOperationType(ZipFileMeta.getOperationTypeByDesc(this.wOperation.getText()));
        this.input.setMoveToFolderField(this.wMoveToFolderField.getText());
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void keepFolder() {
        this.wlBaseFolderField.setEnabled(this.wKeepFolders.getSelection());
        this.wBaseFolderField.setEnabled(this.wKeepFolders.getSelection());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            String source = this.wSourceFileNameField.getText();
            String target = this.wTargetFileNameField.getText();
            String base = this.wBaseFolderField.getText();
            try {
                this.wSourceFileNameField.removeAll();
                this.wTargetFileNameField.removeAll();
                this.wBaseFolderField.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    String[] fields = r.getFieldNames();
                    this.wSourceFileNameField.setItems(fields);
                    this.wTargetFileNameField.setItems(fields);
                    this.wBaseFolderField.setItems(fields);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ZipFileDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ZipFileDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            finally {
                if (source != null) {
                    this.wSourceFileNameField.setText(source);
                }
                if (target != null) {
                    this.wTargetFileNameField.setText(target);
                }
                if (base != null) {
                    this.wBaseFolderField.setText(base);
                }
            }
        }
    }

    private void updateOperation() {
        this.wlMoveToFolderField.setEnabled(ZipFileMeta.getOperationTypeByDesc(this.wOperation.getText()) == 1);
        this.wMoveToFolderField.setEnabled(ZipFileMeta.getOperationTypeByDesc(this.wOperation.getText()) == 1);
    }
}

