/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.exasol4;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;

@DatabaseMetaPlugin(type="EXASOL4", typeDescription="Exasol")
@GuiPlugin(id="GUI-ExasolDatabaseMeta")
public class Exasol4DatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 8563;
        }
        return -1;
    }

    public boolean supportsAutoInc() {
        return false;
    }

    public String getLimitClause(int nrRows) {
        return " WHERE ROWNUM <= " + nrRows;
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT /*+FIRST_ROWS*/ * FROM " + tableName + " WHERE 1=0";
    }

    public String getSqlTableExists(String tableName) {
        return this.getSqlQueryFields(tableName);
    }

    public String getSqlColumnExists(String columnname, String tableName) {
        return this.getSqlQueryColumnFields(columnname, tableName);
    }

    public String getSqlQueryColumnFields(String columnname, String tableName) {
        return "SELECT /*+FIRST_ROWS*/ " + columnname + " FROM " + tableName + " WHERE 1=0";
    }

    public String getDriverClass() {
        return "com.exasol.jdbc.EXADriver";
    }

    public String getURL(String hostname, String port, String databaseName) throws HopDatabaseException {
        return "jdbc:exa:" + hostname + ":" + port;
    }

    public boolean supportsOptionsInURL() {
        return true;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean useSchemaNameForTableList() {
        return true;
    }

    public boolean supportsSynonyms() {
        return false;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD ( " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false) + " ) ";
    }

    public String getDropColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " DROP COLUMN " + v.getName() + Const.CR;
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " MODIFY COLUMN " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        StringBuilder retval = new StringBuilder(128);
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval.append(fieldname).append(' ');
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval.append("TIMESTAMP");
                break;
            }
            case 4: {
                retval.append("BOOLEAN");
                break;
            }
            case 1: 
            case 6: {
                retval.append("DECIMAL");
                if (length <= 0) break;
                retval.append('(').append(length);
                if (precision > 0) {
                    retval.append(", ").append(precision);
                }
                retval.append(')');
                break;
            }
            case 5: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval.append("BIGINT NOT NULL PRIMARY KEY");
                    break;
                }
                retval.append("INTEGER");
                break;
            }
            case 2: {
                if (length > 0 && length <= 2000000) {
                    retval.append("VARCHAR(").append(length).append(')');
                    break;
                }
                retval.append("VARCHAR(2000000)");
                break;
            }
            default: {
                retval.append("UNKNOWN");
            }
        }
        if (addCr) {
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    public String[] getReservedWords() {
        return new String[]{"ABSOLUTE", "ACTION", "ADD", "AFTER", "ALL", "ALLOCATE", "ALTER", "AND", "APPEND", "ARE", "ARRAY", "AS", "ASC", "ASENSITIVE", "ASSERTION", "AT", "ATTRIBUTE", "AUTHID", "AUTHORIZATION", "BEFORE", "BEGIN", "BETWEEN", "BIGINT", "BINARY", "BIT", "BLOB", "BLOCKED", "BOOL", "BOOLEAN", "BOTH", "BY", "BYTE", "CALL", "CALLED", "CARDINALITY", "CASCADE", "CASCADED", "CASE", "CASESPECIFIC", "CAST", "CATALOG", "CHAIN", "CHAR", "CHARACTER", "CHARACTERISTICS", "CHARACTER_SET_CATALOG", "CHARACTER_SET_NAME", "CHARACTER_SET_SCHEMA", "CHECK", "CHECKED", "CLOSE", "COALESCE", "COLLATE", "COLLATION", "COLLATION_CATALOG", "COLLATION_NAME", "COLLATION_SCHEMA", "COLUMN", "COMMIT", "CONDITION", "CONNECTION", "CONSTANT", "CONSTRAINT", "CONSTRAINTS", "CONSTRUCTOR", "CONTAINS", "CONTINUE", "CONTROL", "CONVERT", "CORRESPONDING", "CREATE", "CS", "CSV", "CUBE", "CURRENT", "CURRENT_DATE", "CURRENT_PATH", "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_SESSION", "CURRENT_STATEMENT", "CURRENT_TIME", "CURRENT_TIMESTAMP", "CURRENT_USER", "CURSOR", "CYCLE", "DATA", "DATALINK", "DATE", "DATETIME_INTERVAL_CODE", "DATETIME_INTERVAL_PRECISION", "DAY", "DEALLOCATE", "DEC", "DECIMAL", "DECLARE", "DEFAULT", "DEFERRABLE", "DEFERRED", "DEFINED", "DEFINER", "DELETE", "DEREF", "DERIVED", "DESC", "DESCRIBE", "DESCRIPTOR", "DETERMINISTIC", "DISABLE", "DISABLED", "DISCONNECT", "DISPATCH", "DISTINCT", "DLURLCOMPLETE", "DLURLPATH", "DLURLPATHONLY", "DLURLSCHEME", "DLURLSERVER", "DLVALUE", "DO", "DOMAIN", "DOUBLE", "DROP", "DYNAMIC", "DYNAMIC_FUNCTION", "DYNAMIC_FUNCTION_CODE", "EACH", "ELSE", "ELSEIF", "ELSIF", "ENABLE", "ENABLED", "END", "END-EXEC", "ENFORCE", "EQUALS", "ERRORS", "ESCAPE", "EXCEPT", "EXCEPTION", "EXEC", "EXECUTE", "EXISTS", "EXIT", "EXPORT", "EXTERNAL", "EXTRACT", "FALSE", "FBV", "FETCH", "FILE", "FINAL", "FIRST", "FLOAT", "FOLLOWING", "FOR", "FORALL", "FORCE", "FORMAT", "FOUND", "FREE", "FROM", "FS", "FULL", "FUNCTION", "GENERAL", "GENERATED", "GET", "GLOBAL", "GO", "GOTO", "GRANT", "GRANTED", "GROUP", "GROUPING", "GROUP_CONCAT", "HAVING", "HOLD", "HOUR", "IDENTITY", "IF", "IFNULL", "IMMEDIATE", "IMPLEMENTATION", "IMPORT", "IN", "INDEX", "INDICATOR", "INNER", "INOUT", "INPUT", "INSENSITIVE", "INSERT", "INSTANCE", "INSTANTIABLE", "INT", "INTEGER", "INTEGRITY", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ITERATE", "JOIN", "KEY_MEMBER", "KEY_TYPE", "LARGE", "LAST", "LATERAL", "LEADING", "LEAVE", "LEFT", "LIKE", "LIMIT", "LOCAL", "LOCALTIME", "LOCALTIMESTAMP", "LOCATOR", "LOG", "LONGVARCHAR", "LOOP", "MAP", "MATCH", "MATCHED", "MERGE", "METHOD", "MINUS", "MINUTE", "MOD", "MODIFIES", "MODIFY", "MODULE", "MONTH", "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NCLOB", "NEW", "NEXT", "NLS_DATE_FORMAT", "NLS_DATE_LANGUAGE", "NLS_NUMERIC_CHARACTERS", "NLS_TIMESTAMP_FORMAT", "NO", "NOLOGGING", "NONE", "NOT", "NULL", "NULLIF", "NUMBER", "NUMERIC", "OBJECT", "OF", "OFF", "OLD", "ON", "ONLY", "OPEN", "OPTION", "OPTIONS", "OR", "ORDER", "ORDERING", "ORDINALITY", "OTHERS", "OUT", "OUTER", "OUTPUT", "OVER", "OVERLAPS", "OVERLAY", "OVERRIDING", "PAD", "PARALLEL_ENABLE", "PARAMETER", "PARAMETER_SPECIFIC_CATALOG", "PARAMETER_SPECIFIC_NAME", "PARAMETER_SPECIFIC_SCHEMA", "PARTIAL", "PATH", "PERMISSION", "PLACING", "POSITION", "PRECEDING", "PREPARE", "PRESERVE", "PRIOR", "PRIVILEGES", "PROCEDURE", "RANDOM", "RANGE", "READ", "READS", "REAL", "RECOVERY", "RECURSIVE", "REF", "REFERENCES", "REFERENCING", "REGEXP_LIKE", "RELATIVE", "RELEASE", "RENAME", "REPEAT", "REPLACE", "RESTORE", "RESTRICT", "RESULT", "RETURN", "RETURNED_LENGTH", "RETURNED_OCTET_LENGTH", "RETURNS", "REVOKE", "RIGHT", "ROLLBACK", "ROLLUP", "ROUTINE", "ROW", "ROWS", "ROWTYPE", "SAVEPOINT", "SCHEMA", "SCOPE", "SCRIPT", "SCROLL", "SEARCH", "SECOND", "SECTION", "SECURITY", "SELECT", "SELECTIVE", "SELF", "SENSITIVE", "SEPARATOR", "SEQUENCE", "SESSION", "SESSION_USER", "SET", "SETS", "SHORTINT", "SIMILAR", "SMALLINT", "SOURCE", "SPACE", "SPECIFIC", "SPECIFICTYPE", "SQL", "SQLEXCEPTION", "SQLSTATE", "SQLWARNING", "SQL_BIGINT", "SQL_BIT", "SQL_CHAR", "SQL_DATE", "SQL_DECIMAL", "SQL_DOUBLE", "SQL_FLOAT", "SQL_INTEGER", "SQL_LONGVARCHAR", "SQL_NUMERIC", "SQL_REAL", "SQL_SMALLINT", "SQL_TIMESTAMP", "SQL_TINYINT", "SQL_TYPE_DATE", "SQL_TYPE_TIMESTAMP", "SQL_VARCHAR", "START", "STATE", "STATEMENT", "STATIC", "STRUCTURE", "STYLE", "SUBSTRING", "SUBTYPE", "SYSDATE", "SYSTEM", "SYSTEM_USER", "SYSTIMESTAMP", "TABLE", "TEMPORARY", "TEXT", "THEN", "TIME", "TIMESTAMP", "TIMEZONE_HOUR", "TIMEZONE_MINUTE", "TINYINT", "TO", "TRAILING", "TRANSACTION", "TRANSFORM", "TRANSFORMS", "TRANSLATION", "TREAT", "TRIGGER", "TRIM", "TRUE", "TRUNCATE", "UNDER", "UNION", "UNIQUE", "UNKNOWN", "UNLINK", "UNNEST", "UNTIL", "UPDATE", "USAGE", "USER", "USING", "VALUE", "VALUES", "VARCHAR", "VARCHAR2", "VARRAY", "VERIFY", "VIEW", "WHEN", "WHENEVER", "WHERE", "WHILE", "WINDOW", "WITH", "WITHIN", "WITHOUT", "WORK", "YEAR", "YES", "ZONE"};
    }

    public String getExtraOptionsHelpText() {
        return "http://www.exasol.com/knowledge-center.html";
    }

    public boolean checkIndexExists(Database database, String schemaName, String tableName, String[] idxFields) throws HopDatabaseException {
        return true;
    }

    public boolean requiresCreateTablePrimaryKeyAppend() {
        return false;
    }

    public boolean supportsPreparedStatementMetadataRetrieval() {
        return false;
    }

    public int getMaxColumnsInIndex() {
        return -1;
    }

    public String quoteSqlString(String string) {
        string = string.replace("'", "''");
        string = string.replace("\\n", "'||chr(13)||'");
        string = string.replace("\\r", "'||chr(10)||'");
        return "'" + string + "'";
    }

    public boolean releaseSavepoint() {
        return false;
    }

    public boolean supportsErrorHandlingOnBatchUpdates() {
        return false;
    }

    public boolean isExasolVariant() {
        return true;
    }

    public boolean isQuoteAllFields() {
        return true;
    }
}

