/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.creditcardvalidator;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaBoolean;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.creditcardvalidator.CreditCardValidator;
import org.apache.hop.pipeline.transforms.creditcardvalidator.CreditCardValidatorData;
import org.w3c.dom.Node;

@Transform(id="CreditCardValidator", image="creditcardvalidator.svg", name="i18n::BaseTransform.TypeLongDesc.CreditCardValidator", description="i18n::BaseTransform.TypeTooltipDesc.CreditCardValidator", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Utility", documentationUrl="/pipeline/transforms/creditcardvalidator.html")
public class CreditCardValidatorMeta
extends BaseTransformMeta
implements ITransformMeta<CreditCardValidator, CreditCardValidatorData> {
    private static final Class<?> PKG = CreditCardValidatorMeta.class;
    private String fieldname;
    private String cardtype;
    private String notvalidmsg;
    private String resultfieldname;
    private boolean onlydigits;

    public String getDynamicField() {
        return this.fieldname;
    }

    public void setDynamicField(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getResultFieldName() {
        return this.resultfieldname;
    }

    public void setOnlyDigits(boolean onlydigits) {
        this.onlydigits = onlydigits;
    }

    public boolean isOnlyDigits() {
        return this.onlydigits;
    }

    public void setResultFieldName(String resultfieldname) {
        this.resultfieldname = resultfieldname;
    }

    public void setCardType(String cardtype) {
        this.cardtype = cardtype;
    }

    public String getCardType() {
        return this.cardtype;
    }

    public void setNotValidMsg(String notvalidmsg) {
        this.notvalidmsg = notvalidmsg;
    }

    public String getNotValidMsg() {
        return this.notvalidmsg;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public Object clone() {
        CreditCardValidatorMeta retval = (CreditCardValidatorMeta)((Object)super.clone());
        return retval;
    }

    public void setDefault() {
        this.resultfieldname = "result";
        this.onlydigits = false;
        this.cardtype = "card type";
        this.notvalidmsg = "not valid message";
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        String realcardtype;
        String realresultfieldname = variables.resolve(this.resultfieldname);
        if (!Utils.isEmpty((CharSequence)realresultfieldname)) {
            ValueMetaBoolean v = new ValueMetaBoolean(realresultfieldname);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        if (!Utils.isEmpty((CharSequence)(realcardtype = variables.resolve(this.cardtype)))) {
            ValueMetaString v = new ValueMetaString(realcardtype);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
        String realnotvalidmsg = variables.resolve(this.notvalidmsg);
        if (!Utils.isEmpty((CharSequence)this.notvalidmsg)) {
            ValueMetaString v = new ValueMetaString(realnotvalidmsg);
            v.setOrigin(name);
            inputRowMeta.addValueMeta((IValueMeta)v);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    ").append(XmlHandler.addTagValue((String)"fieldname", (String)this.fieldname));
        retval.append("    ").append(XmlHandler.addTagValue((String)"resultfieldname", (String)this.resultfieldname));
        retval.append("    ").append(XmlHandler.addTagValue((String)"cardtype", (String)this.cardtype));
        retval.append("    ").append(XmlHandler.addTagValue((String)"onlydigits", (boolean)this.onlydigits));
        retval.append("    ").append(XmlHandler.addTagValue((String)"notvalidmsg", (String)this.notvalidmsg));
        return retval.toString();
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.fieldname = XmlHandler.getTagValue((Node)transformNode, (String)"fieldname");
            this.resultfieldname = XmlHandler.getTagValue((Node)transformNode, (String)"resultfieldname");
            this.cardtype = XmlHandler.getTagValue((Node)transformNode, (String)"cardtype");
            this.notvalidmsg = XmlHandler.getTagValue((Node)transformNode, (String)"notvalidmsg");
            this.onlydigits = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"onlydigits"));
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.Exception.UnableToReadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        String realresultfieldname = variables.resolve(this.resultfieldname);
        if (Utils.isEmpty((CharSequence)realresultfieldname)) {
            errorMessage = BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.ResultFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.ResultFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.fieldname)) {
            errorMessage = BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.CardFieldMissing", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.CardFieldOK", (String[])new String[0]);
            cr = new CheckResult(1, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.ReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"CreditCardValidatorMeta.CheckResult.NoInpuReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public CreditCardValidator createTransform(TransformMeta transformMeta, CreditCardValidatorData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new CreditCardValidator(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public CreditCardValidatorData getTransformData() {
        return new CreditCardValidatorData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

