/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.creditcardvalidator;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.creditcardvalidator.CreditCardValidatorData;
import org.apache.hop.pipeline.transforms.creditcardvalidator.CreditCardValidatorMeta;
import org.apache.hop.pipeline.transforms.creditcardvalidator.CreditCardVerifier;
import org.apache.hop.pipeline.transforms.creditcardvalidator.ReturnIndicator;

public class CreditCardValidator
extends BaseTransform<CreditCardValidatorMeta, CreditCardValidatorData>
implements ITransform<CreditCardValidatorMeta, CreditCardValidatorData> {
    private static final Class<?> PKG = CreditCardValidatorMeta.class;

    public CreditCardValidator(TransformMeta transformMeta, CreditCardValidatorMeta meta, CreditCardValidatorData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        block16: {
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            boolean isValid = false;
            String cardType = null;
            String unValid = null;
            if (this.first) {
                this.first = false;
                ((CreditCardValidatorData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                ((CreditCardValidatorData)this.data).NrPrevFields = ((CreditCardValidatorData)this.data).previousRowMeta.size();
                ((CreditCardValidatorData)this.data).outputRowMeta = ((CreditCardValidatorData)this.data).previousRowMeta;
                ((CreditCardValidatorMeta)this.meta).getFields(((CreditCardValidatorData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (Utils.isEmpty((CharSequence)((CreditCardValidatorMeta)this.meta).getDynamicField())) {
                    this.logError(BaseMessages.getString(PKG, (String)"CreditCardValidator.Error.CardFieldMissing", (String[])new String[0]));
                    throw new HopException(BaseMessages.getString(PKG, (String)"CreditCardValidator.Error.CardFieldMissing", (String[])new String[0]));
                }
                if (((CreditCardValidatorData)this.data).indexOfField < 0) {
                    ((CreditCardValidatorData)this.data).indexOfField = this.getInputRowMeta().indexOfValue(((CreditCardValidatorMeta)this.meta).getDynamicField());
                    if (((CreditCardValidatorData)this.data).indexOfField < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"CreditCardValidator.Exception.CouldnotFindField", (String[])new String[]{((CreditCardValidatorMeta)this.meta).getDynamicField()}));
                    }
                }
                ((CreditCardValidatorData)this.data).realResultFieldname = this.resolve(((CreditCardValidatorMeta)this.meta).getResultFieldName());
                if (Utils.isEmpty((CharSequence)((CreditCardValidatorData)this.data).realResultFieldname)) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"CreditCardValidator.Exception.ResultFieldMissing", (String[])new String[0]));
                }
                ((CreditCardValidatorData)this.data).realCardTypeFieldname = this.resolve(((CreditCardValidatorMeta)this.meta).getCardType());
                ((CreditCardValidatorData)this.data).realNotValidMsgFieldname = this.resolve(((CreditCardValidatorMeta)this.meta).getNotValidMsg());
            }
            Object[] outputRow = RowDataUtil.allocateRowData((int)((CreditCardValidatorData)this.data).outputRowMeta.size());
            for (int i = 0; i < ((CreditCardValidatorData)this.data).NrPrevFields; ++i) {
                outputRow[i] = r[i];
            }
            try {
                String fieldvalue = this.getInputRowMeta().getString(r, ((CreditCardValidatorData)this.data).indexOfField);
                if (((CreditCardValidatorMeta)this.meta).isOnlyDigits()) {
                    fieldvalue = Const.getDigitsOnly((String)fieldvalue);
                }
                ReturnIndicator rt = CreditCardVerifier.CheckCC(fieldvalue);
                isValid = rt.CardValid;
                if (!Utils.isEmpty((CharSequence)((CreditCardValidatorData)this.data).realCardTypeFieldname)) {
                    cardType = rt.CardType;
                }
                if (!Utils.isEmpty((CharSequence)((CreditCardValidatorData)this.data).realNotValidMsgFieldname)) {
                    unValid = rt.UnValidMsg;
                }
                outputRow[((CreditCardValidatorData)this.data).NrPrevFields] = isValid;
                int rowIndex = ((CreditCardValidatorData)this.data).NrPrevFields;
                ++rowIndex;
                if (!Utils.isEmpty((CharSequence)((CreditCardValidatorData)this.data).realCardTypeFieldname)) {
                    outputRow[rowIndex++] = cardType;
                }
                if (!Utils.isEmpty((CharSequence)((CreditCardValidatorData)this.data).realNotValidMsgFieldname)) {
                    outputRow[rowIndex++] = unValid;
                }
                this.putRow(((CreditCardValidatorData)this.data).outputRowMeta, outputRow);
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"CreditCardValidator.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"CreditCardValidator.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block16;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((CreditCardValidatorMeta)this.meta).getResultFieldName(), "CreditCardValidator001");
            }
        }
        return true;
    }

    public boolean init() {
        if (super.init()) {
            if (Utils.isEmpty((CharSequence)((CreditCardValidatorMeta)this.meta).getResultFieldName())) {
                this.logError(BaseMessages.getString(PKG, (String)"CreditCardValidator.Error.ResultFieldMissing", (String[])new String[0]));
                return false;
            }
            return true;
        }
        return false;
    }
}

