/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow;

import java.util.Map;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.runners.dataflow.BatchViewOverrides;
import org.apache.beam.runners.dataflow.DataflowRunner;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Instant;

public class BatchStatefulParDoOverrides {
    public static <K, InputT, OutputT> PTransformOverrideFactory<PCollection<KV<K, InputT>>, PCollection<OutputT>, ParDo.SingleOutput<KV<K, InputT>, OutputT>> singleOutputOverrideFactory() {
        return new SingleOutputOverrideFactory();
    }

    public static <K, InputT, OutputT> PTransformOverrideFactory<PCollection<KV<K, InputT>>, PCollectionTuple, ParDo.MultiOutput<KV<K, InputT>, OutputT>> multiOutputOverrideFactory(DataflowPipelineOptions options) {
        return new MultiOutputOverrideFactory();
    }

    private static <InputT, OutputT> void verifyFnIsStateful(DoFn<InputT, OutputT> fn) {
        DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
        Preconditions.checkState((signature.usesState() || signature.usesTimers() ? 1 : 0) != 0, (String)"%s used for %s that does not use state or timers.", (Object)BatchStatefulParDoOverrides.class.getSimpleName(), (Object)ParDo.class.getSimpleName());
    }

    public static class BatchStatefulDoFn<K, V, OutputT>
    extends DoFn<KV<K, Iterable<KV<Instant, WindowedValue<KV<K, V>>>>>, OutputT> {
        private final DoFn<KV<K, V>, OutputT> underlyingDoFn;

        BatchStatefulDoFn(DoFn<KV<K, V>, OutputT> underlyingDoFn) {
            this.underlyingDoFn = underlyingDoFn;
        }

        public DoFn<KV<K, V>, OutputT> getUnderlyingDoFn() {
            return this.underlyingDoFn;
        }

        @DoFn.Setup
        public void setup(PipelineOptions options) {
            DoFnInvokers.tryInvokeSetupFor(this.underlyingDoFn, (PipelineOptions)options);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
            throw new UnsupportedOperationException("BatchStatefulDoFn.ProcessElement should never be invoked");
        }

        @DoFn.Teardown
        public void teardown() {
            DoFnInvokers.invokerFor(this.underlyingDoFn).invokeTeardown();
        }

        public TypeDescriptor<OutputT> getOutputTypeDescriptor() {
            return this.underlyingDoFn.getOutputTypeDescriptor();
        }
    }

    static class ReifyWindowedValueFn<K, V>
    extends DoFn<KV<K, V>, KV<K, KV<Instant, WindowedValue<KV<K, V>>>>> {
        ReifyWindowedValueFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, BoundedWindow window) {
            c.output((Object)KV.of((Object)((KV)c.element()).getKey(), (Object)KV.of((Object)c.timestamp(), (Object)WindowedValue.of((Object)((KV)c.element()), (Instant)c.timestamp(), (BoundedWindow)window, (PaneInfo)c.pane()))));
        }
    }

    static class GbkBeforeStatefulParDo<K, V>
    extends PTransform<PCollection<KV<K, V>>, PCollection<KV<K, Iterable<KV<Instant, WindowedValue<KV<K, V>>>>>>> {
        GbkBeforeStatefulParDo() {
        }

        public PCollection<KV<K, Iterable<KV<Instant, WindowedValue<KV<K, V>>>>>> expand(PCollection<KV<K, V>> input) {
            WindowingStrategy inputWindowingStrategy = input.getWindowingStrategy();
            Preconditions.checkState((boolean)(input.getCoder() instanceof KvCoder), (String)"Input to a %s using state requires a %s, but the coder was %s", (Object)ParDo.class.getSimpleName(), (Object)KvCoder.class.getSimpleName(), (Object)input.getCoder());
            KvCoder kvCoder = (KvCoder)input.getCoder();
            Coder keyCoder = kvCoder.getKeyCoder();
            Coder windowCoder = inputWindowingStrategy.getWindowFn().windowCoder();
            return ((PCollection)((PCollection)input.apply("ReifyWindows", (PTransform)ParDo.of(new ReifyWindowedValueFn()))).setCoder((Coder)KvCoder.of((Coder)keyCoder, (Coder)KvCoder.of((Coder)InstantCoder.of(), (Coder)WindowedValue.getFullCoder((Coder)kvCoder, (Coder)windowCoder)))).apply("PartitionKeys", new BatchViewOverrides.GroupByKeyAndSortValuesOnly())).setWindowingStrategyInternal(inputWindowingStrategy);
        }
    }

    static class StatefulMultiOutputParDo<K, InputT, OutputT>
    extends PTransform<PCollection<KV<K, InputT>>, PCollectionTuple> {
        private final ParDo.MultiOutput<KV<K, InputT>, OutputT> originalParDo;

        StatefulMultiOutputParDo(ParDo.MultiOutput<KV<K, InputT>, OutputT> originalParDo) {
            this.originalParDo = originalParDo;
        }

        public PCollectionTuple expand(PCollection<KV<K, InputT>> input) {
            DoFn fn = this.originalParDo.getFn();
            BatchStatefulParDoOverrides.verifyFnIsStateful(fn);
            DataflowPipelineOptions options = (DataflowPipelineOptions)input.getPipeline().getOptions().as(DataflowPipelineOptions.class);
            DataflowRunner.verifyDoFnSupported(fn, false, DataflowRunner.useStreamingEngine(options));
            DataflowRunner.verifyStateSupportForWindowingStrategy(input.getWindowingStrategy());
            ParDo.MultiOutput statefulParDo = ParDo.of(new BatchStatefulDoFn(fn)).withSideInputs(this.originalParDo.getSideInputs()).withOutputTags(this.originalParDo.getMainOutputTag(), this.originalParDo.getAdditionalOutputTags());
            return (PCollectionTuple)((PCollection)input.apply(new GbkBeforeStatefulParDo())).apply((PTransform)statefulParDo);
        }

        public ParDo.MultiOutput<KV<K, InputT>, OutputT> getOriginalParDo() {
            return this.originalParDo;
        }
    }

    static class StatefulSingleOutputParDo<K, InputT, OutputT>
    extends PTransform<PCollection<KV<K, InputT>>, PCollection<OutputT>> {
        private final ParDo.SingleOutput<KV<K, InputT>, OutputT> originalParDo;

        StatefulSingleOutputParDo(ParDo.SingleOutput<KV<K, InputT>, OutputT> originalParDo) {
            this.originalParDo = originalParDo;
        }

        ParDo.SingleOutput<KV<K, InputT>, OutputT> getOriginalParDo() {
            return this.originalParDo;
        }

        public PCollection<OutputT> expand(PCollection<KV<K, InputT>> input) {
            DoFn fn = this.originalParDo.getFn();
            BatchStatefulParDoOverrides.verifyFnIsStateful(fn);
            DataflowPipelineOptions options = (DataflowPipelineOptions)input.getPipeline().getOptions().as(DataflowPipelineOptions.class);
            DataflowRunner.verifyDoFnSupported(fn, false, DataflowRunner.useStreamingEngine(options));
            DataflowRunner.verifyStateSupportForWindowingStrategy(input.getWindowingStrategy());
            ParDo.SingleOutput statefulParDo = ParDo.of(new BatchStatefulDoFn(fn)).withSideInputs(this.originalParDo.getSideInputs());
            return (PCollection)((PCollection)input.apply(new GbkBeforeStatefulParDo())).apply((PTransform)statefulParDo);
        }
    }

    private static class MultiOutputOverrideFactory<K, InputT, OutputT>
    implements PTransformOverrideFactory<PCollection<KV<K, InputT>>, PCollectionTuple, ParDo.MultiOutput<KV<K, InputT>, OutputT>> {
        private MultiOutputOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<K, InputT>>, PCollectionTuple> getReplacementTransform(AppliedPTransform<PCollection<KV<K, InputT>>, PCollectionTuple, ParDo.MultiOutput<KV<K, InputT>, OutputT>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new StatefulMultiOutputParDo((ParDo.MultiOutput)transform.getTransform()));
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollectionTuple newOutput) {
            return ReplacementOutputs.tagged(outputs, (POutput)newOutput);
        }
    }

    private static class SingleOutputOverrideFactory<K, InputT, OutputT>
    implements PTransformOverrideFactory<PCollection<KV<K, InputT>>, PCollection<OutputT>, ParDo.SingleOutput<KV<K, InputT>, OutputT>> {
        private SingleOutputOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PCollection<KV<K, InputT>>, PCollection<OutputT>> getReplacementTransform(AppliedPTransform<PCollection<KV<K, InputT>>, PCollection<OutputT>, ParDo.SingleOutput<KV<K, InputT>, OutputT>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)PTransformReplacements.getSingletonMainInput(transform), new StatefulSingleOutputParDo((ParDo.SingleOutput)transform.getTransform()));
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollection<OutputT> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }
}

