/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.driver.extras.codecs.json;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.ParseUtils;
import com.datastax.driver.core.ProtocolVersion;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.exceptions.InvalidTypeException;
import com.datastax.driver.core.utils.Bytes;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.common.reflect.TypeToken;
import java.io.IOException;
import java.nio.ByteBuffer;

public class JacksonJsonCodec<T>
extends TypeCodec<T> {
    private final ObjectMapper objectMapper;

    public JacksonJsonCodec(Class<T> javaClass) {
        this(javaClass, new ObjectMapper());
    }

    public JacksonJsonCodec(TypeToken<T> javaType) {
        this(javaType, new ObjectMapper());
    }

    public JacksonJsonCodec(Class<T> javaClass, ObjectMapper objectMapper) {
        this(TypeToken.of(javaClass), objectMapper);
    }

    public JacksonJsonCodec(TypeToken<T> javaType, ObjectMapper objectMapper) {
        super(DataType.varchar(), javaType);
        this.objectMapper = objectMapper;
    }

    public ByteBuffer serialize(T value, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (value == null) {
            return null;
        }
        try {
            return ByteBuffer.wrap(this.objectMapper.writeValueAsBytes(value));
        }
        catch (JsonProcessingException e) {
            throw new InvalidTypeException(e.getMessage(), (Throwable)e);
        }
    }

    public T deserialize(ByteBuffer bytes, ProtocolVersion protocolVersion) throws InvalidTypeException {
        if (bytes == null) {
            return null;
        }
        try {
            return (T)this.objectMapper.readValue(Bytes.getArray((ByteBuffer)bytes), this.toJacksonJavaType());
        }
        catch (IOException e) {
            throw new InvalidTypeException(e.getMessage(), (Throwable)e);
        }
    }

    public String format(T value) throws InvalidTypeException {
        String json;
        if (value == null) {
            return "NULL";
        }
        try {
            json = this.objectMapper.writeValueAsString(value);
        }
        catch (IOException e) {
            throw new InvalidTypeException(e.getMessage(), (Throwable)e);
        }
        return ParseUtils.quote((String)json);
    }

    public T parse(String value) throws InvalidTypeException {
        if (value == null || value.isEmpty() || value.equalsIgnoreCase("NULL")) {
            return null;
        }
        if (!ParseUtils.isQuoted((String)value)) {
            throw new InvalidTypeException("JSON strings must be enclosed by single quotes");
        }
        String json = ParseUtils.unquote((String)value);
        try {
            return (T)this.objectMapper.readValue(json, this.toJacksonJavaType());
        }
        catch (IOException e) {
            throw new InvalidTypeException(e.getMessage(), (Throwable)e);
        }
    }

    protected JavaType toJacksonJavaType() {
        return TypeFactory.defaultInstance().constructType(this.getJavaType().getType());
    }
}

