/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.h2;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;

@DatabaseMetaPlugin(type="H2", typeDescription="H2")
@GuiPlugin(id="GUI-H2DatabaseMeta")
public class H2DatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getNotFoundTK(boolean useAutoinc) {
        return super.getNotFoundTK(useAutoinc);
    }

    public String getDriverClass() {
        return "org.h2.Driver";
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 8082;
        }
        return -1;
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (databaseName != null && databaseName.startsWith("mem:") || (Utils.isEmpty((CharSequence)port) || "-1".equals(port)) && Utils.isEmpty((CharSequence)hostname)) {
            return "jdbc:h2:" + databaseName;
        }
        return "jdbc:h2:tcp://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean isFetchSizeSupported() {
        return true;
    }

    public boolean supportsBitmapIndex() {
        return false;
    }

    public boolean supportsAutoInc() {
        return true;
    }

    public boolean supportsGetBlob() {
        return true;
    }

    public boolean supportsSetCharacterStream() {
        return false;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ALTER " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        String retval = "";
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        if (addFieldName) {
            retval = retval + fieldname + " ";
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval = retval + "TIMESTAMP";
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval = retval + "BOOLEAN";
                    break;
                }
                retval = retval + "CHAR(1)";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    retval = retval + "IDENTITY";
                    break;
                }
                if (length > 0) {
                    if (precision > 0 || length > 18) {
                        retval = retval + "DECIMAL(" + length + ", " + precision + ")";
                        break;
                    }
                    if (length > 9) {
                        retval = retval + "BIGINT";
                        break;
                    }
                    if (length < 5) {
                        if (length < 3) {
                            retval = retval + "TINYINT";
                            break;
                        }
                        retval = retval + "SMALLINT";
                        break;
                    }
                    retval = retval + "INTEGER";
                    break;
                }
                retval = retval + "DOUBLE";
                break;
            }
            case 2: {
                if (length >= 9999999) {
                    retval = retval + "TEXT";
                    break;
                }
                retval = retval + "VARCHAR";
                retval = length > 0 ? retval + "(" + length : retval + "(2147483647";
                retval = retval + ")";
                break;
            }
            case 8: {
                retval = retval + "BLOB";
                break;
            }
            default: {
                retval = retval + "UNKNOWN";
            }
        }
        if (addCr) {
            retval = retval + Const.CR;
        }
        return retval;
    }

    public String[] getReservedWords() {
        return new String[]{"CURRENT_TIMESTAMP", "CURRENT_TIME", "CURRENT_DATE", "CROSS", "DISTINCT", "EXCEPT", "EXISTS", "FROM", "FOR", "FALSE", "FULL", "GROUP", "HAVING", "INNER", "INTERSECT", "IS", "JOIN", "LIKE", "MINUS", "NATURAL", "NOT", "NULL", "ON", "ORDER", "PRIMARY", "ROWNUM", "SELECT", "SYSDATE", "SYSTIME", "SYSTIMESTAMP", "TODAY", "TRUE", "UNION", "WHERE"};
    }

    public boolean supportsPreparedStatementMetadataRetrieval() {
        return false;
    }
}

