/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.writetolog;

import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.writetolog.WriteToLogData;
import org.apache.hop.pipeline.transforms.writetolog.WriteToLogMeta;

public class WriteToLog
extends BaseTransform<WriteToLogMeta, WriteToLogData>
implements ITransform<WriteToLogMeta, WriteToLogData> {
    private static final Class<?> PKG = WriteToLogMeta.class;
    private int rowCounter = 0;
    private boolean rowCounterLimitHit = false;

    public WriteToLog(TransformMeta transformMeta, WriteToLogMeta meta, WriteToLogData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.rowCounterLimitHit) {
            this.putRow(this.getInputRowMeta(), r);
            return true;
        }
        if (this.first) {
            int i;
            this.first = false;
            if (((WriteToLogMeta)this.meta).getFieldName() != null && ((WriteToLogMeta)this.meta).getFieldName().length > 0) {
                ((WriteToLogData)this.data).fieldnrs = new int[((WriteToLogMeta)this.meta).getFieldName().length];
                for (i = 0; i < ((WriteToLogData)this.data).fieldnrs.length; ++i) {
                    ((WriteToLogData)this.data).fieldnrs[i] = this.getInputRowMeta().indexOfValue(((WriteToLogMeta)this.meta).getFieldName()[i]);
                    if (((WriteToLogData)this.data).fieldnrs[i] >= 0) continue;
                    this.logError(BaseMessages.getString(PKG, (String)"WriteToLog.Log.CanNotFindField", (String[])new String[]{((WriteToLogMeta)this.meta).getFieldName()[i]}));
                    throw new HopException(BaseMessages.getString(PKG, (String)"WriteToLog.Log.CanNotFindField", (String[])new String[]{((WriteToLogMeta)this.meta).getFieldName()[i]}));
                }
            } else {
                ((WriteToLogData)this.data).fieldnrs = new int[this.getInputRowMeta().size()];
                for (i = 0; i < ((WriteToLogData)this.data).fieldnrs.length; ++i) {
                    ((WriteToLogData)this.data).fieldnrs[i] = i;
                }
            }
            ((WriteToLogData)this.data).fieldnr = ((WriteToLogData)this.data).fieldnrs.length;
            ((WriteToLogData)this.data).loglevel = ((WriteToLogMeta)this.meta).getLogLevelByDesc();
            ((WriteToLogData)this.data).logmessage = Const.NVL((String)this.resolve(((WriteToLogMeta)this.meta).getLogMessage()), (String)"");
            if (!Utils.isEmpty((CharSequence)((WriteToLogData)this.data).logmessage)) {
                ((WriteToLogData)this.data).logmessage = ((WriteToLogData)this.data).logmessage + Const.CR + Const.CR;
            }
        }
        StringBuilder out = new StringBuilder();
        out.append(Const.CR + "------------> " + BaseMessages.getString(PKG, (String)"WriteToLog.Log.NLigne", (String[])new String[]{"" + this.getLinesRead()}) + "------------------------------" + Const.CR);
        out.append(this.getRealLogMessage());
        for (int i = 0; i < ((WriteToLogData)this.data).fieldnr; ++i) {
            String fieldvalue = this.getInputRowMeta().getString(r, ((WriteToLogData)this.data).fieldnrs[i]);
            if (((WriteToLogMeta)this.meta).isDisplayHeader()) {
                String fieldname = this.getInputRowMeta().getFieldNames()[((WriteToLogData)this.data).fieldnrs[i]];
                out.append(fieldname + " = " + fieldvalue + Const.CR);
                continue;
            }
            out.append(fieldvalue + Const.CR);
        }
        out.append(Const.CR + "====================");
        this.setLog(((WriteToLogData)this.data).loglevel, out);
        if (((WriteToLogMeta)this.meta).isLimitRows() && ++this.rowCounter >= ((WriteToLogMeta)this.meta).getLimitRowsNumber()) {
            this.rowCounterLimitHit = true;
        }
        this.putRow(this.getInputRowMeta(), r);
        return true;
    }

    private void setLog(LogLevel loglevel, StringBuilder msg) {
        switch (loglevel) {
            case ERROR: {
                this.logError(msg.toString());
                break;
            }
            case MINIMAL: {
                this.logMinimal(msg.toString());
                break;
            }
            case BASIC: {
                this.logBasic(msg.toString());
                break;
            }
            case DETAILED: {
                this.logDetailed(msg.toString());
                break;
            }
            case DEBUG: {
                this.logDebug(msg.toString());
                break;
            }
            case ROWLEVEL: {
                this.logRowlevel(msg.toString());
                break;
            }
            case NOTHING: {
                break;
            }
        }
    }

    public String getRealLogMessage() {
        return ((WriteToLogData)this.data).logmessage;
    }

    public boolean init() {
        return super.init();
    }
}

