/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.databases.monetdb;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.BaseDatabaseMeta;
import org.apache.hop.core.database.DatabaseMetaPlugin;
import org.apache.hop.core.database.IDatabase;
import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;

@DatabaseMetaPlugin(type="MONETDB", typeDescription="MonetDB")
@GuiPlugin(id="GUI-MonetDBDatabaseMeta")
public class MonetDBDatabaseMeta
extends BaseDatabaseMeta
implements IDatabase {
    public static ThreadLocal<Boolean> safeModeLocal = new ThreadLocal();
    public static final int DEFAULT_VARCHAR_LENGTH = 100;
    protected static final String FIELDNAME_PROTECTOR = "_";
    private static final int MAX_VARCHAR_LENGTH = Integer.MAX_VALUE;

    public int[] getAccessTypeList() {
        return new int[]{0};
    }

    public int getDefaultDatabasePort() {
        if (this.getAccessType() == 0) {
            return 50000;
        }
        return -1;
    }

    public int getNotFoundTK(boolean useAutoinc) {
        if (this.supportsAutoInc() && useAutoinc) {
            return 1;
        }
        return super.getNotFoundTK(useAutoinc);
    }

    public String getDriverClass() {
        return "nl.cwi.monetdb.jdbc.MonetDriver";
    }

    public String getURL(String hostname, String port, String databaseName) {
        if (Utils.isEmpty((CharSequence)port)) {
            return "jdbc:monetdb://" + hostname + "/" + databaseName;
        }
        return "jdbc:monetdb://" + hostname + ":" + port + "/" + databaseName;
    }

    public boolean isFetchSizeSupported() {
        return false;
    }

    public boolean supportsBitmapIndex() {
        return true;
    }

    public boolean supportsAutoInc() {
        return true;
    }

    public boolean supportsBatchUpdates() {
        return true;
    }

    public boolean supportsSetMaxRows() {
        return true;
    }

    public String getTruncateTableStatement(String tableName) {
        return "DELETE FROM " + tableName;
    }

    public String getAddColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " ADD " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String getModifyColumnStatement(String tableName, IValueMeta v, String tk, boolean useAutoinc, String pk, boolean semicolon) {
        return "ALTER TABLE " + tableName + " MODIFY " + this.getFieldDefinition(v, tk, pk, useAutoinc, true, false);
    }

    public String[] getReservedWords() {
        return new String[]{"IS", "ISNULL", "NOTNULL", "IN", "BETWEEN", "OVERLAPS", "LIKE", "ILIKE", "NOT", "AND", "OR", "CHAR", "VARCHAR", "CLOB", "BLOB", "DECIMAL", "DEC", "NUMERIC", "TINYINT", "SMALLINT", "INT", "BIGINT", "REAL", "DOUBLE", "BOOLEAN", "DATE", "TIME", "TIMESTAMP", "INTERVAL", "YEAR", "MONTH", "DAY", "HOUR", "MINUTE", "SECOND", "TIMEZONE", "EXTRACT", "CURRENT_DATE", "CURRENT_TIME", "CURRENT_TIMESTAMP", "LOCALTIME", "LOCALTIMESTAMP", "CURRENT_TIME", "SERIAL", "START", "WITH", "INCREMENT", "CACHE", "CYCLE", "SEQUENCE", "GETANCHOR", "GETBASENAME", "GETCONTENT", "GETCONTEXT", "GETDOMAIN", "GETEXTENSION", "GETFILE", "GETHOST", "GETPORT", "GETPROTOCOL", "GETQUERY", "GETUSER", "GETROBOTURL", "ISURL", "NEWURL", "BROADCAST", "MASKLEN", "SETMASKLEN", "NETMASK", "HOSTMASK", "NETWORK", "TEXT", "ABBREV", "CREATE", "TYPE", "NAME", "DROP", "USER"};
    }

    public String getFieldDefinition(IValueMeta v, String tk, String pk, boolean useAutoinc, boolean addFieldName, boolean addCr) {
        boolean safeMode;
        StringBuilder retval = new StringBuilder();
        String fieldname = v.getName();
        int length = v.getLength();
        int precision = v.getPrecision();
        Boolean mode = safeModeLocal.get();
        boolean bl = safeMode = mode != null && mode != false;
        if (addFieldName) {
            if (safeMode) {
                fieldname = this.getSafeFieldname(fieldname);
            }
            retval.append(fieldname + " ");
        }
        int type = v.getType();
        switch (type) {
            case 3: 
            case 9: {
                retval.append("TIMESTAMP");
                break;
            }
            case 4: {
                if (this.supportsBooleanDataType()) {
                    retval.append("BOOLEAN");
                    break;
                }
                retval.append("CHAR(1)");
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                if (fieldname.equalsIgnoreCase(tk) || fieldname.equalsIgnoreCase(pk)) {
                    if (useAutoinc) {
                        retval.append("SERIAL");
                        break;
                    }
                    retval.append("BIGINT");
                    break;
                }
                if (precision == 0) {
                    if (length > 9) {
                        if (length < 19) {
                            retval.append("BIGINT");
                            break;
                        }
                        retval.append("DECIMAL(").append(length).append(")");
                        break;
                    }
                    if (type == 1) {
                        retval.append("DOUBLE");
                        break;
                    }
                    retval.append("BIGINT");
                    break;
                }
                if (length > 15) {
                    retval.append("DECIMAL(").append(length);
                    if (precision > 0) {
                        retval.append(", ").append(precision);
                    }
                    retval.append(")");
                    break;
                }
                retval.append("DOUBLE");
                break;
            }
            case 2: {
                if (length > this.getMaxVARCHARLength()) {
                    retval.append("CLOB");
                    break;
                }
                retval.append("VARCHAR(");
                if (length > 0) {
                    retval.append(length);
                } else if (safeMode) {
                    retval.append(100);
                }
                retval.append(")");
                break;
            }
            default: {
                retval.append(" UNKNOWN");
            }
        }
        if (addCr) {
            retval.append(Const.CR);
        }
        return retval.toString();
    }

    public String getSqlQueryFields(String tableName) {
        return "SELECT * FROM " + tableName + ";";
    }

    public boolean supportsResultSetMetadataRetrievalOnly() {
        return true;
    }

    public int getMaxVARCHARLength() {
        return Integer.MAX_VALUE;
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSqlListOfSequences() {
        return "SELECT name FROM sys.sequences";
    }

    public String getSqlSequenceExists(String sequenceName) {
        return String.format("SELECT * FROM sys.sequences WHERE name = '%s'", sequenceName);
    }

    public String getSqlCurrentSequenceValue(String sequenceName) {
        String realSequenceName = sequenceName.replace(this.getStartQuote(), "").replace(this.getEndQuote(), "");
        return String.format("SELECT get_value_for( 'sys', '%s' )", realSequenceName);
    }

    public String getSqlNextSequenceValue(String sequenceName) {
        String realSequenceName = sequenceName.replace(this.getStartQuote(), "").replace(this.getEndQuote(), "");
        return String.format("SELECT next_value_for( 'sys', '%s' )", realSequenceName);
    }
}

