/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.groupby;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopPluginException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionDeep;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.row.value.ValueMetaNone;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.groupby.Aggregation;
import org.apache.hop.pipeline.transforms.groupby.GroupBy;
import org.apache.hop.pipeline.transforms.groupby.GroupByData;
import org.w3c.dom.Node;

@Transform(id="GroupBy", image="groupby.svg", name="i18n::GroupBy.Name", description="i18n::GroupBy.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Statistics", documentationUrl="/pipeline/transforms/groupby.html", keywords={""})
@InjectionSupported(localizationPrefix="GroupByMeta.Injection.", groups={"GROUPS", "AGGREGATIONS"})
public class GroupByMeta
extends BaseTransformMeta
implements ITransformMeta<GroupBy, GroupByData> {
    private static final Class<?> PKG = GroupByMeta.class;
    public static final int TYPE_GROUP_NONE = 0;
    public static final int TYPE_GROUP_SUM = 1;
    public static final int TYPE_GROUP_AVERAGE = 2;
    public static final int TYPE_GROUP_MEDIAN = 3;
    public static final int TYPE_GROUP_PERCENTILE = 4;
    public static final int TYPE_GROUP_MIN = 5;
    public static final int TYPE_GROUP_MAX = 6;
    public static final int TYPE_GROUP_COUNT_ALL = 7;
    public static final int TYPE_GROUP_CONCAT_COMMA = 8;
    public static final int TYPE_GROUP_FIRST = 9;
    public static final int TYPE_GROUP_LAST = 10;
    public static final int TYPE_GROUP_FIRST_INCL_NULL = 11;
    public static final int TYPE_GROUP_LAST_INCL_NULL = 12;
    public static final int TYPE_GROUP_CUMULATIVE_SUM = 13;
    public static final int TYPE_GROUP_CUMULATIVE_AVERAGE = 14;
    public static final int TYPE_GROUP_STANDARD_DEVIATION = 15;
    public static final int TYPE_GROUP_CONCAT_STRING = 16;
    public static final int TYPE_GROUP_COUNT_DISTINCT = 17;
    public static final int TYPE_GROUP_COUNT_ANY = 18;
    public static final int TYPE_GROUP_STANDARD_DEVIATION_SAMPLE = 19;
    public static final int TYPE_GROUP_PERCENTILE_NEAREST_RANK = 20;
    public static final int TYPE_GROUP_CONCAT_STRING_CRLF = 21;
    public static final String[] typeGroupCode = new String[]{"-", "SUM", "AVERAGE", "MEDIAN", "PERCENTILE", "MIN", "MAX", "COUNT_ALL", "CONCAT_COMMA", "FIRST", "LAST", "FIRST_INCL_NULL", "LAST_INCL_NULL", "CUM_SUM", "CUM_AVG", "STD_DEV", "CONCAT_STRING", "COUNT_DISTINCT", "COUNT_ANY", "STD_DEV_SAMPLE", "PERCENTILE_NEAREST_RANK", "CONCAT_STRING_CRLF"};
    public static final String[] typeGroupLongDesc = new String[]{"-", BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.SUM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.AVERAGE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.MEDIAN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.PERCENTILE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.MIN", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.MAX", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_ALL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_COMMA", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.FIRST", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.LAST", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.FIRST_INCL_NULL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.LAST_INCL_NULL", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CUMUMALTIVE_SUM", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CUMUMALTIVE_AVERAGE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.STANDARD_DEVIATION", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_STRING", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.COUNT_DISTINCT", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.COUNT_ANY", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.STANDARD_DEVIATION_SAMPLE", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.PERCENTILE_NEAREST_RANK", (String[])new String[0]), BaseMessages.getString(PKG, (String)"GroupByMeta.TypeGroupLongDesc.CONCAT_STRING_CRLF", (String[])new String[0])};
    @Injection(name="PASS_ALL_ROWS")
    private boolean passAllRows;
    @Injection(name="TEMP_DIRECTORY")
    private String directory;
    @Injection(name="TEMP_FILE_PREFIX")
    private String prefix;
    private boolean aggregateIgnored;
    private String aggregateIgnoredField;
    @Injection(name="GROUP_FIELD", group="GROUPS")
    private String[] groupField;
    @InjectionDeep
    private List<Aggregation> aggregations;
    @Injection(name="ADD_GROUP_LINENR")
    private boolean addingLineNrInGroup;
    @Injection(name="ADD_GROUP_LINENR_FIELD")
    private String lineNrInGroupField;
    @Injection(name="ALWAYS_GIVE_ROW")
    private boolean alwaysGivingBackOneRow;

    public boolean isAggregateIgnored() {
        return this.aggregateIgnored;
    }

    public void setAggregateIgnored(boolean aggregateIgnored) {
        this.aggregateIgnored = aggregateIgnored;
    }

    public String getAggregateIgnoredField() {
        return this.aggregateIgnoredField;
    }

    public void setAggregateIgnoredField(String aggregateIgnoredField) {
        this.aggregateIgnoredField = aggregateIgnoredField;
    }

    public String[] getGroupField() {
        return this.groupField;
    }

    public void setGroupField(String[] groupField) {
        this.groupField = groupField;
    }

    public boolean passAllRows() {
        return this.passAllRows;
    }

    public void setPassAllRows(boolean passAllRows) {
        this.passAllRows = passAllRows;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode);
    }

    public void allocate(int groupSize) {
        this.groupField = new String[groupSize];
        this.aggregations = new ArrayList<Aggregation>();
    }

    public Object clone() {
        GroupByMeta groupByMeta = (GroupByMeta)((Object)super.clone());
        int szGroup = 0;
        if (this.groupField != null) {
            szGroup = this.groupField.length;
        }
        groupByMeta.allocate(szGroup);
        System.arraycopy(this.groupField, 0, groupByMeta.groupField, 0, szGroup);
        ArrayList<Aggregation> aggsCopy = new ArrayList<Aggregation>();
        for (Aggregation aggregation : this.aggregations) {
            aggsCopy.add(aggregation.clone());
        }
        groupByMeta.setAggregations(aggsCopy);
        return groupByMeta;
    }

    private void readData(Node transformNode) throws HopXmlException {
        try {
            this.passAllRows = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"all_rows"));
            this.aggregateIgnored = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"ignore_aggregate"));
            this.aggregateIgnoredField = XmlHandler.getTagValue((Node)transformNode, (String)"field_ignore");
            this.directory = XmlHandler.getTagValue((Node)transformNode, (String)"directory");
            this.prefix = XmlHandler.getTagValue((Node)transformNode, (String)"prefix");
            this.addingLineNrInGroup = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"add_linenr"));
            this.lineNrInGroupField = XmlHandler.getTagValue((Node)transformNode, (String)"linenr_fieldname");
            Node groupNode = XmlHandler.getSubNode((Node)transformNode, (String)"group");
            Node fieldsNode = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrGroups = XmlHandler.countNodes((Node)groupNode, (String)"field");
            int nrFields = XmlHandler.countNodes((Node)fieldsNode, (String)"field");
            this.allocate(nrGroups);
            for (int i = 0; i < nrGroups; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)groupNode, (String)"field", (int)i);
                this.groupField[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
            }
            this.aggregations = new ArrayList<Aggregation>();
            boolean hasNumberOfValues = false;
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fieldsNode, (String)"field", (int)i);
                String aggField = XmlHandler.getTagValue((Node)fnode, (String)"aggregate");
                String aggSubject = XmlHandler.getTagValue((Node)fnode, (String)"subject");
                int aggType = GroupByMeta.getType(XmlHandler.getTagValue((Node)fnode, (String)"type"));
                if (aggType == 7 || aggType == 17 || aggType == 18) {
                    hasNumberOfValues = true;
                }
                String aggValue = XmlHandler.getTagValue((Node)fnode, (String)"valuefield");
                this.aggregations.add(new Aggregation(aggField, aggSubject, aggType, aggValue));
            }
            String giveBackRow = XmlHandler.getTagValue((Node)transformNode, (String)"give_back_row");
            this.alwaysGivingBackOneRow = Utils.isEmpty((CharSequence)giveBackRow) ? hasNumberOfValues : "Y".equalsIgnoreCase(giveBackRow);
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"GroupByMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public static final int getType(String desc) {
        int i;
        for (i = 0; i < typeGroupCode.length; ++i) {
            if (!typeGroupCode[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        for (i = 0; i < typeGroupLongDesc.length; ++i) {
            if (!typeGroupLongDesc[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getTypeDesc(int i) {
        if (i < 0 || i >= typeGroupCode.length) {
            return null;
        }
        return typeGroupCode[i];
    }

    public static final String getTypeDescLong(int i) {
        if (i < 0 || i >= typeGroupLongDesc.length) {
            return null;
        }
        return typeGroupLongDesc[i];
    }

    public void setDefault() {
        this.directory = "${java.io.tmpdir}";
        this.prefix = "grp";
        this.passAllRows = false;
        this.aggregateIgnored = false;
        this.aggregateIgnoredField = null;
        int sizeGroup = 0;
        this.allocate(sizeGroup);
    }

    public void getFields(IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        RowMeta fields = new RowMeta();
        if (!this.passAllRows) {
            for (int i = 0; i < this.groupField.length; ++i) {
                IValueMeta valueMeta = rowMeta.searchValueMeta(this.groupField[i]);
                if (valueMeta == null) continue;
                fields.addValueMeta(valueMeta);
            }
        } else {
            fields.addRowMeta(rowMeta);
        }
        for (Aggregation aggregation : this.aggregations) {
            IValueMeta v;
            int aggregationType = aggregation.getType();
            IValueMeta subj = rowMeta.searchValueMeta(aggregation.getSubject());
            if (subj == null && aggregationType != 18) continue;
            String valueName = aggregation.getField();
            int valueType = 0;
            int length = -1;
            int precision = -1;
            switch (aggregationType) {
                case 1: 
                case 2: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    valueType = subj.getType();
                    break;
                }
                case 7: 
                case 17: 
                case 18: {
                    valueType = 5;
                    break;
                }
                case 8: {
                    valueType = 2;
                    break;
                }
                case 3: 
                case 4: 
                case 15: 
                case 19: 
                case 20: {
                    valueType = 1;
                    break;
                }
                case 16: 
                case 21: {
                    valueType = 2;
                    break;
                }
            }
            if (aggregationType == 14 && valueType == 5) {
                valueType = 1;
                precision = -1;
                length = -1;
            } else if (aggregationType == 7 || aggregationType == 17 || aggregationType == 18) {
                length = 10;
                precision = 0;
            } else if (aggregationType == 1 && valueType != 5 && valueType != 1 && valueType != 6) {
                valueType = 1;
                precision = -1;
                length = -1;
            }
            if (valueType == 0) continue;
            try {
                v = ValueMetaFactory.createValueMeta((String)valueName, (int)valueType);
            }
            catch (HopPluginException e) {
                v = new ValueMetaNone(valueName);
            }
            v.setOrigin(origin);
            v.setLength(length, precision);
            if (subj != null) {
                v.setConversionMask(subj.getConversionMask());
            }
            fields.addValueMeta(v);
        }
        if (this.passAllRows && this.addingLineNrInGroup && !Utils.isEmpty((CharSequence)this.lineNrInGroupField)) {
            ValueMetaInteger lineNr = new ValueMetaInteger(this.lineNrInGroupField);
            lineNr.setLength(10, 0);
            lineNr.setOrigin(origin);
            fields.addValueMeta((IValueMeta)lineNr);
        }
        rowMeta.clear();
        rowMeta.addRowMeta((IRowMeta)fields);
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("      ").append(XmlHandler.addTagValue((String)"all_rows", (boolean)this.passAllRows));
        retval.append("      ").append(XmlHandler.addTagValue((String)"ignore_aggregate", (boolean)this.aggregateIgnored));
        retval.append("      ").append(XmlHandler.addTagValue((String)"field_ignore", (String)this.aggregateIgnoredField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"directory", (String)this.directory));
        retval.append("      ").append(XmlHandler.addTagValue((String)"prefix", (String)this.prefix));
        retval.append("      ").append(XmlHandler.addTagValue((String)"add_linenr", (boolean)this.addingLineNrInGroup));
        retval.append("      ").append(XmlHandler.addTagValue((String)"linenr_fieldname", (String)this.lineNrInGroupField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"give_back_row", (boolean)this.alwaysGivingBackOneRow));
        retval.append("      <group>").append(Const.CR);
        for (int i = 0; i < this.groupField.length; ++i) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XmlHandler.addTagValue((String)"name", (String)this.groupField[i]));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </group>").append(Const.CR);
        retval.append("      <fields>").append(Const.CR);
        for (Aggregation aggregation : this.aggregations) {
            retval.append("        <field>").append(Const.CR);
            retval.append("          ").append(XmlHandler.addTagValue((String)"aggregate", (String)aggregation.getField()));
            retval.append("          ").append(XmlHandler.addTagValue((String)"subject", (String)aggregation.getSubject()));
            retval.append("          ").append(XmlHandler.addTagValue((String)"type", (String)GroupByMeta.getTypeDesc(aggregation.getType())));
            retval.append("          ").append(XmlHandler.addTagValue((String)"valuefield", (String)aggregation.getValue()));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("      </fields>").append(Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        if (input.length > 0) {
            CheckResult cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"GroupByMeta.CheckResult.ReceivingInfoOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            CheckResult cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"GroupByMeta.CheckResult.NoInputError", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public ITransform createTransform(TransformMeta transformMeta, GroupByData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new GroupBy(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public GroupByData getTransformData() {
        return new GroupByData();
    }

    public String getDirectory() {
        return this.directory;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public boolean isAddingLineNrInGroup() {
        return this.addingLineNrInGroup;
    }

    public void setAddingLineNrInGroup(boolean addingLineNrInGroup) {
        this.addingLineNrInGroup = addingLineNrInGroup;
    }

    public String getLineNrInGroupField() {
        return this.lineNrInGroupField;
    }

    public void setLineNrInGroupField(String lineNrInGroupField) {
        this.lineNrInGroupField = lineNrInGroupField;
    }

    public boolean isAlwaysGivingBackOneRow() {
        return this.alwaysGivingBackOneRow;
    }

    public void setAlwaysGivingBackOneRow(boolean alwaysGivingBackOneRow) {
        this.alwaysGivingBackOneRow = alwaysGivingBackOneRow;
    }

    public PipelineMeta.PipelineType[] getSupportedPipelineTypes() {
        return new PipelineMeta.PipelineType[]{PipelineMeta.PipelineType.Normal};
    }

    public List<Aggregation> getAggregations() {
        return this.aggregations;
    }

    public void setAggregations(List<Aggregation> aggregations) {
        this.aggregations = aggregations;
    }
}

