/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tablecompare;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.tablecompare.TableCompare;
import org.apache.hop.pipeline.transforms.tablecompare.TableCompareData;
import org.w3c.dom.Node;

@Transform(id="TableCompare", image="tablecompare.svg", description="i18n::BaseTransform.TypeTooltipDesc.TableCompare", name="i18n::BaseTransform.TypeLongDesc.TableCompare", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Flow", documentationUrl="/pipeline/transforms/tablecompare.html")
public class TableCompareMeta
extends BaseTransformMeta
implements ITransformMeta<TableCompare, TableCompareData> {
    private static final Class<?> PKG = TableCompare.class;
    private DatabaseMeta referenceConnection;
    private String referenceSchemaField;
    private String referenceTableField;
    private DatabaseMeta compareConnection;
    private String compareSchemaField;
    private String compareTableField;
    private String keyFieldsField;
    private String excludeFieldsField;
    private String nrErrorsField;
    private String nrRecordsReferenceField;
    private String nrRecordsCompareField;
    private String nrErrorsLeftJoinField;
    private String nrErrorsInnerJoinField;
    private String nrErrorsRightJoinField;
    private String keyDescriptionField;
    private String valueReferenceField;
    private String valueCompareField;
    private IHopMetadataProvider metadataProvider;

    public String getReferenceSchemaField() {
        return this.referenceSchemaField;
    }

    public void setReferenceSchemaField(String referenceSchemaField) {
        this.referenceSchemaField = referenceSchemaField;
    }

    public String getReferenceTableField() {
        return this.referenceTableField;
    }

    public void setReferenceTableField(String referenceTableField) {
        this.referenceTableField = referenceTableField;
    }

    public String getCompareSchemaField() {
        return this.compareSchemaField;
    }

    public void setCompareSchemaField(String compareSchemaField) {
        this.compareSchemaField = compareSchemaField;
    }

    public String getCompareTableField() {
        return this.compareTableField;
    }

    public void setCompareTableField(String compareTableField) {
        this.compareTableField = compareTableField;
    }

    public String getNrErrorsField() {
        return this.nrErrorsField;
    }

    public void setNrErrorsField(String nrErrorsField) {
        this.nrErrorsField = nrErrorsField;
    }

    public DatabaseMeta getReferenceConnection() {
        return this.referenceConnection;
    }

    public void setReferenceConnection(DatabaseMeta referenceConnection) {
        this.referenceConnection = referenceConnection;
    }

    public DatabaseMeta getCompareConnection() {
        return this.compareConnection;
    }

    public void setCompareConnection(DatabaseMeta compareConnection) {
        this.compareConnection = compareConnection;
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        ArrayList<DatabaseMeta> connList = new ArrayList<DatabaseMeta>(2);
        if (this.compareConnection != null) {
            connList.add(this.compareConnection);
        }
        if (this.referenceConnection != null) {
            connList.add(this.referenceConnection);
        }
        if (connList.size() > 0) {
            DatabaseMeta[] rtn = new DatabaseMeta[connList.size()];
            connList.toArray(rtn);
            return rtn;
        }
        return super.getUsedDatabaseConnections();
    }

    public String getKeyFieldsField() {
        return this.keyFieldsField;
    }

    public void setKeyFieldsField(String keyFieldsField) {
        this.keyFieldsField = keyFieldsField;
    }

    public String getExcludeFieldsField() {
        return this.excludeFieldsField;
    }

    public void setExcludeFieldsField(String excludeFieldsField) {
        this.excludeFieldsField = excludeFieldsField;
    }

    public String getNrRecordsReferenceField() {
        return this.nrRecordsReferenceField;
    }

    public void setNrRecordsReferenceField(String nrRecordsReferenceField) {
        this.nrRecordsReferenceField = nrRecordsReferenceField;
    }

    public String getNrRecordsCompareField() {
        return this.nrRecordsCompareField;
    }

    public void setNrRecordsCompareField(String nrRecordsCompareField) {
        this.nrRecordsCompareField = nrRecordsCompareField;
    }

    public String getNrErrorsLeftJoinField() {
        return this.nrErrorsLeftJoinField;
    }

    public void setNrErrorsLeftJoinField(String nrErrorsLeftJoinField) {
        this.nrErrorsLeftJoinField = nrErrorsLeftJoinField;
    }

    public String getNrErrorsInnerJoinField() {
        return this.nrErrorsInnerJoinField;
    }

    public void setNrErrorsInnerJoinField(String nrErrorsInnerJoinField) {
        this.nrErrorsInnerJoinField = nrErrorsInnerJoinField;
    }

    public String getNrErrorsRightJoinField() {
        return this.nrErrorsRightJoinField;
    }

    public void setNrErrorsRightJoinField(String nrErrorsRightJoinField) {
        this.nrErrorsRightJoinField = nrErrorsRightJoinField;
    }

    public String getKeyDescriptionField() {
        return this.keyDescriptionField;
    }

    public void setKeyDescriptionField(String keyDescriptionField) {
        this.keyDescriptionField = keyDescriptionField;
    }

    public String getValueReferenceField() {
        return this.valueReferenceField;
    }

    public void setValueReferenceField(String valueReferenceField) {
        this.valueReferenceField = valueReferenceField;
    }

    public String getValueCompareField() {
        return this.valueCompareField;
    }

    public void setValueCompareField(String valueCompareField) {
        this.valueCompareField = valueCompareField;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        TableCompareMeta retval = (TableCompareMeta)((Object)super.clone());
        return retval;
    }

    public ITransform createTransform(TransformMeta transformMeta, TableCompareData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new TableCompare(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    public void getFields(IRowMeta inputRowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (Utils.isEmpty((CharSequence)this.nrErrorsField)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrErrorsFieldIsNotSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.nrRecordsReferenceField)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrRecordsReferenceFieldNotSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.nrRecordsCompareField)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrRecordsCompareFieldNotSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.nrErrorsLeftJoinField)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrErrorsLeftJoinFieldNotSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.nrErrorsInnerJoinField)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrErrorsInnerJoinFieldNotSpecified", (String[])new String[0]));
        }
        if (Utils.isEmpty((CharSequence)this.nrErrorsRightJoinField)) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"TableCompareMeta.Exception.NrErrorsRightJoinFieldNotSpecified", (String[])new String[0]));
        }
        ValueMetaInteger nrErrorsValueMeta = new ValueMetaInteger(this.nrErrorsField);
        nrErrorsValueMeta.setLength(9);
        nrErrorsValueMeta.setOrigin(origin);
        inputRowMeta.addValueMeta((IValueMeta)nrErrorsValueMeta);
        ValueMetaInteger nrRecordsReference = new ValueMetaInteger(this.nrRecordsReferenceField);
        nrRecordsReference.setLength(9);
        nrRecordsReference.setOrigin(origin);
        inputRowMeta.addValueMeta((IValueMeta)nrRecordsReference);
        ValueMetaInteger nrRecordsCompare = new ValueMetaInteger(this.nrRecordsCompareField);
        nrRecordsCompare.setLength(9);
        nrRecordsCompare.setOrigin(origin);
        inputRowMeta.addValueMeta((IValueMeta)nrRecordsCompare);
        ValueMetaInteger nrErrorsLeft = new ValueMetaInteger(this.nrErrorsLeftJoinField);
        nrErrorsLeft.setLength(9);
        nrErrorsLeft.setOrigin(origin);
        inputRowMeta.addValueMeta((IValueMeta)nrErrorsLeft);
        ValueMetaInteger nrErrorsInner = new ValueMetaInteger(this.nrErrorsInnerJoinField);
        nrErrorsInner.setLength(9);
        nrErrorsInner.setOrigin(origin);
        inputRowMeta.addValueMeta((IValueMeta)nrErrorsInner);
        ValueMetaInteger nrErrorsRight = new ValueMetaInteger(this.nrErrorsRightJoinField);
        nrErrorsRight.setLength(9);
        nrErrorsRight.setOrigin(origin);
        inputRowMeta.addValueMeta((IValueMeta)nrErrorsRight);
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.metadataProvider = metadataProvider;
        try {
            this.referenceConnection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)XmlHandler.getTagValue((Node)transformNode, (String)"reference_connection"));
            this.referenceSchemaField = XmlHandler.getTagValue((Node)transformNode, (String)"reference_schema_field");
            this.referenceTableField = XmlHandler.getTagValue((Node)transformNode, (String)"reference_table_field");
            this.compareConnection = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)XmlHandler.getTagValue((Node)transformNode, (String)"compare_connection"));
            this.compareSchemaField = XmlHandler.getTagValue((Node)transformNode, (String)"compare_schema_field");
            this.compareTableField = XmlHandler.getTagValue((Node)transformNode, (String)"compare_table_field");
            this.keyFieldsField = XmlHandler.getTagValue((Node)transformNode, (String)"key_fields_field");
            this.excludeFieldsField = XmlHandler.getTagValue((Node)transformNode, (String)"exclude_fields_field");
            this.nrErrorsField = XmlHandler.getTagValue((Node)transformNode, (String)"nr_errors_field");
            this.nrRecordsReferenceField = XmlHandler.getTagValue((Node)transformNode, (String)"nr_records_reference_field");
            this.nrRecordsCompareField = XmlHandler.getTagValue((Node)transformNode, (String)"nr_records_compare_field");
            this.nrErrorsLeftJoinField = XmlHandler.getTagValue((Node)transformNode, (String)"nr_errors_left_join_field");
            this.nrErrorsInnerJoinField = XmlHandler.getTagValue((Node)transformNode, (String)"nr_errors_inner_join_field");
            this.nrErrorsRightJoinField = XmlHandler.getTagValue((Node)transformNode, (String)"nr_errors_right_join_field");
            this.keyDescriptionField = XmlHandler.getTagValue((Node)transformNode, (String)"key_description_field");
            this.valueReferenceField = XmlHandler.getTagValue((Node)transformNode, (String)"value_reference_field");
            this.valueCompareField = XmlHandler.getTagValue((Node)transformNode, (String)"value_compare_field");
        }
        catch (Exception e) {
            throw new HopXmlException("It was not possibke to load the Trim metadata from XML", (Throwable)e);
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("      ").append(XmlHandler.addTagValue((String)"reference_connection", this.referenceConnection == null ? null : this.referenceConnection.getName()));
        retval.append("      ").append(XmlHandler.addTagValue((String)"reference_schema_field", (String)this.referenceSchemaField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"reference_table_field", (String)this.referenceTableField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"compare_connection", this.compareConnection == null ? null : this.compareConnection.getName()));
        retval.append("      ").append(XmlHandler.addTagValue((String)"compare_schema_field", (String)this.compareSchemaField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"compare_table_field", (String)this.compareTableField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"key_fields_field", (String)this.keyFieldsField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"exclude_fields_field", (String)this.excludeFieldsField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nr_errors_field", (String)this.nrErrorsField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nr_records_reference_field", (String)this.nrRecordsReferenceField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nr_records_compare_field", (String)this.nrRecordsCompareField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nr_errors_left_join_field", (String)this.nrErrorsLeftJoinField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nr_errors_inner_join_field", (String)this.nrErrorsInnerJoinField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"nr_errors_right_join_field", (String)this.nrErrorsRightJoinField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"key_description_field", (String)this.keyDescriptionField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"value_reference_field", (String)this.valueReferenceField));
        retval.append("      ").append(XmlHandler.addTagValue((String)"value_compare_field", (String)this.valueCompareField));
        return retval.toString();
    }

    public void setDefault() {
        this.nrErrorsField = "nrErrors";
        this.nrRecordsReferenceField = "nrRecordsReferenceTable";
        this.nrRecordsCompareField = "nrRecordsCompareTable";
        this.nrErrorsLeftJoinField = "nrErrorsLeftJoin";
        this.nrErrorsInnerJoinField = "nrErrorsInnerJoin";
        this.nrErrorsRightJoinField = "nrErrorsRightJoin";
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev == null || prev.size() == 0) {
            cr = new CheckResult(3, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NotReceivingFields", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.TransformRecevingData", (String[])new String[]{prev.size() + ""}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.TransformRecevingData2", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"IfNullMeta.CheckResult.NoInputReceivedFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public TableCompareData getTransformData() {
        return new TableCompareData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

