/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.tablecompare;

import java.util.Arrays;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.tablecompare.TableCompare;
import org.apache.hop.pipeline.transforms.tablecompare.TableCompareMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.widget.LabelCombo;
import org.apache.hop.ui.core.widget.LabelText;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TableCompareDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = TableCompare.class;
    private final TableCompareMeta input;
    private IRowMeta prevFields = null;
    private LabelCombo wReferenceDB;
    private LabelCombo wReferenceSchema;
    private LabelCombo wReferenceTable;
    private LabelCombo wCompareDB;
    private LabelCombo wCompareSchema;
    private LabelCombo wCompareTable;
    private LabelCombo wKeyFields;
    private LabelCombo wExcludeFields;
    private LabelText wNrErrors;
    private LabelText wNrRecordsReference;
    private LabelText wNrRecordsCompare;
    private LabelText wNrErrorsLeftJoin;
    private LabelText wNrErrorsInnerJoin;
    private LabelText wNrErrorsRightJoin;
    private LabelCombo wKeyDesc;
    private LabelCombo wReferenceValue;
    private LabelCombo wCompareValue;

    public TableCompareDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (TableCompareMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"TableCompareDialog.Shell.Title", (String[])new String[0]));
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"TableCompareDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        this.wReferenceDB = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceDB.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceDB.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceDB);
        FormData fdReferenceDB = new FormData();
        fdReferenceDB.left = new FormAttachment(0, 0);
        fdReferenceDB.top = new FormAttachment((Control)lastControl, margin);
        fdReferenceDB.right = new FormAttachment(100, 0);
        this.wReferenceDB.setLayoutData((Object)fdReferenceDB);
        lastControl = this.wReferenceDB;
        this.wReferenceSchema = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceSchemaField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceSchemaField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceSchema);
        FormData fdReferenceSchema = new FormData();
        fdReferenceSchema.left = new FormAttachment(0, 0);
        fdReferenceSchema.top = new FormAttachment((Control)lastControl, margin);
        fdReferenceSchema.right = new FormAttachment(100, 0);
        this.wReferenceSchema.setLayoutData((Object)fdReferenceSchema);
        lastControl = this.wReferenceSchema;
        this.wReferenceTable = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceTableField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceTableField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceTable);
        FormData fdReferenceTable = new FormData();
        fdReferenceTable.left = new FormAttachment(0, 0);
        fdReferenceTable.top = new FormAttachment((Control)lastControl, margin);
        fdReferenceTable.right = new FormAttachment(100, 0);
        this.wReferenceTable.setLayoutData((Object)fdReferenceTable);
        lastControl = this.wReferenceTable;
        this.wCompareDB = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareDB.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareDB.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareDB);
        FormData fdCompareDB = new FormData();
        fdCompareDB.left = new FormAttachment(0, 0);
        fdCompareDB.top = new FormAttachment((Control)lastControl, margin);
        fdCompareDB.right = new FormAttachment(100, 0);
        this.wCompareDB.setLayoutData((Object)fdCompareDB);
        lastControl = this.wCompareDB;
        this.wCompareSchema = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareSchemaField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareSchemaField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareSchema);
        FormData fdCompareSchema = new FormData();
        fdCompareSchema.left = new FormAttachment(0, 0);
        fdCompareSchema.top = new FormAttachment((Control)lastControl, margin);
        fdCompareSchema.right = new FormAttachment(100, 0);
        this.wCompareSchema.setLayoutData((Object)fdCompareSchema);
        lastControl = this.wCompareSchema;
        this.wCompareTable = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareTableField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareTableField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareTable);
        FormData fdCompareTable = new FormData();
        fdCompareTable.left = new FormAttachment(0, 0);
        fdCompareTable.top = new FormAttachment((Control)lastControl, margin);
        fdCompareTable.right = new FormAttachment(100, 0);
        this.wCompareTable.setLayoutData((Object)fdCompareTable);
        lastControl = this.wCompareTable;
        this.wKeyFields = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyFieldsField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyFieldsField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wKeyFields);
        FormData fdKeyFields = new FormData();
        fdKeyFields.left = new FormAttachment(0, 0);
        fdKeyFields.top = new FormAttachment((Control)lastControl, margin);
        fdKeyFields.right = new FormAttachment(100, 0);
        this.wKeyFields.setLayoutData((Object)fdKeyFields);
        lastControl = this.wKeyFields;
        this.wExcludeFields = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.ExcludeFieldsField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ExcludeFieldsField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wExcludeFields);
        FormData fdExcludeFields = new FormData();
        fdExcludeFields.left = new FormAttachment(0, 0);
        fdExcludeFields.top = new FormAttachment((Control)lastControl, margin);
        fdExcludeFields.right = new FormAttachment(100, 0);
        this.wExcludeFields.setLayoutData((Object)fdExcludeFields);
        lastControl = this.wExcludeFields;
        this.wNrErrors = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrors);
        FormData fdNrErrors = new FormData();
        fdNrErrors.left = new FormAttachment(0, 0);
        fdNrErrors.top = new FormAttachment((Control)lastControl, margin * 3);
        fdNrErrors.right = new FormAttachment(100, 0);
        this.wNrErrors.setLayoutData((Object)fdNrErrors);
        lastControl = this.wNrErrors;
        this.wNrRecordsReference = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsReferenceField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsReferenceField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrRecordsReference);
        FormData fdNrRecordsReference = new FormData();
        fdNrRecordsReference.left = new FormAttachment(0, 0);
        fdNrRecordsReference.top = new FormAttachment((Control)lastControl, margin);
        fdNrRecordsReference.right = new FormAttachment(100, 0);
        this.wNrRecordsReference.setLayoutData((Object)fdNrRecordsReference);
        lastControl = this.wNrRecordsReference;
        this.wNrRecordsCompare = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsCompareField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrRecordsCompareField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrRecordsCompare);
        FormData fdNrRecordsCompare = new FormData();
        fdNrRecordsCompare.left = new FormAttachment(0, 0);
        fdNrRecordsCompare.top = new FormAttachment((Control)lastControl, margin);
        fdNrRecordsCompare.right = new FormAttachment(100, 0);
        this.wNrRecordsCompare.setLayoutData((Object)fdNrRecordsCompare);
        lastControl = this.wNrRecordsCompare;
        this.wNrErrorsLeftJoin = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsLeftJoinField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsLeftJoinField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrorsLeftJoin);
        FormData fdNrErrorsLeftJoin = new FormData();
        fdNrErrorsLeftJoin.left = new FormAttachment(0, 0);
        fdNrErrorsLeftJoin.top = new FormAttachment((Control)lastControl, margin);
        fdNrErrorsLeftJoin.right = new FormAttachment(100, 0);
        this.wNrErrorsLeftJoin.setLayoutData((Object)fdNrErrorsLeftJoin);
        lastControl = this.wNrErrorsLeftJoin;
        this.wNrErrorsInnerJoin = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsInnerJoinField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsInnerJoinField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrorsInnerJoin);
        FormData fdNrErrorsInnerJoin = new FormData();
        fdNrErrorsInnerJoin.left = new FormAttachment(0, 0);
        fdNrErrorsInnerJoin.top = new FormAttachment((Control)lastControl, margin);
        fdNrErrorsInnerJoin.right = new FormAttachment(100, 0);
        this.wNrErrorsInnerJoin.setLayoutData((Object)fdNrErrorsInnerJoin);
        lastControl = this.wNrErrorsInnerJoin;
        this.wNrErrorsRightJoin = new LabelText((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsRightJoinField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.NrErrorsRightJoinField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wNrErrorsRightJoin);
        FormData fdNrErrorsRightJoin = new FormData();
        fdNrErrorsRightJoin.left = new FormAttachment(0, 0);
        fdNrErrorsRightJoin.top = new FormAttachment((Control)lastControl, margin);
        fdNrErrorsRightJoin.right = new FormAttachment(100, 0);
        this.wNrErrorsRightJoin.setLayoutData((Object)fdNrErrorsRightJoin);
        lastControl = this.wNrErrorsRightJoin;
        this.wKeyDesc = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyDescField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.KeyDescField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wKeyDesc);
        FormData fdKeyDesc = new FormData();
        fdKeyDesc.left = new FormAttachment(0, 0);
        fdKeyDesc.top = new FormAttachment((Control)lastControl, margin * 3);
        fdKeyDesc.right = new FormAttachment(100, 0);
        this.wKeyDesc.setLayoutData((Object)fdKeyDesc);
        lastControl = this.wKeyDesc;
        this.wReferenceValue = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceValueField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.ReferenceValueField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wReferenceValue);
        FormData fdReferenceValue = new FormData();
        fdReferenceValue.left = new FormAttachment(0, 0);
        fdReferenceValue.top = new FormAttachment((Control)lastControl, margin);
        fdReferenceValue.right = new FormAttachment(100, 0);
        this.wReferenceValue.setLayoutData((Object)fdReferenceValue);
        lastControl = this.wReferenceValue;
        this.wCompareValue = new LabelCombo((Composite)this.shell, BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareValueField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TableCompareDialog.CompareValueField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCompareValue);
        FormData fdCompareValue = new FormData();
        fdCompareValue.left = new FormAttachment(0, 0);
        fdCompareValue.top = new FormAttachment((Control)lastControl, margin);
        fdCompareValue.right = new FormAttachment(100, 0);
        this.wCompareValue.setLayoutData((Object)fdCompareValue);
        lastControl = this.wCompareValue;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, (Control)lastControl);
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setComboValues() {
        Runnable fieldLoader = new Runnable(){

            @Override
            public void run() {
                try {
                    TableCompareDialog.this.prevFields = TableCompareDialog.this.pipelineMeta.getPrevTransformFields(TableCompareDialog.this.variables, TableCompareDialog.this.transformName);
                }
                catch (HopException e) {
                    String msg = BaseMessages.getString((Class)PKG, (String)"TableCompareDialog.DoMapping.UnableToFindInput", (String[])new String[0]);
                    TableCompareDialog.this.log.logError(this.toString(), new Object[]{msg});
                }
                Object[] prevTransformFieldNames = TableCompareDialog.this.prevFields.getFieldNames();
                if (prevTransformFieldNames != null) {
                    Arrays.sort(prevTransformFieldNames);
                    TableCompareDialog.this.wReferenceSchema.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wReferenceTable.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wCompareSchema.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wCompareTable.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wKeyFields.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wExcludeFields.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wKeyDesc.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wReferenceValue.setItems((String[])prevTransformFieldNames);
                    TableCompareDialog.this.wCompareValue.setItems((String[])prevTransformFieldNames);
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    public void getData() {
        for (DatabaseMeta dbMeta : this.pipelineMeta.getDatabases()) {
            this.wReferenceDB.add(dbMeta.getName());
            this.wCompareDB.add(dbMeta.getName());
        }
        this.wReferenceDB.setText(this.input.getReferenceConnection() != null ? this.input.getReferenceConnection().getName() : "");
        this.wReferenceSchema.setText(Const.NVL((String)this.input.getReferenceSchemaField(), (String)""));
        this.wReferenceTable.setText(Const.NVL((String)this.input.getReferenceTableField(), (String)""));
        this.wCompareDB.setText(this.input.getCompareConnection() != null ? this.input.getCompareConnection().getName() : "");
        this.wCompareSchema.setText(Const.NVL((String)this.input.getCompareSchemaField(), (String)""));
        this.wCompareTable.setText(Const.NVL((String)this.input.getCompareTableField(), (String)""));
        this.wKeyFields.setText(Const.NVL((String)this.input.getKeyFieldsField(), (String)""));
        this.wExcludeFields.setText(Const.NVL((String)this.input.getExcludeFieldsField(), (String)""));
        this.wNrErrors.setText(Const.NVL((String)this.input.getNrErrorsField(), (String)""));
        this.wNrRecordsReference.setText(Const.NVL((String)this.input.getNrRecordsReferenceField(), (String)""));
        this.wNrRecordsCompare.setText(Const.NVL((String)this.input.getNrRecordsCompareField(), (String)""));
        this.wNrErrorsLeftJoin.setText(Const.NVL((String)this.input.getNrErrorsLeftJoinField(), (String)""));
        this.wNrErrorsInnerJoin.setText(Const.NVL((String)this.input.getNrErrorsInnerJoinField(), (String)""));
        this.wNrErrorsRightJoin.setText(Const.NVL((String)this.input.getNrErrorsRightJoinField(), (String)""));
        this.wKeyDesc.setText(Const.NVL((String)this.input.getKeyDescriptionField(), (String)""));
        this.wReferenceValue.setText(Const.NVL((String)this.input.getValueReferenceField(), (String)""));
        this.wCompareValue.setText(Const.NVL((String)this.input.getValueCompareField(), (String)""));
        this.setComboValues();
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.input.setReferenceConnection(this.pipelineMeta.findDatabase(this.wReferenceDB.getText()));
        this.input.setReferenceSchemaField(this.wReferenceSchema.getText());
        this.input.setReferenceTableField(this.wReferenceTable.getText());
        this.input.setCompareConnection(this.pipelineMeta.findDatabase(this.wCompareDB.getText()));
        this.input.setCompareSchemaField(this.wCompareSchema.getText());
        this.input.setCompareTableField(this.wCompareTable.getText());
        this.input.setKeyFieldsField(this.wKeyFields.getText());
        this.input.setExcludeFieldsField(this.wExcludeFields.getText());
        this.input.setNrErrorsField(this.wNrErrors.getText());
        this.input.setNrRecordsReferenceField(this.wNrRecordsReference.getText());
        this.input.setNrRecordsCompareField(this.wNrRecordsCompare.getText());
        this.input.setNrErrorsLeftJoinField(this.wNrErrorsLeftJoin.getText());
        this.input.setNrErrorsInnerJoinField(this.wNrErrorsInnerJoin.getText());
        this.input.setNrErrorsRightJoinField(this.wNrErrorsRightJoin.getText());
        this.input.setKeyDescriptionField(this.wKeyDesc.getText());
        this.input.setValueReferenceField(this.wReferenceValue.getText());
        this.input.setValueCompareField(this.wCompareValue.getText());
        this.dispose();
    }
}

