/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.xml.xslt;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.transforms.xml.xslt.XsltMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.xml.xslt.Xslt;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class XsltDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = Xslt.class;
    private static final String[] FILETYPES_XML = new String[]{BaseMessages.getString(PKG, (String)"ActionXSLT.Filetype.Xml", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionXSLT.Filetype.All", (String[])new String[0])};
    private static final String[] FILETYPES_XSL = new String[]{BaseMessages.getString(PKG, (String)"ActionXSLT.Filetype.Xsl", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionXSLT.Filetype.Xslt", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionXSLT.Filetype.All", (String[])new String[0])};
    private Text wName;
    private Label wlxmlFilename;
    private Button wbxmlFilename;
    private TextVar wxmlFilename;
    private Label wlxslFilename;
    private Button wbxslFilename;
    private TextVar wxslFilename;
    private Label wlOutputFilename;
    private TextVar wOutputFilename;
    private Button wbMovetoDirectory;
    private CCombo wIfFileExists;
    private Xslt action;
    private Shell shell;
    private boolean changed;
    private CCombo wXSLTFactory;
    private Button wPrevious;
    private Button wAddFileToResult;
    private TableView wFields;
    private TableView wOutputProperties;

    public XsltDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (Xslt)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionXSLT.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)wTabFolder, 5);
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.Tab.General.Label", (String[])new String[0]));
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wGeneralComp);
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        wGeneralComp.setLayout((Layout)generalLayout);
        Group wFiles = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wFiles);
        wFiles.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.Files.Group.Label", (String[])new String[0]));
        FormLayout groupLayout = new FormLayout();
        groupLayout.marginWidth = 10;
        groupLayout.marginHeight = 10;
        wFiles.setLayout((Layout)groupLayout);
        Label wlPrevious = new Label((Composite)wFiles, 131072);
        wlPrevious.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.Previous.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPrevious);
        FormData fdlPrevious = new FormData();
        fdlPrevious.left = new FormAttachment(0, 0);
        fdlPrevious.top = new FormAttachment((Control)this.wName, margin);
        fdlPrevious.right = new FormAttachment(middle, -margin);
        wlPrevious.setLayoutData((Object)fdlPrevious);
        this.wPrevious = new Button((Composite)wFiles, 32);
        this.props.setLook((Control)this.wPrevious);
        this.wPrevious.setToolTipText(BaseMessages.getString(PKG, (String)"ActionXSLT.Previous.ToolTip", (String[])new String[0]));
        FormData fdPrevious = new FormData();
        fdPrevious.left = new FormAttachment(middle, 0);
        fdPrevious.top = new FormAttachment((Control)wlPrevious, 0, 0x1000000);
        fdPrevious.right = new FormAttachment(100, 0);
        this.wPrevious.setLayoutData((Object)fdPrevious);
        this.wPrevious.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XsltDialog.this.refreshArgFromPrevious();
            }
        });
        this.wlxmlFilename = new Label((Composite)wFiles, 131072);
        this.wlxmlFilename.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.xmlFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlxmlFilename);
        FormData fdlxmlFilename = new FormData();
        fdlxmlFilename.left = new FormAttachment(0, 0);
        fdlxmlFilename.top = new FormAttachment((Control)wlPrevious, 2 * margin);
        fdlxmlFilename.right = new FormAttachment(middle, -margin);
        this.wlxmlFilename.setLayoutData((Object)fdlxmlFilename);
        this.wbxmlFilename = new Button((Composite)wFiles, 0x1000008);
        this.props.setLook((Control)this.wbxmlFilename);
        this.wbxmlFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbxmlFilename = new FormData();
        fdbxmlFilename.right = new FormAttachment(100, 0);
        fdbxmlFilename.top = new FormAttachment((Control)wlPrevious, 2 * margin);
        this.wbxmlFilename.setLayoutData((Object)fdbxmlFilename);
        this.wxmlFilename = new TextVar(this.variables, (Composite)wFiles, 18436);
        this.props.setLook((Control)this.wxmlFilename);
        this.wxmlFilename.addModifyListener(lsMod);
        FormData fdxmlFilename = new FormData();
        fdxmlFilename.left = new FormAttachment(middle, 0);
        fdxmlFilename.top = new FormAttachment((Control)wlPrevious, 2 * margin);
        fdxmlFilename.right = new FormAttachment((Control)this.wbxmlFilename, -margin);
        this.wxmlFilename.setLayoutData((Object)fdxmlFilename);
        this.wxmlFilename.addModifyListener(e -> this.wxmlFilename.setToolTipText(this.variables.resolve(this.wxmlFilename.getText())));
        this.wbxmlFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(XsltDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.xml;*.XML", "*"});
                if (XsltDialog.this.wxmlFilename.getText() != null) {
                    dialog.setFileName(XsltDialog.this.variables.resolve(XsltDialog.this.wxmlFilename.getText()));
                }
                dialog.setFilterNames(FILETYPES_XML);
                if (dialog.open() != null) {
                    XsltDialog.this.wxmlFilename.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        this.wlxslFilename = new Label((Composite)wFiles, 131072);
        this.wlxslFilename.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.xslFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlxslFilename);
        FormData fdlxslFilename = new FormData();
        fdlxslFilename.left = new FormAttachment(0, 0);
        fdlxslFilename.top = new FormAttachment((Control)this.wxmlFilename, margin);
        fdlxslFilename.right = new FormAttachment(middle, -margin);
        this.wlxslFilename.setLayoutData((Object)fdlxslFilename);
        this.wbxslFilename = new Button((Composite)wFiles, 0x1000008);
        this.props.setLook((Control)this.wbxslFilename);
        this.wbxslFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbxslFilename = new FormData();
        fdbxslFilename.right = new FormAttachment(100, 0);
        fdbxslFilename.top = new FormAttachment((Control)this.wxmlFilename, 0);
        this.wbxslFilename.setLayoutData((Object)fdbxslFilename);
        this.wxslFilename = new TextVar(this.variables, (Composite)wFiles, 18436);
        this.props.setLook((Control)this.wxslFilename);
        this.wxslFilename.addModifyListener(lsMod);
        FormData fdxslFilename = new FormData();
        fdxslFilename.left = new FormAttachment(middle, 0);
        fdxslFilename.top = new FormAttachment((Control)this.wxmlFilename, margin);
        fdxslFilename.right = new FormAttachment((Control)this.wbxslFilename, -margin);
        this.wxslFilename.setLayoutData((Object)fdxslFilename);
        this.wxslFilename.addModifyListener(e -> this.wxslFilename.setToolTipText(this.variables.resolve(this.wxslFilename.getText())));
        this.wbxslFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(XsltDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.xsl;*.XSL", "*.xslt;*.XSLT", "*"});
                if (XsltDialog.this.wxslFilename.getText() != null) {
                    dialog.setFileName(XsltDialog.this.variables.resolve(XsltDialog.this.wxslFilename.getText()));
                }
                dialog.setFilterNames(FILETYPES_XSL);
                if (dialog.open() != null) {
                    XsltDialog.this.wxslFilename.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        Button wbOutputDirectory = new Button((Composite)wFiles, 0x1000008);
        this.props.setLook((Control)wbOutputDirectory);
        wbOutputDirectory.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbOutputDirectory = new FormData();
        fdbOutputDirectory.right = new FormAttachment(100, 0);
        fdbOutputDirectory.top = new FormAttachment((Control)this.wXSLTFactory, margin);
        wbOutputDirectory.setLayoutData((Object)fdbOutputDirectory);
        wbOutputDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                DirectoryDialog ddialog = new DirectoryDialog(XsltDialog.this.shell, 4096);
                if (XsltDialog.this.wOutputFilename.getText() != null) {
                    ddialog.setFilterPath(XsltDialog.this.variables.resolve(XsltDialog.this.wOutputFilename.getText()));
                }
                if ((dir = ddialog.open()) != null) {
                    XsltDialog.this.wOutputFilename.setText(dir);
                }
            }
        });
        this.wlOutputFilename = new Label((Composite)wFiles, 131072);
        this.wlOutputFilename.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.OutputFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOutputFilename);
        FormData fdlOutputFilename = new FormData();
        fdlOutputFilename.left = new FormAttachment(0, 0);
        fdlOutputFilename.top = new FormAttachment((Control)this.wxslFilename, margin);
        fdlOutputFilename.right = new FormAttachment(middle, -margin);
        this.wlOutputFilename.setLayoutData((Object)fdlOutputFilename);
        this.wbMovetoDirectory = new Button((Composite)wFiles, 0x1000008);
        this.props.setLook((Control)this.wbMovetoDirectory);
        this.wbMovetoDirectory.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbMovetoDirectory = new FormData();
        fdbMovetoDirectory.right = new FormAttachment(100, 0);
        fdbMovetoDirectory.top = new FormAttachment((Control)this.wxslFilename, margin);
        this.wbMovetoDirectory.setLayoutData((Object)fdbMovetoDirectory);
        this.wbMovetoDirectory.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                DirectoryDialog ddialog = new DirectoryDialog(XsltDialog.this.shell, 4096);
                if (XsltDialog.this.wOutputFilename.getText() != null) {
                    ddialog.setFilterPath(XsltDialog.this.variables.resolve(XsltDialog.this.wOutputFilename.getText()));
                }
                if ((dir = ddialog.open()) != null) {
                    XsltDialog.this.wOutputFilename.setText(dir);
                }
            }
        });
        this.wOutputFilename = new TextVar(this.variables, (Composite)wFiles, 18436);
        this.props.setLook((Control)this.wOutputFilename);
        this.wOutputFilename.addModifyListener(lsMod);
        FormData fdOutputFilename = new FormData();
        fdOutputFilename.left = new FormAttachment(middle, 0);
        fdOutputFilename.top = new FormAttachment((Control)this.wxslFilename, margin);
        fdOutputFilename.right = new FormAttachment((Control)this.wbMovetoDirectory, -margin);
        this.wOutputFilename.setLayoutData((Object)fdOutputFilename);
        this.wOutputFilename.addModifyListener(e -> this.wOutputFilename.setToolTipText(this.variables.resolve(this.wOutputFilename.getText())));
        FormData fdFiles = new FormData();
        fdFiles.left = new FormAttachment(0, margin);
        fdFiles.top = new FormAttachment((Control)this.wName, margin);
        fdFiles.right = new FormAttachment(100, -margin);
        wFiles.setLayoutData((Object)fdFiles);
        Group wFileResult = new Group(wGeneralComp, 32);
        this.props.setLook((Control)wFileResult);
        wFileResult.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.FileResult.Group.Settings.Label", (String[])new String[0]));
        FormLayout groupFilesResultLayout = new FormLayout();
        groupFilesResultLayout.marginWidth = 10;
        groupFilesResultLayout.marginHeight = 10;
        wFileResult.setLayout((Layout)groupFilesResultLayout);
        Label wlXSLTFactory = new Label((Composite)wFileResult, 131072);
        wlXSLTFactory.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.XSLTFactory.Label", (String[])new String[0]));
        this.props.setLook((Control)wlXSLTFactory);
        FormData fdlXSLTFactory = new FormData();
        fdlXSLTFactory.left = new FormAttachment(0, 0);
        fdlXSLTFactory.top = new FormAttachment((Control)wFiles, margin);
        fdlXSLTFactory.right = new FormAttachment(middle, -margin);
        wlXSLTFactory.setLayoutData((Object)fdlXSLTFactory);
        this.wXSLTFactory = new CCombo((Composite)wFileResult, 2056);
        this.wXSLTFactory.setEditable(true);
        this.props.setLook((Control)this.wXSLTFactory);
        this.wXSLTFactory.addModifyListener(lsMod);
        FormData fdXSLTFactory = new FormData();
        fdXSLTFactory.left = new FormAttachment(middle, 0);
        fdXSLTFactory.top = new FormAttachment((Control)wFiles, margin);
        fdXSLTFactory.right = new FormAttachment(100, 0);
        this.wXSLTFactory.setLayoutData((Object)fdXSLTFactory);
        this.wXSLTFactory.add("JAXP");
        this.wXSLTFactory.add("SAXON");
        Label wlIfFileExists = new Label((Composite)wFileResult, 131072);
        wlIfFileExists.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.IfFileExists.Label", (String[])new String[0]));
        this.props.setLook((Control)wlIfFileExists);
        FormData fdlIfFileExists = new FormData();
        fdlIfFileExists.left = new FormAttachment(0, 0);
        fdlIfFileExists.right = new FormAttachment(middle, -margin);
        fdlIfFileExists.top = new FormAttachment((Control)this.wXSLTFactory, margin);
        wlIfFileExists.setLayoutData((Object)fdlIfFileExists);
        this.wIfFileExists = new CCombo((Composite)wFileResult, 2060);
        this.wIfFileExists.add(BaseMessages.getString(PKG, (String)"ActionXSLT.Create_NewFile_IfFileExists.Label", (String[])new String[0]));
        this.wIfFileExists.add(BaseMessages.getString(PKG, (String)"ActionXSLT.Do_Nothing_IfFileExists.Label", (String[])new String[0]));
        this.wIfFileExists.add(BaseMessages.getString(PKG, (String)"ActionXSLT.Fail_IfFileExists.Label", (String[])new String[0]));
        this.wIfFileExists.select(1);
        this.props.setLook((Control)this.wIfFileExists);
        FormData fdIfFileExists = new FormData();
        fdIfFileExists.left = new FormAttachment(middle, 0);
        fdIfFileExists.top = new FormAttachment((Control)this.wXSLTFactory, margin);
        fdIfFileExists.right = new FormAttachment(100, 0);
        this.wIfFileExists.setLayoutData((Object)fdIfFileExists);
        fdIfFileExists = new FormData();
        fdIfFileExists.left = new FormAttachment(middle, 0);
        fdIfFileExists.top = new FormAttachment((Control)this.wXSLTFactory, margin);
        fdIfFileExists.right = new FormAttachment(100, 0);
        this.wIfFileExists.setLayoutData((Object)fdIfFileExists);
        Label wlAddFileToResult = new Label((Composite)wFileResult, 131072);
        wlAddFileToResult.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.AddFileToResult.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAddFileToResult);
        FormData fdlAddFileToResult = new FormData();
        fdlAddFileToResult.left = new FormAttachment(0, 0);
        fdlAddFileToResult.top = new FormAttachment((Control)this.wIfFileExists, margin);
        fdlAddFileToResult.right = new FormAttachment(middle, -margin);
        wlAddFileToResult.setLayoutData((Object)fdlAddFileToResult);
        this.wAddFileToResult = new Button((Composite)wFileResult, 32);
        this.props.setLook((Control)this.wAddFileToResult);
        this.wAddFileToResult.setToolTipText(BaseMessages.getString(PKG, (String)"ActionXSLT.AddFileToResult.Tooltip", (String[])new String[0]));
        FormData fdAddFileToResult = new FormData();
        fdAddFileToResult.left = new FormAttachment(middle, 0);
        fdAddFileToResult.top = new FormAttachment((Control)wlAddFileToResult, 0, 0x1000000);
        fdAddFileToResult.right = new FormAttachment(100, 0);
        this.wAddFileToResult.setLayoutData((Object)fdAddFileToResult);
        this.wAddFileToResult.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XsltDialog.this.action.setChanged();
            }
        });
        FormData fdFileResult = new FormData();
        fdFileResult.left = new FormAttachment(0, margin);
        fdFileResult.top = new FormAttachment((Control)wFiles, margin);
        fdFileResult.right = new FormAttachment(100, -margin);
        wFileResult.setLayoutData((Object)fdFileResult);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(500, -margin);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
        this.props.setLook((Control)wGeneralComp);
        CTabItem wAdvancedTab = new CTabItem(wTabFolder, 0);
        wAdvancedTab.setText(BaseMessages.getString(PKG, (String)"ActionXSLT.Tab.Advanced.Label", (String[])new String[0]));
        Composite wAdvancedComp = new Composite((Composite)wTabFolder, 0);
        this.props.setLook((Control)wAdvancedComp);
        FormLayout advancedLayout = new FormLayout();
        advancedLayout.marginWidth = 3;
        advancedLayout.marginHeight = 3;
        wAdvancedComp.setLayout((Layout)advancedLayout);
        Label wlOutputProperties = new Label(wAdvancedComp, 0);
        wlOutputProperties.setText(BaseMessages.getString(PKG, (String)"XsltDialog.OutputProperties.Label", (String[])new String[0]));
        this.props.setLook((Control)wlOutputProperties);
        FormData fdlOutputProperties = new FormData();
        fdlOutputProperties.left = new FormAttachment(0, 0);
        fdlOutputProperties.top = new FormAttachment(0, margin);
        wlOutputProperties.setLayoutData((Object)fdlOutputProperties);
        int OutputPropertiesRows = this.action.getOutputPropertyName().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XsltDialog.ColumnInfo.OutputProperties.Name", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XsltDialog.ColumnInfo.OutputProperties.Value", (String[])new String[0]), 1, false)};
        colinf[0].setComboValues(XsltMeta.outputProperties);
        colinf[1].setUsingVariables(true);
        this.wOutputProperties = new TableView(this.variables, wAdvancedComp, 67586, colinf, OutputPropertiesRows, lsMod, this.props);
        FormData fdOutputProperties = new FormData();
        fdOutputProperties.left = new FormAttachment(0, 0);
        fdOutputProperties.top = new FormAttachment((Control)wlOutputProperties, margin);
        fdOutputProperties.right = new FormAttachment(100, -margin);
        fdOutputProperties.bottom = new FormAttachment((Control)wlOutputProperties, 200);
        this.wOutputProperties.setLayoutData((Object)fdOutputProperties);
        Label wlFields = new Label(wAdvancedComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"XsltDialog.Parameters.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)this.wOutputProperties, 2 * margin);
        wlFields.setLayoutData((Object)fdlFields);
        int FieldsRows = this.action.getParameterField().length;
        colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XsltDialog.ColumnInfo.Name", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XsltDialog.ColumnInfo.Parameter", (String[])new String[0]), 1, false)};
        colinf[1].setUsingVariables(true);
        colinf[0].setUsingVariables(true);
        this.wFields = new TableView(this.variables, wAdvancedComp, 67586, colinf, FieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, -margin);
        fdFields.bottom = new FormAttachment(100, -margin);
        this.wFields.setLayoutData((Object)fdFields);
        FormData fdAdvancedComp = new FormData();
        fdAdvancedComp.left = new FormAttachment(0, 0);
        fdAdvancedComp.top = new FormAttachment(0, 0);
        fdAdvancedComp.right = new FormAttachment(100, 0);
        fdAdvancedComp.bottom = new FormAttachment(500, -margin);
        wAdvancedComp.setLayoutData((Object)fdAdvancedComp);
        wAdvancedComp.layout();
        wAdvancedTab.setControl((Control)wAdvancedComp);
        this.props.setLook((Control)wAdvancedComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wName, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        this.getData();
        this.refreshArgFromPrevious();
        wTabFolder.setSelection(0);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    private void refreshArgFromPrevious() {
        this.wlxmlFilename.setEnabled(!this.wPrevious.getSelection());
        this.wxmlFilename.setEnabled(!this.wPrevious.getSelection());
        this.wbxmlFilename.setEnabled(!this.wPrevious.getSelection());
        this.wlxslFilename.setEnabled(!this.wPrevious.getSelection());
        this.wxslFilename.setEnabled(!this.wPrevious.getSelection());
        this.wbxslFilename.setEnabled(!this.wPrevious.getSelection());
        this.wlOutputFilename.setEnabled(!this.wPrevious.getSelection());
        this.wOutputFilename.setEnabled(!this.wPrevious.getSelection());
        this.wbMovetoDirectory.setEnabled(!this.wPrevious.getSelection());
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        TableItem item;
        int i;
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wxmlFilename.setText(Const.nullToEmpty((String)this.action.getxmlFilename()));
        this.wxslFilename.setText(Const.nullToEmpty((String)this.action.getxslFilename()));
        this.wOutputFilename.setText(Const.nullToEmpty((String)this.action.getoutputFilename()));
        if (this.action.ifFileExists >= 0) {
            this.wIfFileExists.select(this.action.ifFileExists);
        } else {
            this.wIfFileExists.select(2);
        }
        this.wAddFileToResult.setSelection(this.action.isAddFileToResult());
        this.wPrevious.setSelection(this.action.isFilenamesFromPrevious());
        if (this.action.getXSLTFactory() != null) {
            this.wXSLTFactory.setText(this.action.getXSLTFactory());
        } else {
            this.wXSLTFactory.setText("JAXP");
        }
        if (this.action.getParameterName() != null) {
            for (i = 0; i < this.action.getParameterName().length; ++i) {
                item = this.wFields.table.getItem(i);
                item.setText(1, Const.NVL((String)this.action.getParameterField()[i], (String)""));
                item.setText(2, Const.NVL((String)this.action.getParameterName()[i], (String)""));
            }
        }
        if (this.action.getOutputPropertyName() != null) {
            for (i = 0; i < this.action.getOutputPropertyName().length; ++i) {
                item = this.wOutputProperties.table.getItem(i);
                item.setText(1, Const.NVL((String)this.action.getOutputPropertyName()[i], (String)""));
                item.setText(2, Const.NVL((String)this.action.getOutputPropertyValue()[i], (String)""));
            }
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setxmlFilename(this.wxmlFilename.getText());
        this.action.setxslFilename(this.wxslFilename.getText());
        this.action.setoutputFilename(this.wOutputFilename.getText());
        this.action.ifFileExists = this.wIfFileExists.getSelectionIndex();
        this.action.setFilenamesFromPrevious(this.wPrevious.getSelection());
        this.action.setAddFileToResult(this.wAddFileToResult.getSelection());
        this.action.setXSLTFactory(this.wXSLTFactory.getText());
        int nrparams = this.wFields.nrNonEmpty();
        int nroutputprops = this.wOutputProperties.nrNonEmpty();
        this.action.allocate(nrparams, nroutputprops);
        for (i = 0; i < nrparams; ++i) {
            item = this.wFields.getNonEmpty(i);
            this.action.getParameterField()[i] = item.getText(1);
            this.action.getParameterName()[i] = item.getText(2);
        }
        for (i = 0; i < nroutputprops; ++i) {
            item = this.wOutputProperties.getNonEmpty(i);
            this.action.getOutputPropertyName()[i] = item.getText(1);
            this.action.getOutputPropertyValue()[i] = item.getText(2);
        }
        this.dispose();
    }
}

