/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.xml.xsdvalidator;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.xml.xsdvalidator.XsdValidator;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class XsdValidatorDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = XsdValidator.class;
    private static final String[] FILETYPES_XML = new String[]{BaseMessages.getString(PKG, (String)"ActionXSDValidator.Filetype.Xml", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionXSDValidator.Filetype.All", (String[])new String[0])};
    private static final String[] FILETYPES_XSD = new String[]{BaseMessages.getString(PKG, (String)"ActionXSDValidator.Filetype.Xsd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionXSDValidator.Filetype.All", (String[])new String[0])};
    private Text wName;
    private Button wAllowExternalEntities;
    private TextVar wxmlFilename;
    private TextVar wxsdFilename;
    private XsdValidator action;
    private Shell shell;
    private boolean changed;

    public XsdValidatorDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (XsdValidator)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"ActionXSDValidator.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, -margin);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlAllowExternalEntities = new Label((Composite)this.shell, 131072);
        wlAllowExternalEntities.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.AllowExternalEntities.Label", (String[])new String[0]));
        this.props.setLook((Control)wlAllowExternalEntities);
        FormData fdlAllowExternalEntities = new FormData();
        fdlAllowExternalEntities.left = new FormAttachment(0, 0);
        fdlAllowExternalEntities.right = new FormAttachment(middle, -margin);
        fdlAllowExternalEntities.top = new FormAttachment((Control)this.wName, margin);
        wlAllowExternalEntities.setLayoutData((Object)fdlAllowExternalEntities);
        this.wAllowExternalEntities = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wAllowExternalEntities);
        FormData fdAllowExternalEntities = new FormData();
        fdAllowExternalEntities.left = new FormAttachment(middle, 0);
        fdAllowExternalEntities.top = new FormAttachment((Control)wlAllowExternalEntities, 0, 0x1000000);
        fdAllowExternalEntities.right = new FormAttachment(100, 0);
        this.wAllowExternalEntities.setLayoutData((Object)fdAllowExternalEntities);
        this.wAllowExternalEntities.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XsdValidatorDialog.this.action.setChanged();
            }
        });
        Label wlxmlFilename = new Label((Composite)this.shell, 131072);
        wlxmlFilename.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.xmlFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlxmlFilename);
        FormData fdlxmlFilename = new FormData();
        fdlxmlFilename.left = new FormAttachment(0, 0);
        fdlxmlFilename.top = new FormAttachment((Control)wlAllowExternalEntities, 2 * margin);
        fdlxmlFilename.right = new FormAttachment(middle, -margin);
        wlxmlFilename.setLayoutData((Object)fdlxmlFilename);
        Button wbxmlFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbxmlFilename);
        wbxmlFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbxmlFilename = new FormData();
        fdbxmlFilename.right = new FormAttachment(100, 0);
        fdbxmlFilename.top = new FormAttachment((Control)wlAllowExternalEntities, 2 * margin);
        wbxmlFilename.setLayoutData((Object)fdbxmlFilename);
        this.wxmlFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wxmlFilename);
        this.wxmlFilename.addModifyListener(lsMod);
        FormData fdxmlFilename = new FormData();
        fdxmlFilename.left = new FormAttachment(middle, 0);
        fdxmlFilename.top = new FormAttachment((Control)wlAllowExternalEntities, 2 * margin);
        fdxmlFilename.right = new FormAttachment((Control)wbxmlFilename, -margin);
        this.wxmlFilename.setLayoutData((Object)fdxmlFilename);
        this.wxmlFilename.addModifyListener(e -> this.wxmlFilename.setToolTipText(this.variables.resolve(this.wxmlFilename.getText())));
        wbxmlFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(XsdValidatorDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.xml;*.XML", "*"});
                if (XsdValidatorDialog.this.wxmlFilename.getText() != null) {
                    dialog.setFileName(XsdValidatorDialog.this.variables.resolve(XsdValidatorDialog.this.wxmlFilename.getText()));
                }
                dialog.setFilterNames(FILETYPES_XML);
                if (dialog.open() != null) {
                    XsdValidatorDialog.this.wxmlFilename.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        Label wlxsdFilename = new Label((Composite)this.shell, 131072);
        wlxsdFilename.setText(BaseMessages.getString(PKG, (String)"ActionXSDValidator.xsdFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlxsdFilename);
        FormData fdlxsdFilename = new FormData();
        fdlxsdFilename.left = new FormAttachment(0, 0);
        fdlxsdFilename.top = new FormAttachment((Control)this.wxmlFilename, margin);
        fdlxsdFilename.right = new FormAttachment(middle, -margin);
        wlxsdFilename.setLayoutData((Object)fdlxsdFilename);
        Button wbxsdFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)wbxsdFilename);
        wbxsdFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbxsdFilename = new FormData();
        fdbxsdFilename.right = new FormAttachment(100, 0);
        fdbxsdFilename.top = new FormAttachment((Control)this.wxmlFilename, 0);
        wbxsdFilename.setLayoutData((Object)fdbxsdFilename);
        this.wxsdFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wxsdFilename);
        this.wxsdFilename.addModifyListener(lsMod);
        FormData fdxsdFilename = new FormData();
        fdxsdFilename.left = new FormAttachment(middle, 0);
        fdxsdFilename.top = new FormAttachment((Control)this.wxmlFilename, margin);
        fdxsdFilename.right = new FormAttachment((Control)wbxsdFilename, -margin);
        this.wxsdFilename.setLayoutData((Object)fdxsdFilename);
        this.wxsdFilename.addModifyListener(e -> this.wxsdFilename.setToolTipText(this.variables.resolve(this.wxsdFilename.getText())));
        wbxsdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(XsdValidatorDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.xsd;*.XSD", "*"});
                if (XsdValidatorDialog.this.wxsdFilename.getText() != null) {
                    dialog.setFileName(XsdValidatorDialog.this.variables.resolve(XsdValidatorDialog.this.wxsdFilename.getText()));
                }
                dialog.setFilterNames(FILETYPES_XSD);
                if (dialog.open() != null) {
                    XsdValidatorDialog.this.wxsdFilename.setText(dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName());
                }
            }
        });
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, (Control)this.wxsdFilename);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wAllowExternalEntities.setSelection(this.action.isAllowExternalEntities());
        this.wxmlFilename.setText(Const.nullToEmpty((String)this.action.getxmlFilename()));
        this.wxsdFilename.setText(Const.nullToEmpty((String)this.action.getxsdFilename()));
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setAllowExternalEntities(this.wAllowExternalEntities.getSelection());
        this.action.setxmlFilename(this.wxmlFilename.getText());
        this.action.setxsdFilename(this.wxsdFilename.getText());
        this.dispose();
    }
}

