/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.xml.dtdvalidator;

import java.util.List;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.resource.IResourceHolder;
import org.apache.hop.resource.ResourceEntry;
import org.apache.hop.resource.ResourceReference;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.actions.xml.dtdvalidator.DtdValidatorUtil;
import org.w3c.dom.Node;

@Action(id="DTD_VALIDATOR", name="i18n::DTD_VALIDATOR.Name", description="i18n::DTD_VALIDATOR.Description", image="DTD.svg", categoryDescription="i18n::DTD_VALIDATOR.Category", documentationUrl="/workflow/actions/dtdvalidator.html")
public class DtdValidator
extends ActionBase
implements Cloneable,
IAction {
    private String xmlfilename = null;
    private String dtdfilename = null;
    private boolean dtdintern = false;

    public DtdValidator(String n) {
        super(n, "");
    }

    public DtdValidator() {
        this("");
    }

    public Object clone() {
        DtdValidator je = (DtdValidator)super.clone();
        return je;
    }

    public String getXml() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXml());
        retval.append("      ").append(XmlHandler.addTagValue((String)"xmlfilename", (String)this.xmlfilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"dtdfilename", (String)this.dtdfilename));
        retval.append("      ").append(XmlHandler.addTagValue((String)"dtdintern", (boolean)this.dtdintern));
        return retval.toString();
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.xmlfilename = XmlHandler.getTagValue((Node)entrynode, (String)"xmlfilename");
            this.dtdfilename = XmlHandler.getTagValue((Node)entrynode, (String)"dtdfilename");
            this.dtdintern = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"dtdintern"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException("Unable to load job entry of type 'DTDvalidator' from XML node", (Throwable)xe);
        }
    }

    public String getRealxmlfilename() {
        return this.resolve(this.xmlfilename);
    }

    public String getRealDTDfilename() {
        return this.resolve(this.dtdfilename);
    }

    public Result execute(Result previousResult, int nr) {
        Result result = previousResult;
        result.setResult(true);
        String realxmlfilename = this.getRealxmlfilename();
        String realDTDfilename = this.getRealDTDfilename();
        DtdValidatorUtil validator = new DtdValidatorUtil(this.log);
        validator.setXMLFilename(realxmlfilename);
        if (this.dtdintern) {
            validator.setInternDTD(true);
        } else {
            validator.setDTDFilename(realDTDfilename);
        }
        boolean status = validator.validate();
        if (!status) {
            this.log.logError(validator.getErrorMessage());
            result.setResult(false);
            result.setNrErrors((long)validator.getNrErrors());
            result.setLogText(validator.getErrorMessage());
        }
        return result;
    }

    public boolean isEvaluation() {
        return true;
    }

    public void setxmlFilename(String filename) {
        this.xmlfilename = filename;
    }

    public String getxmlFilename() {
        return this.xmlfilename;
    }

    public void setdtdFilename(String filename) {
        this.dtdfilename = filename;
    }

    public String getdtdFilename() {
        return this.dtdfilename;
    }

    public boolean getDTDIntern() {
        return this.dtdintern;
    }

    public void setDTDIntern(boolean dtdinternin) {
        this.dtdintern = dtdinternin;
    }

    public List<ResourceReference> getResourceDependencies(IVariables variables, WorkflowMeta workflowMeta) {
        List references = super.getResourceDependencies(variables, workflowMeta);
        if (!Utils.isEmpty((CharSequence)this.dtdfilename) && !Utils.isEmpty((CharSequence)this.xmlfilename)) {
            String realXmlFileName = variables.resolve(this.xmlfilename);
            String realXsdFileName = variables.resolve(this.dtdfilename);
            ResourceReference reference = new ResourceReference((IResourceHolder)this);
            reference.getEntries().add(new ResourceEntry(realXmlFileName, ResourceEntry.ResourceType.FILE));
            reference.getEntries().add(new ResourceEntry(realXsdFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta jobMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notBlankValidator(), ActionValidatorUtils.fileExistsValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "dtdfilename", remarks, ctx);
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, "xmlFilename", remarks, ctx);
    }
}

