/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.setvaluefield;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.setvaluefield.SetValueField;
import org.apache.hop.pipeline.transforms.setvaluefield.SetValueFieldData;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="SetValueField.Injection.", groups={"FIELDS"})
@Transform(id="SetValueField", image="setvaluefield.svg", name="i18n::BaseTransform.TypeLongDesc.SetValueField", description="i18n::BaseTransform.TypeTooltipDesc.SetValueField", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/setvaluefield.html")
public class SetValueFieldMeta
extends BaseTransformMeta
implements ITransformMeta<SetValueField, SetValueFieldData> {
    private static final Class<?> PKG = SetValueFieldMeta.class;
    @Injection(name="FIELD_NAME", group="FIELDS")
    private String[] fieldName;
    @Injection(name="REPLACE_BY_FIELD_VALUE", group="FIELDS")
    private String[] replaceByFieldValue;

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getReplaceByFieldValue() {
        return this.replaceByFieldValue;
    }

    public void setReplaceByFieldValue(String[] replaceByFieldValue) {
        this.replaceByFieldValue = replaceByFieldValue;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public void allocate(int count) {
        this.fieldName = new String[count];
        this.replaceByFieldValue = new String[count];
    }

    public Object clone() {
        SetValueFieldMeta retval = (SetValueFieldMeta)((Object)super.clone());
        int count = this.fieldName.length;
        retval.allocate(count);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, count);
        System.arraycopy(this.replaceByFieldValue, 0, retval.replaceByFieldValue, 0, count);
        return retval;
    }

    public ITransform createTransform(TransformMeta transformMeta, SetValueFieldData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new SetValueField(transformMeta, this, data, copyNr, pipelineMeta, pipeline);
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int count = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(count);
            for (int i = 0; i < count; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.replaceByFieldValue[i] = XmlHandler.getTagValue((Node)fnode, (String)"replaceby");
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"SetValueFieldMeta.Exception.UnableToReadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        int count = 0;
        this.allocate(count);
        for (int i = 0; i < count; ++i) {
            this.fieldName[i] = "field" + i;
            this.replaceByFieldValue[i] = "";
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      <field>" + Const.CR);
            retval.append("        " + XmlHandler.addTagValue((String)"name", (String)this.fieldName[i]));
            retval.append("        " + XmlHandler.addTagValue((String)"replaceby", (String)this.replaceByFieldValue[i]));
            retval.append("        </field>" + Const.CR);
        }
        retval.append("      </fields>" + Const.CR);
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr = prev == null || prev.size() == 0 ? new CheckResult(3, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.NoReceivingFieldsError", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.TransformReceivingFieldsOK", (String[])new String[]{prev.size() + ""}), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        cr = input.length > 0 ? new CheckResult(1, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.TransformRecevingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta) : new CheckResult(4, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.NoInputReceivedError", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
        if (this.fieldName == null && this.fieldName.length == 0) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.FieldsSelectionEmpty", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            for (int i = 0; i < this.fieldName.length; ++i) {
                if (!Utils.isEmpty((CharSequence)this.replaceByFieldValue[i])) continue;
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SetValueFieldMeta.CheckResult.ReplaceByValueMissing", (String[])new String[]{this.fieldName[i], "" + i}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        }
    }

    public SetValueFieldData getTransformData() {
        return new SetValueFieldData();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

