/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ServerStream;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.metrics.Meter;
import com.google.cloud.bigtable.metrics.Timer;
import java.util.ArrayList;
import java.util.Iterator;

@InternalApi(value="For internal usage only")
public class RowResultScanner<T>
implements ResultScanner<T> {
    private static final Meter resultsMeter = BigtableClientMetrics.meter(BigtableClientMetrics.MetricLevel.Info, "scanner.results");
    private static final Timer resultsTimer = BigtableClientMetrics.timer(BigtableClientMetrics.MetricLevel.Debug, "scanner.results.latency");
    private final ServerStream<T> stream;
    private final Iterator<T> iterator;
    private final T[] arr;

    public RowResultScanner(ServerStream<T> stream, T[] arr) {
        this.stream = stream;
        this.iterator = stream.iterator();
        this.arr = arr;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T next() {
        if (!this.iterator.hasNext()) {
            return null;
        }
        try (Timer.Context ignored = resultsTimer.time();){
            T result = this.iterator.next();
            resultsMeter.mark();
            T t = result;
            return t;
        }
    }

    @Override
    public T[] next(int count) {
        T row;
        ArrayList<T> resultList = new ArrayList<T>(count);
        for (int i = 0; this.iterator.hasNext() && i < count && (row = this.next()) != null; ++i) {
            resultList.add(row);
        }
        return resultList.toArray(this.arr);
    }

    @Override
    public int available() {
        return this.stream.isReceiveReady() ? 1 : 0;
    }

    @Override
    public void close() {
        if (this.iterator.hasNext()) {
            this.stream.cancel();
        }
    }
}

