/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.scanner;

import com.google.api.client.util.Preconditions;
import com.google.api.core.ApiClock;
import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.bigtable.v2.RowSet;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.DeadlineGenerator;
import com.google.cloud.bigtable.grpc.async.AbstractRetryingOperation;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.cloud.bigtable.grpc.async.CallController;
import com.google.cloud.bigtable.grpc.io.Watchdog;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.grpc.scanner.ReadRowsRequestManager;
import com.google.cloud.bigtable.grpc.scanner.RowMerger;
import com.google.cloud.bigtable.grpc.scanner.ScanHandler;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import io.opencensus.trace.AttributeValue;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.concurrent.NotThreadSafe;

@InternalApi(value="For internal usage only")
@NotThreadSafe
public class RetryingReadRowsOperation
extends AbstractRetryingOperation<ReadRowsRequest, ReadRowsResponse, String>
implements ScanHandler {
    private final ReadRowsRequestManager requestManager;
    private final StreamObserver<FlatRow> rowObserver;
    private final RowMerger rowMerger;
    private int timeoutRetryCount = 0;
    private StreamObserver<ReadRowsResponse> resultObserver;
    private int totalRowsProcessed = 0;
    private volatile ReadRowsRequest nextRequest;

    public RetryingReadRowsOperation(StreamObserver<FlatRow> observer, RetryOptions retryOptions, ReadRowsRequest request, BigtableAsyncRpc<ReadRowsRequest, ReadRowsResponse> retryableRpc, DeadlineGenerator deadlineGenerator, ScheduledExecutorService retryExecutorService, Metadata originalMetadata, ApiClock clock) {
        super(retryOptions, request, retryableRpc, deadlineGenerator, retryExecutorService, originalMetadata, clock);
        this.rowObserver = observer;
        this.rowMerger = new RowMerger(this.rowObserver);
        this.requestManager = new ReadRowsRequestManager(request);
        this.nextRequest = request;
    }

    @Override
    protected CallController<ReadRowsRequest, ReadRowsResponse> createCallController() {
        return new IdleResumingCallController();
    }

    public void setResultObserver(StreamObserver<ReadRowsResponse> resultObserver) {
        this.resultObserver = resultObserver;
    }

    @Override
    protected ReadRowsRequest getRetryRequest() {
        return this.nextRequest;
    }

    @Override
    public void run() {
        try {
            super.run();
            this.callWrapper.request(1);
            if (this.rowObserver instanceof ClientResponseObserver) {
                ((ClientResponseObserver)this.rowObserver).beforeStart((ClientCallStreamObserver)this.callWrapper);
            }
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    public void onMessage(ReadRowsResponse message) {
        try {
            this.resetStatusBasedBackoff();
            this.timeoutRetryCount = 0;
            ByteString previouslyProcessedKey = this.rowMerger.getLastCompletedRowKey();
            this.operationSpan.addAnnotation("Got a response");
            this.rowMerger.onNext(message);
            int rowCountInLastMessage = this.rowMerger.getRowCountInLastMessage();
            this.operationSpan.addAnnotation("Processed Response", (Map)ImmutableMap.of((Object)"rowCount", (Object)AttributeValue.longAttributeValue((long)rowCountInLastMessage)));
            this.totalRowsProcessed += rowCountInLastMessage;
            this.requestManager.incrementRowCount(rowCountInLastMessage);
            ByteString lastProcessedKey = this.rowMerger.getLastCompletedRowKey();
            if (previouslyProcessedKey != lastProcessedKey) {
                this.updateLastFoundKey(lastProcessedKey);
            } else {
                this.updateLastFoundKey(message.getLastScannedRowKey());
            }
            if (this.callWrapper.isAutoFlowControlEnabled()) {
                this.callWrapper.request(1);
            }
            if (this.resultObserver != null) {
                this.resultObserver.onNext((Object)message);
            }
        }
        catch (Exception e) {
            this.setException(e);
        }
    }

    @Override
    protected void finalizeStats(Status status) {
        this.operationSpan.addAnnotation("Total Rows Processed", (Map)ImmutableMap.of((Object)"rowCount", (Object)AttributeValue.longAttributeValue((long)this.totalRowsProcessed)));
        super.finalizeStats(status);
    }

    private void updateLastFoundKey(ByteString lastProcessedKey) {
        if (lastProcessedKey != null && !lastProcessedKey.isEmpty()) {
            this.requestManager.updateLastFoundKey(lastProcessedKey);
        }
    }

    @Override
    public void onClose(Status status, Metadata trailers) {
        ReadRowsRequest retryRequest;
        boolean isFullTableScan;
        if (!status.isOk() && this.requestManager.getLastFoundKey() != null && (isFullTableScan = (retryRequest = this.requestManager.buildUpdatedRequest()).getRows().equals((Object)RowSet.getDefaultInstance()))) {
            status = Status.OK;
        }
        if (status.getCause() instanceof Watchdog.StreamWaitTimeoutException) {
            Watchdog.StreamWaitTimeoutException timeoutException = (Watchdog.StreamWaitTimeoutException)status.getCause();
            switch (timeoutException.getState()) {
                case WAITING: {
                    this.operationSpan.addAnnotation("Received an WAITING timeout.");
                    this.handleTimeoutError(status);
                    return;
                }
                case IDLE: {
                    this.operationSpan.addAnnotation("Received an IDLE timeout.");
                    ((IdleResumingCallController)this.callWrapper).setIsIdle();
                    return;
                }
            }
        }
        super.onClose(status, trailers);
    }

    @Override
    public void setException(Exception exception) {
        this.rowMerger.onError(exception);
        super.setException(exception);
    }

    @Override
    protected boolean isRequestRetryable() {
        return true;
    }

    @Override
    protected boolean onOK(Metadata trailers) {
        this.rowMerger.onCompleted();
        this.completionFuture.set("");
        return true;
    }

    private void handleTimeoutError(Status status) {
        Preconditions.checkArgument((boolean)(status.getCause() instanceof Watchdog.StreamWaitTimeoutException), (Object)"status is not caused by a StreamWaitTimeoutException");
        Watchdog.StreamWaitTimeoutException e = (Watchdog.StreamWaitTimeoutException)status.getCause();
        this.rpcTimerContext.close();
        ++this.failedCount;
        int maxRetries = this.retryOptions.getMaxScanTimeoutRetries();
        if (this.retryOptions.enableRetries() && ++this.timeoutRetryCount <= maxRetries) {
            LOG.warn("The client could not get a response in %d ms. Retrying the scan.", e.getWaitTimeMs());
            this.resetStatusBasedBackoff();
            this.performRetry(0L);
        } else {
            LOG.warn("The client could not get a response after %d tries, giving up.", this.timeoutRetryCount);
            this.rpc.getRpcMetrics().markFailure();
            this.finalizeStats(status);
            this.setException(this.getExhaustedRetriesException(status));
        }
    }

    @Override
    protected void performRetry(long nextBackOff) {
        this.buildUpdatedRequest();
        super.performRetry(nextBackOff);
    }

    @VisibleForTesting
    ReadRowsRequest buildUpdatedRequest() {
        this.rowMerger.clearRowInProgress();
        this.nextRequest = this.requestManager.buildUpdatedRequest();
        return this.nextRequest;
    }

    @VisibleForTesting
    int getTimeoutRetryCount() {
        return this.timeoutRetryCount;
    }

    @VisibleForTesting
    RowMerger getRowMerger() {
        return this.rowMerger;
    }

    class IdleResumingCallController
    extends CallController {
        private boolean isIdle = false;

        IdleResumingCallController() {
        }

        @Override
        public synchronized void request(int count) {
            if (this.isIdle) {
                RetryingReadRowsOperation.this.operationSpan.addAnnotation("Resuming after IDLE");
                this.isIdle = false;
                RetryingReadRowsOperation.this.performRetry(0L);
            } else {
                super.request(count);
            }
        }

        synchronized void setIsIdle() {
            this.isIdle = true;
        }
    }
}

