/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.io;

import com.google.api.core.InternalApi;
import com.google.auth.Credentials;
import com.google.auth.oauth2.OAuth2Credentials;
import com.google.cloud.bigtable.config.CredentialFactory;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.io.RefreshingOAuth2CredentialsInterceptor;
import com.google.cloud.bigtable.util.ThreadUtil;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.ClientInterceptor;
import io.grpc.auth.ClientAuthInterceptor;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@InternalApi(value="For internal usage only")
public class CredentialInterceptorCache {
    private static CredentialInterceptorCache instance = new CredentialInterceptorCache();
    private final ExecutorService executor = Executors.newCachedThreadPool(ThreadUtil.getThreadFactory("Credentials-Refresh-%d", true));
    private ClientInterceptor defaultCredentialInterceptor;

    public static CredentialInterceptorCache getInstance() {
        return instance;
    }

    private CredentialInterceptorCache() {
    }

    public synchronized ClientInterceptor getCredentialsInterceptor(CredentialOptions credentialOptions, RetryOptions retryOptions) throws IOException, GeneralSecurityException {
        boolean isDefaultCredentials;
        boolean bl = isDefaultCredentials = credentialOptions.getCredentialType() == CredentialOptions.CredentialType.DefaultCredentials;
        if (isDefaultCredentials && this.defaultCredentialInterceptor != null) {
            return this.defaultCredentialInterceptor;
        }
        Credentials credentials = CredentialFactory.getCredentials(credentialOptions);
        if (credentials == null) {
            return null;
        }
        if (credentials instanceof OAuth2Credentials) {
            RefreshingOAuth2CredentialsInterceptor oauth2Interceptor = new RefreshingOAuth2CredentialsInterceptor(this.executor, (OAuth2Credentials)credentials);
            oauth2Interceptor.asyncRefresh();
            if (isDefaultCredentials) {
                this.defaultCredentialInterceptor = oauth2Interceptor;
            }
            return oauth2Interceptor;
        }
        ClientAuthInterceptor jwtAuthInterceptor = new ClientAuthInterceptor(credentials, MoreExecutors.directExecutor());
        if (isDefaultCredentials) {
            this.defaultCredentialInterceptor = jwtAuthInterceptor;
        }
        return jwtAuthInterceptor;
    }
}

