/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.api.core.ApiClock;
import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.DeadlineGenerator;
import com.google.cloud.bigtable.grpc.async.AbstractRetryingOperation;
import com.google.cloud.bigtable.grpc.async.BigtableAsyncRpc;
import com.google.common.collect.ImmutableList;
import io.grpc.Metadata;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;

@InternalApi(value="For internal usage only")
public class RetryingStreamOperation<RequestT, ResponseT>
extends AbstractRetryingOperation<RequestT, ResponseT, List<ResponseT>> {
    private ImmutableList.Builder<ResponseT> buffer;

    public RetryingStreamOperation(RetryOptions retryOptions, RequestT request, BigtableAsyncRpc<RequestT, ResponseT> retryableRpc, DeadlineGenerator deadlineGenerator, ScheduledExecutorService executorService, Metadata metadata, ApiClock clock) {
        super(retryOptions, request, retryableRpc, deadlineGenerator, executorService, metadata, clock);
    }

    @Override
    public void run() {
        this.buffer = new ImmutableList.Builder();
        super.run();
    }

    public void onMessage(ResponseT message) {
        this.callWrapper.request(1);
        this.buffer.add(message);
    }

    @Override
    protected boolean onOK(Metadata trailers) {
        this.completionFuture.set(this.buffer.build());
        return true;
    }
}

