/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.MutateRowsResponse;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.rpc.Status;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.List;

@InternalApi(value="For internal usage only")
public class MutateRowsRequestManager {
    private static final Status STATUS_INTERNAL = Status.newBuilder().setCode(Status.Code.INTERNAL.value()).setMessage("Response was not returned for this index.").build();
    private volatile MutateRowsRequest currentRequest;
    private int[] mapToOriginalIndex;
    private final Status[] results;
    private final RetryOptions retryOptions;
    private final MutateRowsRequest originalRequest;
    private boolean messageIsInvalid = false;

    private static Status.Code getGrpcCode(Status status) {
        return status == null ? null : io.grpc.Status.fromCodeValue((int)status.getCode()).getCode();
    }

    private static MutateRowsResponse.Entry createEntry(int i, Status status) {
        return MutateRowsResponse.Entry.newBuilder().setIndex((long)i).setStatus(status).build();
    }

    public MutateRowsRequestManager(RetryOptions retryOptions, MutateRowsRequest originalRequest) {
        this.currentRequest = originalRequest;
        this.originalRequest = originalRequest;
        this.retryOptions = retryOptions;
        this.results = new Status[originalRequest.getEntriesCount()];
        this.mapToOriginalIndex = new int[originalRequest.getEntriesCount()];
        for (int i = 0; i < this.mapToOriginalIndex.length; ++i) {
            this.mapToOriginalIndex[i] = i;
        }
    }

    public void onMessage(MutateRowsResponse message) {
        for (MutateRowsResponse.Entry entry : message.getEntriesList()) {
            int index = (int)entry.getIndex();
            if (index >= this.mapToOriginalIndex.length || index < 0) {
                this.messageIsInvalid = true;
                break;
            }
            this.results[this.mapToOriginalIndex[index]] = entry.getStatus();
        }
    }

    public ProcessingStatus onOK() {
        if (!this.messageIsInvalid) {
            for (int i = 0; i < this.results.length; ++i) {
                if (this.results[i] != null) continue;
                this.messageIsInvalid = true;
                break;
            }
        }
        if (this.messageIsInvalid) {
            return ProcessingStatus.INVALID;
        }
        ArrayList<Integer> toRetry = new ArrayList<Integer>();
        ProcessingStatus processingStatus = ProcessingStatus.SUCCESS;
        for (int i = 0; i < this.results.length; ++i) {
            Status status = this.results[i];
            if (status.getCode() == Status.Code.OK.value()) continue;
            if (this.retryOptions.isRetryable(MutateRowsRequestManager.getGrpcCode(status))) {
                toRetry.add(i);
                if (processingStatus != ProcessingStatus.SUCCESS) continue;
                processingStatus = ProcessingStatus.RETRYABLE;
                continue;
            }
            processingStatus = ProcessingStatus.NOT_RETRYABLE;
            break;
        }
        if (!toRetry.isEmpty()) {
            this.currentRequest = this.createRetryRequest(toRetry);
        }
        return processingStatus;
    }

    public MutateRowsRequest getRetryRequest() {
        return this.currentRequest;
    }

    private MutateRowsRequest createRetryRequest(List<Integer> indicesToRetry) {
        MutateRowsRequest.Builder updatedRequest = MutateRowsRequest.newBuilder().setTableName(this.originalRequest.getTableName());
        this.mapToOriginalIndex = new int[indicesToRetry.size()];
        for (int i = 0; i < indicesToRetry.size(); ++i) {
            this.mapToOriginalIndex[i] = indicesToRetry.get(i);
            updatedRequest.addEntries(this.originalRequest.getEntries(indicesToRetry.get(i).intValue()));
        }
        return updatedRequest.build();
    }

    public MutateRowsResponse buildResponse() {
        ArrayList<MutateRowsResponse.Entry> entries = new ArrayList<MutateRowsResponse.Entry>();
        for (int i = 0; i < this.results.length; ++i) {
            Status status = this.results[i] == null ? STATUS_INTERNAL : this.results[i];
            entries.add(MutateRowsRequestManager.createEntry(i, status));
        }
        return MutateRowsResponse.newBuilder().addAllEntries(entries).build();
    }

    public static enum ProcessingStatus {
        SUCCESS,
        RETRYABLE,
        NOT_RETRYABLE,
        INVALID;

    }
}

