/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc.async;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.Batcher;
import com.google.cloud.bigtable.core.IBulkMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.common.base.Preconditions;
import java.io.IOException;

@InternalApi(value="For internal usage only")
public class BulkMutationGCJClient
implements IBulkMutation {
    private final Batcher<RowMutationEntry, Void> bulkMutateBatcher;

    public BulkMutationGCJClient(Batcher<RowMutationEntry, Void> bulkMutateBatcher) {
        this.bulkMutateBatcher = bulkMutateBatcher;
    }

    @Override
    public synchronized ApiFuture<Void> add(RowMutationEntry rowMutation) {
        Preconditions.checkNotNull((Object)rowMutation, (Object)"mutation details cannot be null");
        return this.bulkMutateBatcher.add((Object)rowMutation);
    }

    @Override
    public void sendUnsent() {
        this.bulkMutateBatcher.sendOutstanding();
    }

    @Override
    public void flush() {
        try {
            this.bulkMutateBatcher.flush();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Could not complete RPC for current Batch", ex);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.bulkMutateBatcher.close();
        }
        catch (InterruptedException e) {
            throw new IOException("Could not close the bulk mutation Batcher", e);
        }
    }
}

