/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.InternalApi;
import com.google.bigtable.admin.v2.CreateTableFromSnapshotRequest;
import com.google.bigtable.admin.v2.DeleteSnapshotRequest;
import com.google.bigtable.admin.v2.GetSnapshotRequest;
import com.google.bigtable.admin.v2.ListSnapshotsRequest;
import com.google.bigtable.admin.v2.ListSnapshotsResponse;
import com.google.bigtable.admin.v2.Snapshot;
import com.google.bigtable.admin.v2.SnapshotTableRequest;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.models.Backup;
import com.google.cloud.bigtable.admin.v2.models.CreateBackupRequest;
import com.google.cloud.bigtable.admin.v2.models.CreateTableRequest;
import com.google.cloud.bigtable.admin.v2.models.ModifyColumnFamiliesRequest;
import com.google.cloud.bigtable.admin.v2.models.RestoreTableRequest;
import com.google.cloud.bigtable.admin.v2.models.RestoredTableResult;
import com.google.cloud.bigtable.admin.v2.models.Table;
import com.google.cloud.bigtable.admin.v2.models.UpdateBackupRequest;
import com.google.cloud.bigtable.core.IBigtableTableAdminClient;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.protobuf.ByteString;
import com.google.protobuf.Empty;
import java.util.List;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;

@InternalApi(value="For internal usage only")
public class BigtableTableAdminGCJClient
implements IBigtableTableAdminClient,
AutoCloseable {
    private final BigtableTableAdminClient delegate;
    private final BaseBigtableTableAdminClient baseAdminClient;

    public BigtableTableAdminGCJClient(@Nonnull BigtableTableAdminClient delegate, @Nonnull BaseBigtableTableAdminClient baseAdminClient) {
        this.delegate = delegate;
        this.baseAdminClient = baseAdminClient;
    }

    @Override
    public Table createTable(CreateTableRequest request) {
        return this.delegate.createTable(request);
    }

    @Override
    public ApiFuture<Table> createTableAsync(CreateTableRequest request) {
        return this.delegate.createTableAsync(request);
    }

    @Override
    public Table getTable(String tableId) {
        return this.delegate.getTable(tableId);
    }

    @Override
    public ApiFuture<Table> getTableAsync(String tableId) {
        return this.delegate.getTableAsync(tableId);
    }

    @Override
    public List<String> listTables() {
        return this.delegate.listTables();
    }

    @Override
    public ApiFuture<List<String>> listTablesAsync() {
        return this.delegate.listTablesAsync();
    }

    @Override
    public void deleteTable(String tableId) {
        this.delegate.deleteTable(tableId);
    }

    @Override
    public ApiFuture<Void> deleteTableAsync(String tableId) {
        return this.delegate.deleteTableAsync(tableId);
    }

    @Override
    public Table modifyFamilies(ModifyColumnFamiliesRequest request) {
        return this.delegate.modifyFamilies(request);
    }

    @Override
    public ApiFuture<Table> modifyFamiliesAsync(ModifyColumnFamiliesRequest request) {
        return this.delegate.modifyFamiliesAsync(request);
    }

    @Override
    public void dropRowRange(String tableId, String rowKeyPrefix) {
        this.delegate.dropRowRange(tableId, rowKeyPrefix);
    }

    @Override
    public void dropRowRange(String tableId, ByteString rowKeyPrefix) {
        this.delegate.dropRowRange(tableId, rowKeyPrefix);
    }

    @Override
    public ApiFuture<Void> dropRowRangeAsync(String tableId, String rowKeyPrefix) {
        return this.delegate.dropRowRangeAsync(tableId, rowKeyPrefix);
    }

    @Override
    public ApiFuture<Void> dropRowRangeAsync(String tableId, ByteString rowKeyPrefix) {
        return this.delegate.dropRowRangeAsync(tableId, rowKeyPrefix);
    }

    @Override
    public void dropAllRows(String tableId) {
        this.delegate.dropAllRows(tableId);
    }

    @Override
    public ApiFuture<Void> dropAllRowsAsync(String tableId) {
        return this.delegate.dropAllRowsAsync(tableId);
    }

    @Override
    public ApiFuture<Operation> snapshotTableAsync(SnapshotTableRequest request) {
        return this.baseAdminClient.snapshotTableCallable().futureCall((Object)request);
    }

    @Override
    public ApiFuture<Snapshot> getSnapshotAsync(GetSnapshotRequest request) {
        return this.baseAdminClient.getSnapshotCallable().futureCall((Object)request);
    }

    @Override
    public ApiFuture<ListSnapshotsResponse> listSnapshotsAsync(ListSnapshotsRequest request) {
        return this.baseAdminClient.listSnapshotsCallable().futureCall((Object)request);
    }

    @Override
    public ApiFuture<Void> deleteSnapshotAsync(DeleteSnapshotRequest request) {
        return ApiFutures.transform((ApiFuture)this.baseAdminClient.deleteSnapshotCallable().futureCall((Object)request), (ApiFunction)new ApiFunction<Empty, Void>(){

            public Void apply(Empty input) {
                return null;
            }
        }, (Executor)MoreExecutors.directExecutor());
    }

    @Override
    public ApiFuture<Operation> createTableFromSnapshotAsync(CreateTableFromSnapshotRequest request) {
        return this.baseAdminClient.createTableFromSnapshotCallable().futureCall((Object)request);
    }

    @Override
    public ApiFuture<Backup> createBackupAsync(CreateBackupRequest request) {
        return this.delegate.createBackupAsync(request);
    }

    @Override
    public ApiFuture<Backup> getBackupAsync(String clusterId, String backupId) {
        return this.delegate.getBackupAsync(clusterId, backupId);
    }

    @Override
    public ApiFuture<Backup> updateBackupAsync(UpdateBackupRequest request) {
        return this.delegate.updateBackupAsync(request);
    }

    @Override
    public ApiFuture<List<String>> listBackupsAsync(String clusterId) {
        return this.delegate.listBackupsAsync(clusterId);
    }

    @Override
    public ApiFuture<Void> deleteBackupAsync(String clusterId, String backupId) {
        return this.delegate.deleteBackupAsync(clusterId, backupId);
    }

    @Override
    public ApiFuture<RestoredTableResult> restoreTableAsync(RestoreTableRequest request) {
        return this.delegate.restoreTableAsync(request);
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
        this.baseAdminClient.close();
    }
}

