/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.api.client.util.Clock;
import com.google.api.client.util.Strings;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.FixedExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.bigtable.admin.v2.ListClustersResponse;
import com.google.bigtable.v2.BigtableGrpc;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BaseBigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.BigtableVeneerSettingsFactory;
import com.google.cloud.bigtable.config.BigtableVersionInfo;
import com.google.cloud.bigtable.config.BulkOptions;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.core.IBigtableDataClient;
import com.google.cloud.bigtable.core.IBigtableTableAdminClient;
import com.google.cloud.bigtable.core.IBulkMutation;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.cloud.bigtable.grpc.BigtableClusterName;
import com.google.cloud.bigtable.grpc.BigtableClusterUtilities;
import com.google.cloud.bigtable.grpc.BigtableDataClient;
import com.google.cloud.bigtable.grpc.BigtableDataClientWrapper;
import com.google.cloud.bigtable.grpc.BigtableDataGCJClient;
import com.google.cloud.bigtable.grpc.BigtableDataGrpcClient;
import com.google.cloud.bigtable.grpc.BigtableInstanceClient;
import com.google.cloud.bigtable.grpc.BigtableInstanceGrpcClient;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.cloud.bigtable.grpc.BigtableSessionSharedThreadPools;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClient;
import com.google.cloud.bigtable.grpc.BigtableTableAdminClientWrapper;
import com.google.cloud.bigtable.grpc.BigtableTableAdminGCJClient;
import com.google.cloud.bigtable.grpc.BigtableTableAdminGrpcClient;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.grpc.ConfiguredDeadlineGeneratorFactory;
import com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.cloud.bigtable.grpc.async.BulkMutationWrapper;
import com.google.cloud.bigtable.grpc.async.BulkRead;
import com.google.cloud.bigtable.grpc.async.ResourceLimiter;
import com.google.cloud.bigtable.grpc.async.ResourceLimiterStats;
import com.google.cloud.bigtable.grpc.async.ThrottlingClientInterceptor;
import com.google.cloud.bigtable.grpc.io.ChannelPool;
import com.google.cloud.bigtable.grpc.io.CredentialInterceptorCache;
import com.google.cloud.bigtable.grpc.io.GoogleCloudResourcePrefixInterceptor;
import com.google.cloud.bigtable.grpc.io.HeaderInterceptor;
import com.google.cloud.bigtable.grpc.io.Watchdog;
import com.google.cloud.bigtable.grpc.io.WatchdogInterceptor;
import com.google.cloud.bigtable.metrics.BigtableClientMetrics;
import com.google.cloud.bigtable.util.ReferenceCountedHashMap;
import com.google.cloud.bigtable.util.ThreadUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.grpc.Channel;
import io.grpc.ClientInterceptor;
import io.grpc.ClientInterceptors;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.alts.ComputeEngineChannelBuilder;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;

@InternalExtensionOnly
public class BigtableSession
implements Closeable {
    private static final Logger LOG = new Logger(BigtableSession.class);
    private static Map<String, ManagedChannel> cachedDataChannelPools = new HashMap<String, ManagedChannel>();
    private static Map<String, ClientContext> cachedClientContexts = new ReferenceCountedHashMap<String, ClientContext>(new ReferenceCountedHashMap.Callable<ClientContext>(){

        @Override
        public void call(ClientContext context) {
            for (BackgroundResource backgroundResource : context.getBackgroundResources()) {
                backgroundResource.shutdown();
            }
        }
    });
    private static final Map<String, ResourceLimiter> resourceLimiterMap = new HashMap<String, ResourceLimiter>();
    private static final int MAX_MESSAGE_SIZE = 0x10000000;
    static final long CHANNEL_KEEP_ALIVE_TIME_SECONDS = 30L;
    static final long CHANNEL_KEEP_ALIVE_TIMEOUT_SECONDS = 10L;
    @VisibleForTesting
    static final String PROJECT_ID_EMPTY_OR_NULL = "ProjectId must not be empty or null.";
    @VisibleForTesting
    static final String INSTANCE_ID_EMPTY_OR_NULL = "InstanceId must not be empty or null.";
    @VisibleForTesting
    static final String USER_AGENT_EMPTY_OR_NULL = "UserAgent must not be empty or null";
    private Watchdog watchdog;
    private final BigtableOptions options;
    private final List<ManagedChannel> managedChannels;
    @Deprecated
    private final List<ClientInterceptor> dataChannelInterceptors;
    private final BigtableDataClient dataClient;
    private final RequestContext dataRequestContext;
    private final BigtableDataClient throttlingDataClient;
    private BigtableTableAdminClient tableAdminClient;
    private BigtableInstanceGrpcClient instanceAdminClient;
    private final BigtableDataGCJClient dataGCJClient;
    private final BigtableTableAdminSettings adminSettings;
    private final BaseBigtableTableAdminSettings baseAdminSettings;
    private BigtableTableAdminGCJClient adminGCJClient;
    private IBigtableTableAdminClient adminClientWrapper;
    private BigtableClusterName clusterName;

    private static void performWarmup() {
        ExecutorService connectionStartupExecutor = Executors.newCachedThreadPool(ThreadUtil.getThreadFactory("BigtableSession-startup-%d", true));
        connectionStartupExecutor.execute(new Runnable(){

            @Override
            public void run() {
                BigtableSessionSharedThreadPools.getInstance();
            }
        });
        for (final String host : Arrays.asList("bigtable.googleapis.com", "bigtableadmin.googleapis.com")) {
            connectionStartupExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        InetAddress.getByName(host);
                    }
                    catch (UnknownHostException unknownHostException) {
                        // empty catch block
                    }
                }
            });
        }
        connectionStartupExecutor.shutdown();
    }

    private static synchronized ResourceLimiter initializeResourceLimiter(BigtableOptions options) {
        BigtableInstanceName instanceName = options.getInstanceName();
        String key = instanceName.toString();
        ResourceLimiter resourceLimiter = resourceLimiterMap.get(key);
        if (resourceLimiter == null) {
            int maxInflightRpcs = options.getBulkOptions().getMaxInflightRpcs();
            long maxMemory = options.getBulkOptions().getMaxMemory();
            ResourceLimiterStats stats = ResourceLimiterStats.getInstance(instanceName);
            resourceLimiter = new ResourceLimiter(stats, maxMemory, maxInflightRpcs);
            BulkOptions bulkOptions = options.getBulkOptions();
            if (bulkOptions.isEnableBulkMutationThrottling()) {
                resourceLimiter.throttle(bulkOptions.getBulkMutationRpcTargetMs());
            }
            resourceLimiterMap.put(key, resourceLimiter);
        }
        return resourceLimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public BigtableSession(BigtableOptions opts) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)opts.getProjectId()) ? 1 : 0) != 0, (Object)PROJECT_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)opts.getInstanceId()) ? 1 : 0) != 0, (Object)INSTANCE_ID_EMPTY_OR_NULL);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)opts.getUserAgent()) ? 1 : 0) != 0, (Object)USER_AGENT_EMPTY_OR_NULL);
        LOG.info("Opening session for projectId %s, instanceId %s, on data host %s, admin host %s.", opts.getProjectId(), opts.getInstanceId(), opts.getDataHost(), opts.getAdminHost());
        LOG.info("Bigtable options: %s.", opts);
        this.options = opts;
        this.managedChannels = new ArrayList<ManagedChannel>();
        if (this.options.useGCJClient()) {
            BigtableDataSettings dataSettings = BigtableVeneerSettingsFactory.createBigtableDataSettings(this.options);
            if (this.options.useCachedChannel()) {
                ClientContext cachedCtx = null;
                Class<BigtableSession> clazz = BigtableSession.class;
                // MONITORENTER : com.google.cloud.bigtable.grpc.BigtableSession.class
                cachedCtx = !cachedClientContexts.containsKey(this.options.getDataHost()) ? ClientContext.create((StubSettings)dataSettings.getStubSettings()) : cachedClientContexts.get(this.options.getDataHost());
                cachedClientContexts.put(this.options.getDataHost(), cachedCtx);
                // MONITOREXIT : clazz
                BigtableDataSettings.Builder builder = dataSettings.toBuilder();
                ((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)builder.stubSettings().setExecutorProvider((ExecutorProvider)FixedExecutorProvider.create((ScheduledExecutorService)cachedCtx.getExecutor()))).setTransportChannelProvider((TransportChannelProvider)FixedTransportChannelProvider.create((TransportChannel)Objects.requireNonNull(cachedCtx.getTransportChannel())))).setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)cachedCtx.getCredentials()))).build();
                dataSettings = builder.build();
            }
            this.dataGCJClient = new BigtableDataGCJClient(com.google.cloud.bigtable.data.v2.BigtableDataClient.create((BigtableDataSettings)dataSettings));
            this.adminSettings = BigtableVeneerSettingsFactory.createTableAdminSettings(this.options);
            this.baseAdminSettings = BaseBigtableTableAdminSettings.create((BigtableTableAdminStubSettings)this.adminSettings.getStubSettings());
            this.dataClient = null;
            this.throttlingDataClient = null;
            this.dataRequestContext = null;
            this.dataChannelInterceptors = null;
        } else {
            ChannelPool rawDataChannelPool;
            if (this.options.useCachedChannel()) {
                Class<BigtableSession> cachedCtx = BigtableSession.class;
                // MONITORENTER : com.google.cloud.bigtable.grpc.BigtableSession.class
                String key = String.format("%s:%d", this.options.getDataHost(), this.options.getPort());
                rawDataChannelPool = cachedDataChannelPools.get(key);
                if (rawDataChannelPool == null) {
                    rawDataChannelPool = BigtableSession.createRawDataChannelPool(this.options);
                    cachedDataChannelPools.put(key, rawDataChannelPool);
                }
                // MONITOREXIT : cachedCtx
            } else {
                rawDataChannelPool = BigtableSession.createRawDataChannelPool(this.options);
                this.managedChannels.add(rawDataChannelPool);
            }
            this.dataChannelInterceptors = this.createDataApiInterceptors(this.options);
            Channel dataChannel = ClientInterceptors.intercept((Channel)rawDataChannelPool, this.dataChannelInterceptors);
            this.dataRequestContext = RequestContext.create((String)this.options.getProjectId(), (String)this.options.getInstanceId(), (String)this.options.getAppProfileId());
            BigtableSessionSharedThreadPools sharedPools = BigtableSessionSharedThreadPools.getInstance();
            ConfiguredDeadlineGeneratorFactory callOptionsFactory = new ConfiguredDeadlineGeneratorFactory(this.options.getCallOptionsConfig());
            this.dataClient = new BigtableDataGrpcClient(dataChannel, sharedPools.getRetryExecutor(), this.options);
            this.dataClient.setDeadlineGeneratorFactory(callOptionsFactory);
            ResourceLimiter resourceLimiter = BigtableSession.initializeResourceLimiter(this.options);
            Channel asyncDataChannel = ClientInterceptors.intercept((Channel)dataChannel, (ClientInterceptor[])new ClientInterceptor[]{new ThrottlingClientInterceptor(resourceLimiter)});
            this.throttlingDataClient = new BigtableDataGrpcClient(asyncDataChannel, sharedPools.getRetryExecutor(), this.options);
            this.throttlingDataClient.setDeadlineGeneratorFactory(callOptionsFactory);
            ManagedChannel rawAdminChannel = BigtableSession.createNettyChannel(this.options.getAdminHost(), this.options, new ClientInterceptor[0]);
            this.managedChannels.add(rawAdminChannel);
            Channel adminChannel = ClientInterceptors.intercept((Channel)rawAdminChannel, BigtableSession.createAdminApiInterceptors(this.options));
            this.instanceAdminClient = new BigtableInstanceGrpcClient(adminChannel);
            this.tableAdminClient = new BigtableTableAdminGrpcClient(adminChannel, sharedPools.getRetryExecutor(), this.options);
            this.dataGCJClient = null;
            this.adminSettings = null;
            this.baseAdminSettings = null;
        }
        BigtableClientMetrics.counter(BigtableClientMetrics.MetricLevel.Info, "sessions.active").inc();
    }

    static List<ClientInterceptor> createAdminApiInterceptors(BigtableOptions options) throws IOException {
        ImmutableList.Builder interceptors = ImmutableList.builder();
        if (options.getInstanceName() != null) {
            interceptors.add((Object)new GoogleCloudResourcePrefixInterceptor(options.getInstanceName().toString()));
        }
        interceptors.add((Object)BigtableSession.createGaxHeaderInterceptor());
        ClientInterceptor authInterceptor = BigtableSession.createAuthInterceptor(options);
        if (authInterceptor != null) {
            interceptors.add((Object)authInterceptor);
        }
        return interceptors.build();
    }

    private List<ClientInterceptor> createDataApiInterceptors(BigtableOptions options) throws IOException {
        ClientInterceptor authInterceptor;
        ImmutableList.Builder interceptors = ImmutableList.builder();
        if (options.getInstanceName() != null) {
            interceptors.add((Object)new GoogleCloudResourcePrefixInterceptor(options.getInstanceName().toString()));
        }
        interceptors.add((Object)BigtableSession.createGaxHeaderInterceptor());
        interceptors.add((Object)this.setupWatchdog());
        if (!BigtableOptions.isDirectPathEnabled() && (authInterceptor = BigtableSession.createAuthInterceptor(options)) != null) {
            interceptors.add((Object)authInterceptor);
        }
        return interceptors.build();
    }

    private static ClientInterceptor createGaxHeaderInterceptor() {
        return new HeaderInterceptor((Metadata.Key<String>)Metadata.Key.of((String)ApiClientHeaderProvider.getDefaultApiClientHeaderKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER), String.format("gl-java/%s %s/%s cbt/%s", BigtableVersionInfo.JDK_VERSION, GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion(), BigtableVersionInfo.CLIENT_VERSION));
    }

    private WatchdogInterceptor setupWatchdog() {
        Preconditions.checkState((this.watchdog == null ? 1 : 0) != 0, (Object)"Watchdog already setup");
        this.watchdog = new Watchdog(Clock.SYSTEM, this.options.getRetryOptions().getReadPartialRowTimeoutMillis());
        this.watchdog.start(BigtableSessionSharedThreadPools.getInstance().getRetryExecutor());
        return new WatchdogInterceptor((Set<MethodDescriptor<?, ?>>)ImmutableSet.of((Object)BigtableGrpc.getReadRowsMethod()), this.watchdog);
    }

    @Nullable
    private static ClientInterceptor createAuthInterceptor(BigtableOptions options) throws IOException {
        CredentialInterceptorCache credentialsCache = CredentialInterceptorCache.getInstance();
        RetryOptions retryOptions = options.getRetryOptions();
        CredentialOptions credentialOptions = options.getCredentialOptions();
        try {
            return credentialsCache.getCredentialsInterceptor(credentialOptions, retryOptions);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Could not initialize credentials.", e);
        }
    }

    @Deprecated
    protected ManagedChannel createManagedPool(String host, int channelCount) throws IOException {
        ManagedChannel channelPool = this.createChannelPool(host, channelCount);
        this.managedChannels.add(channelPool);
        return channelPool;
    }

    @Deprecated
    protected ManagedChannel createChannelPool(final String hostString, int count) throws IOException {
        Preconditions.checkState((!this.options.useGCJClient() ? 1 : 0) != 0, (Object)"Channel pools cannot be created when using google-cloud-java");
        final ClientInterceptor[] clientInterceptorArray = this.dataChannelInterceptors.toArray(new ClientInterceptor[0]);
        ChannelPool.ChannelFactory channelFactory = new ChannelPool.ChannelFactory(){

            @Override
            public ManagedChannel create() throws IOException {
                return BigtableSession.createNettyChannel(hostString, BigtableSession.this.options, clientInterceptorArray);
            }
        };
        return this.createChannelPool(channelFactory, count);
    }

    @Deprecated
    @InternalApi(value="For internal usage only")
    protected ManagedChannel createChannelPool(ChannelPool.ChannelFactory channelFactory, int count) throws IOException {
        return new ChannelPool(channelFactory, count);
    }

    @Deprecated
    @InternalApi(value="For internal usage only")
    public static ManagedChannel createChannelPool(String host, BigtableOptions options) throws IOException, GeneralSecurityException {
        return BigtableSession.createChannelPool(host, options, 1);
    }

    @Deprecated
    @InternalApi(value="For internal usage only")
    public static ManagedChannel createChannelPool(final String host, final BigtableOptions options, int count) throws IOException, GeneralSecurityException {
        ArrayList<ClientInterceptor> interceptorList = new ArrayList<ClientInterceptor>();
        ClientInterceptor credentialsInterceptor = CredentialInterceptorCache.getInstance().getCredentialsInterceptor(options.getCredentialOptions(), options.getRetryOptions());
        if (credentialsInterceptor != null) {
            interceptorList.add(credentialsInterceptor);
        }
        if (options.getInstanceName() != null) {
            interceptorList.add(new GoogleCloudResourcePrefixInterceptor(options.getInstanceName().toString()));
        }
        final ClientInterceptor[] interceptors = interceptorList.toArray(new ClientInterceptor[interceptorList.size()]);
        ChannelPool.ChannelFactory factory = new ChannelPool.ChannelFactory(){

            @Override
            public ManagedChannel create() throws IOException {
                return BigtableSession.createNettyChannel(host, options, interceptors);
            }
        };
        return new ChannelPool(factory, count);
    }

    private static ChannelPool createRawDataChannelPool(final BigtableOptions options) throws IOException {
        ChannelPool.ChannelFactory channelFactory = new ChannelPool.ChannelFactory(){

            @Override
            public ManagedChannel create() throws IOException {
                return BigtableSession.createNettyChannel(options.getDataHost(), options, new ClientInterceptor[0]);
            }
        };
        return new ChannelPool(channelFactory, options.getChannelCount());
    }

    @InternalApi(value="For internal usage only")
    public static ManagedChannel createNettyChannel(String host, BigtableOptions options, ClientInterceptor ... interceptors) throws SSLException {
        ManagedChannelBuilder builder;
        boolean isDirectPath = BigtableOptions.isDirectPathEnabled() && !host.contains("admin");
        LOG.info("Creating new channel for %s", host);
        if (LOG.getLog().isTraceEnabled()) {
            LOG.trace(Throwables.getStackTraceAsString((Throwable)new Throwable()), new Object[0]);
        }
        if (isDirectPath) {
            LOG.warn("Connecting to Bigtable using DirectPath. This is currently an experimental feature and should not be used in production.", new Object[0]);
            builder = ComputeEngineChannelBuilder.forAddress((String)host, (int)options.getPort());
            ImmutableMap pickFirstStrategy = ImmutableMap.of((Object)"pick_first", (Object)ImmutableMap.of());
            ImmutableMap childPolicy = ImmutableMap.of((Object)"childPolicy", (Object)ImmutableList.of((Object)pickFirstStrategy));
            ImmutableMap grpcLbPolicy = ImmutableMap.of((Object)"grpclb", (Object)childPolicy);
            ImmutableMap loadBalancingConfig = ImmutableMap.of((Object)"loadBalancingConfig", (Object)ImmutableList.of((Object)grpcLbPolicy));
            builder.defaultServiceConfig((Map)loadBalancingConfig);
        } else {
            builder = ManagedChannelBuilder.forAddress((String)host, (int)options.getPort());
            if (options.usePlaintextNegotiation()) {
                builder.usePlaintext();
            }
        }
        if (options.getChannelConfigurator() != null) {
            builder = options.getChannelConfigurator().configureChannel(builder, host);
        }
        return builder.idleTimeout(Long.MAX_VALUE, TimeUnit.SECONDS).maxInboundMessageSize(0x10000000).keepAliveTime(30L, TimeUnit.SECONDS).keepAliveTimeout(10L, TimeUnit.SECONDS).userAgent(BigtableVersionInfo.CORE_USER_AGENT + "," + options.getUserAgent()).intercept(interceptors).build();
    }

    public synchronized BigtableClusterName getClusterName() throws IOException {
        if (this.clusterName == null) {
            try (BigtableClusterUtilities util = new BigtableClusterUtilities(this.options);){
                ListClustersResponse clusters = util.getClusters();
                Preconditions.checkState((clusters.getClustersCount() == 1 ? 1 : 0) != 0, (Object)String.format("Project '%s' / Instance '%s' has %d clusters. There must be exactly 1 for this operation to work.", this.options.getProjectId(), this.options.getInstanceId(), clusters.getClustersCount()));
                this.clusterName = new BigtableClusterName(clusters.getClusters(0).getName());
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Could not get cluster Id.", e);
            }
        }
        return this.clusterName;
    }

    public BigtableDataClient getDataClient() {
        return this.dataClient;
    }

    @InternalApi(value="For internal usage only")
    public IBigtableDataClient getDataClientWrapper() {
        if (this.options.useGCJClient()) {
            return this.dataGCJClient;
        }
        return new BigtableDataClientWrapper(this.dataClient, this.dataRequestContext);
    }

    public BulkMutation createBulkMutation(BigtableTableName tableName) {
        if (this.options.useGCJClient()) {
            LOG.warn("Using cloud-bigtable-client's implementation of BulkMutation.", new Object[0]);
        }
        return new BulkMutation(tableName, this.throttlingDataClient, BigtableSessionSharedThreadPools.getInstance().getRetryExecutor(), this.options.getBulkOptions());
    }

    @InternalApi(value="For internal usage only")
    public IBulkMutation createBulkMutationWrapper(BigtableTableName tableName) {
        if (this.options.useGCJClient()) {
            return this.getDataClientWrapper().createBulkMutationBatcher(tableName.getTableId());
        }
        return new BulkMutationWrapper(this.createBulkMutation(tableName));
    }

    public BulkRead createBulkRead(BigtableTableName tableName) {
        return new BulkRead(this.getDataClientWrapper(), tableName, this.options.getBulkOptions().getBulkMaxRowKeyCount(), BigtableSessionSharedThreadPools.getInstance().getBatchThreadPool());
    }

    public BigtableTableAdminClient getTableAdminClient() throws IOException {
        return this.tableAdminClient;
    }

    @InternalApi(value="For internal usage only")
    public synchronized IBigtableTableAdminClient getTableAdminClientWrapper() throws IOException {
        if (this.options.useGCJClient()) {
            if (this.adminGCJClient == null) {
                com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient adminClientV2 = com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient.create((BigtableTableAdminSettings)this.adminSettings);
                BaseBigtableTableAdminClient baseAdminClientV2 = BaseBigtableTableAdminClient.create((BaseBigtableTableAdminSettings)this.baseAdminSettings);
                this.adminGCJClient = new BigtableTableAdminGCJClient(adminClientV2, baseAdminClientV2);
            }
            return this.adminGCJClient;
        }
        if (this.adminClientWrapper == null) {
            this.adminClientWrapper = new BigtableTableAdminClientWrapper(this.getTableAdminClient(), this.options);
        }
        return this.adminClientWrapper;
    }

    public BigtableInstanceClient getInstanceAdminClient() throws IOException {
        return this.instanceAdminClient;
    }

    @Deprecated
    @InternalApi(value="For internal usage only")
    public static BigtableInstanceClient createInstanceClient(BigtableOptions options) throws IOException, GeneralSecurityException {
        ManagedChannel rawAdminChannel = BigtableSession.createNettyChannel(options.getAdminHost(), options, new ClientInterceptor[0]);
        Channel adminChannel = ClientInterceptors.intercept((Channel)rawAdminChannel, BigtableSession.createAdminApiInterceptors(options));
        return new BigtableInstanceGrpcClient(adminChannel);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.watchdog != null) {
            this.watchdog.stop();
        }
        long timeoutNanos = TimeUnit.SECONDS.toNanos(10L);
        long endTimeNanos = System.nanoTime() + timeoutNanos;
        for (ManagedChannel channel : this.managedChannels) {
            channel.shutdown();
        }
        for (ManagedChannel channel : this.managedChannels) {
            long awaitTimeNanos = endTimeNanos - System.nanoTime();
            if (awaitTimeNanos <= 0L) break;
            try {
                channel.awaitTermination(awaitTimeNanos, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Interrupted while closing the channelPools");
            }
        }
        for (ManagedChannel channel : this.managedChannels) {
            if (channel.isTerminated()) continue;
            LOG.info("Could not close %s after 10 seconds.", channel.getClass().getName());
            break;
        }
        this.managedChannels.clear();
        try {
            if (this.dataGCJClient != null) {
                this.dataGCJClient.close();
            }
        }
        catch (Exception ex) {
            throw new IOException("Could not close the data client", ex);
        }
        try {
            if (this.adminGCJClient != null) {
                this.adminGCJClient.close();
            }
        }
        catch (Exception ex) {
            throw new IOException("Could not close the admin client", ex);
        }
        if (this.options.useCachedChannel() && this.options.useGCJClient()) {
            cachedClientContexts.remove(this.options.getDataHost());
        }
        BigtableClientMetrics.counter(BigtableClientMetrics.MetricLevel.Info, "sessions.active").dec();
    }

    public BigtableOptions getOptions() {
        return this.options;
    }

    @InternalApi(value="VisibleForTesting")
    public Map<String, ClientContext> getCachedClientContexts() {
        Preconditions.checkState((boolean)this.options.useGCJClient(), (Object)"Client Context is only available for GCJ Client.");
        return cachedClientContexts;
    }

    static {
        if (!System.getProperty("BIGTABLE_SESSION_SKIP_WARMUP", "").equalsIgnoreCase("true")) {
            BigtableSession.performWarmup();
        }
    }
}

