/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.grpc;

import com.google.api.core.ApiFuture;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.Batcher;
import com.google.api.gax.rpc.ServerStream;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StreamController;
import com.google.cloud.bigtable.core.IBigtableDataClient;
import com.google.cloud.bigtable.core.IBulkMutation;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.cloud.bigtable.data.v2.models.Query;
import com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.cloud.bigtable.data.v2.models.Row;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.cloud.bigtable.grpc.async.BulkMutationGCJClient;
import com.google.cloud.bigtable.grpc.scanner.FlatRow;
import com.google.cloud.bigtable.grpc.scanner.FlatRowAdapter;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.cloud.bigtable.grpc.scanner.RowResultScanner;
import io.grpc.stub.StreamObserver;
import java.util.List;

@InternalApi(value="For internal usage only")
public class BigtableDataGCJClient
implements IBigtableDataClient,
AutoCloseable {
    private final BigtableDataClient delegate;

    public BigtableDataGCJClient(BigtableDataClient delegate) {
        this.delegate = delegate;
    }

    @Override
    public void mutateRow(RowMutation rowMutation) {
        this.delegate.mutateRow(rowMutation);
    }

    @Override
    public ApiFuture<Void> mutateRowAsync(RowMutation rowMutation) {
        return this.delegate.mutateRowAsync(rowMutation);
    }

    @Override
    public Row readModifyWriteRow(ReadModifyWriteRow readModifyWriteRow) {
        return this.delegate.readModifyWriteRow(readModifyWriteRow);
    }

    @Override
    public ApiFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRow readModifyWriteRow) {
        return this.delegate.readModifyWriteRowAsync(readModifyWriteRow);
    }

    @Override
    public IBulkMutation createBulkMutationBatcher(String tableId) {
        return new BulkMutationGCJClient((Batcher<RowMutationEntry, Void>)this.delegate.newBulkMutationBatcher(tableId));
    }

    @Override
    public Boolean checkAndMutateRow(ConditionalRowMutation conditionalRowMutation) {
        return this.delegate.checkAndMutateRow(conditionalRowMutation);
    }

    @Override
    public ApiFuture<Boolean> checkAndMutateRowAsync(ConditionalRowMutation conditionalRowMutation) {
        return this.delegate.checkAndMutateRowAsync(conditionalRowMutation);
    }

    @Override
    public List<KeyOffset> sampleRowKeys(String tableId) {
        return this.delegate.sampleRowKeys(tableId);
    }

    @Override
    public ApiFuture<List<KeyOffset>> sampleRowKeysAsync(String tableId) {
        return this.delegate.sampleRowKeysAsync(tableId);
    }

    @Override
    public ResultScanner<Row> readRows(Query request) {
        ServerStream response = this.delegate.readRows(request);
        return new RowResultScanner<Row>(response, new Row[0]);
    }

    @Override
    public ApiFuture<List<Row>> readRowsAsync(Query request) {
        return this.delegate.readRowsCallable().all().futureCall((Object)request);
    }

    @Override
    public List<FlatRow> readFlatRowsList(Query request) {
        return (List)this.delegate.readRowsCallable((RowAdapter)new FlatRowAdapter()).all().call((Object)request);
    }

    @Override
    public ResultScanner<FlatRow> readFlatRows(Query request) {
        ServerStream stream = this.delegate.readRowsCallable((RowAdapter)new FlatRowAdapter()).call((Object)request);
        return new RowResultScanner<FlatRow>(stream, new FlatRow[0]);
    }

    @Override
    public ApiFuture<List<FlatRow>> readFlatRowsAsync(Query request) {
        return this.delegate.readRowsCallable((RowAdapter)new FlatRowAdapter()).all().futureCall((Object)request);
    }

    @Override
    public void readFlatRowsAsync(Query request, StreamObserver<FlatRow> observer) {
        this.delegate.readRowsCallable((RowAdapter)new FlatRowAdapter()).call((Object)request, new StreamObserverAdapter<FlatRow>(observer));
    }

    @Override
    public void close() throws Exception {
        this.delegate.close();
    }

    private static class StreamObserverAdapter<T>
    extends StateCheckingResponseObserver<T> {
        private final StreamObserver<T> delegate;

        StreamObserverAdapter(StreamObserver<T> delegate) {
            this.delegate = delegate;
        }

        protected void onStartImpl(StreamController controller) {
        }

        protected void onResponseImpl(T response) {
            this.delegate.onNext(response);
        }

        protected void onErrorImpl(Throwable t) {
            this.delegate.onError(t);
        }

        protected void onCompleteImpl() {
            this.delegate.onCompleted();
        }
    }
}

