/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.config.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

@InternalApi(value="For internal usage only")
public class BigtableVersionInfo {
    private static final Logger LOG = new Logger(BigtableVersionInfo.class);
    public static final String CLIENT_VERSION = BigtableVersionInfo.getVersion();
    public static final String JDK_VERSION = BigtableVersionInfo.getJavaVersion();
    public static final String CORE_USER_AGENT = "bigtable-" + CLIENT_VERSION + ",jdk-" + JDK_VERSION;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getVersion() {
        String defaultVersion = "dev-" + System.currentTimeMillis();
        String fileName = "bigtable-version.properties";
        String versionProperty = "bigtable.version";
        try (InputStream stream = BigtableVersionInfo.class.getResourceAsStream("bigtable-version.properties");){
            if (stream == null) {
                LOG.error("Could not load properties file bigtable-version.properties", new Object[0]);
                String string = defaultVersion;
                return string;
            }
            Properties properties = new Properties();
            properties.load(stream);
            String value = properties.getProperty("bigtable.version");
            if (value == null) {
                LOG.error("%s not found in %s.", "bigtable.version", "bigtable-version.properties");
                return defaultVersion;
            }
            if (value.startsWith("$")) {
                LOG.info("%s property is not replaced.", "bigtable.version");
                return defaultVersion;
            }
            String string = value;
            return string;
        }
        catch (IOException e) {
            LOG.error("Error while trying to get user agent name from %s", e, "bigtable-version.properties");
        }
        return defaultVersion;
    }

    private static String getJavaVersion() {
        return System.getProperty("java.specification.version");
    }
}

