/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.api.client.util.Preconditions;
import com.google.api.core.ApiFunction;
import com.google.api.core.InternalApi;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.FixedHeaderProvider;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.admin.v2.stub.BigtableTableAdminStubSettings;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.config.BigtableVersionInfo;
import com.google.cloud.bigtable.config.BulkOptions;
import com.google.cloud.bigtable.config.CallOptionsConfig;
import com.google.cloud.bigtable.config.CredentialFactory;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStubSettings;
import com.google.common.collect.ImmutableSet;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Set;
import javax.annotation.Nonnull;
import org.threeten.bp.Duration;

@InternalApi(value="For internal usage only")
public class BigtableVeneerSettingsFactory {
    private static final Logger LOG = new Logger(BigtableVeneerSettingsFactory.class);
    private static final String VENEER_ADAPTER = BigtableVersionInfo.CORE_USER_AGENT + ",veneer-adapter,";
    private static final int RPC_DEADLINE_MS = 360000;
    private static final int MAX_RETRY_TIMEOUT_MS = 60000;

    public static BigtableDataSettings createBigtableDataSettings(@Nonnull BigtableOptions options) throws IOException {
        Preconditions.checkState((boolean)options.getRetryOptions().enableRetries(), (Object)"Disabling retries is not currently supported.");
        BigtableDataSettings.Builder builder = BigtableDataSettings.newBuilder();
        EnhancedBigtableStubSettings.Builder dataSettingStub = builder.stubSettings();
        Duration shortRpcTimeoutMs = Duration.ofMillis((long)options.getCallOptionsConfig().getShortRpcTimeoutMs());
        builder.setProjectId(options.getProjectId()).setInstanceId(options.getInstanceId()).setAppProfileId(options.getAppProfileId());
        ((EnhancedBigtableStubSettings.Builder)((EnhancedBigtableStubSettings.Builder)dataSettingStub.setEndpoint(options.getDataHost() + ":" + options.getPort())).setHeaderProvider(BigtableVeneerSettingsFactory.buildHeaderProvider(options.getUserAgent()))).setCredentialsProvider(BigtableVeneerSettingsFactory.buildCredentialProvider(options.getCredentialOptions()));
        if (options.usePlaintextNegotiation()) {
            dataSettingStub.setTransportChannelProvider(BigtableVeneerSettingsFactory.buildChannelProvider(dataSettingStub.getEndpoint(), options));
        }
        dataSettingStub.checkAndMutateRowSettings().setSimpleTimeoutNoRetries(shortRpcTimeoutMs);
        dataSettingStub.readModifyWriteRowSettings().setSimpleTimeoutNoRetries(shortRpcTimeoutMs);
        BigtableVeneerSettingsFactory.buildBulkMutationsSettings(dataSettingStub, options);
        BigtableVeneerSettingsFactory.buildReadRowsSettings(dataSettingStub, options);
        BigtableVeneerSettingsFactory.buildReadRowSettings(dataSettingStub, options);
        BigtableVeneerSettingsFactory.buildBulkReadRowsSettings(dataSettingStub, options);
        BigtableVeneerSettingsFactory.buildMutateRowSettings(dataSettingStub, options);
        BigtableVeneerSettingsFactory.buildSampleRowKeysSettings(dataSettingStub, options);
        return builder.build();
    }

    public static BigtableTableAdminSettings createTableAdminSettings(@Nonnull BigtableOptions options) throws IOException {
        BigtableTableAdminSettings.Builder adminBuilder = BigtableTableAdminSettings.newBuilder();
        BigtableTableAdminStubSettings.Builder adminStub = adminBuilder.stubSettings();
        adminBuilder.setProjectId(options.getProjectId()).setInstanceId(options.getInstanceId());
        ((BigtableTableAdminStubSettings.Builder)((BigtableTableAdminStubSettings.Builder)adminStub.setHeaderProvider(BigtableVeneerSettingsFactory.buildHeaderProvider(options.getUserAgent()))).setEndpoint(options.getAdminHost() + ":" + options.getPort())).setCredentialsProvider(BigtableVeneerSettingsFactory.buildCredentialProvider(options.getCredentialOptions()));
        if (options.usePlaintextNegotiation()) {
            adminStub.setTransportChannelProvider(BigtableVeneerSettingsFactory.buildChannelProvider(adminStub.getEndpoint(), options));
        }
        return adminBuilder.build();
    }

    private static CredentialsProvider buildCredentialProvider(CredentialOptions credentialOptions) throws IOException {
        try {
            Credentials credentials = CredentialFactory.getCredentials(credentialOptions);
            if (credentials == null) {
                LOG.info("Enabling the use of null credentials. This should not be used in production.", new Object[0]);
                return NoCredentialsProvider.create();
            }
            return FixedCredentialsProvider.create((Credentials)credentials);
        }
        catch (GeneralSecurityException exception) {
            throw new IOException("Could not initialize credentials.", exception);
        }
    }

    private static HeaderProvider buildHeaderProvider(String userAgent) {
        return FixedHeaderProvider.create((String[])new String[]{GrpcUtil.USER_AGENT_KEY.name(), VENEER_ADAPTER + userAgent});
    }

    private static void buildBulkMutationsSettings(EnhancedBigtableStubSettings.Builder builder, BigtableOptions options) {
        BulkOptions bulkOptions = options.getBulkOptions();
        BatchingSettings.Builder batchBuilder = builder.bulkMutateRowsSettings().getBatchingSettings().toBuilder();
        long autoFlushMs = bulkOptions.getAutoflushMs();
        long bulkMaxRowKeyCount = bulkOptions.getBulkMaxRowKeyCount();
        long maxInflightRpcs = bulkOptions.getMaxInflightRpcs();
        if (autoFlushMs > 0L) {
            batchBuilder.setDelayThreshold(Duration.ofMillis((long)autoFlushMs));
        }
        FlowControlSettings.Builder flowControlBuilder = FlowControlSettings.newBuilder();
        if (maxInflightRpcs > 0L) {
            flowControlBuilder.setMaxOutstandingRequestBytes(Long.valueOf(bulkOptions.getMaxMemory())).setMaxOutstandingElementCount(Long.valueOf(maxInflightRpcs * bulkMaxRowKeyCount));
        }
        batchBuilder.setIsEnabled(Boolean.valueOf(bulkOptions.useBulkApi())).setElementCountThreshold(Long.valueOf(bulkOptions.getBulkMaxRowKeyCount())).setRequestByteThreshold(Long.valueOf(bulkOptions.getBulkMaxRequestSize())).setFlowControlSettings(flowControlBuilder.build());
        RetrySettings retrySettings = BigtableVeneerSettingsFactory.buildIdempotentRetrySettings(builder.bulkMutateRowsSettings().getRetrySettings(), options);
        builder.bulkMutateRowsSettings().setBatchingSettings(batchBuilder.build()).setRetrySettings(retrySettings).setRetryableCodes(BigtableVeneerSettingsFactory.buildRetryCodes(options.getRetryOptions()));
    }

    private static void buildSampleRowKeysSettings(EnhancedBigtableStubSettings.Builder builder, BigtableOptions options) {
        RetrySettings retrySettings = BigtableVeneerSettingsFactory.buildIdempotentRetrySettings(builder.sampleRowKeysSettings().getRetrySettings(), options);
        builder.sampleRowKeysSettings().setRetrySettings(retrySettings).setRetryableCodes(BigtableVeneerSettingsFactory.buildRetryCodes(options.getRetryOptions()));
    }

    private static void buildMutateRowSettings(EnhancedBigtableStubSettings.Builder builder, BigtableOptions options) {
        RetrySettings retrySettings = BigtableVeneerSettingsFactory.buildIdempotentRetrySettings(builder.mutateRowSettings().getRetrySettings(), options);
        builder.mutateRowSettings().setRetrySettings(retrySettings).setRetryableCodes(BigtableVeneerSettingsFactory.buildRetryCodes(options.getRetryOptions()));
    }

    private static void buildReadRowSettings(EnhancedBigtableStubSettings.Builder builder, BigtableOptions options) {
        RetrySettings retrySettings = BigtableVeneerSettingsFactory.buildIdempotentRetrySettings(builder.readRowSettings().getRetrySettings(), options);
        builder.readRowSettings().setRetrySettings(retrySettings).setRetryableCodes(BigtableVeneerSettingsFactory.buildRetryCodes(options.getRetryOptions()));
    }

    private static void buildReadRowsSettings(EnhancedBigtableStubSettings.Builder builder, BigtableOptions options) {
        RetryOptions retryOptions = options.getRetryOptions();
        CallOptionsConfig callOptions = options.getCallOptionsConfig();
        RetrySettings.Builder retryBuilder = builder.readRowsSettings().getRetrySettings().toBuilder();
        Duration rpcTimeout = Duration.ofMillis((long)retryOptions.getReadPartialRowTimeoutMillis());
        Duration totalTimeout = Duration.ofMillis((long)(callOptions.isUseTimeout() ? (long)callOptions.getReadStreamRpcTimeoutMs() : (long)retryOptions.getMaxElapsedBackoffMillis()));
        retryBuilder.setInitialRetryDelay(Duration.ofMillis((long)retryOptions.getInitialBackoffMillis())).setRetryDelayMultiplier(retryOptions.getBackoffMultiplier()).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setMaxAttempts(retryOptions.getMaxScanTimeoutRetries()).setInitialRpcTimeout(rpcTimeout).setMaxRpcTimeout(rpcTimeout).setTotalTimeout(totalTimeout);
        builder.readRowsSettings().setRetrySettings(retryBuilder.build()).setRetryableCodes(BigtableVeneerSettingsFactory.buildRetryCodes(options.getRetryOptions()));
    }

    private static void buildBulkReadRowsSettings(EnhancedBigtableStubSettings.Builder builder, BigtableOptions options) {
        RetrySettings retrySettings = BigtableVeneerSettingsFactory.buildIdempotentRetrySettings(builder.bulkReadRowsSettings().getRetrySettings(), options);
        long bulkMaxRowKeyCount = options.getBulkOptions().getBulkMaxRowKeyCount();
        BatchingSettings.Builder batchBuilder = builder.bulkReadRowsSettings().getBatchingSettings().toBuilder();
        batchBuilder.setElementCountThreshold(Long.valueOf(bulkMaxRowKeyCount));
        builder.bulkReadRowsSettings().setRetrySettings(retrySettings).setRetryableCodes(BigtableVeneerSettingsFactory.buildRetryCodes(options.getRetryOptions())).setBatchingSettings(batchBuilder.build());
    }

    private static RetrySettings buildIdempotentRetrySettings(RetrySettings retrySettings, BigtableOptions options) {
        RetryOptions retryOptions = options.getRetryOptions();
        CallOptionsConfig callOptions = options.getCallOptionsConfig();
        RetrySettings.Builder retryBuilder = retrySettings.toBuilder();
        if (retryOptions.allowRetriesWithoutTimestamp()) {
            throw new UnsupportedOperationException("Retries without Timestamp does not support yet.");
        }
        Duration rpcTimeout = Duration.ofMillis((long)(callOptions.isUseTimeout() ? (long)callOptions.getShortRpcTimeoutMs() : 360000L));
        retryBuilder.setInitialRetryDelay(Duration.ofMillis((long)retryOptions.getInitialBackoffMillis())).setRetryDelayMultiplier(retryOptions.getBackoffMultiplier()).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(rpcTimeout).setMaxRpcTimeout(rpcTimeout).setMaxAttempts(0).setTotalTimeout(Duration.ofMillis((long)retryOptions.getMaxElapsedBackoffMillis()));
        return retryBuilder.build();
    }

    private static Set<StatusCode.Code> buildRetryCodes(RetryOptions retryOptions) {
        ImmutableSet.Builder statusCodeBuilder = ImmutableSet.builder();
        for (Status.Code retryCode : retryOptions.getRetryableStatusCodes()) {
            statusCodeBuilder.add((Object)GrpcStatusCode.of((Status.Code)retryCode).getCode());
        }
        return statusCodeBuilder.build();
    }

    private static TransportChannelProvider buildChannelProvider(String endpoint, BigtableOptions options) {
        return EnhancedBigtableStubSettings.defaultGrpcTransportProviderBuilder().setEndpoint(endpoint).setPoolSize(options.getChannelCount()).setChannelConfigurator((ApiFunction)new ApiFunction<ManagedChannelBuilder, ManagedChannelBuilder>(){

            public ManagedChannelBuilder apply(ManagedChannelBuilder channelBuilder) {
                return channelBuilder.usePlaintext();
            }
        }).build();
    }
}

