/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.config;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.core.InternalExtensionOnly;
import com.google.cloud.bigtable.config.BulkOptions;
import com.google.cloud.bigtable.config.CallOptionsConfig;
import com.google.cloud.bigtable.config.CredentialOptions;
import com.google.cloud.bigtable.config.Logger;
import com.google.cloud.bigtable.config.RetryOptions;
import com.google.cloud.bigtable.grpc.BigtableInstanceName;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.grpc.ManagedChannelBuilder;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

@InternalExtensionOnly
public class BigtableOptions
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    @InternalApi(value="For internal usage only")
    public static final String BIGTABLE_EMULATOR_HOST_ENV_VAR = "BIGTABLE_EMULATOR_HOST";
    @InternalApi(value="For internal usage only")
    public static final String BIGTABLE_ADMIN_HOST_DEFAULT = "bigtableadmin.googleapis.com";
    @InternalApi(value="For internal usage only")
    public static final String BIGTABLE_DATA_HOST_DEFAULT = "bigtable.googleapis.com";
    private static final String DIRECT_PATH_ENV_VAR = "GOOGLE_CLOUD_ENABLE_DIRECT_PATH";
    private static final String BIGTABLE_DIRECTPATH_DATA_HOST_DEFAULT = "directpath-bigtable.googleapis.com";
    @InternalApi(value="For internal usage only")
    public static final String BIGTABLE_BATCH_DATA_HOST_DEFAULT = "batch-bigtable.googleapis.com";
    @InternalApi(value="For internal usage only")
    public static final int BIGTABLE_PORT_DEFAULT = 443;
    @InternalApi(value="For internal usage only")
    public static final int BIGTABLE_DATA_CHANNEL_COUNT_DEFAULT = BigtableOptions.getDefaultDataChannelCount();
    @InternalApi(value="For internal usage only")
    public static final String BIGTABLE_APP_PROFILE_DEFAULT = "";
    @Deprecated
    public static final String BIGTABLE_CLIENT_ADAPTER = "BIGTABLE_CLIENT_ADAPTER";
    private static final Logger LOG = new Logger(BigtableOptions.class);
    private String adminHost;
    private String dataHost;
    private int port;
    private String projectId;
    private String instanceId;
    private String appProfileId = "";
    private String userAgent;
    private int dataChannelCount;
    private boolean usePlaintextNegotiation;
    private boolean useCachedDataPool;
    private boolean useGCJClient;
    private ChannelConfigurator channelConfigurator;
    private BigtableInstanceName instanceName;
    private BulkOptions bulkOptions;
    private CallOptionsConfig callOptionsConfig;
    private CredentialOptions credentialOptions;
    private RetryOptions retryOptions;
    private boolean useBatch;

    private static int getDefaultDataChannelCount() {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        return Math.min(250, Math.max(1, availableProcessors * 4));
    }

    public static BigtableOptions getDefaultOptions() {
        return BigtableOptions.builder().build();
    }

    @InternalApi(value="For internal use only")
    public static boolean isDirectPathEnabled() {
        String whiteList = ((String)MoreObjects.firstNonNull((Object)System.getenv(DIRECT_PATH_ENV_VAR), (Object)BIGTABLE_APP_PROFILE_DEFAULT)).trim();
        if (whiteList.isEmpty()) {
            return false;
        }
        for (String entry : whiteList.split(",")) {
            if (!BIGTABLE_DATA_HOST_DEFAULT.contains(entry)) continue;
            return true;
        }
        return false;
    }

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    BigtableOptions() {
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getDataHost() {
        return this.dataHost;
    }

    public String getAdminHost() {
        return this.adminHost;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public String getAppProfileId() {
        return this.appProfileId;
    }

    public int getPort() {
        return this.port;
    }

    public CredentialOptions getCredentialOptions() {
        return this.credentialOptions;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public RetryOptions getRetryOptions() {
        return this.retryOptions;
    }

    public int getChannelCount() {
        return this.dataChannelCount;
    }

    @InternalApi(value="Visible for testing only")
    @Nullable
    public ChannelConfigurator getChannelConfigurator() {
        return this.channelConfigurator;
    }

    public BigtableInstanceName getInstanceName() {
        return this.instanceName;
    }

    public BulkOptions getBulkOptions() {
        return this.bulkOptions;
    }

    public boolean usePlaintextNegotiation() {
        return this.usePlaintextNegotiation;
    }

    public CallOptionsConfig getCallOptionsConfig() {
        return this.callOptionsConfig;
    }

    @BetaApi(value="Will be removed after hbase transitions away from bigtable-client-core")
    public boolean useGCJClient() {
        return this.useGCJClient;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != BigtableOptions.class) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        BigtableOptions other = (BigtableOptions)obj;
        return this.port == other.port && this.dataChannelCount == other.dataChannelCount && this.usePlaintextNegotiation == other.usePlaintextNegotiation && this.useCachedDataPool == other.useCachedDataPool && Objects.equals(this.adminHost, other.adminHost) && Objects.equals(this.dataHost, other.dataHost) && Objects.equals(this.projectId, other.projectId) && Objects.equals(this.instanceId, other.instanceId) && Objects.equals(this.appProfileId, other.appProfileId) && Objects.equals(this.userAgent, other.userAgent) && Objects.equals(this.credentialOptions, other.credentialOptions) && Objects.equals(this.retryOptions, other.retryOptions) && Objects.equals(this.bulkOptions, other.bulkOptions) && Objects.equals(this.callOptionsConfig, other.callOptionsConfig) && Objects.equals(this.useBatch, other.useBatch) && Objects.equals(this.useGCJClient, other.useGCJClient) && Objects.equals(this.channelConfigurator, other.channelConfigurator);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("dataHost", (Object)this.dataHost).add("adminHost", (Object)this.adminHost).add("port", this.port).add("projectId", (Object)this.projectId).add("instanceId", (Object)this.instanceId).add("appProfileId", (Object)this.appProfileId).add("userAgent", (Object)this.userAgent).add("credentialType", (Object)this.credentialOptions.getCredentialType()).add("dataChannelCount", this.dataChannelCount).add("retryOptions", (Object)this.retryOptions).add("bulkOptions", (Object)this.bulkOptions).add("callOptionsConfig", (Object)this.callOptionsConfig).add("usePlaintextNegotiation", this.usePlaintextNegotiation).add("useCachedDataPool", this.useCachedDataPool).add("useBatch", this.useBatch).add("useGCJClient", this.useGCJClient).toString();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean useCachedChannel() {
        return this.useCachedDataPool;
    }

    public boolean useBatch() {
        return this.useBatch;
    }

    protected BigtableOptions clone() {
        try {
            return (BigtableOptions)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not cloe BigtableOptions");
        }
    }

    public static class Builder {
        private BigtableOptions options = new BigtableOptions();

        @Deprecated
        public Builder() {
            this.options = new BigtableOptions();
            this.options.appProfileId = BigtableOptions.BIGTABLE_APP_PROFILE_DEFAULT;
            this.options.dataHost = BigtableOptions.isDirectPathEnabled() ? BigtableOptions.BIGTABLE_DIRECTPATH_DATA_HOST_DEFAULT : BigtableOptions.BIGTABLE_DATA_HOST_DEFAULT;
            this.options.adminHost = BigtableOptions.BIGTABLE_ADMIN_HOST_DEFAULT;
            this.options.port = 443;
            this.options.dataChannelCount = BIGTABLE_DATA_CHANNEL_COUNT_DEFAULT;
            this.options.usePlaintextNegotiation = false;
            this.options.useCachedDataPool = false;
            this.options.useGCJClient = false;
            this.options.retryOptions = new RetryOptions.Builder().build();
            this.options.callOptionsConfig = CallOptionsConfig.builder().build();
            this.options.credentialOptions = CredentialOptions.defaultCredentials();
            this.options.useBatch = false;
        }

        private Builder(BigtableOptions options) {
            this.options = options.clone();
        }

        public Builder setAdminHost(String adminHost) {
            this.options.adminHost = adminHost;
            return this;
        }

        public Builder setDataHost(String dataHost) {
            this.options.dataHost = dataHost;
            return this;
        }

        public Builder setPort(int port) {
            this.options.port = port;
            return this;
        }

        public Builder setProjectId(String projectId) {
            this.options.projectId = projectId;
            return this;
        }

        public Builder setInstanceId(String instanceId) {
            this.options.instanceId = instanceId;
            return this;
        }

        public Builder setAppProfileId(String appProfileId) {
            Preconditions.checkNotNull((Object)appProfileId);
            this.options.appProfileId = appProfileId;
            return this;
        }

        public Builder setCredentialOptions(CredentialOptions credentialOptions) {
            this.options.credentialOptions = credentialOptions;
            return this;
        }

        public Builder setUserAgent(String userAgent) {
            this.options.userAgent = userAgent;
            return this;
        }

        public Builder setDataChannelCount(int dataChannelCount) {
            this.options.dataChannelCount = dataChannelCount;
            return this;
        }

        @InternalApi(value="Visible for test only")
        public Builder setChannelConfigurator(ChannelConfigurator configurator) {
            this.options.channelConfigurator = configurator;
            return this;
        }

        @InternalApi(value="For internal usage only")
        public int getDataChannelCount() {
            return this.options.dataChannelCount;
        }

        public Builder setRetryOptions(RetryOptions retryOptions) {
            this.options.retryOptions = retryOptions;
            return this;
        }

        public Builder setBulkOptions(BulkOptions bulkOptions) {
            this.options.bulkOptions = bulkOptions;
            return this;
        }

        public Builder setUsePlaintextNegotiation(boolean usePlaintextNegotiation) {
            this.options.usePlaintextNegotiation = usePlaintextNegotiation;
            return this;
        }

        public Builder setUseCachedDataPool(boolean useCachedDataPool) {
            this.options.useCachedDataPool = useCachedDataPool;
            return this;
        }

        public Builder setCallOptionsConfig(CallOptionsConfig callOptionsConfig) {
            this.options.callOptionsConfig = callOptionsConfig;
            return this;
        }

        public Builder setUseBatch(boolean useBatch) {
            this.options.useBatch = useBatch;
            return this;
        }

        @BetaApi(value="Will be removed after hbase transitions away from bigtable-client-core")
        public Builder setUseGCJClient(boolean useGCJClient) {
            this.options.useGCJClient = useGCJClient;
            return this;
        }

        private void applyEmulatorEnvironment() {
            String emulatorHost = System.getenv(BigtableOptions.BIGTABLE_EMULATOR_HOST_ENV_VAR);
            if (emulatorHost == null) {
                return;
            }
            this.enableEmulator(emulatorHost);
        }

        public Builder enableEmulator(String emulatorHostAndPort) {
            int port;
            String[] hostPort = emulatorHostAndPort.split(":");
            Preconditions.checkArgument((hostPort.length == 2 ? 1 : 0) != 0, (Object)("Malformed BIGTABLE_EMULATOR_HOST environment variable: " + emulatorHostAndPort + ". Expecting host:port."));
            try {
                port = Integer.parseInt(hostPort[1]);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Invalid port in BIGTABLE_EMULATOR_HOST environment variable: " + emulatorHostAndPort);
            }
            this.enableEmulator(hostPort[0], port);
            return this;
        }

        public Builder enableEmulator(String host, int port) {
            Preconditions.checkArgument((host != null && !host.isEmpty() ? 1 : 0) != 0, (Object)"Host cannot be null or empty");
            Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (Object)"Port must be positive");
            this.setUsePlaintextNegotiation(true);
            this.setCredentialOptions(CredentialOptions.nullCredential());
            this.setDataHost(host);
            this.setAdminHost(host);
            this.setPort(port);
            LOG.info("Connecting to the Bigtable emulator at " + host + ":" + port, new Object[0]);
            return this;
        }

        public BigtableOptions build() {
            int maxInflightRpcs;
            if (this.options.bulkOptions == null) {
                maxInflightRpcs = 10 * this.options.dataChannelCount;
                this.options.bulkOptions = BulkOptions.builder().setMaxInflightRpcs(maxInflightRpcs).build();
            } else if (this.options.bulkOptions.getMaxInflightRpcs() <= 0) {
                maxInflightRpcs = 10 * this.options.dataChannelCount;
                this.options.bulkOptions = this.options.bulkOptions.toBuilder().setMaxInflightRpcs(maxInflightRpcs).build();
            }
            this.applyEmulatorEnvironment();
            this.options.adminHost = (String)Preconditions.checkNotNull((Object)this.options.adminHost);
            this.options.dataHost = (String)Preconditions.checkNotNull((Object)this.options.dataHost);
            if (!Strings.isNullOrEmpty((String)this.options.projectId) && !Strings.isNullOrEmpty((String)this.options.instanceId)) {
                this.options.instanceName = new BigtableInstanceName(this.options.projectId, this.options.instanceId);
            } else {
                this.options.instanceName = null;
            }
            if (this.options.useBatch) {
                this.options.useCachedDataPool = true;
                if (this.options.dataHost.equals(BigtableOptions.BIGTABLE_DATA_HOST_DEFAULT)) {
                    this.options.dataHost = BigtableOptions.BIGTABLE_BATCH_DATA_HOST_DEFAULT;
                }
                RetryOptions.Builder retryOptionsBuilder = this.options.retryOptions.toBuilder();
                if (this.options.retryOptions.getInitialBackoffMillis() == 5) {
                    retryOptionsBuilder.setInitialBackoffMillis((int)TimeUnit.SECONDS.toMillis(5L));
                }
                if (this.options.retryOptions.getMaxElapsedBackoffMillis() == RetryOptions.DEFAULT_MAX_ELAPSED_BACKOFF_MILLIS) {
                    retryOptionsBuilder.setMaxElapsedBackoffMillis((int)TimeUnit.MINUTES.toMillis(5L));
                }
                this.options.retryOptions = retryOptionsBuilder.build();
            }
            LOG.debug("Connection Configuration: projectId: %s, instanceId: %s, data host %s, admin host %s.", this.options.projectId, this.options.instanceId, this.options.dataHost, this.options.adminHost);
            return this.options;
        }
    }

    @InternalApi(value="Visible for test only")
    public static interface ChannelConfigurator {
        public ManagedChannelBuilder configureChannel(ManagedChannelBuilder var1, String var2);
    }
}

