/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.io.dns.DnsSettings$;
import akka.io.dns.internal.ResolvConf;
import akka.io.dns.internal.ResolvConfParser$;
import akka.util.Helpers$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import akka.util.ccompat.package$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.io.File;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005Uc!B\u0001\u0003\u0005\tA!a\u0003#ogN+G\u000f^5oONT!a\u0001\u0003\u0002\u0007\u0011t7O\u0003\u0002\u0006\r\u0005\u0011\u0011n\u001c\u0006\u0002\u000f\u0005!\u0011m[6b'\t\u0001\u0011\u0002\u0005\u0002\u000b\u001b5\t1BC\u0001\r\u0003\u0015\u00198-\u00197b\u0013\tq1B\u0001\u0004B]f\u0014VM\u001a\u0005\t!\u0001\u0011\t\u0011)A\u0005%\u000511/_:uK6\u001c\u0001\u0001\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\r\u0005)\u0011m\u0019;pe&\u0011q\u0003\u0006\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\t3\u0001\u0011\t\u0011)A\u00055\u0005\t1\r\u0005\u0002\u001cE5\tAD\u0003\u0002\u001e=\u000511m\u001c8gS\u001eT!a\b\u0011\u0002\u0011QL\b/Z:bM\u0016T\u0011!I\u0001\u0004G>l\u0017BA\u0012\u001d\u0005\u0019\u0019uN\u001c4jO\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"2aJ\u0015+!\tA\u0003!D\u0001\u0003\u0011\u0015\u0001B\u00051\u0001\u0013\u0011\u0015IB\u00051\u0001\u001b\u0011\u001da\u0003A1A\u0005\u00025\n1BT1nKN+'O^3sgV\ta\u0006E\u00020oir!\u0001M\u001b\u000f\u0005E\"T\"\u0001\u001a\u000b\u0005M\n\u0012A\u0002\u001fs_>$h(C\u0001\r\u0013\t14\"A\u0004qC\u000e\\\u0017mZ3\n\u0005aJ$\u0001\u0002'jgRT!AN\u0006\u0011\u0005m\u0002U\"\u0001\u001f\u000b\u0005ur\u0014a\u00018fi*\tq(\u0001\u0003kCZ\f\u0017BA!=\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o\u001d\u0005\u0007\u0007\u0002\u0001\u000b\u0011\u0002\u0018\u0002\u00199\u000bW.Z*feZ,'o\u001d\u0011\t\u000f\u0015\u0003!\u0019!C\u0001\r\u0006q!+Z:pYZ,G+[7f_V$X#A$\u0011\u0005!kU\"A%\u000b\u0005)[\u0015\u0001\u00033ve\u0006$\u0018n\u001c8\u000b\u00051[\u0011AC2p]\u000e,(O]3oi&\u0011a*\u0013\u0002\u000f\r&t\u0017\u000e^3EkJ\fG/[8o\u0011\u0019\u0001\u0006\u0001)A\u0005\u000f\u0006y!+Z:pYZ,G+[7f_V$\b\u0005\u0003\u0005S\u0001!\u0015\r\u0011\"\u0003T\u0003)\u0011Xm]8mm\u000e{gNZ\u000b\u0002)B\u0019!\"V,\n\u0005Y[!AB(qi&|g\u000e\u0005\u0002Y76\t\u0011L\u0003\u0002[\u0005\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002]3\nQ!+Z:pYZ\u001cuN\u001c4\t\u0011y\u0003\u0001\u0012!Q!\nQ\u000b1B]3t_248i\u001c8gA!9\u0001\r\u0001b\u0001\n\u0003\t\u0017!D*fCJ\u001c\u0007\u000eR8nC&t7/F\u0001c!\rysg\u0019\t\u0003I\u001et!AC3\n\u0005\u0019\\\u0011A\u0002)sK\u0012,g-\u0003\u0002iS\n11\u000b\u001e:j]\u001eT!AZ\u0006\t\r-\u0004\u0001\u0015!\u0003c\u00039\u0019V-\u0019:dQ\u0012{W.Y5og\u0002Bq!\u001c\u0001C\u0002\u0013\u0005a.A\u0003O\t>$8/F\u0001p!\tQ\u0001/\u0003\u0002r\u0017\t\u0019\u0011J\u001c;\t\rM\u0004\u0001\u0015!\u0003p\u0003\u0019qEi\u001c;tA!)Q\u000f\u0001C\u0001m\u00069c-Y5m+:\f'\r\\3U_\u0012+G/\u001a:nS:,G)\u001a4bk2$h*Y7fg\u0016\u0014h/\u001a:t+\u00059\bC\u0001\u0006y\u0013\tI8BA\u0004O_RD\u0017N\\4)\u0005\u0001Y\bC\u0001?\u0000\u001b\u0005i(B\u0001@\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0004\u0003\u0003i(aC%oi\u0016\u0014h.\u00197Ba&<q!!\u0002\u0003\u0011\u0003\t9!A\u0006E]N\u001cV\r\u001e;j]\u001e\u001c\bc\u0001\u0015\u0002\n\u00191\u0011A\u0001E\u0001\u0003\u0017\u00192!!\u0003\n\u0011\u001d)\u0013\u0011\u0002C\u0001\u0003\u001f!\"!a\u0002\t\u0015\u0005M\u0011\u0011\u0002b\u0001\n\u001b\t)\"A\bE]N4\u0015\r\u001c7cC\u000e\\\u0007k\u001c:u+\t\t9b\u0004\u0002\u0002\u001au\tQ\u0007C\u0005\u0002\u001e\u0005%\u0001\u0015!\u0004\u0002\u0018\u0005\u0001BI\\:GC2d'-Y2l!>\u0014H\u000f\t\u0005\u000b\u0003C\tIA1A\u0005\n\u0005\r\u0012!E5oKR\u001cvnY6fi\u0006#GM]3tgV\u0011\u0011Q\u0005\t\u0005\u0003O\t\t$\u0004\u0002\u0002*)!\u00111FA\u0017\u0003!i\u0017\r^2iS:<'bAA\u0018\u0017\u0005!Q\u000f^5m\u0013\u0011\t\u0019$!\u000b\u0003\u000bI+w-\u001a=\t\u0013\u0005]\u0012\u0011\u0002Q\u0001\n\u0005\u0015\u0012AE5oKR\u001cvnY6fi\u0006#GM]3tg\u0002B\u0011\"a\u000f\u0002\n\u0011\u0005a!!\u0010\u0002-A\f'o]3OC6,7/\u001a:wKJ\fE\r\u001a:fgN$2AOA \u0011\u001d\t\t%!\u000fA\u0002\r\f1a\u001d;sQ\r\tId\u001f\u0005\n\u0003\u000f\nI\u0001\"\u0001\u0007\u0003\u0013\nQcZ3u\t\u00164\u0017-\u001e7u\u001d\u0006lWmU3sm\u0016\u00148\u000f\u0006\u0003\u0002L\u0005M\u0003#BA'\u0003\u001frSBAA\u0017\u0013\u0011\t\t&!\f\u0003\u0007Q\u0013\u0018\u0010\u0003\u0004\u0011\u0003\u000b\u0002\rA\u0005")
public final class DnsSettings {
    private final ExtendedActorSystem system;
    private final List<InetSocketAddress> NameServers;
    private final FiniteDuration ResolveTimeout;
    private Option<ResolvConf> resolvConf;
    private final List<String> SearchDomains;
    private final int NDots;
    private volatile boolean bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Option resolvConf$lzycompute() {
        DnsSettings dnsSettings = this;
        synchronized (dnsSettings) {
            if (!this.bitmap$0) {
                None$ none$;
                File etcResolvConf = new File("/etc/resolv.conf");
                if (Helpers$.MODULE$.isWindows()) {
                    none$ = None$.MODULE$;
                } else if (etcResolvConf.exists()) {
                    Some some;
                    Try<ResolvConf> parsed = ResolvConfParser$.MODULE$.parseFile(etcResolvConf);
                    Try<ResolvConf> try_ = parsed;
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        ResolvConf value = (ResolvConf)success.value();
                        some = new Some((Object)value);
                    } else {
                        if (!(try_ instanceof Failure)) throw new MatchError(try_);
                        Failure failure = (Failure)try_;
                        Throwable exception = failure.exception();
                        if (this.system.log().isWarningEnabled()) {
                            this.system.log().error(exception, "Error parsing /etc/resolv.conf, ignoring.");
                        }
                        some = None$.MODULE$;
                    }
                    none$ = some;
                } else {
                    none$ = None$.MODULE$;
                }
                this.resolvConf = none$;
                this.bitmap$0 = true;
            }
            return this.resolvConf;
        }
    }

    public List<InetSocketAddress> NameServers() {
        return this.NameServers;
    }

    public FiniteDuration ResolveTimeout() {
        return this.ResolveTimeout;
    }

    private Option<ResolvConf> resolvConf() {
        return this.bitmap$0 ? this.resolvConf : this.resolvConf$lzycompute();
    }

    public List<String> SearchDomains() {
        return this.SearchDomains;
    }

    public int NDots() {
        return this.NDots;
    }

    public Nothing$ failUnableToDetermineDefaultNameservers() {
        throw new IllegalStateException("Unable to obtain default nameservers from JNDI or via reflection. Please set `akka.io.dns.async-dns.nameservers` explicitly in order to be able to resolve domain names. ");
    }

    public DnsSettings(ExtendedActorSystem system, Config c) {
        block9: {
            block12: {
                block16: {
                    int n;
                    block15: {
                        ConfigValueType configValueType;
                        block13: {
                            block14: {
                                int n2;
                                List list;
                                block11: {
                                    ConfigValueType configValueType2;
                                    block10: {
                                        List list2;
                                        block8: {
                                            ConfigValueType configValueType3;
                                            block7: {
                                                List list3;
                                                this.system = system;
                                                configValueType3 = c.getValue("nameservers").valueType();
                                                if (!ConfigValueType.STRING.equals(configValueType3)) break block7;
                                                String string = c.getString("nameservers");
                                                if ("default".equals(string)) {
                                                    List osAddresses = (List)DnsSettings$.MODULE$.getDefaultNameServers(system).getOrElse((Function0)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ DnsSettings $outer;

                                                        public final Nothing$ apply() {
                                                            return this.$outer.failUnableToDetermineDefaultNameservers();
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    });
                                                    if (osAddresses.isEmpty()) {
                                                        throw this.failUnableToDetermineDefaultNameservers();
                                                    }
                                                    list3 = osAddresses;
                                                } else {
                                                    InetSocketAddress inetSocketAddress = DnsSettings$.MODULE$.parseNameserverAddress(string);
                                                    list3 = Nil$.MODULE$.$colon$colon((Object)inetSocketAddress);
                                                }
                                                list2 = list3;
                                                break block8;
                                            }
                                            if (!ConfigValueType.LIST.equals(configValueType3)) break block9;
                                            IndexedSeq userAddresses = (IndexedSeq)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("nameservers")).asScala()).iterator().map((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final InetSocketAddress apply(String str) {
                                                    return DnsSettings$.MODULE$.parseNameserverAddress(str);
                                                }
                                            }).to(package$.MODULE$.genericCompanionToCBF(IndexedSeq$.MODULE$));
                                            Predef$.MODULE$.require(userAddresses.nonEmpty(), (Function0)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                public final String apply() {
                                                    return "nameservers can not be empty";
                                                }
                                            });
                                            list2 = userAddresses.toList();
                                        }
                                        this.NameServers = list2;
                                        this.ResolveTimeout = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(c.getDuration("resolve-timeout")));
                                        configValueType2 = c.getValue("search-domains").valueType();
                                        if (!ConfigValueType.STRING.equals(configValueType2)) break block10;
                                        String string = c.getString("search-domains");
                                        List list4 = "default".equals(string) ? (List)this.resolvConf().map((Function1)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final List<String> apply(ResolvConf x$2) {
                                                return x$2.search();
                                            }
                                        }).getOrElse((Function0)new Serializable(this){
                                            public static final long serialVersionUID = 0L;

                                            public final Nil$ apply() {
                                                return Nil$.MODULE$;
                                            }
                                        }) : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{string}));
                                        list = list4;
                                        break block11;
                                    }
                                    if (!ConfigValueType.LIST.equals(configValueType2)) break block12;
                                    list = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("search-domains")).asScala()).toList();
                                }
                                this.SearchDomains = list;
                                configValueType = c.getValue("ndots").valueType();
                                if (!ConfigValueType.STRING.equals(configValueType)) break block13;
                                String string = c.getString("ndots");
                                if (!"default".equals(string)) break block14;
                                n = n2 = BoxesRunTime.unboxToInt((Object)this.resolvConf().map((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply(ResolvConf x$3) {
                                        return x$3.ndots();
                                    }
                                }).getOrElse((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final int apply() {
                                        return this.apply$mcI$sp();
                                    }

                                    public int apply$mcI$sp() {
                                        return 1;
                                    }
                                }));
                                break block15;
                            }
                            throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
                        }
                        if (!ConfigValueType.NUMBER.equals(configValueType)) break block16;
                        int ndots = c.getInt("ndots");
                        if (ndots < 0) {
                            throw new IllegalArgumentException("Invalid value for ndots, ndots must not be negative.");
                        }
                        n = ndots;
                    }
                    this.NDots = n;
                    return;
                }
                throw new IllegalArgumentException("Invalid value for ndots. Must be the string 'default' or an integer.");
            }
            throw new IllegalArgumentException("Invalid type for search-domains. Must be a string or string list.");
        }
        throw new IllegalArgumentException("Invalid type for nameservers. Must be a string or string list");
    }
}

