/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.simpleeval;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.IAction;
import org.w3c.dom.Node;

@Action(id="SIMPLE_EVAL", name="i18n::ActionSimpleEval.Name", description="i18n::ActionSimpleEval.Description", image="SimpleEval.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.Conditions", documentationUrl="/workflow/actions/simpleeval.html")
public class ActionSimpleEval
extends ActionBase
implements Cloneable,
IAction {
    private static final Class<?> PKG = ActionSimpleEval.class;
    public static final String[] valueTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSimpleEval.EvalPreviousField.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.EvalVariable.Label", (String[])new String[0])};
    public static final String[] valueTypeCode = new String[]{"field", "variable"};
    public static final int VALUE_TYPE_FIELD = 0;
    public static final int VALUE_TYPE_VARIABLE = 1;
    public int valuetype = 0;
    public static final String[] successConditionDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenContains.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenNotContains.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenStartWith.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenNotStartWith.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenEndWith.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenNotEndWith.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenRegExp.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenInList.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenNotInList.Label", (String[])new String[0])};
    public static final String[] successConditionCode = new String[]{"equal", "different", "contains", "notcontains", "startswith", "notstatwith", "endswith", "notendwith", "regexp", "inlist", "notinlist"};
    public static final int SUCCESS_CONDITION_EQUAL = 0;
    public static final int SUCCESS_CONDITION_DIFFERENT = 1;
    public static final int SUCCESS_CONDITION_CONTAINS = 2;
    public static final int SUCCESS_CONDITION_NOT_CONTAINS = 3;
    public static final int SUCCESS_CONDITION_START_WITH = 4;
    public static final int SUCCESS_CONDITION_NOT_START_WITH = 5;
    public static final int SUCCESS_CONDITION_END_WITH = 6;
    public static final int SUCCESS_CONDITION_NOT_END_WITH = 7;
    public static final int SUCCESS_CONDITION_REGEX = 8;
    public static final int SUCCESS_CONDITION_IN_LIST = 9;
    public static final int SUCCESS_CONDITION_NOT_IN_LIST = 10;
    public int successcondition = 0;
    public static final String[] fieldTypeDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldTypeString.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldTypeNumber.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldTypeDateTime.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.FieldTypeBoolean.Label", (String[])new String[0])};
    public static final String[] fieldTypeCode = new String[]{"string", "number", "datetime", "boolean"};
    public static final int FIELD_TYPE_STRING = 0;
    public static final int FIELD_TYPE_NUMBER = 1;
    public static final int FIELD_TYPE_DATE_TIME = 2;
    public static final int FIELD_TYPE_BOOLEAN = 3;
    public int fieldtype = 0;
    public static final String[] successNumberConditionDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenEqual.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenDifferent.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenSmallThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenSmallOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenGreaterThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenGreaterOrEqualThan.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessBetween.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenInList.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenNotInList.Label", (String[])new String[0])};
    public static final String[] successNumberConditionCode = new String[]{"equal", "different", "smaller", "smallequal", "greater", "greaterequal", "between", "inlist", "notinlist"};
    public static final int SUCCESS_NUMBER_CONDITION_EQUAL = 0;
    public static final int SUCCESS_NUMBER_CONDITION_DIFFERENT = 1;
    public static final int SUCCESS_NUMBER_CONDITION_SMALLER = 2;
    public static final int SUCCESS_NUMBER_CONDITION_SMALLER_EQUAL = 3;
    public static final int SUCCESS_NUMBER_CONDITION_GREATER = 4;
    public static final int SUCCESS_NUMBER_CONDITION_GREATER_EQUAL = 5;
    public static final int SUCCESS_NUMBER_CONDITION_BETWEEN = 6;
    public static final int SUCCESS_NUMBER_CONDITION_IN_LIST = 7;
    public static final int SUCCESS_NUMBER_CONDITION_NOT_IN_LIST = 8;
    public int successnumbercondition = 0;
    public static final String[] successBooleanConditionDesc = new String[]{BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenTrue.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ActionSimpleEval.SuccessWhenFalse.Label", (String[])new String[0])};
    public static final String[] successBooleanConditionCode = new String[]{"true", "false"};
    public static final int SUCCESS_BOOLEAN_CONDITION_TRUE = 0;
    public static final int SUCCESS_BOOLEAN_CONDITION_FALSE = 1;
    public int successbooleancondition = 1;
    private String fieldname = null;
    private String variablename = null;
    private String mask = null;
    private String comparevalue = null;
    private String minvalue = null;
    private String maxvalue = null;
    private boolean successwhenvarset = false;

    public ActionSimpleEval(String n) {
        super(n, "");
    }

    public ActionSimpleEval() {
        this("");
    }

    public Object clone() {
        ActionSimpleEval je = (ActionSimpleEval)super.clone();
        return je;
    }

    private static String getValueTypeCode(int i) {
        if (i < 0 || i >= valueTypeCode.length) {
            return valueTypeCode[0];
        }
        return valueTypeCode[i];
    }

    private static String getFieldTypeCode(int i) {
        if (i < 0 || i >= fieldTypeCode.length) {
            return fieldTypeCode[0];
        }
        return fieldTypeCode[i];
    }

    private static String getSuccessConditionCode(int i) {
        if (i < 0 || i >= successConditionCode.length) {
            return successConditionCode[0];
        }
        return successConditionCode[i];
    }

    public static String getSuccessNumberConditionCode(int i) {
        if (i < 0 || i >= successNumberConditionCode.length) {
            return successNumberConditionCode[0];
        }
        return successNumberConditionCode[i];
    }

    private static String getSuccessBooleanConditionCode(int i) {
        if (i < 0 || i >= successBooleanConditionCode.length) {
            return successBooleanConditionCode[0];
        }
        return successBooleanConditionCode[i];
    }

    public String getXml() {
        StringBuilder xml = new StringBuilder(300);
        xml.append(super.getXml());
        xml.append("      ").append(XmlHandler.addTagValue((String)"valuetype", (String)ActionSimpleEval.getValueTypeCode(this.valuetype)));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fieldname", (String)this.fieldname));
        xml.append("      ").append(XmlHandler.addTagValue((String)"variablename", (String)this.variablename));
        xml.append("      ").append(XmlHandler.addTagValue((String)"fieldtype", (String)ActionSimpleEval.getFieldTypeCode(this.fieldtype)));
        xml.append("      ").append(XmlHandler.addTagValue((String)"mask", (String)this.mask));
        xml.append("      ").append(XmlHandler.addTagValue((String)"comparevalue", (String)this.comparevalue));
        xml.append("      ").append(XmlHandler.addTagValue((String)"minvalue", (String)this.minvalue));
        xml.append("      ").append(XmlHandler.addTagValue((String)"maxvalue", (String)this.maxvalue));
        xml.append("      ").append(XmlHandler.addTagValue((String)"successcondition", (String)ActionSimpleEval.getSuccessConditionCode(this.successcondition)));
        xml.append("      ").append(XmlHandler.addTagValue((String)"successnumbercondition", (String)ActionSimpleEval.getSuccessNumberConditionCode(this.successnumbercondition)));
        xml.append("      ").append(XmlHandler.addTagValue((String)"successbooleancondition", (String)ActionSimpleEval.getSuccessBooleanConditionCode(this.successbooleancondition)));
        xml.append("      ").append(XmlHandler.addTagValue((String)"successwhenvarset", (boolean)this.successwhenvarset));
        return xml.toString();
    }

    private static int getValueTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < valueTypeCode.length; ++i) {
            if (!valueTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessNumberByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionCode.length; ++i) {
            if (!successNumberConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessBooleanByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successBooleanConditionCode.length; ++i) {
            if (!successBooleanConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getFieldTypeByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < fieldTypeCode.length; ++i) {
            if (!fieldTypeCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionCode.length; ++i) {
            if (!successConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void setSuccessWhenVarSet(boolean successwhenvarset) {
        this.successwhenvarset = successwhenvarset;
    }

    public boolean isSuccessWhenVarSet() {
        return this.successwhenvarset;
    }

    public static int getSuccessNumberConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionCode.length; ++i) {
            if (!successNumberConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    private static int getSuccessBooleanConditionByCode(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successBooleanConditionCode.length; ++i) {
            if (!successBooleanConditionCode[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return 0;
    }

    public void loadXml(Node entrynode, IHopMetadataProvider metadataProvider, IVariables variables) throws HopXmlException {
        try {
            super.loadXml(entrynode);
            this.valuetype = ActionSimpleEval.getValueTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"valuetype"), (String)""));
            this.fieldname = XmlHandler.getTagValue((Node)entrynode, (String)"fieldname");
            this.fieldtype = ActionSimpleEval.getFieldTypeByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"fieldtype"), (String)""));
            this.variablename = XmlHandler.getTagValue((Node)entrynode, (String)"variablename");
            this.mask = XmlHandler.getTagValue((Node)entrynode, (String)"mask");
            this.comparevalue = XmlHandler.getTagValue((Node)entrynode, (String)"comparevalue");
            this.minvalue = XmlHandler.getTagValue((Node)entrynode, (String)"minvalue");
            this.maxvalue = XmlHandler.getTagValue((Node)entrynode, (String)"maxvalue");
            this.successcondition = ActionSimpleEval.getSuccessConditionByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"successcondition"), (String)""));
            this.successnumbercondition = ActionSimpleEval.getSuccessNumberConditionByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"successnumbercondition"), (String)""));
            this.successbooleancondition = ActionSimpleEval.getSuccessBooleanConditionByCode(Const.NVL((String)XmlHandler.getTagValue((Node)entrynode, (String)"successbooleancondition"), (String)""));
            this.successwhenvarset = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)entrynode, (String)"successwhenvarset"));
        }
        catch (HopXmlException xe) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"ActionSimple.Error.Exception.UnableLoadXML", (String[])new String[0]), (Throwable)xe);
        }
    }

    public Result execute(Result previousResult, int nr) throws HopException {
        Result result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        String sourcevalue = null;
        switch (this.valuetype) {
            case 0: {
                List rows = result.getRows();
                RowMetaAndData resultRow = null;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.ArgFromPrevious.Found", (String[])new String[]{(rows != null ? rows.size() : 0) + ""}));
                }
                if (rows.size() == 0) {
                    rows = null;
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.NoRows", (String[])new String[0]));
                    return result;
                }
                resultRow = (RowMetaAndData)rows.get(0);
                String realfieldname = this.resolve(this.fieldname);
                int indexOfField = -1;
                indexOfField = resultRow.getRowMeta().indexOfValue(realfieldname);
                if (indexOfField == -1) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.FieldNotExist", (String[])new String[]{realfieldname}));
                    resultRow = null;
                    rows = null;
                    return result;
                }
                sourcevalue = resultRow.getString(indexOfField, null);
                if (sourcevalue == null) {
                    sourcevalue = "";
                }
                resultRow = null;
                rows = null;
                break;
            }
            case 1: {
                if (Utils.isEmpty((CharSequence)this.variablename)) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.VariableMissing", (String[])new String[0]));
                    return result;
                }
                if (this.isSuccessWhenVarSet()) {
                    String variableName = StringUtil.getVariableName((String)Const.NVL((String)this.getVariableName(), (String)""));
                    String value = this.getVariable(variableName);
                    if (value != null) {
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSimpleEval.VariableSet", (String[])new String[]{variableName}));
                        }
                        result.setResult(true);
                        result.setNrErrors(0L);
                        return result;
                    }
                    if (this.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSimpleEval.VariableNotSet", (String[])new String[]{variableName}));
                    }
                    result.setNrErrors(0L);
                    return result;
                }
                sourcevalue = this.resolve(this.getVariableWithSpec());
                break;
            }
        }
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.ValueToevaluate", (String[])new String[]{sourcevalue}));
        }
        boolean success = false;
        String realCompareValue = this.resolve(this.comparevalue);
        if (realCompareValue == null) {
            realCompareValue = "";
        }
        String realMinValue = this.resolve(this.minvalue);
        String realMaxValue = this.resolve(this.maxvalue);
        block27 : switch (this.fieldtype) {
            case 0: {
                switch (this.successcondition) {
                    case 0: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = sourcevalue.equals(realCompareValue);
                        if (this.valuetype != 1 || success || !Utils.isEmpty((CharSequence)realCompareValue)) break;
                        String variableName = StringUtil.getVariableName((String)this.variablename);
                        if (System.getProperty(variableName) != null) break block27;
                        success = true;
                        break;
                    }
                    case 1: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = !sourcevalue.equals(realCompareValue);
                        break;
                    }
                    case 2: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = sourcevalue.contains(realCompareValue);
                        break;
                    }
                    case 3: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = !sourcevalue.contains(realCompareValue);
                        break;
                    }
                    case 4: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = sourcevalue.startsWith(realCompareValue);
                        break;
                    }
                    case 5: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = !sourcevalue.startsWith(realCompareValue);
                        break;
                    }
                    case 6: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = sourcevalue.endsWith(realCompareValue);
                        break;
                    }
                    case 7: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = !sourcevalue.endsWith(realCompareValue);
                        break;
                    }
                    case 8: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        success = Pattern.compile(realCompareValue).matcher(sourcevalue).matches();
                        break;
                    }
                    case 9: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                        String[] parts = realCompareValue.split(",");
                        for (int i = 0; i < parts.length && !success; ++i) {
                            success = sourcevalue.equals(parts[i].trim());
                        }
                        break block27;
                    }
                    case 10: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                        String[] parts = realCompareValue.split(",");
                        success = true;
                        for (int i = 0; i < parts.length && success; ++i) {
                            success = !sourcevalue.equals(parts[i].trim());
                        }
                        break block27;
                    }
                }
                break;
            }
            case 1: {
                double valuenumber;
                try {
                    valuenumber = Double.parseDouble(sourcevalue);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{sourcevalue, e.getMessage()}));
                    return result;
                }
                switch (this.successnumbercondition) {
                    case 0: {
                        double valuecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber == valuecompare;
                        break;
                    }
                    case 1: {
                        double valuecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber != valuecompare;
                        break;
                    }
                    case 2: {
                        double valuecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber < valuecompare;
                        break;
                    }
                    case 3: {
                        double valuecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber <= valuecompare;
                        break;
                    }
                    case 4: {
                        double valuecompare;
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber > valuecompare;
                        break;
                    }
                    case 5: {
                        double valuecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            valuecompare = Double.parseDouble(realCompareValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{realCompareValue, e.getMessage()}));
                            return result;
                        }
                        success = valuenumber >= valuecompare;
                        break;
                    }
                    case 6: {
                        double valuemax;
                        double valuemin;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValues", (String[])new String[]{realMinValue, realMaxValue}));
                        }
                        try {
                            valuemin = Double.parseDouble(realMinValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{realMinValue, e.getMessage()}));
                            return result;
                        }
                        try {
                            valuemax = Double.parseDouble(realMaxValue);
                        }
                        catch (Exception e) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{realMaxValue, e.getMessage()}));
                            return result;
                        }
                        if (valuemin >= valuemax) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.IncorrectNumbers", (String[])new String[]{realMinValue, realMaxValue}));
                            return result;
                        }
                        success = valuenumber >= valuemin && valuenumber <= valuemax;
                        break;
                    }
                    case 7: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        String[] parts = realCompareValue.split(",");
                        for (int i = 0; i < parts.length && !success; ++i) {
                            double valuecompare;
                            try {
                                valuecompare = Double.parseDouble(parts[i]);
                            }
                            catch (Exception e) {
                                this.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{parts[i], e.getMessage()})});
                                return result;
                            }
                            success = valuenumber == valuecompare;
                        }
                        break block27;
                    }
                    case 8: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                        String[] parts = realCompareValue.split(",");
                        success = true;
                        for (int i = 0; i < parts.length && success; ++i) {
                            double valuecompare;
                            try {
                                valuecompare = Double.parseDouble(parts[i]);
                            }
                            catch (Exception e) {
                                this.logError(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableNumber", (String[])new String[]{parts[i], e.getMessage()})});
                                return result;
                            }
                            success = valuenumber != valuecompare;
                        }
                        break block27;
                    }
                }
                break;
            }
            case 2: {
                String realMask = this.resolve(this.mask);
                SimpleDateFormat df = new SimpleDateFormat();
                if (!Utils.isEmpty((CharSequence)realMask)) {
                    df.applyPattern(realMask);
                }
                Date datevalue = null;
                try {
                    datevalue = this.convertToDate(sourcevalue, realMask, df);
                }
                catch (Exception e) {
                    this.logError(e.getMessage());
                    return result;
                }
                switch (this.successnumbercondition) {
                    case 0: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = datevalue.equals(datecompare);
                        break;
                    }
                    case 1: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = !datevalue.equals(datecompare);
                        break;
                    }
                    case 2: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = datevalue.before(datecompare);
                        break;
                    }
                    case 3: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = datevalue.before(datecompare) || datevalue.equals(datecompare);
                        break;
                    }
                    case 4: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = datevalue.after(datecompare);
                        break;
                    }
                    case 5: {
                        Date datecompare;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        try {
                            datecompare = this.convertToDate(realCompareValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        success = datevalue.after(datecompare) || datevalue.equals(datecompare);
                        break;
                    }
                    case 6: {
                        Date datemax;
                        Date datemin;
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValues", (String[])new String[]{realMinValue, realMaxValue}));
                        }
                        try {
                            datemin = this.convertToDate(realMinValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        try {
                            datemax = this.convertToDate(realMaxValue, realMask, df);
                        }
                        catch (Exception e) {
                            this.logError(e.getMessage());
                            return result;
                        }
                        if (datemin.after(datemax) || datemin.equals(datemax)) {
                            this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.IncorrectDates", (String[])new String[]{realMinValue, realMaxValue}));
                            return result;
                        }
                        success = !(!datevalue.after(datemin) && !datevalue.equals(datemin) || !datevalue.before(datemax) && !datevalue.equals(datemax));
                        break;
                    }
                    case 7: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        String[] parts = realCompareValue.split(",");
                        for (int i = 0; i < parts.length && !success; ++i) {
                            Date datecompare;
                            try {
                                datecompare = this.convertToDate(realCompareValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(this.toString(), new Object[]{e.getMessage()});
                                return result;
                            }
                            success = datevalue.equals(datecompare);
                        }
                        break;
                    }
                    case 8: {
                        if (this.isDebug()) {
                            this.logDebug(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Log.CompareWithValue", (String[])new String[]{sourcevalue, realCompareValue}));
                        }
                        realCompareValue = Const.NVL((String)realCompareValue, (String)"");
                        String[] parts = realCompareValue.split(",");
                        success = true;
                        for (int i = 0; i < parts.length && success; ++i) {
                            Date datecompare;
                            try {
                                datecompare = this.convertToDate(realCompareValue, realMask, df);
                            }
                            catch (Exception e) {
                                this.logError(this.toString(), new Object[]{e.getMessage()});
                                return result;
                            }
                            success = !datevalue.equals(datecompare);
                        }
                        break;
                    }
                }
                df = null;
                break;
            }
            case 3: {
                boolean valuebool;
                try {
                    valuebool = ValueMetaString.convertStringToBoolean((String)sourcevalue);
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableBoolean", (String[])new String[]{sourcevalue, e.getMessage()}));
                    return result;
                }
                switch (this.successbooleancondition) {
                    case 1: {
                        success = !valuebool;
                        break block27;
                    }
                    case 0: {
                        success = valuebool;
                        break block27;
                    }
                }
                break;
            }
        }
        result.setResult(success);
        result.setNrErrors(0L);
        return result;
    }

    private String getVariableWithSpec() {
        String variable = this.getVariableName();
        if (!(variable.contains("${") || variable.contains("%%") || variable.contains("$[") || variable.contains("}") || variable.contains("%%") || variable.contains("]"))) {
            variable = "${" + variable + "}";
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionSimpleEval.CheckingVariable", (String[])new String[]{variable}));
            }
        }
        return variable;
    }

    private Date convertToDate(String valueString, String mask, SimpleDateFormat df) throws HopException {
        Date datevalue = null;
        try {
            datevalue = df.parse(valueString);
        }
        catch (Exception e) {
            throw new HopException(BaseMessages.getString(PKG, (String)"ActionSimpleEval.Error.UnparsableDate", (String[])new String[]{valueString}));
        }
        return datevalue;
    }

    public static String getValueTypeDesc(int i) {
        if (i < 0 || i >= valueTypeDesc.length) {
            return valueTypeDesc[0];
        }
        return valueTypeDesc[i];
    }

    public static String getFieldTypeDesc(int i) {
        if (i < 0 || i >= fieldTypeDesc.length) {
            return fieldTypeDesc[0];
        }
        return fieldTypeDesc[i];
    }

    public static String getSuccessConditionDesc(int i) {
        if (i < 0 || i >= successConditionDesc.length) {
            return successConditionDesc[0];
        }
        return successConditionDesc[i];
    }

    public static String getSuccessNumberConditionDesc(int i) {
        if (i < 0 || i >= successNumberConditionDesc.length) {
            return successNumberConditionDesc[0];
        }
        return successNumberConditionDesc[i];
    }

    public static String getSuccessBooleanConditionDesc(int i) {
        if (i < 0 || i >= successBooleanConditionDesc.length) {
            return successBooleanConditionDesc[0];
        }
        return successBooleanConditionDesc[i];
    }

    public static int getValueTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < valueTypeDesc.length; ++i) {
            if (!valueTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionSimpleEval.getValueTypeByCode(tt);
    }

    public static int getFieldTypeByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < fieldTypeDesc.length; ++i) {
            if (!fieldTypeDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionSimpleEval.getFieldTypeByCode(tt);
    }

    public static int getSuccessConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successConditionDesc.length; ++i) {
            if (!successConditionDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionSimpleEval.getSuccessConditionByCode(tt);
    }

    public static int getSuccessNumberConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successNumberConditionDesc.length; ++i) {
            if (!successNumberConditionDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionSimpleEval.getSuccessNumberByCode(tt);
    }

    public static int getSuccessBooleanConditionByDesc(String tt) {
        if (tt == null) {
            return 0;
        }
        for (int i = 0; i < successBooleanConditionDesc.length; ++i) {
            if (!successBooleanConditionDesc[i].equalsIgnoreCase(tt)) continue;
            return i;
        }
        return ActionSimpleEval.getSuccessBooleanByCode(tt);
    }

    public void setMinValue(String minvalue) {
        this.minvalue = minvalue;
    }

    public String getMinValue() {
        return this.minvalue;
    }

    public void setCompareValue(String comparevalue) {
        this.comparevalue = comparevalue;
    }

    public String getMask() {
        return this.mask;
    }

    public void setMask(String mask) {
        this.mask = mask;
    }

    public String getFieldName() {
        return this.fieldname;
    }

    public void setFieldName(String fieldname) {
        this.fieldname = fieldname;
    }

    public String getVariableName() {
        return this.variablename;
    }

    public void setVariableName(String variablename) {
        this.variablename = variablename;
    }

    public String getCompareValue() {
        return this.comparevalue;
    }

    public void setMaxValue(String maxvalue) {
        this.maxvalue = maxvalue;
    }

    public String getMaxValue() {
        return this.maxvalue;
    }

    public boolean isEvaluation() {
        return true;
    }
}

