/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dynamicsqlrow;

import java.util.List;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopDatabaseException;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.DatabaseImpact;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dynamicsqlrow.DynamicSqlRow;
import org.apache.hop.pipeline.transforms.dynamicsqlrow.DynamicSqlRowData;
import org.w3c.dom.Node;

@Transform(id="DynamicSqlRow", image="dynamicsqlrow.svg", name="i18n::BaseTransform.TypeLongDesc.DynamicSQLRow", description="i18n::BaseTransform.TypeTooltipDesc.DynamicSQLRow", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Lookup", documentationUrl="/pipeline/transforms/dynamicsqlrow.html")
public class DynamicSqlRowMeta
extends BaseTransformMeta
implements ITransformMeta<DynamicSqlRow, DynamicSqlRowData> {
    private static final Class<?> PKG = DynamicSqlRowMeta.class;
    private DatabaseMeta databaseMeta;
    private String sql;
    private String sqlfieldname;
    private int rowLimit;
    private boolean outerJoin;
    private boolean replacevars;
    public boolean queryonlyonchange;

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    public boolean isOuterJoin() {
        return this.outerJoin;
    }

    public void setOuterJoin(boolean outerJoin) {
        this.outerJoin = outerJoin;
    }

    public boolean isVariableReplace() {
        return this.replacevars;
    }

    public void setVariableReplace(boolean replacevars) {
        this.replacevars = replacevars;
    }

    public boolean isQueryOnlyOnChange() {
        return this.queryonlyonchange;
    }

    public void setQueryOnlyOnChange(boolean queryonlyonchange) {
        this.queryonlyonchange = queryonlyonchange;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public String getSql() {
        return this.sql;
    }

    public void setSql(String sql) {
        this.sql = sql;
    }

    public String getSqlFieldName() {
        return this.sqlfieldname;
    }

    public void setSqlFieldName(String sqlfieldname) {
        this.sqlfieldname = sqlfieldname;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        this.readData(transformNode, metadataProvider);
    }

    public Object clone() {
        DynamicSqlRowMeta retval = (DynamicSqlRowMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            String con = XmlHandler.getTagValue((Node)transformNode, (String)"connection");
            this.databaseMeta = DatabaseMeta.loadDatabase((IHopMetadataProvider)metadataProvider, (String)con);
            this.sql = XmlHandler.getTagValue((Node)transformNode, (String)"sql");
            this.outerJoin = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"outer_join"));
            this.replacevars = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"replace_vars"));
            this.queryonlyonchange = "Y".equalsIgnoreCase(XmlHandler.getTagValue((Node)transformNode, (String)"query_only_on_change"));
            this.rowLimit = Const.toInt((String)XmlHandler.getTagValue((Node)transformNode, (String)"rowlimit"), (int)0);
            this.sqlfieldname = XmlHandler.getTagValue((Node)transformNode, (String)"sql_fieldname");
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.Exception.UnableToLoadTransformMeta", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.databaseMeta = null;
        this.rowLimit = 0;
        this.sql = "";
        this.outerJoin = false;
        this.replacevars = false;
        this.sqlfieldname = null;
        this.queryonlyonchange = false;
    }

    public void getFields(IRowMeta row, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        if (this.databaseMeta == null) {
            return;
        }
        Database db = new Database(loggingObject, variables, this.databaseMeta);
        this.databases = new Database[]{db};
        IRowMeta add = null;
        String realSql = this.sql;
        if (this.replacevars) {
            realSql = variables.resolve(realSql);
        }
        try {
            add = db.getQueryFields(realSql, false);
        }
        catch (HopDatabaseException dbe) {
            throw new HopTransformException(BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.Exception.UnableToDetermineQueryFields", (String[])new String[0]) + Const.CR + this.sql, (Throwable)dbe);
        }
        if (add != null) {
            for (int i = 0; i < add.size(); ++i) {
                IValueMeta v = add.getValueMeta(i);
                v.setOrigin(name);
            }
            row.addRowMeta(add);
        } else {
            try {
                db.connect();
                add = db.getQueryFields(realSql, false);
                for (int i = 0; i < add.size(); ++i) {
                    IValueMeta v = add.getValueMeta(i);
                    v.setOrigin(name);
                }
                row.addRowMeta(add);
                db.disconnect();
            }
            catch (HopDatabaseException dbe) {
                throw new HopTransformException(BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.Exception.ErrorObtainingFields", (String[])new String[0]), (Throwable)dbe);
            }
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder();
        retval.append("    " + XmlHandler.addTagValue((String)"connection", (String)(this.databaseMeta == null ? "" : this.databaseMeta.getName())));
        retval.append("    " + XmlHandler.addTagValue((String)"rowlimit", (int)this.rowLimit));
        retval.append("    " + XmlHandler.addTagValue((String)"sql", (String)this.sql));
        retval.append("    " + XmlHandler.addTagValue((String)"outer_join", (boolean)this.outerJoin));
        retval.append("    " + XmlHandler.addTagValue((String)"replace_vars", (boolean)this.replacevars));
        retval.append("    " + XmlHandler.addTagValue((String)"sql_fieldname", (String)this.sqlfieldname));
        retval.append("    " + XmlHandler.addTagValue((String)"query_only_on_change", (boolean)this.queryonlyonchange));
        return retval.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.ReceivingInfo", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (Utils.isEmpty((CharSequence)this.sqlfieldname)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.SQLFieldNameMissing", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            IValueMeta vfield = prev.searchValueMeta(this.sqlfieldname);
            cr = vfield == null ? new CheckResult(4, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.SQLFieldNotFound", (String[])new String[]{this.sqlfieldname}), (ICheckResultSource)transformMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.SQLFieldFound", (String[])new String[]{this.sqlfieldname, vfield.getOrigin()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, variables, this.databaseMeta);
            this.databases = new Database[]{db};
            try {
                db.connect();
                if (this.sql == null || this.sql.length() == 0) return;
                errorMessage = "";
                IRowMeta r = db.getQueryFields(this.sql, true);
                if (r != null) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.QueryOK", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                    return;
                }
                errorMessage = BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.InvalidDBQuery", (String[])new String[0]);
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                return;
            }
            catch (HopException e) {
                errorMessage = BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.ErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
                return;
            }
            finally {
                db.disconnect();
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public DynamicSqlRow createTransform(TransformMeta transformMeta, DynamicSqlRowData data, int cnr, PipelineMeta tr, Pipeline pipeline) {
        return new DynamicSqlRow(transformMeta, this, data, cnr, tr, pipeline);
    }

    public DynamicSqlRowData getTransformData() {
        return new DynamicSqlRowData();
    }

    public void analyseImpact(IVariables variables, List<DatabaseImpact> impact, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IHopMetadataProvider metadataProvider) throws HopTransformException {
        IRowMeta out = prev.clone();
        this.getFields(out, transformMeta.getName(), new IRowMeta[]{info}, null, variables, metadataProvider);
        if (out != null) {
            for (int i = 0; i < out.size(); ++i) {
                IValueMeta outvalue = out.getValueMeta(i);
                DatabaseImpact di = new DatabaseImpact(1, pipelineMeta.getName(), transformMeta.getName(), this.databaseMeta.getDatabaseName(), "", outvalue.getName(), outvalue.getName(), transformMeta.getName(), this.sql, BaseMessages.getString(PKG, (String)"DynamicSQLRowMeta.DatabaseImpact.Title", (String[])new String[0]));
                impact.add(di);
            }
        }
    }

    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    public boolean supportsErrorHandling() {
        return true;
    }
}

