/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dynamicsqlrow;

import org.apache.hop.core.Const;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transforms.dynamicsqlrow.DynamicSqlRowMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class DynamicSqlRowDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = DynamicSqlRowMeta.class;
    private boolean gotPreviousFields = false;
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private StyledTextComp wSql;
    private Text wLimit;
    private Button wOuter;
    private Button wuseVars;
    private Label wlPosition;
    private CCombo wSqlFieldName;
    private Button wqueryOnlyOnChange;
    private final DynamicSqlRowMeta input;

    public DynamicSqlRowDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String sname) {
        super(parent, variables, (BaseTransformMeta)in, tr, sname);
        this.input = (DynamicSqlRowMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getDatabaseMeta(), lsMod);
        if (this.input.getDatabaseMeta() == null && this.pipelineMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        Label wlSqlFieldName = new Label((Composite)this.shell, 131072);
        wlSqlFieldName.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.SQLFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSqlFieldName);
        FormData fdlSqlFieldName = new FormData();
        fdlSqlFieldName.left = new FormAttachment(0, 0);
        fdlSqlFieldName.right = new FormAttachment(middle, -margin);
        fdlSqlFieldName.top = new FormAttachment(this.wConnection, 2 * margin);
        wlSqlFieldName.setLayoutData((Object)fdlSqlFieldName);
        this.wSqlFieldName = new CCombo((Composite)this.shell, 2056);
        this.wSqlFieldName.setEditable(true);
        this.props.setLook((Control)this.wSqlFieldName);
        this.wSqlFieldName.addModifyListener(lsMod);
        FormData fdSqlFieldName = new FormData();
        fdSqlFieldName.left = new FormAttachment(middle, 0);
        fdSqlFieldName.top = new FormAttachment(this.wConnection, 2 * margin);
        fdSqlFieldName.right = new FormAttachment(100, -margin);
        this.wSqlFieldName.setLayoutData((Object)fdSqlFieldName);
        this.wSqlFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DynamicSqlRowDialog.this.shell.getDisplay(), 1);
                DynamicSqlRowDialog.this.shell.setCursor(busy);
                DynamicSqlRowDialog.this.get();
                DynamicSqlRowDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel}, margin, null);
        Label wlLimit = new Label((Composite)this.shell, 131072);
        wlLimit.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Limit.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLimit);
        FormData fdlLimit = new FormData();
        fdlLimit.left = new FormAttachment(0, 0);
        fdlLimit.right = new FormAttachment(middle, -margin);
        fdlLimit.top = new FormAttachment((Control)this.wSqlFieldName, margin);
        wlLimit.setLayoutData((Object)fdlLimit);
        this.wLimit = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        FormData fdLimit = new FormData();
        fdLimit.left = new FormAttachment(middle, 0);
        fdLimit.right = new FormAttachment(100, 0);
        fdLimit.top = new FormAttachment((Control)this.wSqlFieldName, margin);
        this.wLimit.setLayoutData((Object)fdLimit);
        Label wlOuter = new Label((Composite)this.shell, 131072);
        wlOuter.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Outerjoin.Label", (String[])new String[0]));
        wlOuter.setToolTipText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Outerjoin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlOuter);
        FormData fdlOuter = new FormData();
        fdlOuter.left = new FormAttachment(0, 0);
        fdlOuter.right = new FormAttachment(middle, -margin);
        fdlOuter.top = new FormAttachment((Control)this.wLimit, margin);
        wlOuter.setLayoutData((Object)fdlOuter);
        this.wOuter = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wOuter);
        this.wOuter.setToolTipText(wlOuter.getToolTipText());
        FormData fdOuter = new FormData();
        fdOuter.left = new FormAttachment(middle, 0);
        fdOuter.top = new FormAttachment((Control)wlOuter, 0, 0x1000000);
        this.wOuter.setLayoutData((Object)fdOuter);
        this.wOuter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicSqlRowDialog.this.input.setChanged();
            }
        });
        Label wluseVars = new Label((Composite)this.shell, 131072);
        wluseVars.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.useVarsjoin.Label", (String[])new String[0]));
        wluseVars.setToolTipText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.useVarsjoin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wluseVars);
        FormData fdluseVars = new FormData();
        fdluseVars.left = new FormAttachment(0, 0);
        fdluseVars.right = new FormAttachment(middle, -margin);
        fdluseVars.top = new FormAttachment((Control)this.wOuter, margin);
        wluseVars.setLayoutData((Object)fdluseVars);
        this.wuseVars = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wuseVars);
        this.wuseVars.setToolTipText(wluseVars.getToolTipText());
        FormData fduseVars = new FormData();
        fduseVars.left = new FormAttachment(middle, 0);
        fduseVars.top = new FormAttachment((Control)wluseVars, 0, 0x1000000);
        this.wuseVars.setLayoutData((Object)fduseVars);
        this.wuseVars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicSqlRowDialog.this.input.setChanged();
            }
        });
        Label wlqueryOnlyOnChange = new Label((Composite)this.shell, 131072);
        wlqueryOnlyOnChange.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.queryOnlyOnChangejoin.Label", (String[])new String[0]));
        wlqueryOnlyOnChange.setToolTipText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.queryOnlyOnChangejoin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)wlqueryOnlyOnChange);
        FormData fdlqueryOnlyOnChange = new FormData();
        fdlqueryOnlyOnChange.left = new FormAttachment(0, 0);
        fdlqueryOnlyOnChange.right = new FormAttachment(middle, -margin);
        fdlqueryOnlyOnChange.top = new FormAttachment((Control)this.wuseVars, margin);
        wlqueryOnlyOnChange.setLayoutData((Object)fdlqueryOnlyOnChange);
        this.wqueryOnlyOnChange = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wqueryOnlyOnChange);
        this.wqueryOnlyOnChange.setToolTipText(wlqueryOnlyOnChange.getToolTipText());
        FormData fdqueryOnlyOnChange = new FormData();
        fdqueryOnlyOnChange.left = new FormAttachment(middle, 0);
        fdqueryOnlyOnChange.top = new FormAttachment((Control)wlqueryOnlyOnChange, 0, 0x1000000);
        this.wqueryOnlyOnChange.setLayoutData((Object)fdqueryOnlyOnChange);
        this.wqueryOnlyOnChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicSqlRowDialog.this.input.setChanged();
            }
        });
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        fdlPosition.right = new FormAttachment(100, 0);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        Label wlSql = new Label((Composite)this.shell, 0);
        wlSql.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.SQL.Label", (String[])new String[0]));
        this.props.setLook((Control)wlSql);
        FormData fdlSql = new FormData();
        fdlSql.left = new FormAttachment(0, 0);
        fdlSql.top = new FormAttachment((Control)this.wqueryOnlyOnChange, margin);
        wlSql.setLayoutData((Object)fdlSql);
        this.wSql = new StyledTextComp(this.variables, (Composite)this.shell, 19202);
        this.props.setLook((Control)this.wSql, 1);
        FormData fdSql = new FormData();
        fdSql.left = new FormAttachment(0, 0);
        fdSql.top = new FormAttachment((Control)wlSql, margin);
        fdSql.right = new FormAttachment(100, -2 * margin);
        fdSql.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wSql.setLayoutData((Object)fdSql);
        this.wSql.addModifyListener(arg0 -> this.setPosition());
        this.wSql.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DynamicSqlRowDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                DynamicSqlRowDialog.this.setPosition();
            }
        });
        this.wSql.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DynamicSqlRowDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                DynamicSqlRowDialog.this.setPosition();
            }
        });
        this.wSql.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DynamicSqlRowDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                DynamicSqlRowDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                DynamicSqlRowDialog.this.setPosition();
            }
        });
        this.wSql.addModifyListener(lsMod);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void setPosition() {
        int lineNumber = this.wSql.getLineNumber();
        int columnNumber = this.wSql.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Position.Label", (String[])new String[]{"" + lineNumber, "" + columnNumber}));
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wSql.setText(Const.NVL((String)this.input.getSql(), (String)""));
        this.wLimit.setText("" + this.input.getRowLimit());
        this.wOuter.setSelection(this.input.isOuterJoin());
        this.wuseVars.setSelection(this.input.isVariableReplace());
        if (this.input.getSqlFieldName() != null) {
            this.wSqlFieldName.setText(this.input.getSqlFieldName());
        }
        this.wqueryOnlyOnChange.setSelection(this.input.isQueryOnlyOnChange());
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.input.setRowLimit(Const.toInt((String)this.wLimit.getText(), (int)0));
        this.input.setSql(this.wSql.getText());
        this.input.setSqlFieldName(this.wSqlFieldName.getText());
        this.input.setOuterJoin(this.wOuter.getSelection());
        this.input.setVariableReplace(this.wuseVars.getSelection());
        this.input.setQueryOnlyOnChange(this.wqueryOnlyOnChange.getSelection());
        this.input.setDatabaseMeta(this.pipelineMeta.findDatabase(this.wConnection.getText()));
        this.transformName = this.wTransformName.getText();
        if (this.pipelineMeta.findDatabase(this.wConnection.getText()) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            try {
                String sqlfield = this.wSqlFieldName.getText();
                this.wSqlFieldName.removeAll();
                IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
                if (r != null) {
                    this.wSqlFieldName.removeAll();
                    this.wSqlFieldName.setItems(r.getFieldNames());
                }
                if (sqlfield != null) {
                    this.wSqlFieldName.setText(sqlfield);
                }
            }
            catch (HopException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

