/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.dynamicsqlrow;

import java.sql.ResultSet;
import org.apache.hop.core.Const;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.dynamicsqlrow.DynamicSqlRowData;
import org.apache.hop.pipeline.transforms.dynamicsqlrow.DynamicSqlRowMeta;

public class DynamicSqlRow
extends BaseTransform<DynamicSqlRowMeta, DynamicSqlRowData>
implements ITransform<DynamicSqlRowMeta, DynamicSqlRowData> {
    private static final Class<?> PKG = DynamicSqlRowMeta.class;

    public DynamicSqlRow(TransformMeta transformMeta, DynamicSqlRowMeta meta, DynamicSqlRowData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    private synchronized void lookupValues(IRowMeta rowMeta, Object[] rowData) throws HopException {
        boolean loadFromBuffer = true;
        if (this.first) {
            this.first = false;
            ((DynamicSqlRowData)this.data).outputRowMeta = rowMeta.clone();
            ((DynamicSqlRowMeta)this.meta).getFields(((DynamicSqlRowData)this.data).outputRowMeta, this.getTransformName(), new IRowMeta[]{((DynamicSqlRowMeta)this.meta).getTableFields((IVariables)this)}, null, (IVariables)this, this.metadataProvider);
            loadFromBuffer = false;
        }
        if (this.log.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.CheckingRow", (String[])new String[0]) + rowMeta.getString(rowData));
        }
        String sqlTemp = this.getInputRowMeta().getString(rowData, ((DynamicSqlRowData)this.data).indexOfSqlField);
        String sql = null;
        sql = ((DynamicSqlRowMeta)this.meta).isVariableReplace() ? this.resolve(sqlTemp) : sqlTemp;
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.SQLStatement", (String[])new String[]{sql}));
        }
        if (((DynamicSqlRowMeta)this.meta).isQueryOnlyOnChange()) {
            if (loadFromBuffer && ((DynamicSqlRowData)this.data).previousSql != null && !((DynamicSqlRowData)this.data).previousSql.equals(sql)) {
                loadFromBuffer = false;
            }
            ((DynamicSqlRowData)this.data).previousSql = sql;
        } else {
            loadFromBuffer = false;
        }
        if (loadFromBuffer) {
            this.incrementLinesInput();
            if (!((DynamicSqlRowData)this.data).skipPreviousRow) {
                Object[] newRow = RowDataUtil.resizeArray((Object[])rowData, (int)((DynamicSqlRowData)this.data).outputRowMeta.size());
                int newIndex = rowMeta.size();
                IRowMeta addMeta = ((DynamicSqlRowData)this.data).db.getReturnRowMeta();
                for (int p = 0; p < ((DynamicSqlRowData)this.data).previousrowbuffer.size(); ++p) {
                    Object[] getBufferRow = ((DynamicSqlRowData)this.data).previousrowbuffer.get(p);
                    for (int i = 0; i < addMeta.size(); ++i) {
                        newRow[newIndex++] = getBufferRow[i];
                    }
                    this.putRow(((DynamicSqlRowData)this.data).outputRowMeta, ((DynamicSqlRowData)this.data).outputRowMeta.cloneRow(newRow));
                }
            }
        } else {
            int newIndex;
            Object[] newRow;
            if (((DynamicSqlRowMeta)this.meta).isQueryOnlyOnChange()) {
                ((DynamicSqlRowData)this.data).previousrowbuffer.clear();
            }
            ResultSet rs = ((DynamicSqlRowData)this.data).db.openQuery(sql);
            Object[] add = ((DynamicSqlRowData)this.data).db.getRow(rs);
            IRowMeta addMeta = ((DynamicSqlRowData)this.data).db.getReturnRowMeta();
            if (add != null) {
                int nrTemplateFields = ((DynamicSqlRowData)this.data).outputRowMeta.size() - this.getInputRowMeta().size();
                if (addMeta.size() != nrTemplateFields) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Exception.IncorrectNrTemplateFields", (Object[])new Object[]{nrTemplateFields, addMeta.size(), sql}));
                }
                StringBuilder typeErrors = new StringBuilder();
                for (int i = 0; i < addMeta.size(); ++i) {
                    IValueMeta templateValueMeta = addMeta.getValueMeta(i);
                    IValueMeta outputValueMeta = ((DynamicSqlRowData)this.data).outputRowMeta.getValueMeta(this.getInputRowMeta().size() + i);
                    if (templateValueMeta.getType() == outputValueMeta.getType()) continue;
                    if (typeErrors.length() > 0) {
                        typeErrors.append(Const.CR);
                    }
                    typeErrors.append(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Exception.TemplateReturnDataTypeError", (String[])new String[]{templateValueMeta.toString(), outputValueMeta.toString()}));
                }
                if (typeErrors.length() > 0) {
                    throw new HopException(typeErrors.toString());
                }
            }
            this.incrementLinesInput();
            int counter = 0;
            while (add != null && (((DynamicSqlRowMeta)this.meta).getRowLimit() == 0 || counter < ((DynamicSqlRowMeta)this.meta).getRowLimit())) {
                ++counter;
                newRow = RowDataUtil.resizeArray((Object[])rowData, (int)((DynamicSqlRowData)this.data).outputRowMeta.size());
                newIndex = rowMeta.size();
                for (int i = 0; i < addMeta.size(); ++i) {
                    newRow[newIndex++] = add[i];
                }
                this.putRow(((DynamicSqlRowData)this.data).outputRowMeta, ((DynamicSqlRowData)this.data).outputRowMeta.cloneRow(newRow));
                if (((DynamicSqlRowMeta)this.meta).isQueryOnlyOnChange()) {
                    ((DynamicSqlRowData)this.data).previousrowbuffer.add(add);
                    ((DynamicSqlRowData)this.data).skipPreviousRow = false;
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.PutoutRow", (String[])new String[0]) + ((DynamicSqlRowData)this.data).outputRowMeta.getString(newRow));
                }
                if (((DynamicSqlRowMeta)this.meta).getRowLimit() != 0 && counter >= ((DynamicSqlRowMeta)this.meta).getRowLimit()) continue;
                add = ((DynamicSqlRowData)this.data).db.getRow(rs);
                this.incrementLinesInput();
            }
            if (counter == 0 && ((DynamicSqlRowMeta)this.meta).isOuterJoin()) {
                if (((DynamicSqlRowData)this.data).notfound == null) {
                    ((DynamicSqlRowData)this.data).notfound = new Object[((DynamicSqlRowData)this.data).db.getReturnRowMeta().size()];
                }
                newRow = RowDataUtil.resizeArray((Object[])rowData, (int)((DynamicSqlRowData)this.data).outputRowMeta.size());
                newIndex = rowMeta.size();
                for (int i = 0; i < ((DynamicSqlRowData)this.data).notfound.length; ++i) {
                    newRow[newIndex++] = ((DynamicSqlRowData)this.data).notfound[i];
                }
                this.putRow(((DynamicSqlRowData)this.data).outputRowMeta, newRow);
                if (((DynamicSqlRowMeta)this.meta).isQueryOnlyOnChange()) {
                    ((DynamicSqlRowData)this.data).previousrowbuffer.add(((DynamicSqlRowData)this.data).notfound);
                    ((DynamicSqlRowData)this.data).skipPreviousRow = false;
                }
            } else if (((DynamicSqlRowMeta)this.meta).isQueryOnlyOnChange() && counter == 0 && !((DynamicSqlRowMeta)this.meta).isOuterJoin()) {
                ((DynamicSqlRowData)this.data).skipPreviousRow = true;
            }
            if (((DynamicSqlRowData)this.data).db != null) {
                ((DynamicSqlRowData)this.data).db.closeQuery(rs);
            }
        }
    }

    public boolean processRow() throws HopException {
        block10: {
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                if (Utils.isEmpty((CharSequence)((DynamicSqlRowMeta)this.meta).getSqlFieldName())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Exception.SQLFieldNameEmpty", (String[])new String[0]));
                }
                if (Utils.isEmpty((CharSequence)((DynamicSqlRowMeta)this.meta).getSql())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Exception.SQLEmpty", (String[])new String[0]));
                }
                if (((DynamicSqlRowData)this.data).indexOfSqlField < 0) {
                    ((DynamicSqlRowData)this.data).indexOfSqlField = this.getInputRowMeta().indexOfValue(((DynamicSqlRowMeta)this.meta).getSqlFieldName());
                    if (((DynamicSqlRowData)this.data).indexOfSqlField < 0) {
                        throw new HopException(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Exception.FieldNotFound", (String[])new String[]{((DynamicSqlRowMeta)this.meta).getSqlFieldName()}));
                    }
                }
            }
            try {
                this.lookupValues(this.getInputRowMeta(), r);
                if (this.checkFeedback(this.getLinesRead()) && this.log.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.LineNumber", (String[])new String[0]) + this.getLinesRead());
                }
            }
            catch (HopException e) {
                boolean sendToErrorRow = false;
                String errorMessage = null;
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block10;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "DynamicSQLRow001");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning() throws HopException {
        if (((DynamicSqlRowData)this.data).db != null && !((DynamicSqlRowData)this.data).isCanceled) {
            Database database = ((DynamicSqlRowData)this.data).db;
            synchronized (database) {
                ((DynamicSqlRowData)this.data).db.cancelQuery();
            }
            this.setStopped(true);
            ((DynamicSqlRowData)this.data).isCanceled = true;
        }
    }

    public boolean init() {
        block5: {
            if (super.init()) {
                if (((DynamicSqlRowMeta)this.meta).getDatabaseMeta() == null) {
                    this.logError(BaseMessages.getString(PKG, (String)"DynmaicSQLRow.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                    return false;
                }
                ((DynamicSqlRowData)this.data).db = new Database((ILoggingObject)this, this.variables, ((DynamicSqlRowMeta)this.meta).getDatabaseMeta());
                try {
                    ((DynamicSqlRowData)this.data).db.connect();
                    ((DynamicSqlRowData)this.data).db.setCommit(100);
                    if (this.log.isDetailed()) {
                        this.logDetailed(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.ConnectedToDB", (String[])new String[0]));
                    }
                    ((DynamicSqlRowData)this.data).db.setQueryLimit(((DynamicSqlRowMeta)this.meta).getRowLimit());
                    return true;
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"DynamicSQLRow.Log.DatabaseError", (String[])new String[0]) + e.getMessage());
                    if (((DynamicSqlRowData)this.data).db == null) break block5;
                    ((DynamicSqlRowData)this.data).db.disconnect();
                }
            }
        }
        return false;
    }

    public void dispose() {
        if (((DynamicSqlRowData)this.data).db != null) {
            ((DynamicSqlRowData)this.data).db.disconnect();
        }
        super.dispose();
    }
}

