/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PTransformMatchers;
import org.apache.beam.runners.core.construction.PTransformReplacements;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.ReplacementOutputs;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.runners.PTransformMatcher;
import org.apache.beam.sdk.runners.PTransformOverride;
import org.apache.beam.sdk.runners.PTransformOverrideFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.reflect.DoFnInvoker;
import org.apache.beam.sdk.transforms.reflect.DoFnInvokers;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PCollectionViews;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;

public class SplittableParDo<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>
extends PTransform<PCollection<InputT>, PCollectionTuple> {
    private final DoFn<InputT, OutputT> doFn;
    private final List<PCollectionView<?>> sideInputs;
    private final TupleTag<OutputT> mainOutputTag;
    private final TupleTagList additionalOutputTags;
    private final Map<TupleTag<?>, Coder<?>> outputTagsToCoders;
    public static final String SPLITTABLE_PROCESS_URN = "beam:runners_core:transforms:splittable_process:v1";
    public static final String SPLITTABLE_GBKIKWI_URN = "beam:runners_core:transforms:splittable_gbkikwi:v1";
    public static final PTransformOverride PRIMITIVE_BOUNDED_READ_OVERRIDE = PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Read.Bounded.class), new BoundedReadOverrideFactory());
    public static final PTransformOverride PRIMITIVE_UNBOUNDED_READ_OVERRIDE = PTransformOverride.of((PTransformMatcher)PTransformMatchers.classEqualTo(Read.Unbounded.class), new UnboundedReadOverrideFactory());

    private SplittableParDo(DoFn<InputT, OutputT> doFn, List<PCollectionView<?>> sideInputs, TupleTag<OutputT> mainOutputTag, TupleTagList additionalOutputTags, Map<TupleTag<?>, Coder<?>> outputTagsToCoders) {
        Preconditions.checkArgument((boolean)DoFnSignatures.getSignature(doFn.getClass()).processElement().isSplittable(), (Object)"fn must be a splittable DoFn");
        this.doFn = doFn;
        this.sideInputs = sideInputs;
        this.mainOutputTag = mainOutputTag;
        this.additionalOutputTags = additionalOutputTags;
        this.outputTagsToCoders = outputTagsToCoders;
    }

    public static <InputT, OutputT> SplittableParDo<InputT, OutputT, ?, ?> forAppliedParDo(AppliedPTransform<PCollection<InputT>, PCollectionTuple, ?> parDo) {
        Preconditions.checkArgument((parDo != null ? 1 : 0) != 0, (Object)"parDo must not be null");
        try {
            HashMap outputTagsToCoders = Maps.newHashMap();
            for (Map.Entry entry : parDo.getOutputs().entrySet()) {
                outputTagsToCoders.put((TupleTag)entry.getKey(), ((PCollection)entry.getValue()).getCoder());
            }
            return new SplittableParDo(ParDoTranslation.getDoFn(parDo), ParDoTranslation.getSideInputs(parDo), ParDoTranslation.getMainOutputTag(parDo), ParDoTranslation.getAdditionalOutputTags(parDo), outputTagsToCoders);
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public PCollectionTuple expand(PCollection<InputT> input) {
        Coder restrictionCoder = DoFnInvokers.invokerFor(this.doFn).invokeGetRestrictionCoder(input.getPipeline().getCoderRegistry());
        Coder watermarkEstimatorStateCoder = DoFnInvokers.invokerFor(this.doFn).invokeGetWatermarkEstimatorStateCoder(input.getPipeline().getCoderRegistry());
        KvCoder splitCoder = KvCoder.of((Coder)input.getCoder(), (Coder)restrictionCoder);
        PCollection keyedRestrictions = (PCollection)((PCollection)((PCollection)((PCollection)input.apply("Pair with initial restriction", (PTransform)ParDo.of(new PairWithRestrictionFn(this.doFn)))).setCoder((Coder)splitCoder).apply("Split restriction", (PTransform)ParDo.of(new SplitRestrictionFn(this.doFn)))).setCoder((Coder)splitCoder).apply("Explode windows", (PTransform)ParDo.of(new ExplodeWindowsFn()))).apply("Assign unique key", (PTransform)WithKeys.of(new RandomUniqueKeyFn()));
        return (PCollectionTuple)keyedRestrictions.apply("ProcessKeyedElements", new ProcessKeyedElements(this.doFn, input.getCoder(), restrictionCoder, watermarkEstimatorStateCoder, input.getWindowingStrategy(), this.sideInputs, this.mainOutputTag, this.additionalOutputTags, this.outputTagsToCoders));
    }

    public Map<TupleTag<?>, PValue> getAdditionalInputs() {
        return PCollectionViews.toAdditionalInputs(this.sideInputs);
    }

    public static void convertReadBasedSplittableDoFnsToPrimitiveReadsIfNecessary(Pipeline pipeline) {
        if (!ExperimentalOptions.hasExperiment((PipelineOptions)pipeline.getOptions(), (String)"use_sdf_read") || ExperimentalOptions.hasExperiment((PipelineOptions)pipeline.getOptions(), (String)"beam_fn_api_use_deprecated_read") || ExperimentalOptions.hasExperiment((PipelineOptions)pipeline.getOptions(), (String)"use_deprecated_read")) {
            SplittableParDo.convertReadBasedSplittableDoFnsToPrimitiveReads(pipeline);
        }
    }

    public static void convertReadBasedSplittableDoFnsToPrimitiveReads(Pipeline pipeline) {
        pipeline.replaceAll((List)ImmutableList.of((Object)PRIMITIVE_BOUNDED_READ_OVERRIDE, (Object)PRIMITIVE_UNBOUNDED_READ_OVERRIDE));
    }

    public static class PrimitiveUnboundedRead<T>
    extends PrimitiveRead<T> {
        public PrimitiveUnboundedRead(Read.Unbounded<T> originalTransform) {
            super(originalTransform, originalTransform.getSource());
        }

        public PCollection<T> expand(PBegin input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.UNBOUNDED, (Coder)this.getSource().getOutputCoder());
        }

        public UnboundedSource<T, ? extends UnboundedSource.CheckpointMark> getSource() {
            return (UnboundedSource)this.source;
        }
    }

    public static class PrimitiveBoundedRead<T>
    extends PrimitiveRead<T> {
        public PrimitiveBoundedRead(Read.Bounded<T> originalTransform) {
            super(originalTransform, originalTransform.getSource());
        }

        public PCollection<T> expand(PBegin input) {
            return PCollection.createPrimitiveOutputInternal((Pipeline)input.getPipeline(), (WindowingStrategy)WindowingStrategy.globalDefault(), (PCollection.IsBounded)PCollection.IsBounded.BOUNDED, (Coder)this.getSource().getOutputCoder());
        }

        public BoundedSource<T> getSource() {
            return (BoundedSource)this.source;
        }
    }

    private static abstract class PrimitiveRead<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final PTransform<PBegin, PCollection<T>> originalTransform;
        protected final Object source;

        public PrimitiveRead(PTransform<PBegin, PCollection<T>> originalTransform, Object source) {
            this.originalTransform = originalTransform;
            this.source = source;
        }

        public void validate(@Nullable PipelineOptions options) {
            this.originalTransform.validate(options);
        }

        public Map<TupleTag<?>, PValue> getAdditionalInputs() {
            return this.originalTransform.getAdditionalInputs();
        }

        public <CoderT> Coder<CoderT> getDefaultOutputCoder(PBegin input, PCollection<CoderT> output) throws CannotProvideCoderException {
            return this.originalTransform.getDefaultOutputCoder((PInput)input, output);
        }

        public String getName() {
            return this.originalTransform.getName();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.originalTransform.populateDisplayData(builder);
        }

        protected String getKindString() {
            return String.format("Read(%s)", NameUtils.approximateSimpleName((Object)this.source));
        }
    }

    private static class UnboundedReadOverrideFactory<T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Read.Unbounded<T>> {
        private UnboundedReadOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<T>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<T>, Read.Unbounded<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), new PrimitiveUnboundedRead((Read.Unbounded)transform.getTransform()));
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class BoundedReadOverrideFactory<T>
    implements PTransformOverrideFactory<PBegin, PCollection<T>, Read.Bounded<T>> {
        private BoundedReadOverrideFactory() {
        }

        public PTransformOverrideFactory.PTransformReplacement<PBegin, PCollection<T>> getReplacementTransform(AppliedPTransform<PBegin, PCollection<T>, Read.Bounded<T>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of((PInput)transform.getPipeline().begin(), new PrimitiveBoundedRead((Read.Bounded)transform.getTransform()));
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollection<T> newOutput) {
            return ReplacementOutputs.singleton(outputs, newOutput);
        }
    }

    private static class SplitRestrictionFn<InputT, RestrictionT>
    extends DoFn<KV<InputT, RestrictionT>, KV<InputT, RestrictionT>> {
        private final DoFn<InputT, ?> splittableFn;
        private transient @Nullable DoFnInvoker<InputT, ?> invoker;

        SplitRestrictionFn(DoFn<InputT, ?> splittableFn) {
            this.splittableFn = splittableFn;
        }

        @DoFn.Setup
        public void setup(PipelineOptions options) {
            this.invoker = DoFnInvokers.tryInvokeSetupFor(this.splittableFn, (PipelineOptions)options);
        }

        @DoFn.ProcessElement
        public void processElement(final DoFn.ProcessContext c, final BoundedWindow w) {
            this.invoker.invokeSplitRestriction((DoFnInvoker.ArgumentProvider)new DoFnInvoker.BaseArgumentProvider<InputT, RestrictionT>(){

                public InputT element(DoFn<InputT, RestrictionT> doFn) {
                    return ((KV)c.element()).getKey();
                }

                public Object restriction() {
                    return ((KV)c.element()).getValue();
                }

                public RestrictionTracker<?, ?> restrictionTracker() {
                    return invoker.invokeNewTracker((DoFnInvoker.ArgumentProvider)this);
                }

                public Instant timestamp(DoFn<InputT, RestrictionT> doFn) {
                    return c.timestamp();
                }

                public PipelineOptions pipelineOptions() {
                    return c.getPipelineOptions();
                }

                public PaneInfo paneInfo(DoFn<InputT, RestrictionT> doFn) {
                    return c.pane();
                }

                public BoundedWindow window() {
                    return w;
                }

                public DoFn.OutputReceiver<RestrictionT> outputReceiver(DoFn<InputT, RestrictionT> doFn) {
                    return new DoFn.OutputReceiver<RestrictionT>(){

                        public void output(RestrictionT part) {
                            c.output((Object)KV.of((Object)((KV)c.element()).getKey(), part));
                        }

                        public void outputWithTimestamp(RestrictionT part, Instant timestamp) {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                public String getErrorContext() {
                    return SplitRestrictionFn.class.getSimpleName() + ".invokeSplitRestriction";
                }
            });
        }

        @DoFn.Teardown
        public void tearDown() {
            this.invoker.invokeTeardown();
            this.invoker = null;
        }
    }

    private static class PairWithRestrictionFn<InputT, OutputT, RestrictionT>
    extends DoFn<InputT, KV<InputT, RestrictionT>> {
        private DoFn<InputT, OutputT> fn;
        private transient @Nullable DoFnInvoker<InputT, OutputT> invoker;

        PairWithRestrictionFn(DoFn<InputT, OutputT> fn) {
            this.fn = fn;
        }

        @DoFn.Setup
        public void setup(PipelineOptions options) {
            this.invoker = DoFnInvokers.tryInvokeSetupFor(this.fn, (PipelineOptions)options);
        }

        @DoFn.ProcessElement
        public void processElement(final DoFn.ProcessContext context, final BoundedWindow w) {
            context.output((Object)KV.of((Object)context.element(), (Object)this.invoker.invokeGetInitialRestriction((DoFnInvoker.ArgumentProvider)new DoFnInvoker.BaseArgumentProvider<InputT, OutputT>(){

                public InputT element(DoFn<InputT, OutputT> doFn) {
                    return context.element();
                }

                public Instant timestamp(DoFn<InputT, OutputT> doFn) {
                    return context.timestamp();
                }

                public PipelineOptions pipelineOptions() {
                    return context.getPipelineOptions();
                }

                public PaneInfo paneInfo(DoFn<InputT, OutputT> doFn) {
                    return context.pane();
                }

                public BoundedWindow window() {
                    return w;
                }

                public String getErrorContext() {
                    return PairWithRestrictionFn.class.getSimpleName() + ".invokeGetInitialRestriction";
                }
            })));
        }

        @DoFn.Teardown
        public void tearDown() {
            this.invoker.invokeTeardown();
            this.invoker = null;
        }
    }

    private static class RandomUniqueKeyFn<T>
    implements SerializableFunction<T, byte[]> {
        private RandomUniqueKeyFn() {
        }

        public byte[] apply(T input) {
            byte[] key = new byte[128];
            ThreadLocalRandom.current().nextBytes(key);
            return key;
        }
    }

    public static class ProcessKeyedElementsTranslator
    implements PTransformTranslation.TransformPayloadTranslator<ProcessKeyedElements<?, ?, ?, ?>> {
        public static PTransformTranslation.TransformPayloadTranslator create() {
            return new ProcessKeyedElementsTranslator();
        }

        private ProcessKeyedElementsTranslator() {
        }

        @Override
        public String getUrn(ProcessKeyedElements<?, ?, ?, ?> transform) {
            return "beam:transform:sdf_process_keyed_elements:v1";
        }

        @Override
        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, ProcessKeyedElements<?, ?, ?, ?>> transform, SdkComponents components) throws IOException {
            final ProcessKeyedElements pke = (ProcessKeyedElements)transform.getTransform();
            final DoFn fn = pke.getFn();
            final DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
            final String restrictionCoderId = components.registerCoder(pke.getRestrictionCoder());
            RunnerApi.ParDoPayload payload = ParDoTranslation.payloadForParDoLike(new ParDoTranslation.ParDoLike(){

                @Override
                public RunnerApi.FunctionSpec translateDoFn(SdkComponents newComponents) {
                    return ParDoTranslation.translateDoFn(fn, pke.getMainOutputTag(), Collections.emptyMap(), DoFnSchemaInformation.create(), newComponents);
                }

                @Override
                public Map<String, RunnerApi.SideInput> translateSideInputs(SdkComponents components) {
                    return ParDoTranslation.translateSideInputs(pke.getSideInputs(), components);
                }

                @Override
                public Map<String, RunnerApi.StateSpec> translateStateSpecs(SdkComponents components) {
                    return ImmutableMap.of();
                }

                @Override
                public Map<String, RunnerApi.TimerFamilySpec> translateTimerFamilySpecs(SdkComponents newComponents) {
                    return ImmutableMap.of();
                }

                @Override
                public boolean isStateful() {
                    return !signature.stateDeclarations().isEmpty() || !signature.timerDeclarations().isEmpty() || !signature.timerFamilyDeclarations().isEmpty();
                }

                @Override
                public boolean isSplittable() {
                    return true;
                }

                @Override
                public boolean isRequiresStableInput() {
                    return signature.processElement().requiresStableInput();
                }

                @Override
                public boolean isRequiresTimeSortedInput() {
                    return signature.processElement().requiresTimeSortedInput();
                }

                @Override
                public boolean requestsFinalization() {
                    return signature.startBundle() != null && signature.startBundle().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer()) || signature.processElement() != null && signature.processElement().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer()) || signature.finishBundle() != null && signature.finishBundle().extraParameters().contains(DoFnSignature.Parameter.bundleFinalizer());
                }

                @Override
                public String translateRestrictionCoderId(SdkComponents newComponents) {
                    return restrictionCoderId;
                }
            }, components);
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn(pke)).setPayload(payload.toByteString()).build();
        }
    }

    public static class Registrar
    implements TransformPayloadTranslatorRegistrar {
        @Override
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.builder().put(ProcessKeyedElements.class, (Object)new ProcessKeyedElementsTranslator()).build();
        }
    }

    public static class ProcessKeyedElements<InputT, OutputT, RestrictionT, WatermarkEstimatorStateT>
    extends PTransform<PCollection<KV<byte[], KV<InputT, RestrictionT>>>, PCollectionTuple> {
        private final DoFn<InputT, OutputT> fn;
        private final Coder<InputT> elementCoder;
        private final Coder<RestrictionT> restrictionCoder;
        private final Coder<WatermarkEstimatorStateT> watermarkEstimatorStateCoder;
        private final WindowingStrategy<InputT, ?> windowingStrategy;
        private final List<PCollectionView<?>> sideInputs;
        private final TupleTag<OutputT> mainOutputTag;
        private final TupleTagList additionalOutputTags;
        private final Map<TupleTag<?>, Coder<?>> outputTagsToCoders;

        public ProcessKeyedElements(DoFn<InputT, OutputT> fn, Coder<InputT> elementCoder, Coder<RestrictionT> restrictionCoder, Coder<WatermarkEstimatorStateT> watermarkEstimatorStateCoder, WindowingStrategy<InputT, ?> windowingStrategy, List<PCollectionView<?>> sideInputs, TupleTag<OutputT> mainOutputTag, TupleTagList additionalOutputTags, Map<TupleTag<?>, Coder<?>> outputTagsToCoders) {
            this.fn = fn;
            this.elementCoder = elementCoder;
            this.restrictionCoder = restrictionCoder;
            this.watermarkEstimatorStateCoder = watermarkEstimatorStateCoder;
            this.windowingStrategy = windowingStrategy;
            this.sideInputs = sideInputs;
            this.mainOutputTag = mainOutputTag;
            this.additionalOutputTags = additionalOutputTags;
            this.outputTagsToCoders = outputTagsToCoders;
        }

        public DoFn<InputT, OutputT> getFn() {
            return this.fn;
        }

        public Coder<InputT> getElementCoder() {
            return this.elementCoder;
        }

        public Coder<RestrictionT> getRestrictionCoder() {
            return this.restrictionCoder;
        }

        public Coder<WatermarkEstimatorStateT> getWatermarkEstimatorStateCoder() {
            return this.watermarkEstimatorStateCoder;
        }

        public WindowingStrategy<InputT, ?> getInputWindowingStrategy() {
            return this.windowingStrategy;
        }

        public List<PCollectionView<?>> getSideInputs() {
            return this.sideInputs;
        }

        public TupleTag<OutputT> getMainOutputTag() {
            return this.mainOutputTag;
        }

        public TupleTagList getAdditionalOutputTags() {
            return this.additionalOutputTags;
        }

        public Map<TupleTag<?>, Coder<?>> getOutputTagsToCoders() {
            return this.outputTagsToCoders;
        }

        public PCollectionTuple expand(PCollection<KV<byte[], KV<InputT, RestrictionT>>> input) {
            return ProcessKeyedElements.createPrimitiveOutputFor(input, this.fn, this.mainOutputTag, this.additionalOutputTags, this.outputTagsToCoders, this.windowingStrategy);
        }

        public static <OutputT> PCollectionTuple createPrimitiveOutputFor(PCollection<?> input, DoFn<?, OutputT> fn, TupleTag<OutputT> mainOutputTag, TupleTagList additionalOutputTags, Map<TupleTag<?>, Coder<?>> outputTagsToCoders, WindowingStrategy<?, ?> windowingStrategy) {
            DoFnSignature signature = DoFnSignatures.getSignature(fn.getClass());
            PCollectionTuple outputs = PCollectionTuple.ofPrimitiveOutputsInternal((Pipeline)input.getPipeline(), (TupleTagList)TupleTagList.of(mainOutputTag).and(additionalOutputTags.getAll()), outputTagsToCoders, windowingStrategy, (PCollection.IsBounded)input.isBounded().and(signature.isBoundedPerElement()));
            outputs.get(mainOutputTag).setTypeDescriptor(fn.getOutputTypeDescriptor());
            return outputs;
        }

        public Map<TupleTag<?>, PValue> getAdditionalInputs() {
            return PCollectionViews.toAdditionalInputs(this.sideInputs);
        }
    }

    private static class ExplodeWindowsFn<InputT>
    extends DoFn<InputT, InputT> {
        private ExplodeWindowsFn() {
        }

        @DoFn.ProcessElement
        public void process(DoFn.ProcessContext c, BoundedWindow window) {
            c.output(c.element());
        }
    }

    public static class OverrideFactory<InputT, OutputT>
    implements PTransformOverrideFactory<PCollection<InputT>, PCollectionTuple, ParDo.MultiOutput<InputT, OutputT>> {
        public PTransformOverrideFactory.PTransformReplacement<PCollection<InputT>, PCollectionTuple> getReplacementTransform(AppliedPTransform<PCollection<InputT>, PCollectionTuple, ParDo.MultiOutput<InputT, OutputT>> transform) {
            return PTransformOverrideFactory.PTransformReplacement.of(PTransformReplacements.getSingletonMainInput(transform), SplittableParDo.forAppliedParDo(transform));
        }

        public Map<PCollection<?>, PTransformOverrideFactory.ReplacementOutput> mapOutputs(Map<TupleTag<?>, PCollection<?>> outputs, PCollectionTuple newOutput) {
            return ReplacementOutputs.tagged(outputs, (POutput)newOutput);
        }
    }
}

