/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.io.IOException;
import java.text.Normalizer;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.CoderTranslation;
import org.apache.beam.runners.core.construction.Environments;
import org.apache.beam.runners.core.construction.PCollectionTranslation;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.WindowingStrategyTranslation;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PortablePipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.resourcehints.ResourceHints;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p36p0.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBiMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SdkComponents {
    private final String newIdPrefix;
    private final RunnerApi.Components.Builder componentsBuilder = RunnerApi.Components.newBuilder();
    private final BiMap<AppliedPTransform<?, ?, ?>, String> transformIds = HashBiMap.create();
    private final BiMap<PCollection<?>, String> pCollectionIds = HashBiMap.create();
    private final BiMap<WindowingStrategy<?, ?>, String> windowingStrategyIds = HashBiMap.create();
    private final BiMap<Coder<?>, String> coderIds = HashBiMap.create();
    private final BiMap<RunnerApi.Environment, String> environmentIds = HashBiMap.create();
    private final BiMap<RunnerApi.Coder, String> coderProtoToId = HashBiMap.create();
    private final Set<String> requirements;
    private final Set<String> reservedIds = new HashSet<String>();
    private String defaultEnvironmentId;
    private Map<ResourceHints, String> environmentIdsByResourceHints = new HashMap<ResourceHints, String>();

    public static SdkComponents create() {
        return new SdkComponents(RunnerApi.Components.getDefaultInstance(), null, "");
    }

    public static SdkComponents create(RunnerApi.Components components, Collection<String> requirements) {
        return new SdkComponents(components, requirements, "");
    }

    static SdkComponents create(RunnerApi.Components components, Map<String, AppliedPTransform<?, ?, ?>> transforms, Map<String, PCollection<?>> pCollections, Map<String, WindowingStrategy<?, ?>> windowingStrategies, Map<String, Coder<?>> coders, Map<String, RunnerApi.Environment> environments, Collection<String> requirements) {
        SdkComponents sdkComponents = SdkComponents.create(components, requirements);
        sdkComponents.transformIds.inverse().putAll(transforms);
        sdkComponents.pCollectionIds.inverse().putAll(pCollections);
        sdkComponents.windowingStrategyIds.inverse().putAll(windowingStrategies);
        sdkComponents.coderIds.inverse().putAll(coders);
        sdkComponents.environmentIds.inverse().putAll(environments);
        return sdkComponents;
    }

    public static SdkComponents create(PipelineOptions options) {
        SdkComponents sdkComponents = new SdkComponents(RunnerApi.Components.getDefaultInstance(), null, "");
        PortablePipelineOptions portablePipelineOptions = (PortablePipelineOptions)options.as(PortablePipelineOptions.class);
        sdkComponents.registerEnvironment(Environments.createOrGetDefaultEnvironment(portablePipelineOptions));
        return sdkComponents;
    }

    private SdkComponents(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable RunnerApi.Components components, @Nullable Collection<String> requirements, String newIdPrefix) {
        this.newIdPrefix = newIdPrefix;
        this.requirements = new HashSet<String>();
        if (components == null) {
            if (requirements != null) {
                this.requirements.addAll(requirements);
            }
        } else {
            this.mergeFrom(components, requirements);
        }
    }

    public void mergeFrom(RunnerApi.Components components, @Nullable Collection<String> requirements) {
        this.reservedIds.addAll(components.getTransformsMap().keySet());
        this.reservedIds.addAll(components.getPcollectionsMap().keySet());
        this.reservedIds.addAll(components.getWindowingStrategiesMap().keySet());
        this.reservedIds.addAll(components.getCodersMap().keySet());
        this.reservedIds.addAll(components.getEnvironmentsMap().keySet());
        components.getEnvironmentsMap().forEach((arg_0, arg_1) -> ((BiMap)this.environmentIds.inverse()).forcePut(arg_0, arg_1));
        components.getCodersMap().forEach((arg_0, arg_1) -> ((BiMap)this.coderProtoToId.inverse()).forcePut(arg_0, arg_1));
        if (requirements != null) {
            this.requirements.addAll(requirements);
        }
        this.componentsBuilder.mergeFrom(components);
    }

    public SdkComponents withNewIdPrefix(String newIdPrefix) {
        SdkComponents sdkComponents = new SdkComponents(this.componentsBuilder.build(), this.requirements, newIdPrefix);
        sdkComponents.transformIds.putAll(this.transformIds);
        sdkComponents.pCollectionIds.putAll(this.pCollectionIds);
        sdkComponents.windowingStrategyIds.putAll(this.windowingStrategyIds);
        sdkComponents.coderIds.putAll(this.coderIds);
        sdkComponents.environmentIds.putAll(this.environmentIds);
        return sdkComponents;
    }

    public String registerPTransform(AppliedPTransform<?, ?, ?> appliedPTransform, List<AppliedPTransform<?, ?, ?>> children) throws IOException {
        String name = this.getApplicationName(appliedPTransform);
        if (this.componentsBuilder.getTransformsOrDefault(name, null) != null) {
            return name;
        }
        Preconditions.checkNotNull(children, (Object)"child nodes may not be null");
        this.componentsBuilder.putTransforms(name, PTransformTranslation.toProto(appliedPTransform, children, this));
        return name;
    }

    private String getApplicationName(AppliedPTransform<?, ?, ?> appliedPTransform) {
        String existing = (String)this.transformIds.get(appliedPTransform);
        if (existing != null) {
            return existing;
        }
        String name = appliedPTransform.getFullName();
        if (name.isEmpty()) {
            name = "unnamed-ptransform";
        }
        int maxNameLength = 100;
        name = (name = Normalizer.normalize(name, Normalizer.Form.NFC).replaceAll("[^A-Za-z0-9-_]", "-")).length() > maxNameLength ? name.substring(0, maxNameLength) : name;
        name = this.uniqify(name, this.transformIds.values());
        this.transformIds.put(appliedPTransform, (Object)name);
        return name;
    }

    String getExistingPTransformId(AppliedPTransform<?, ?, ?> appliedPTransform) {
        Preconditions.checkArgument((boolean)this.transformIds.containsKey(appliedPTransform), (String)"%s %s has not been previously registered", (Object)AppliedPTransform.class.getSimpleName(), appliedPTransform);
        return (String)this.transformIds.get(appliedPTransform);
    }

    public String getPTransformIdOrThrow(AppliedPTransform<?, ?, ?> appliedPTransform) {
        String existing = (String)this.transformIds.get(appliedPTransform);
        Preconditions.checkArgument((existing != null ? 1 : 0) != 0, (String)"PTransform id not found for: %s", appliedPTransform);
        return existing;
    }

    public String registerPCollection(PCollection<?> pCollection) throws IOException {
        String existing = (String)this.pCollectionIds.get(pCollection);
        if (existing != null) {
            return existing;
        }
        String uniqueName = this.uniqify(pCollection.getName(), this.pCollectionIds.values());
        this.pCollectionIds.put(pCollection, (Object)uniqueName);
        this.componentsBuilder.putPcollections(uniqueName, PCollectionTranslation.toProto(pCollection, this));
        return uniqueName;
    }

    public String registerWindowingStrategy(WindowingStrategy<?, ?> windowingStrategy) throws IOException {
        String existing = (String)this.windowingStrategyIds.get(windowingStrategy);
        if (existing != null) {
            return existing;
        }
        String baseName = String.format("%s(%s)", NameUtils.approximateSimpleName(windowingStrategy), NameUtils.approximateSimpleName((Object)windowingStrategy.getWindowFn()));
        String name = this.uniqify(baseName, this.windowingStrategyIds.values());
        this.windowingStrategyIds.put(windowingStrategy, (Object)name);
        RunnerApi.WindowingStrategy windowingStrategyProto = WindowingStrategyTranslation.toProto(windowingStrategy, this);
        this.componentsBuilder.putWindowingStrategies(name, windowingStrategyProto);
        return name;
    }

    public String registerCoder(Coder<?> coder) throws IOException {
        String existing = (String)this.coderIds.get(coder);
        if (existing != null) {
            return existing;
        }
        RunnerApi.Coder coderProto = CoderTranslation.toProto(coder, this);
        if (this.coderProtoToId.containsKey((Object)coderProto)) {
            return (String)this.coderProtoToId.get((Object)coderProto);
        }
        String baseName = NameUtils.approximateSimpleName(coder);
        String name = this.uniqify(baseName, this.coderIds.values());
        this.coderIds.put(coder, (Object)name);
        this.coderProtoToId.put((Object)coderProto, (Object)name);
        this.componentsBuilder.putCoders(name, coderProto);
        return name;
    }

    public String registerEnvironment(RunnerApi.Environment env) {
        String environmentId;
        String existing = (String)this.environmentIds.get((Object)env);
        if (existing != null) {
            environmentId = existing;
        } else {
            String name = this.uniqify(env.getUrn(), this.environmentIds.values());
            this.environmentIds.put((Object)env, (Object)name);
            this.componentsBuilder.putEnvironments(name, env);
            environmentId = name;
        }
        if (this.defaultEnvironmentId == null) {
            this.defaultEnvironmentId = environmentId;
        }
        return environmentId;
    }

    public String getEnvironmentIdFor(ResourceHints resourceHints) {
        if (!this.environmentIdsByResourceHints.containsKey(resourceHints)) {
            String baseEnvironmentId = this.getOnlyEnvironmentId();
            if (resourceHints.hints().size() == 0) {
                this.environmentIdsByResourceHints.put(resourceHints, baseEnvironmentId);
            } else {
                RunnerApi.Environment env = ((RunnerApi.Environment)this.componentsBuilder.getEnvironmentsMap().get(baseEnvironmentId)).toBuilder().putAllResourceHints(Maps.transformValues((Map)resourceHints.hints(), hint -> ByteString.copyFrom((byte[])hint.toBytes()))).build();
                String name = this.uniqify(env.getUrn(), this.environmentIds.values());
                this.environmentIds.put((Object)env, (Object)name);
                this.componentsBuilder.putEnvironments(name, env);
                this.environmentIdsByResourceHints.put(resourceHints, name);
            }
        }
        return this.environmentIdsByResourceHints.get(resourceHints);
    }

    @VisibleForTesting
    String getOnlyEnvironmentId() {
        if (this.defaultEnvironmentId == null) {
            this.defaultEnvironmentId = (String)Iterables.getOnlyElement(this.componentsBuilder.getEnvironmentsMap().keySet());
        }
        return this.defaultEnvironmentId;
    }

    public void addRequirement(String urn) {
        this.requirements.add(urn);
    }

    private String uniqify(String baseName, Set<String> existing) {
        String name = this.newIdPrefix + baseName;
        int increment = 1;
        while (existing.contains(name) || this.reservedIds.contains(name)) {
            name = this.newIdPrefix + baseName + Integer.toString(increment);
            ++increment;
        }
        return name;
    }

    public RunnerApi.Components toComponents() {
        return this.componentsBuilder.build();
    }

    public Collection<String> requirements() {
        return ImmutableSet.copyOf(this.requirements);
    }
}

