/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.fieldsplitter;

import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Const;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.injection.AfterInjection;
import org.apache.hop.core.injection.DataTypeConverter;
import org.apache.hop.core.injection.Injection;
import org.apache.hop.core.injection.InjectionSupported;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.xml.XmlHandler;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.fieldsplitter.FieldSplitter;
import org.apache.hop.pipeline.transforms.fieldsplitter.FieldSplitterData;
import org.apache.hop.pipeline.transforms.fieldsplitter.TrimTypeConverter;
import org.w3c.dom.Node;

@InjectionSupported(localizationPrefix="FieldSplitter.Injection.", groups={"FIELDS"})
@Transform(id="FieldSplitter", image="fieldsplitter.svg", name="i18n::SplitFields.Name", description="i18n::SplitFields.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Transform", documentationUrl="/pipeline/transforms/splitfields.html")
public class FieldSplitterMeta
extends BaseTransformMeta
implements ITransformMeta<FieldSplitter, FieldSplitterData> {
    private static final Class<?> PKG = FieldSplitterMeta.class;
    @Injection(name="FIELD_TO_SPLIT")
    private String splitField;
    @Injection(name="DELIMITER")
    private String delimiter;
    @Injection(name="ENCLOSURE")
    private String enclosure;
    @Injection(name="ESCAPE_STRING")
    private String escapeString;
    @Injection(name="NAME", group="FIELDS")
    private String[] fieldName;
    @Injection(name="ID", group="FIELDS")
    private String[] fieldID;
    @Injection(name="REMOVE_ID", group="FIELDS")
    private boolean[] fieldRemoveID;
    @Injection(name="DATA_TYPE", group="FIELDS", converter=DataTypeConverter.class)
    private int[] fieldType;
    @Injection(name="FORMAT", group="FIELDS")
    private String[] fieldFormat;
    @Injection(name="GROUPING", group="FIELDS")
    private String[] fieldGroup;
    @Injection(name="DECIMAL", group="FIELDS")
    private String[] fieldDecimal;
    @Injection(name="CURRENCY", group="FIELDS")
    private String[] fieldCurrency;
    @Injection(name="LENGTH", group="FIELDS")
    private int[] fieldLength;
    @Injection(name="PRECISION", group="FIELDS")
    private int[] fieldPrecision;
    @Injection(name="NULL_IF", group="FIELDS")
    private String[] fieldNullIf;
    @Injection(name="DEFAULT", group="FIELDS")
    private String[] fieldIfNull;
    @Injection(name="TRIM_TYPE", group="FIELDS", converter=TrimTypeConverter.class)
    private int[] fieldTrimType;

    public String getSplitField() {
        return this.splitField;
    }

    public void setSplitField(String splitField) {
        this.splitField = splitField;
    }

    public String getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(String delimiter) {
        this.delimiter = delimiter;
    }

    public String getEnclosure() {
        return this.enclosure;
    }

    public void setEnclosure(String enclosure) {
        this.enclosure = enclosure;
    }

    public String getEscapeString() {
        return this.escapeString;
    }

    public void setEscapeString(String escapeString) {
        this.escapeString = escapeString;
    }

    public String[] getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String[] fieldName) {
        this.fieldName = fieldName;
    }

    public String[] getFieldID() {
        return this.fieldID;
    }

    public void setFieldID(String[] fieldID) {
        this.fieldID = fieldID;
    }

    public boolean[] getFieldRemoveID() {
        return this.fieldRemoveID;
    }

    public void setFieldRemoveID(boolean[] fieldRemoveID) {
        this.fieldRemoveID = fieldRemoveID;
    }

    public int[] getFieldType() {
        return this.fieldType;
    }

    public void setFieldType(int[] fieldType) {
        this.fieldType = fieldType;
    }

    public String[] getFieldFormat() {
        return this.fieldFormat;
    }

    public void setFieldFormat(String[] fieldFormat) {
        this.fieldFormat = fieldFormat;
    }

    public String[] getFieldGroup() {
        return this.fieldGroup;
    }

    public void setFieldGroup(String[] fieldGroup) {
        this.fieldGroup = fieldGroup;
    }

    public String[] getFieldDecimal() {
        return this.fieldDecimal;
    }

    public void setFieldDecimal(String[] fieldDecimal) {
        this.fieldDecimal = fieldDecimal;
    }

    public String[] getFieldCurrency() {
        return this.fieldCurrency;
    }

    public void setFieldCurrency(String[] fieldCurrency) {
        this.fieldCurrency = fieldCurrency;
    }

    public int[] getFieldLength() {
        return this.fieldLength;
    }

    public void setFieldLength(int[] fieldLength) {
        this.fieldLength = fieldLength;
    }

    public int[] getFieldPrecision() {
        return this.fieldPrecision;
    }

    public void setFieldPrecision(int[] fieldPrecision) {
        this.fieldPrecision = fieldPrecision;
    }

    public String[] getFieldNullIf() {
        return this.fieldNullIf;
    }

    public void setFieldNullIf(String[] fieldNullIf) {
        this.fieldNullIf = fieldNullIf;
    }

    public String[] getFieldIfNull() {
        return this.fieldIfNull;
    }

    public void setFieldIfNull(String[] fieldIfNull) {
        this.fieldIfNull = fieldIfNull;
    }

    public int[] getFieldTrimType() {
        return this.fieldTrimType;
    }

    public void setFieldTrimType(int[] fieldTrimType) {
        this.fieldTrimType = fieldTrimType;
    }

    public void allocate(int nrFields) {
        this.fieldName = new String[nrFields];
        this.fieldID = new String[nrFields];
        this.fieldRemoveID = new boolean[nrFields];
        this.fieldType = new int[nrFields];
        this.fieldFormat = new String[nrFields];
        this.fieldGroup = new String[nrFields];
        this.fieldDecimal = new String[nrFields];
        this.fieldCurrency = new String[nrFields];
        this.fieldLength = new int[nrFields];
        this.fieldPrecision = new int[nrFields];
        this.fieldNullIf = new String[nrFields];
        this.fieldIfNull = new String[nrFields];
        this.fieldTrimType = new int[nrFields];
    }

    public Object clone() {
        FieldSplitterMeta retval = (FieldSplitterMeta)((Object)super.clone());
        int nrFields = this.fieldName.length;
        retval.allocate(nrFields);
        System.arraycopy(this.fieldName, 0, retval.fieldName, 0, nrFields);
        System.arraycopy(this.fieldID, 0, retval.fieldID, 0, nrFields);
        System.arraycopy(this.fieldRemoveID, 0, retval.fieldRemoveID, 0, nrFields);
        System.arraycopy(this.fieldType, 0, retval.fieldType, 0, nrFields);
        System.arraycopy(this.fieldLength, 0, retval.fieldLength, 0, nrFields);
        System.arraycopy(this.fieldPrecision, 0, retval.fieldPrecision, 0, nrFields);
        System.arraycopy(this.fieldFormat, 0, retval.fieldFormat, 0, nrFields);
        System.arraycopy(this.fieldGroup, 0, retval.fieldGroup, 0, nrFields);
        System.arraycopy(this.fieldDecimal, 0, retval.fieldDecimal, 0, nrFields);
        System.arraycopy(this.fieldCurrency, 0, retval.fieldCurrency, 0, nrFields);
        System.arraycopy(this.fieldNullIf, 0, retval.fieldNullIf, 0, nrFields);
        System.arraycopy(this.fieldIfNull, 0, retval.fieldIfNull, 0, nrFields);
        System.arraycopy(this.fieldTrimType, 0, retval.fieldTrimType, 0, nrFields);
        return retval;
    }

    public void loadXml(Node transformNode, IHopMetadataProvider metadataProvider) throws HopXmlException {
        try {
            this.splitField = XmlHandler.getTagValue((Node)transformNode, (String)"splitfield");
            this.delimiter = XmlHandler.getTagValue((Node)transformNode, (String)"delimiter");
            this.enclosure = XmlHandler.getTagValue((Node)transformNode, (String)"enclosure");
            this.escapeString = XmlHandler.getTagValue((Node)transformNode, (String)"escape_string");
            Node fields = XmlHandler.getSubNode((Node)transformNode, (String)"fields");
            int nrFields = XmlHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                Node fnode = XmlHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.fieldName[i] = XmlHandler.getTagValue((Node)fnode, (String)"name");
                this.fieldID[i] = XmlHandler.getTagValue((Node)fnode, (String)"id");
                String sidrem = XmlHandler.getTagValue((Node)fnode, (String)"idrem");
                String stype = XmlHandler.getTagValue((Node)fnode, (String)"type");
                this.fieldFormat[i] = XmlHandler.getTagValue((Node)fnode, (String)"format");
                this.fieldGroup[i] = XmlHandler.getTagValue((Node)fnode, (String)"group");
                this.fieldDecimal[i] = XmlHandler.getTagValue((Node)fnode, (String)"decimal");
                this.fieldCurrency[i] = XmlHandler.getTagValue((Node)fnode, (String)"currency");
                String slen = XmlHandler.getTagValue((Node)fnode, (String)"length");
                String sprc = XmlHandler.getTagValue((Node)fnode, (String)"precision");
                this.fieldNullIf[i] = XmlHandler.getTagValue((Node)fnode, (String)"nullif");
                this.fieldIfNull[i] = XmlHandler.getTagValue((Node)fnode, (String)"ifnull");
                String trim = XmlHandler.getTagValue((Node)fnode, (String)"trimtype");
                this.fieldRemoveID[i] = "Y".equalsIgnoreCase(sidrem);
                this.fieldType[i] = ValueMetaFactory.getIdForValueMeta((String)stype);
                this.fieldLength[i] = Const.toInt((String)slen, (int)-1);
                this.fieldPrecision[i] = Const.toInt((String)sprc, (int)-1);
                this.fieldTrimType[i] = ValueMetaString.getTrimTypeByCode((String)trim);
            }
        }
        catch (Exception e) {
            throw new HopXmlException(BaseMessages.getString(PKG, (String)"FieldSplitterMeta.Exception.UnableToLoadTransformMetaFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.splitField = "";
        this.delimiter = ",";
        this.enclosure = null;
        this.allocate(0);
    }

    public int getFieldsCount() {
        int count = Math.min(this.getFieldName().length, this.getFieldType().length);
        count = Math.min(count, this.getFieldLength().length);
        count = Math.min(count, this.getFieldPrecision().length);
        count = Math.min(count, this.getFieldFormat().length);
        count = Math.min(count, this.getFieldDecimal().length);
        count = Math.min(count, this.getFieldGroup().length);
        count = Math.min(count, this.getFieldCurrency().length);
        count = Math.min(count, this.getFieldTrimType().length);
        return count;
    }

    public void getFields(IRowMeta r, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        int idx = r.indexOfValue(this.getSplitField());
        if (idx < 0) {
            throw new RuntimeException(BaseMessages.getString(PKG, (String)"FieldSplitter.Log.CouldNotFindFieldToSplit", (String[])new String[]{this.getSplitField()}));
        }
        int count = this.getFieldsCount();
        for (int i = 0; i < count; ++i) {
            try {
                IValueMeta v = ValueMetaFactory.createValueMeta((String)this.getFieldName()[i], (int)this.getFieldType()[i]);
                v.setLength(this.getFieldLength()[i], this.getFieldPrecision()[i]);
                v.setOrigin(name);
                v.setConversionMask(this.getFieldFormat()[i]);
                v.setDecimalSymbol(this.getFieldDecimal()[i]);
                v.setGroupingSymbol(this.getFieldGroup()[i]);
                v.setCurrencySymbol(this.getFieldCurrency()[i]);
                v.setTrimType(this.getFieldTrimType()[i]);
                if (i == 0 && idx >= 0) {
                    r.setValueMeta(idx, v);
                    continue;
                }
                if (idx >= r.size()) {
                    r.addValueMeta(v);
                }
                r.addValueMeta(idx + i, v);
                continue;
            }
            catch (Exception e) {
                throw new HopTransformException((Throwable)e);
            }
        }
    }

    public String getXml() {
        StringBuilder retval = new StringBuilder(500);
        retval.append("   ").append(XmlHandler.addTagValue((String)"splitfield", (String)this.splitField)).append("   ").append(XmlHandler.addTagValue((String)"delimiter", (String)this.delimiter)).append("   ").append(XmlHandler.addTagValue((String)"enclosure", (String)this.enclosure)).append("   ").append(XmlHandler.addTagValue((String)"escape_string", (String)this.escapeString));
        retval.append("   ").append("<fields>");
        for (int i = 0; i < this.fieldName.length; ++i) {
            retval.append("      ").append("<field>").append("        ").append(XmlHandler.addTagValue((String)"name", (String)this.fieldName[i])).append("        ").append(XmlHandler.addTagValue((String)"id", ArrayUtils.isEmpty((Object[])this.fieldID) ? null : this.fieldID[i])).append("        ").append(XmlHandler.addTagValue((String)"idrem", (boolean)(ArrayUtils.isEmpty((boolean[])this.fieldRemoveID) ? false : this.fieldRemoveID[i]))).append("        ").append(XmlHandler.addTagValue((String)"type", (String)ValueMetaFactory.getValueMetaName((int)(ArrayUtils.isEmpty((int[])this.fieldType) ? 0 : this.fieldType[i])))).append("        ").append(XmlHandler.addTagValue((String)"format", ArrayUtils.isEmpty((Object[])this.fieldFormat) ? null : this.fieldFormat[i])).append("        ").append(XmlHandler.addTagValue((String)"group", ArrayUtils.isEmpty((Object[])this.fieldGroup) ? null : this.fieldGroup[i])).append("        ").append(XmlHandler.addTagValue((String)"decimal", ArrayUtils.isEmpty((Object[])this.fieldDecimal) ? null : this.fieldDecimal[i])).append("        ").append(XmlHandler.addTagValue((String)"currency", ArrayUtils.isEmpty((Object[])this.fieldCurrency) ? null : this.fieldCurrency[i])).append("        ").append(XmlHandler.addTagValue((String)"length", (int)(ArrayUtils.isEmpty((int[])this.fieldLength) ? -1 : this.fieldLength[i]))).append("        ").append(XmlHandler.addTagValue((String)"precision", (int)(ArrayUtils.isEmpty((int[])this.fieldPrecision) ? -1 : this.fieldPrecision[i]))).append("        ").append(XmlHandler.addTagValue((String)"nullif", ArrayUtils.isEmpty((Object[])this.fieldNullIf) ? null : this.fieldNullIf[i])).append("        ").append(XmlHandler.addTagValue((String)"ifnull", ArrayUtils.isEmpty((Object[])this.fieldIfNull) ? null : this.fieldIfNull[i])).append("        ").append(XmlHandler.addTagValue((String)"trimtype", (String)ValueMetaString.getTrimTypeCode((int)(ArrayUtils.isEmpty((int[])this.fieldTrimType) ? 0 : this.fieldTrimType[i])))).append("      ").append("</field>");
        }
        retval.append("    ").append("</fields>");
        return retval.toString();
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        String errorMessage = "";
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.TransformReceivingFields", (String[])new String[]{prev.size() + ""}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            errorMessage = "";
            int i = prev.indexOfValue(this.splitField);
            if (i < 0) {
                errorMessage = BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.SplitedFieldNotPresentInInputStream", (String[])new String[]{this.splitField});
                cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.SplitedFieldFoundInInputStream", (String[])new String[]{this.splitField}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            errorMessage = BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.CouldNotReadFieldsFromPreviousTransform", (String[])new String[0]) + Const.CR;
            cr = new CheckResult(4, errorMessage, (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.TransformReceivingInfoFromOtherTransform", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"FieldSplitterMeta.CheckResult.NoInputReceivedFromOtherTransform", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public FieldSplitter createTransform(TransformMeta transformMeta, FieldSplitterData data, int cnr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        return new FieldSplitter(transformMeta, this, data, cnr, pipelineMeta, pipeline);
    }

    public FieldSplitterData getTransformData() {
        return new FieldSplitterData();
    }

    @AfterInjection
    public void afterInjectionSynchronization() {
        int nrFields;
        int n = nrFields = this.fieldName == null ? -1 : this.fieldName.length;
        if (nrFields <= 0) {
            return;
        }
        String[][] normalizedStringArrays = Utils.normalizeArrays((int)nrFields, (String[][])new String[][]{this.fieldID, this.fieldFormat, this.fieldGroup, this.fieldDecimal, this.fieldCurrency, this.fieldNullIf, this.fieldIfNull});
        this.fieldID = normalizedStringArrays[0];
        this.fieldFormat = normalizedStringArrays[1];
        this.fieldGroup = normalizedStringArrays[2];
        this.fieldDecimal = normalizedStringArrays[3];
        this.fieldCurrency = normalizedStringArrays[4];
        this.fieldNullIf = normalizedStringArrays[5];
        this.fieldIfNull = normalizedStringArrays[6];
        boolean[][] normalizedBooleanArrays = Utils.normalizeArrays((int)nrFields, (boolean[][])new boolean[][]{this.fieldRemoveID});
        this.fieldRemoveID = normalizedBooleanArrays[0];
        int[][] normalizedIntArrays = Utils.normalizeArrays((int)nrFields, (int[][])new int[][]{this.fieldType, this.fieldLength, this.fieldPrecision, this.fieldTrimType});
        this.fieldType = normalizedIntArrays[0];
        this.fieldLength = normalizedIntArrays[1];
        this.fieldPrecision = normalizedIntArrays[2];
        this.fieldTrimType = normalizedIntArrays[3];
    }
}

