/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.writetolog;

import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogLevel;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ControlSpaceKeyAdapter;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.workflow.action.ActionDialog;
import org.apache.hop.ui.workflow.dialog.WorkflowDialog;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.IAction;
import org.apache.hop.workflow.action.IActionDialog;
import org.apache.hop.workflow.actions.writetolog.ActionWriteToLog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ActionWriteToLogDialog
extends ActionDialog
implements IActionDialog {
    private static final Class<?> PKG = ActionWriteToLog.class;
    private Text wName;
    private Text wLogMessage;
    private ActionWriteToLog action;
    private Shell shell;
    private boolean changed;
    private TextVar wLogSubject;
    private CCombo wLoglevel;

    public ActionWriteToLogDialog(Shell parent, IAction action, WorkflowMeta workflowMeta, IVariables variables) {
        super(parent, workflowMeta, variables);
        this.action = (ActionWriteToLog)action;
        if (this.action.getName() == null) {
            this.action.setName(BaseMessages.getString(PKG, (String)"WriteToLog.Name.Default", (String[])new String[0]));
        }
    }

    public IAction open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        WorkflowDialog.setShellImage((Shell)this.shell, (IAction)this.action);
        ModifyListener lsMod = e -> this.action.setChanged();
        this.changed = this.action.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"WriteToLog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        Button wCancel = new Button((Composite)this.shell, 8);
        wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        wCancel.addListener(13, e -> this.cancel());
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{wOk, wCancel}, (int)margin, null);
        Label wlName = new Label((Composite)this.shell, 131072);
        wlName.setText(BaseMessages.getString(PKG, (String)"WriteToLog.Jobname.Label", (String[])new String[0]));
        this.props.setLook((Control)wlName);
        FormData fdlName = new FormData();
        fdlName.left = new FormAttachment(0, 0);
        fdlName.right = new FormAttachment(middle, 0);
        fdlName.top = new FormAttachment(0, margin);
        wlName.setLayoutData((Object)fdlName);
        this.wName = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wName);
        this.wName.addModifyListener(lsMod);
        FormData fdName = new FormData();
        fdName.left = new FormAttachment(middle, 0);
        fdName.top = new FormAttachment(0, margin);
        fdName.right = new FormAttachment(100, 0);
        this.wName.setLayoutData((Object)fdName);
        Label wlLoglevel = new Label((Composite)this.shell, 131072);
        wlLoglevel.setText(BaseMessages.getString(PKG, (String)"WriteToLog.Loglevel.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLoglevel);
        FormData fdlLoglevel = new FormData();
        fdlLoglevel.left = new FormAttachment(0, 0);
        fdlLoglevel.right = new FormAttachment(middle, -margin);
        fdlLoglevel.top = new FormAttachment((Control)this.wName, margin);
        wlLoglevel.setLayoutData((Object)fdlLoglevel);
        this.wLoglevel = new CCombo((Composite)this.shell, 2060);
        this.wLoglevel.setItems(LogLevel.getLogLevelDescriptions());
        this.props.setLook((Control)this.wLoglevel);
        FormData fdLoglevel = new FormData();
        fdLoglevel.left = new FormAttachment(middle, 0);
        fdLoglevel.top = new FormAttachment((Control)this.wName, margin);
        fdLoglevel.right = new FormAttachment(100, 0);
        this.wLoglevel.setLayoutData((Object)fdLoglevel);
        Label wlLogSubject = new Label((Composite)this.shell, 131072);
        wlLogSubject.setText(BaseMessages.getString(PKG, (String)"WriteToLog.LogSubject.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLogSubject);
        FormData fdlLogSubject = new FormData();
        fdlLogSubject.left = new FormAttachment(0, 0);
        fdlLogSubject.top = new FormAttachment((Control)this.wLoglevel, margin);
        fdlLogSubject.right = new FormAttachment(middle, -margin);
        wlLogSubject.setLayoutData((Object)fdlLogSubject);
        this.wLogSubject = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.wLogSubject.setText(BaseMessages.getString(PKG, (String)"WriteToLog.Name.Default", (String[])new String[0]));
        this.props.setLook((Control)this.wLogSubject);
        this.wLogSubject.addModifyListener(lsMod);
        FormData fdLogSubject = new FormData();
        fdLogSubject.left = new FormAttachment(middle, 0);
        fdLogSubject.top = new FormAttachment((Control)this.wLoglevel, margin);
        fdLogSubject.right = new FormAttachment(100, 0);
        this.wLogSubject.setLayoutData((Object)fdLogSubject);
        Label wlLogMessage = new Label((Composite)this.shell, 131072);
        wlLogMessage.setText(BaseMessages.getString(PKG, (String)"WriteToLog.LogMessage.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLogMessage);
        FormData fdlLogMessage = new FormData();
        fdlLogMessage.left = new FormAttachment(0, 0);
        fdlLogMessage.top = new FormAttachment((Control)this.wLogSubject, margin);
        fdlLogMessage.right = new FormAttachment(middle, -margin);
        wlLogMessage.setLayoutData((Object)fdlLogMessage);
        this.wLogMessage = new Text((Composite)this.shell, 19202);
        this.wLogMessage.setText(BaseMessages.getString(PKG, (String)"WriteToLog.Name.Default", (String[])new String[0]));
        this.props.setLook((Control)this.wLogMessage, 1);
        this.wLogMessage.addModifyListener(lsMod);
        FormData fdLogMessage = new FormData();
        fdLogMessage.left = new FormAttachment(middle, 0);
        fdLogMessage.top = new FormAttachment((Control)this.wLogSubject, margin);
        fdLogMessage.right = new FormAttachment(100, 0);
        fdLogMessage.bottom = new FormAttachment((Control)wOk, -margin);
        this.wLogMessage.setLayoutData((Object)fdLogMessage);
        this.wLogMessage.addKeyListener((KeyListener)new ControlSpaceKeyAdapter(this.variables, (Control)this.wLogMessage));
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.action;
    }

    public void dispose() {
        WindowProperty winprop = new WindowProperty(this.shell);
        this.props.setScreen(winprop);
        this.shell.dispose();
    }

    public void getData() {
        this.wName.setText(Const.nullToEmpty((String)this.action.getName()));
        this.wLogMessage.setText(Const.nullToEmpty((String)this.action.getLogMessage()));
        this.wLogSubject.setText(Const.nullToEmpty((String)this.action.getLogSubject()));
        if (this.action.getActionLogLevel() != null) {
            this.wLoglevel.select(this.action.getActionLogLevel().getLevel());
        }
        this.wName.selectAll();
        this.wName.setFocus();
    }

    private void cancel() {
        this.action.setChanged(this.changed);
        this.action = null;
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wName.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"System.TransformActionNameMissing.Title", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"System.ActionNameMissing.Msg", (String[])new String[0]));
            mb.open();
            return;
        }
        this.action.setName(this.wName.getText());
        this.action.setLogMessage(this.wLogMessage.getText());
        this.action.setLogSubject(this.wLogSubject.getText());
        if (this.wLoglevel.getSelectionIndex() != -1) {
            this.action.setActionLogLevel(LogLevel.values()[this.wLoglevel.getSelectionIndex()]);
        }
        this.dispose();
    }
}

