/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.nodelabels;

import java.util.HashSet;
import java.util.Set;
import org.apache.hadoop.hbase.shaded.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.resource.Resources;

public class NodeLabel
implements Comparable<NodeLabel> {
    private Resource resource;
    private int numActiveNMs;
    private String labelName;
    private Set<NodeId> nodeIds;

    public NodeLabel(String labelName) {
        this(labelName, Resource.newInstance(0, 0), 0);
    }

    protected NodeLabel(String labelName, Resource res, int activeNMs) {
        this.labelName = labelName;
        this.resource = res;
        this.numActiveNMs = activeNMs;
        this.nodeIds = new HashSet<NodeId>();
    }

    public void addNodeId(NodeId node) {
        this.nodeIds.add(node);
    }

    public void removeNodeId(NodeId node) {
        this.nodeIds.remove(node);
    }

    public Set<NodeId> getAssociatedNodeIds() {
        return new HashSet<NodeId>(this.nodeIds);
    }

    public void addNode(Resource nodeRes) {
        Resources.addTo(this.resource, nodeRes);
        ++this.numActiveNMs;
    }

    public void removeNode(Resource nodeRes) {
        Resources.subtractFrom(this.resource, nodeRes);
        --this.numActiveNMs;
    }

    public Resource getResource() {
        return this.resource;
    }

    public int getNumActiveNMs() {
        return this.numActiveNMs;
    }

    public String getLabelName() {
        return this.labelName;
    }

    public NodeLabel getCopy() {
        return new NodeLabel(this.labelName, this.resource, this.numActiveNMs);
    }

    @Override
    public int compareTo(NodeLabel o) {
        if (this.labelName.isEmpty() != o.getLabelName().isEmpty()) {
            if (this.labelName.isEmpty()) {
                return -1;
            }
            return 1;
        }
        return this.labelName.compareTo(o.getLabelName());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NodeLabel) {
            NodeLabel other = (NodeLabel)obj;
            return Resources.equals(this.resource, other.getResource()) && StringUtils.equals(this.labelName, other.getLabelName()) && other.getNumActiveNMs() == this.numActiveNMs;
        }
        return false;
    }

    public int hashCode() {
        int prime = 502357;
        return (int)((((long)this.labelName.hashCode() << 8) + (long)(this.resource.hashCode() << 4) + (long)this.numActiveNMs) % 502357L);
    }
}

