/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records.impl.pb;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.shaded.com.google.protobuf.TextFormat;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.impl.pb.ResourcePBImpl;
import org.apache.hadoop.yarn.proto.YarnProtos;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class ApplicationResourceUsageReportPBImpl
extends ApplicationResourceUsageReport {
    YarnProtos.ApplicationResourceUsageReportProto proto = YarnProtos.ApplicationResourceUsageReportProto.getDefaultInstance();
    YarnProtos.ApplicationResourceUsageReportProto.Builder builder = null;
    boolean viaProto = false;
    Resource usedResources;
    Resource reservedResources;
    Resource neededResources;

    public ApplicationResourceUsageReportPBImpl() {
        this.builder = YarnProtos.ApplicationResourceUsageReportProto.newBuilder();
    }

    public ApplicationResourceUsageReportPBImpl(YarnProtos.ApplicationResourceUsageReportProto proto) {
        this.proto = proto;
        this.viaProto = true;
    }

    public synchronized YarnProtos.ApplicationResourceUsageReportProto getProto() {
        this.mergeLocalToProto();
        this.proto = this.viaProto ? this.proto : this.builder.build();
        this.viaProto = true;
        return this.proto;
    }

    public int hashCode() {
        return this.getProto().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass().isAssignableFrom(this.getClass())) {
            return this.getProto().equals(((ApplicationResourceUsageReportPBImpl)this.getClass().cast(other)).getProto());
        }
        return false;
    }

    public String toString() {
        return TextFormat.shortDebugString(this.getProto());
    }

    private void mergeLocalToBuilder() {
        if (this.usedResources != null && !((ResourcePBImpl)this.usedResources).getProto().equals(this.builder.getUsedResources())) {
            this.builder.setUsedResources(this.convertToProtoFormat(this.usedResources));
        }
        if (this.reservedResources != null && !((ResourcePBImpl)this.reservedResources).getProto().equals(this.builder.getReservedResources())) {
            this.builder.setReservedResources(this.convertToProtoFormat(this.reservedResources));
        }
        if (this.neededResources != null && !((ResourcePBImpl)this.neededResources).getProto().equals(this.builder.getNeededResources())) {
            this.builder.setNeededResources(this.convertToProtoFormat(this.neededResources));
        }
    }

    private void mergeLocalToProto() {
        if (this.viaProto) {
            this.maybeInitBuilder();
        }
        this.mergeLocalToBuilder();
        this.proto = this.builder.build();
        this.viaProto = true;
    }

    private synchronized void maybeInitBuilder() {
        if (this.viaProto || this.builder == null) {
            this.builder = YarnProtos.ApplicationResourceUsageReportProto.newBuilder(this.proto);
        }
        this.viaProto = false;
    }

    @Override
    public synchronized int getNumUsedContainers() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getNumUsedContainers();
    }

    @Override
    public synchronized void setNumUsedContainers(int num_containers) {
        this.maybeInitBuilder();
        this.builder.setNumUsedContainers(num_containers);
    }

    @Override
    public synchronized int getNumReservedContainers() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getNumReservedContainers();
    }

    @Override
    public synchronized void setNumReservedContainers(int num_reserved_containers) {
        this.maybeInitBuilder();
        this.builder.setNumReservedContainers(num_reserved_containers);
    }

    @Override
    public synchronized Resource getUsedResources() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p;
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder applicationResourceUsageReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.usedResources != null) {
            return this.usedResources;
        }
        if (!p.hasUsedResources()) {
            return null;
        }
        this.usedResources = this.convertFromProtoFormat(p.getUsedResources());
        return this.usedResources;
    }

    @Override
    public synchronized void setUsedResources(Resource resources) {
        this.maybeInitBuilder();
        if (resources == null) {
            this.builder.clearUsedResources();
        }
        this.usedResources = resources;
    }

    @Override
    public synchronized Resource getReservedResources() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p;
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder applicationResourceUsageReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.reservedResources != null) {
            return this.reservedResources;
        }
        if (!p.hasReservedResources()) {
            return null;
        }
        this.reservedResources = this.convertFromProtoFormat(p.getReservedResources());
        return this.reservedResources;
    }

    @Override
    public synchronized void setReservedResources(Resource reserved_resources) {
        this.maybeInitBuilder();
        if (reserved_resources == null) {
            this.builder.clearReservedResources();
        }
        this.reservedResources = reserved_resources;
    }

    @Override
    public synchronized Resource getNeededResources() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p;
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder applicationResourceUsageReportProtoOrBuilder = p = this.viaProto ? this.proto : this.builder;
        if (this.neededResources != null) {
            return this.neededResources;
        }
        if (!p.hasNeededResources()) {
            return null;
        }
        this.neededResources = this.convertFromProtoFormat(p.getNeededResources());
        return this.neededResources;
    }

    @Override
    public synchronized void setNeededResources(Resource reserved_resources) {
        this.maybeInitBuilder();
        if (reserved_resources == null) {
            this.builder.clearNeededResources();
        }
        this.neededResources = reserved_resources;
    }

    @Override
    public synchronized void setMemorySeconds(long memory_seconds) {
        this.maybeInitBuilder();
        this.builder.setMemorySeconds(memory_seconds);
    }

    @Override
    public synchronized long getMemorySeconds() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getMemorySeconds();
    }

    @Override
    public synchronized void setVcoreSeconds(long vcore_seconds) {
        this.maybeInitBuilder();
        this.builder.setVcoreSeconds(vcore_seconds);
    }

    @Override
    public synchronized long getVcoreSeconds() {
        YarnProtos.ApplicationResourceUsageReportProtoOrBuilder p = this.viaProto ? this.proto : this.builder;
        return p.getVcoreSeconds();
    }

    private ResourcePBImpl convertFromProtoFormat(YarnProtos.ResourceProto p) {
        return new ResourcePBImpl(p);
    }

    private YarnProtos.ResourceProto convertToProtoFormat(Resource t) {
        return ((ResourcePBImpl)t).getProto();
    }
}

